/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.dashboard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BlackLabel;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.dashboard.PanelClasses;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.DashTotalsRow;
import org.eclipse.aperi.xmsg.MessageLog;

public class DashMain
implements ActionListener,
GuiRequestor {
    private DashTotalsRow dashTotalsRow;
    public static int screenWidth;
    private byte[] currentPanels;
    private JButton cycleButton;
    private JButton refreshButton;
    private static String CYCLENAME;
    private static String REFRESHNAME;
    private BlackLabel fullTitle;
    private JPanel currentPanel;
    IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public DashMain() {
        PanelClasses.panelObjects = new Object[PanelClasses.panelClasses.length];
    }

    public String getTitle() {
        return this.fullTitle.getText();
    }

    public JPanel getDashboard(DashTotalsRow pTotalsRow, boolean rotate) {
        this.dashTotalsRow = pTotalsRow;
        screenWidth = this.guiMain.getFrame().getToolkit().getScreenSize().width;
        DashTotalsRow adminRows = null;
        DashTotalsRow prev = this.dashTotalsRow;
        DashTotalsRow next = null;
        DashTotalsRow node = this.dashTotalsRow.dtrNext;
        while (node != null) {
            if (node.dtrStatisticType == 3 && node.dtrUserName.startsWith("Administrators")) {
                prev.dtrNext = node.dtrNext;
                next = node.dtrNext;
                node.dtrNext = adminRows;
                adminRows = node;
                node = next;
                continue;
            }
            prev = node;
            node = node.dtrNext;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        if (this.currentPanels == null) {
            this.currentPanels = new byte[PanelClasses.defaultPanels.length];
            this.createCurrentPanels(PanelClasses.defaultPanels);
        }
        if (rotate) {
            byte last = this.currentPanels[this.currentPanels.length - 1];
            for (int i = this.currentPanels.length - 1; i > 0; --i) {
                this.currentPanels[i] = this.currentPanels[i - 1];
            }
            this.currentPanels[0] = last;
        }
        JPanel titlePanel = this.buildTitle();
        JPanel gridPanel = new JPanel();
        gridPanel.setLayout(new GridLayout(2, 2));
        gridPanel.add(this.addPanel(this.currentPanels[1]));
        gridPanel.add(this.addPanel(this.currentPanels[2]));
        gridPanel.add(this.addPanel(this.currentPanels[0]));
        gridPanel.add(this.addPanel(this.currentPanels[3]));
        panel.add((Component)titlePanel, "North");
        panel.add((Component)gridPanel, "Center");
        this.cycleButton.addActionListener(this);
        this.refreshButton.addActionListener(this);
        while (adminRows != null) {
            node = adminRows;
            adminRows = adminRows.dtrNext;
            node.dtrNext = this.dashTotalsRow;
            this.dashTotalsRow = node;
        }
        this.currentPanel = panel;
        return panel;
    }

    public JPanel getDisplayedDashboard() {
        return this.currentPanel;
    }

    private void createCurrentPanels(byte[] panelArray) {
        for (int i = 0; i < this.currentPanels.length; ++i) {
            if (panelArray[i] <= 0) continue;
            int panelNumber = panelArray[i] - 1;
            this.currentPanels[panelNumber] = (byte)i;
        }
    }

    private JPanel buildTitle() {
        Capabilities capabilities = this.guiMain.getCapabilities();
        GridBagConstraints gbcLeft = new GridBagConstraints();
        GridBagConstraints gbcCenter = new GridBagConstraints();
        GridBagConstraints gbcRight = new GridBagConstraints();
        Insets inset = new Insets(0, 0, 0, 0);
        gbcLeft.anchor = 17;
        gbcCenter.anchor = 10;
        gbcRight.anchor = 13;
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(2, 1, 2, 1));
        panel.setLayout(new BoxLayout(panel, 0));
        this.cycleButton = new JButton(CYCLENAME);
        this.refreshButton = new JButton(REFRESHNAME);
        GuiUtil.setAccessible(this.cycleButton, CYCLENAME, "BUTTON_DASH_CYCLE_DESC");
        GuiUtil.setAccessible(this.cycleButton, REFRESHNAME, "BUTTON_DASH_REFRESH_DESC");
        this.cycleButton.setToolTipText(Util.getString("TOOLTIP_DASH_CYCLE"));
        this.refreshButton.setToolTipText(Util.getString("TOOLTIP_DASH_REFRESH"));
        this.cycleButton.setMargin(inset);
        this.refreshButton.setMargin(inset);
        this.fullTitle = new BlackLabel(MessageLog.getMessageNoID("STG5278L", GuiUtil.formatDateTime(new Date(this.dashTotalsRow.dtrUpdateTime))));
        Font titleFont = this.fullTitle.getFont();
        float fontSize = titleFont.getSize();
        fontSize += fontSize / 4.0f;
        this.fullTitle.setFont(titleFont.deriveFont(fontSize));
        panel.add(Box.createHorizontalStrut(2));
        panel.add(this.cycleButton);
        panel.add(Box.createGlue());
        panel.add(this.fullTitle);
        panel.add(Box.createGlue());
        panel.add(Box.createHorizontalStrut(2));
        if (capabilities.isAperiAdmin() || capabilities.isDataAdmin()) {
            panel.add(this.refreshButton);
            panel.add(Box.createHorizontalStrut(2));
        }
        return panel;
    }

    private Component addPanel(int panelNumber) {
        boolean isScrollable = true;
        JComponent returnPanel = null;
        Component returnComponent = null;
        String ctor = PanelClasses.panelClasses[panelNumber];
        PanelClasses accessor = null;
        try {
            Class<?> rClass = Class.forName(ctor);
            Class[] argdef = new Class[]{DashTotalsRow.class};
            Constructor<?> constr = rClass.getConstructor(argdef);
            Object[] args = new Object[]{this.dashTotalsRow};
            accessor = (PanelClasses)constr.newInstance(args);
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
        if (accessor != null) {
            if (accessor.isScrollable()) {
                returnPanel = new JScrollPane();
                returnPanel.setBorder(GuiUtil.getBorder());
            } else {
                returnPanel = new JPanel();
                ((JPanel)returnPanel).setLayout(new BorderLayout());
                ((JPanel)returnPanel).setBorder(GuiUtil.getBorder());
                isScrollable = false;
            }
            try {
                returnComponent = accessor.getComponent(PanelClasses.panelObjects[panelNumber], true);
            }
            catch (GeneralException e) {
                returnComponent = new JLabel(e.getMessage());
            }
            PanelClasses.panelObjects[panelNumber] = accessor.getObject();
        }
        if (returnComponent == null) {
            returnPanel = new JScrollPane();
            isScrollable = true;
            returnComponent = new JLabel(MessageLog.getMessageNoID("GUI5083E", ctor));
        }
        if (isScrollable) {
            ((JScrollPane)returnPanel).setViewportView(returnComponent);
        } else {
            ((JPanel)returnPanel).add(returnComponent, "Center");
        }
        return returnPanel;
    }

    public void losingFocus() {
        this.cycleButton.removeActionListener(this);
        this.refreshButton.removeActionListener(this);
    }

    public void editPrefs() {
        System.out.println("edit prefs");
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.cycleButton) {
            this.guiMain.showNull(true);
        } else if (source == this.refreshButton) {
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.server.UpdateTotalsHndlr";
            request.flags = (byte)4;
            request.requestData = GuiUtil.getUserName();
            GuiClient.doRequest(this, request);
        }
    }

    public void handleResponse(short status, Response response) {
        if (status <= 4) {
            this.guiMain.setDashTotalsRow((DashTotalsRow)response.responseData);
            this.guiMain.showNull(false);
        }
    }

    static {
        CYCLENAME = MessageLog.getMessageNoID("STG5237L");
        REFRESHNAME = MessageLog.getMessageNoID("STG0003L");
    }
}

