/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.system;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.TCloseTabPane;
import org.eclipse.aperi.gui.TabCloseListener;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.system.SubsystemDDI;
import org.eclipse.aperi.gui.disk.system.SubsystemDetailsPanel;
import org.eclipse.aperi.gui.disk.system.SubsystemListPanel;

public class SubsystemPanel
extends JPanel
implements FocusListener,
TabCloseListener {
    private SubsystemDDI theDDI = null;
    public TCloseTabPane tabs = null;
    private SubsystemListPanel listPanel = null;
    private SubsystemDetailsPanel detailsPanel = null;
    private Vector veAllTabs = new Vector();

    public SubsystemPanel(SubsystemDDI ddi) {
        this.theDDI = ddi;
    }

    public Vector getAllTabs() {
        return this.veAllTabs;
    }

    public JComponent getComponent() {
        this.setLayout(new BorderLayout());
        if (this.tabs == null) {
            this.tabs = new TCloseTabPane(1);
            this.tabs.setFont(BaseTree.boldFont);
            this.tabs.addFocusListener(this);
            if (this.theDDI.getSubsystemInternalId() == -1) {
                this.listPanel = new SubsystemListPanel(this.theDDI);
                String title = Util.getString("DISK_STORAGESUBSYS_LABEL");
                this.tabs.addTab(title, this.listPanel.getComponent(), title, false);
            } else {
                this.showDetails(this.theDDI.getSubsystem(), false);
            }
            this.add((Component)this.tabs, "Center");
        }
        return this;
    }

    public void showDetails(GUIStorageSubsystem sys, boolean closable) {
        boolean tabExists = false;
        String tabTitle = Util.getString("DISK_DETAILS_LABEL", sys.getDeviceId());
        for (int i = 0; i < this.tabs.getTabCount(); ++i) {
            if (!this.tabs.getTitleAt(i).equals(tabTitle)) continue;
            this.tabs.setSelectedComponent(this.tabs.getComponent(i));
            tabExists = true;
        }
        if (!tabExists) {
            this.detailsPanel = new SubsystemDetailsPanel(sys, this.theDDI);
            this.tabs.addTab(tabTitle, this.detailsPanel.getComponent(), tabTitle, closable, this);
            this.tabs.setSelectedComponent(this.detailsPanel);
            this.veAllTabs.addElement(this.detailsPanel);
        }
    }

    public void refreshPanel() {
        if (this.listPanel != null) {
            this.listPanel.buildTable();
        }
    }

    public void focusGained(FocusEvent e) {
        if (this.listPanel != null) {
            this.listPanel.selectionChanged(true);
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public boolean closeTab(int tabIndex) {
        SubsystemDetailsPanel selDetailPanel = (SubsystemDetailsPanel)this.tabs.getComponentAt(tabIndex);
        selDetailPanel.changesPending(true);
        this.veAllTabs.removeElement(selDetailPanel);
        return true;
    }
}

