/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TUpDownListSelector;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.request.Response;

public abstract class BaseSelectHostPortsStep
extends WizardPage {
    protected JLabel titleLabel = null;
    protected JLabel descLabel = null;
    protected TUpDownListSelector portList = null;
    protected JButton helpButton = null;
    private JButton nextButton = null;
    private JDialog wizardDialog = null;
    protected JList sourceList = null;
    protected JList selectedList = null;
    protected DefaultListModel srcModel = new DefaultListModel();
    protected DefaultListModel selModel = new DefaultListModel();
    protected boolean skipSubsystemStep = false;
    protected boolean isHelpSet = false;
    private boolean isHostPortDataRetrieved = false;
    private boolean isSSPortDataRetrieved = false;
    private boolean isfabricDataRetrieved = false;
    protected boolean getData = false;
    protected boolean addSSData = false;
    protected boolean skipToReviewStep = false;
    protected boolean portAssignFlag = false;
    protected HashMap portWWPN = new HashMap();
    protected HashMap portData = null;
    protected Vector ssportData = null;
    protected String subSystemID = null;
    protected GUIStorageSubsystem subSystem = null;
    private HashMap hmapPortsOfSS;
    private HashMap hmapPortsOfHP;
    private HashMap hmapFabrics = null;
    protected DiskDataAccessor diskAccessor = DiskDataAccessor.getInstance();
    protected HashMap assignedhostports = new HashMap();
    protected Vector originalList = new Vector();
    protected ArrayList originalListRHS = new ArrayList();
    protected ArrayList originalListLHS = new ArrayList();
    protected Vector finalList = new Vector();
    protected Vector unAssignedPorts = new Vector();
    protected Vector unAssignedPortsWithHosts = new Vector();
    public static String HOSTPORTS_DATA = "Host Ports";
    public static String HOSTPORTS_ASSIGNED_DATA = "Assigned Host Ports";
    public static String HOSTPORTS_UNASSIGNED_DATA = "Unassigned Host Ports";
    public static String HOSTPORTS_UNASSIGNED_HOSTS_DATA = "Unassigned Host Ports with hosts";
    private ArrayList selectedPorts;
    private ArrayList srcPorts;

    public BaseSelectHostPortsStep(int buttonFlags, GUIStorageSubsystem ss) {
        super(buttonFlags);
        this.subSystemID = ss.getId();
        this.subSystem = ss;
        this.getFinishButton().setEnabled(false);
        this.nextButton = this.getNextButton();
        Container pane = this.getContentPane();
        pane.add(this.create());
    }

    public JPanel create() {
        JPanel tempPanel = new JPanel();
        tempPanel.setLayout(new BoxLayout(tempPanel, 1));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        String volString = new String();
        String descString = new String();
        if (this.subSystem.getType() == 4) {
            volString = Util.getString("DISK_VOLUME_HOST_PORT_LABEL", Util.getString("DISK_PORT_ASSIGNMENT_VDISKS"));
            descString = Util.getString("DISK_VOLUME_HOST_PORT_DESC_LABEL", Util.getString("DISK_PORT_ASSIGNMENT_VDISKS"));
        } else {
            volString = Util.getString("DISK_VOLUME_HOST_PORT_LABEL", Util.getString("DISK_PORT_ASSIGNMENT_VOLUMES"));
            descString = Util.getString("DISK_VOLUME_HOST_PORT_DESC_LABEL", Util.getString("DISK_PORT_ASSIGNMENT_VOLUMES"));
        }
        this.titleLabel = new JLabel(volString);
        this.titleLabel.setAlignmentX(0.0f);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        titlePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        titlePanel.add(this.titleLabel);
        titlePanel.add(Box.createHorizontalGlue());
        Font font = this.titleLabel.getFont();
        GuiUtil.setAccessible(this.titleLabel, this.titleLabel.getText(), this.titleLabel.getText());
        this.titleLabel.setFont(font.deriveFont(1));
        tempPanel.add(titlePanel);
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BoxLayout(descPanel, 0));
        this.descLabel = new JLabel(descString);
        this.descLabel.setAlignmentX(0.0f);
        this.descLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        descPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        descPanel.add(this.descLabel);
        descPanel.add(Box.createHorizontalGlue());
        tempPanel.add(descPanel);
        this.getPortsFromSystem();
        this.getSSPortsFromSystem();
        this.getFabricsFromsystem();
        this.sourceList = new JList(this.srcModel);
        this.selectedList = new JList(this.selModel);
        JPanel portPanel = new JPanel();
        portPanel.setLayout(new BoxLayout(portPanel, 1));
        this.portList = new TUpDownListSelector(this.sourceList, this.selectedList, Util.getString("DISK_VOLUME_HOST_PORT_SRC_LABEL"), Util.getString("DISK_VOLUME_HOST_PORT_SEL_LABEL"), true);
        portPanel.add(this.portList);
        portPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        tempPanel.add(portPanel);
        return tempPanel;
    }

    public void getPortsFromSystem() {
        this.enableControls(false);
        this.diskAccessor.getHostPortsBySubsystem(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                GUIPort port2 = null;
                BaseSelectHostPortsStep.this.portData = new HashMap();
                String portItem = new String();
                Vector<String> listData = new Vector<String>();
                if (status <= 4 && response != null) {
                    BaseSelectHostPortsStep.this.hmapPortsOfHP = (HashMap)response.responseData;
                    if (BaseSelectHostPortsStep.this.hmapPortsOfHP != null) {
                        for (GUIPort port2 : BaseSelectHostPortsStep.this.hmapPortsOfHP.values()) {
                            portItem = port2.getWwpn();
                            if (port2.getHostName() != null && port2.getHostName().trim().length() > 0) {
                                portItem = portItem + "( " + port2.getHostName() + " )";
                            }
                            listData.add(portItem);
                            BaseSelectHostPortsStep.this.portData.put(portItem, port2);
                            BaseSelectHostPortsStep.this.portWWPN.put(port2.getWwpn(), portItem);
                        }
                        BaseSelectHostPortsStep.this.getAssignedPorts();
                        Collections.sort(listData);
                        for (int i = 0; i < listData.size(); ++i) {
                            BaseSelectHostPortsStep.this.srcModel.addElement(listData.get(i));
                        }
                        BaseSelectHostPortsStep.this.sourceList.setModel(BaseSelectHostPortsStep.this.srcModel);
                        BaseSelectHostPortsStep.this.selectedList.setModel(BaseSelectHostPortsStep.this.selModel);
                        BaseSelectHostPortsStep.this.originalListRHS = BaseSelectHostPortsStep.this.portList.getSelList();
                        BaseSelectHostPortsStep.this.originalListLHS = BaseSelectHostPortsStep.this.portList.getSrcList();
                        if (BaseSelectHostPortsStep.this.originalListRHS == null) {
                            BaseSelectHostPortsStep.this.originalListRHS = new ArrayList();
                        }
                        if (BaseSelectHostPortsStep.this.originalListLHS == null) {
                            BaseSelectHostPortsStep.this.originalListLHS = new ArrayList();
                        }
                    }
                }
                BaseSelectHostPortsStep.this.isHostPortDataRetrieved = true;
                BaseSelectHostPortsStep.this.enableControls(true);
            }
        }, this.subSystemID);
    }

    public void getAssignedPorts() {
    }

    public void addData(Vector ports) {
    }

    public void addData(Vector ports, Vector aPorts) {
    }

    public JDialog getWizardDialog() {
        return null;
    }

    public boolean skipSubsystemStep() {
        return this.skipSubsystemStep;
    }

    public boolean skipToReviewStep() {
        return this.skipToReviewStep;
    }

    public void getSSPortsFromSystem() {
        this.enableControls(false);
        this.diskAccessor.getSubsystemPorts(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                GUIPort port2 = null;
                BaseSelectHostPortsStep.this.ssportData = new Vector();
                if (status <= 4 && response != null) {
                    BaseSelectHostPortsStep.this.hmapPortsOfSS = (HashMap)response.responseData;
                    if (!BaseSelectHostPortsStep.this.hmapPortsOfSS.isEmpty()) {
                        for (GUIPort port2 : BaseSelectHostPortsStep.this.hmapPortsOfSS.values()) {
                            BaseSelectHostPortsStep.this.ssportData.add(port2);
                        }
                        BaseSelectHostPortsStep.this.getData = true;
                    }
                }
                BaseSelectHostPortsStep.this.isSSPortDataRetrieved = true;
                BaseSelectHostPortsStep.this.enableControls(true);
            }
        }, this.subSystemID);
    }

    public void getFabricsFromsystem() {
        this.enableControls(false);
        this.diskAccessor.getFabrics(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                Object port = null;
                if (status <= 4) {
                    if (response != null) {
                        BaseSelectHostPortsStep.this.hmapFabrics = (HashMap)response.responseData;
                    } else {
                        BaseSelectHostPortsStep.this.hmapFabrics = null;
                    }
                }
                BaseSelectHostPortsStep.this.isfabricDataRetrieved = true;
                BaseSelectHostPortsStep.this.enableControls(true);
            }
        });
    }

    public HashMap getSSPorts() {
        return this.hmapPortsOfSS;
    }

    public HashMap getFabrics() {
        return this.hmapFabrics;
    }

    private void enableControls(boolean flag) {
        if (flag && this.isSSPortDataRetrieved && this.isHostPortDataRetrieved && this.isfabricDataRetrieved) {
            this.nextButton.setEnabled(true);
        } else {
            this.nextButton.setEnabled(false);
        }
    }

    public boolean nextBegin() {
        boolean retval = true;
        String sPort = null;
        GUIPort port = null;
        Vector<GUIPort> vPorts = new Vector<GUIPort>();
        this.skipSubsystemStep = false;
        this.skipToReviewStep = false;
        this.selectedPorts = this.portList.getSelList();
        this.srcPorts = this.portList.getSrcList();
        if (this.selectedPorts == null) {
            this.selectedPorts = new ArrayList();
        }
        if (this.srcPorts == null) {
            this.srcPorts = new ArrayList();
        }
        if (this.srcPorts.containsAll(this.originalListLHS) && this.originalListLHS.containsAll(this.srcPorts)) {
            String confirm = null;
            String tString = null;
            if (this.subSystem.getType() == 4) {
                confirm = Util.getString("DISK_VOLUME_HOST_PORT_CONFIRMATION", Util.getString("DISK_PORT_ASSIGNMENT_VDISKS"));
                tString = Util.getString("DISK_VOLUME_HOST_PORT_LABEL", Util.getString("DISK_PORT_ASSIGNMENT_VDISKS"));
            } else {
                confirm = Util.getString("DISK_VOLUME_HOST_PORT_CONFIRMATION", Util.getString("DISK_PORT_ASSIGNMENT_VOLUMES"));
                tString = Util.getString("DISK_VOLUME_HOST_PORT_LABEL", Util.getString("DISK_PORT_ASSIGNMENT_VOLUMES"));
            }
            int action = JOptionPane.showConfirmDialog(this, confirm, tString, 2);
            switch (action) {
                case 0: {
                    retval = true;
                    this.portAssignFlag = true;
                    this.skipToReviewStep = true;
                    this.addSSData = false;
                    break;
                }
                case 2: {
                    this.portAssignFlag = false;
                    this.skipToReviewStep = false;
                    retval = false;
                }
            }
        } else {
            ListIterator ll = this.selectedPorts.listIterator();
            while (ll.hasNext()) {
                Object nextport = ll.next();
                if (nextport == null) continue;
                sPort = nextport.toString();
                if (this.portData != null) {
                    port = (GUIPort)this.portData.get(sPort);
                }
                if (port == null || this.originalList.contains(sPort)) continue;
                vPorts.add(port);
            }
        }
        if (vPorts.size() > 0 && (this.subSystem.getType() == 1 || this.subSystem.getType() == 5)) {
            this.warningMessage(Util.getString("DISK_VOLUME_HOST_PORT_DS4000_WARNING"));
        }
        if (this.subSystem.getCapabilityData().getPortsPerView() == 4 || this.subSystem.getType() == 4) {
            this.skipSubsystemStep = true;
            this.addSSData = true;
        }
        this.addData(vPorts);
        return retval;
    }

    protected void warningMessage(String warning) {
        JOptionPane optPane = new JOptionPane();
        Object text = null;
        Font font = this.descLabel.getFont();
        if (warning.length() > 75) {
            text = new JTextArea(warning, 5, 60);
            ((JTextArea)text).setFont(font);
            ((JTextArea)text).setLineWrap(true);
            ((JTextArea)text).setWrapStyleWord(true);
            ((JTextArea)text).setEditable(false);
            Color bcolor = optPane.getBackground();
            ((JTextArea)text).setBackground(bcolor);
        } else {
            text = warning;
        }
        String title = Util.getString("DISK_VOLUME_HOST_PORT_LABEL", Util.getString("DISK_PORT_ASSIGNMENT_VOLUMES"));
        optPane.setMessage(text);
        optPane.setMessageType(2);
        JDialog optDialog = optPane.createDialog(this, title);
        GuiUtil.centerDialog(optDialog);
        optDialog.pack();
        optDialog.show();
    }

    public boolean previousBegin() {
        return true;
    }
}

