/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.DiskConstants;
import org.eclipse.aperi.gui.disk.common.FormattedTextFieldVerifier;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIIOGroup;
import org.eclipse.aperi.gui.disk.common.model.GUIMDisk;
import org.eclipse.aperi.gui.disk.common.model.GUIMDiskGroup;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskAddMDiskDialog;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskWizard;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;

public class CreateVDiskSetCharacteristicsStep
extends WizardPage
implements ActionListener,
ChangeListener,
TJCTableMouseInterface {
    private String svcID = "0";
    private DiskDataAccessor diskAccessor = null;
    private HashMap iogroupsmap = null;
    private HashMap mdgroupsmap = null;
    private String[] vdiskIDs;
    private HashMap mdiskMap = null;
    private String[] mdiskIDs = null;
    private JDialog wizardDialog = null;
    private JLabel titleLabel = null;
    private JLabel descLabel = null;
    private JLabel typeLabel = null;
    private JLabel vdiskQuantityLabel = null;
    private JLabel vdiskSizeLabel = null;
    private JLabel unitsLabel = null;
    private JLabel vdiskNameLabel = null;
    private JLabel vdiskPrefixLabel = null;
    private JLabel ioGroupLabel = null;
    private JLabel mdGroupLabel = null;
    private JLabel mdiskLabel = null;
    private JLabel noDataLabel = null;
    private JComboBox typeComboBox = null;
    private JSpinner vdiskQuantitySpinner = null;
    private JSpinner vdiskSizeSpinner = null;
    private JComboBox unitsComboBox = null;
    private JComboBox ioGroupComboBox = null;
    private JComboBox mdGroupComboBox = null;
    private JTextField vdiskNameTextField = null;
    private MegaTable mdiskTable = null;
    public JButton addMDiskButton = null;
    public JButton nextButton = null;
    private JCheckBox roundRobinCheckBox = null;
    private JCheckBox formatCheckBox = null;
    private JFormattedTextField vdiskQuantityTextField = new JFormattedTextField();
    private JFormattedTextField vdiskSizeTextField = new JFormattedTextField();
    private int minSpinnerValue = 1;
    private int maxQuantitySpinnerValue = 1024;
    private int minSizeSpinnerValue = 0;
    private int maxSizeSpinnerValue = 1000000;
    private int spinnerStep = 1;
    private CreateVDiskWizard cvWizard = null;
    private boolean dblClick = false;
    private mdiskTableModel tableModel = null;
    private int width = -1;
    private int height = -1;
    private long maxVDiskSize = -1L;
    private long vdiskSizeBytes = -1L;
    private boolean isHelpSet = false;
    private int nameLen = -1;
    private HashMap mdiskGroups = new HashMap();
    private Vector mdiskGroupStrings = new Vector();
    private Vector ioGroups = new Vector();
    private GUIMDiskGroup mdiskGroup = null;
    private GUIIOGroup ioGroup = null;
    private JPanel mdTablePanel = null;
    public boolean isMdiskQueryComplete = false;
    public boolean isIOGroupQueryComplete = false;
    public boolean isMDGroupQueryComplete = false;
    private String vdiskType = null;
    private String vdiskName = null;
    private String vdiskQuantity = null;
    private String vdiskSize = null;
    private String units = null;
    private Vector mdisks = null;
    private String roundRobin = null;
    private String format = null;
    private String[] vdiskTypes = new String[]{Util.getString("DISK_VDISK_TYPE_STRIPED"), Util.getString("DISK_VDISK_TYPE_SEQUENTIAL")};
    private String[] unitsArray = new String[]{Util.getString("DISK_BYTES"), Util.getString("DISK_KB"), Util.getString("DISK_MB"), Util.getString("DISK_GB"), Util.getString("DISK_TB"), Util.getString("DISK_PB")};
    private static final String[] COL_NAMES = new String[]{Util.getString("DISK_MDISKID_LABEL"), Util.getString("DISK_NAME_LABEL"), Util.getString("DISK_STATUS_LABEL"), Util.getString(Util.getString("DISK_CAPACITY_LABEL_MB"))};
    private static final int MDISK_ID = 0;
    private static final int MDISK_NAME = 1;
    private static final int MDISK_STATUS = 2;
    private static final int MDISK_CAPACITY = 3;

    public CreateVDiskSetCharacteristicsStep(int buttonFlags, String SVCID) {
        super(buttonFlags);
        this.setName("CreateVDiskSetCharacteristicsStep");
        this.diskAccessor = DiskDataAccessor.getInstance();
        this.cvWizard = (CreateVDiskWizard)this.getParent();
        this.svcID = SVCID;
        this.getFinishButton().setEnabled(false);
        this.getPreviousButton().setEnabled(false);
        this.nextButton = this.getNextButton();
        Container pane = this.getContentPane();
        pane.add(this.create());
        this.setUpHelp(DiskConstants.DISK_CREATE_VDISK_SET_CHARACTERISTICS);
    }

    public Object next() {
        return "CreateVDiskSelectHostPortsStep";
    }

    public Component create() {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 3));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        this.titleLabel = new JLabel(Util.getString("DISK_VDISK_CHARACTERISTICS_LABEL"));
        this.titleLabel.setAlignmentX(0.0f);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        titlePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        titlePanel.add(this.titleLabel);
        titlePanel.add(Box.createHorizontalGlue());
        Font font = this.titleLabel.getFont();
        GuiUtil.setAccessible(this.titleLabel, this.titleLabel.getText(), this.titleLabel.getText());
        this.titleLabel.setFont(font.deriveFont(1));
        pane.add(titlePanel);
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BoxLayout(descPanel, 0));
        this.descLabel = new JLabel(Util.getString("DISK_VDISK_CHARACTERISTICS_DESC_LABEL"));
        this.descLabel.setAlignmentX(0.0f);
        this.descLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        descPanel.add(this.descLabel);
        descPanel.add(Box.createHorizontalGlue());
        pane.add(descPanel);
        int labelX = 125;
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new BoxLayout(typePanel, 0));
        typePanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.typeLabel = new JLabel(Util.getString("DISK_TYPE_LABEL"));
        this.typeComboBox = new JComboBox<String>(this.vdiskTypes);
        this.typeComboBox.addActionListener(this);
        this.width = this.vdiskTypes[1].length() * this.typeComboBox.getFontMetrics(this.getFont()).charWidth(0) + 2;
        this.height = this.typeComboBox.getFontMetrics(this.getFont()).getHeight() + 5;
        this.typeComboBox.setPreferredSize(new Dimension(this.width, this.height));
        GuiUtil.setAccessibleLabel(this.typeLabel, this.typeComboBox, "", this.typeLabel.getText(), this.typeLabel.getText());
        typePanel.add(this.typeLabel);
        typePanel.add(Box.createRigidArea(new Dimension(labelX - this.typeLabel.getPreferredSize().width, 0)));
        typePanel.add(this.typeComboBox);
        typePanel.add(Box.createHorizontalGlue());
        pane.add(typePanel);
        JPanel quantityPanel = new JPanel();
        quantityPanel.setLayout(new BoxLayout(quantityPanel, 0));
        quantityPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        quantityPanel.setAlignmentX(1.0f);
        this.vdiskQuantityLabel = new JLabel(Util.getString("DISK_VDISK_QUANTITY_LABEL"));
        SpinnerNumberModel volumeQModel = new SpinnerNumberModel(this.minSpinnerValue, this.minSpinnerValue, this.maxQuantitySpinnerValue, this.spinnerStep);
        this.vdiskQuantitySpinner = new JSpinner(volumeQModel);
        JSpinner.NumberEditor vdiskQuantityEditor = (JSpinner.NumberEditor)this.vdiskQuantitySpinner.getEditor();
        this.vdiskQuantityTextField = vdiskQuantityEditor.getTextField();
        this.vdiskQuantityTextField.setInputVerifier(new FormattedTextFieldVerifier());
        this.vdiskQuantitySpinner.addChangeListener(this);
        this.width = volumeQModel.getMaximum().toString().length() * this.vdiskQuantitySpinner.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = this.vdiskQuantitySpinner.getFontMetrics(this.getFont()).getHeight() + 5;
        this.vdiskQuantitySpinner.setPreferredSize(new Dimension(this.width, this.height));
        quantityPanel.add(this.vdiskQuantityLabel);
        if (labelX < this.vdiskQuantityLabel.getPreferredSize().width) {
            labelX = this.vdiskQuantityLabel.getPreferredSize().width + 2;
        }
        quantityPanel.add(Box.createRigidArea(new Dimension(labelX - this.vdiskQuantityLabel.getPreferredSize().width, 0)));
        quantityPanel.add(this.vdiskQuantitySpinner);
        quantityPanel.add(Box.createHorizontalGlue());
        GuiUtil.setAccessibleLabel(this.vdiskQuantityLabel, this.vdiskQuantitySpinner, "", this.vdiskQuantityLabel.getText(), this.vdiskQuantityLabel.getText());
        pane.add(quantityPanel);
        JPanel sizePanel = new JPanel();
        sizePanel.setLayout(new BoxLayout(sizePanel, 0));
        sizePanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        sizePanel.setAlignmentX(1.0f);
        this.vdiskSizeLabel = new JLabel(Util.getString("DISK_VDISK_SIZE_LABEL"));
        SpinnerNumberModel volumeSModel = new SpinnerNumberModel(this.minSizeSpinnerValue, this.minSizeSpinnerValue, this.maxSizeSpinnerValue, this.spinnerStep);
        this.vdiskSizeSpinner = new JSpinner(volumeSModel);
        JSpinner.NumberEditor vdiskSizeEditor = (JSpinner.NumberEditor)this.vdiskSizeSpinner.getEditor();
        this.vdiskSizeTextField = vdiskSizeEditor.getTextField();
        this.vdiskSizeTextField.setInputVerifier(new FormattedTextFieldVerifier());
        this.width = volumeSModel.getMaximum().toString().length() * this.vdiskSizeSpinner.getFontMetrics(this.getFont()).charWidth(0);
        this.height = this.vdiskSizeSpinner.getFontMetrics(this.getFont()).getHeight() + 5;
        this.vdiskSizeSpinner.setPreferredSize(new Dimension(this.width, this.height));
        sizePanel.add(this.vdiskSizeLabel);
        if (labelX < this.vdiskSizeLabel.getPreferredSize().width) {
            labelX = this.vdiskSizeLabel.getPreferredSize().width + 2;
        }
        sizePanel.add(Box.createRigidArea(new Dimension(labelX - this.vdiskSizeLabel.getPreferredSize().width, 0)));
        sizePanel.add(this.vdiskSizeSpinner);
        GuiUtil.setAccessibleLabel(this.vdiskSizeLabel, this.vdiskSizeSpinner, "", this.vdiskSizeLabel.getText(), this.vdiskSizeLabel.getText());
        pane.add(sizePanel);
        JPanel unitsPanel = new JPanel();
        unitsPanel.setLayout(new BoxLayout(unitsPanel, 0));
        this.unitsLabel = new JLabel(Util.getString("DISK_UNITS_LABEL"));
        this.unitsComboBox = new JComboBox<String>(this.unitsArray);
        this.unitsComboBox.addActionListener(this);
        unitsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        unitsPanel.add(this.unitsLabel);
        unitsPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        unitsPanel.add(this.unitsComboBox);
        this.width = this.unitsArray[3].length() * this.unitsComboBox.getFontMetrics(this.getFont()).charWidth(0) + 30;
        this.height = this.unitsComboBox.getFontMetrics(this.getFont()).getHeight() + 5;
        this.unitsComboBox.setMinimumSize(new Dimension(this.width, this.height));
        this.unitsComboBox.setPreferredSize(new Dimension(this.width, this.height));
        this.unitsComboBox.setMaximumSize(new Dimension(this.width * 2, this.height));
        this.unitsComboBox.setSelectedIndex(2);
        sizePanel.add(Box.createHorizontalGlue());
        sizePanel.add(unitsPanel);
        GuiUtil.setAccessible(this.unitsComboBox, this.unitsComboBox.getName(), this.unitsComboBox.getName());
        JPanel vdiskNamePanel = new JPanel();
        vdiskNamePanel.setLayout(new BoxLayout(vdiskNamePanel, 2));
        vdiskNamePanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.vdiskNameLabel = new JLabel(Util.getString("DISK_NAME_LABEL"));
        this.vdiskPrefixLabel = new JLabel(Util.getString("DISK_VDISK_PREFIX_LABEL"));
        PlainDocument pd = new PlainDocument(){

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str != null && str.length() + this.getLength() <= 15) {
                    super.insertString(offs, str, a);
                }
            }
        };
        this.vdiskNameTextField = new JTextField(pd, "", 15);
        this.width = 16 * this.vdiskNameTextField.getFontMetrics(this.getFont()).charWidth(0) + 2;
        this.height = this.vdiskNameTextField.getFontMetrics(this.getFont()).getHeight() + 5;
        this.vdiskNameTextField.setMinimumSize(new Dimension(this.width, this.height));
        this.vdiskNameTextField.setPreferredSize(new Dimension(this.width, this.height));
        this.vdiskNameTextField.setMaximumSize(new Dimension(this.width * 2, this.height));
        vdiskNamePanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.vdiskNameTextField.setAlignmentX(0.0f);
        vdiskNamePanel.add(this.vdiskNameLabel);
        if (labelX < this.vdiskNameLabel.getPreferredSize().width) {
            labelX = this.vdiskNameLabel.getPreferredSize().width + 2;
        }
        vdiskNamePanel.add(Box.createRigidArea(new Dimension(labelX - this.vdiskNameLabel.getPreferredSize().width, 0)));
        vdiskNamePanel.add(this.vdiskNameTextField);
        unitsPanel.add(Box.createRigidArea(new Dimension(15, 0)));
        vdiskNamePanel.add(this.vdiskPrefixLabel);
        vdiskNamePanel.add(Box.createHorizontalGlue());
        pane.add(vdiskNamePanel);
        GuiUtil.setAccessibleLabel(this.vdiskNameLabel, this.vdiskNameTextField, "", this.vdiskNameLabel.getText(), this.vdiskNameLabel.getText());
        JPanel ioPanel = new JPanel();
        ioPanel.setLayout(new BoxLayout(ioPanel, 0));
        ioPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.ioGroupLabel = new JLabel(Util.getString("DISK_VDISK_IOGROUP_LABEL"));
        this.ioGroupComboBox = new JComboBox(new Vector());
        this.ioGroupComboBox.addActionListener(this);
        this.width = this.ioGroups.size() > 0 ? this.ioGroups.get(0).toString().length() : 25;
        this.width = this.width * this.ioGroupComboBox.getFontMetrics(this.getFont()).charWidth(0) + 2;
        this.height = this.ioGroupComboBox.getFontMetrics(this.getFont()).getHeight() + 5;
        this.ioGroupComboBox.setPreferredSize(new Dimension(this.width, this.height));
        ioPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        ioPanel.add(this.ioGroupLabel);
        if (labelX < this.ioGroupLabel.getPreferredSize().width) {
            labelX = this.ioGroupLabel.getPreferredSize().width + 2;
        }
        ioPanel.add(Box.createRigidArea(new Dimension(labelX - this.ioGroupLabel.getPreferredSize().width, 0)));
        ioPanel.add(this.ioGroupComboBox);
        ioPanel.add(Box.createHorizontalGlue());
        GuiUtil.setAccessibleLabel(this.ioGroupLabel, this.ioGroupComboBox, "", this.ioGroupLabel.getText(), this.ioGroupLabel.getText());
        pane.add(ioPanel);
        JPanel mdgPanel = new JPanel();
        mdgPanel.setLayout(new BoxLayout(mdgPanel, 1));
        mdgPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        JPanel mdPanel = new JPanel();
        mdPanel.setLayout(new BoxLayout(mdPanel, 0));
        mdPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.mdGroupLabel = new JLabel(Util.getString("DISK_VDISK_MDGROUP_LABEL"));
        this.mdGroupComboBox = new JComboBox(new Vector());
        this.mdGroupComboBox.addActionListener(this);
        this.width = this.mdiskGroupStrings.size() > 0 ? this.mdiskGroupStrings.get(0).toString().length() : 25;
        this.width *= this.mdGroupComboBox.getFontMetrics(this.getFont()).charWidth(0);
        this.height = this.mdGroupComboBox.getFontMetrics(this.getFont()).getHeight() + 5;
        this.mdGroupComboBox.setPreferredSize(new Dimension(this.width, this.height));
        mdPanel.add(this.mdGroupLabel);
        if (labelX < this.mdGroupLabel.getPreferredSize().width) {
            labelX = this.mdGroupLabel.getPreferredSize().width + 2;
        }
        mdPanel.add(Box.createRigidArea(new Dimension(labelX - this.mdGroupLabel.getPreferredSize().width, 0)));
        mdPanel.add(this.mdGroupComboBox);
        mdPanel.add(Box.createHorizontalGlue());
        GuiUtil.setAccessibleLabel(this.mdGroupLabel, this.mdGroupComboBox, "", this.mdGroupLabel.getText(), this.mdGroupLabel.getText());
        mdgPanel.add(mdPanel);
        JPanel mdiskPanel = new JPanel();
        mdiskPanel.setLayout(new BoxLayout(mdiskPanel, 0));
        this.mdiskLabel = new JLabel(Util.getString("DISK_VDISK_MANAGED_DISK_LABEL"));
        this.mdiskLabel.setAlignmentX(0.0f);
        mdiskPanel.add(Box.createRigidArea(new Dimension(45, 0)));
        mdiskPanel.add(this.mdiskLabel);
        mdgPanel.add(mdiskPanel);
        mdiskPanel.add(Box.createHorizontalGlue());
        this.mdTablePanel = new JPanel();
        this.mdTablePanel.setLayout(new BoxLayout(this.mdTablePanel, 0));
        this.mdTablePanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.mdTablePanel.setPreferredSize(new Dimension(145, 120));
        this.mdiskTable = new MegaTable();
        this.mdiskTable.setMouseListener(this);
        this.mdiskTable.setColumnHidden(0, true);
        this.mdiskTable.setRowIcon(10, false);
        this.mdiskTable.setCellRenderer(BigDecimal.class, TableCellRenderers.number);
        this.mdTablePanel.add(Box.createRigidArea(new Dimension(labelX - this.mdGroupLabel.getPreferredSize().width, 0)));
        this.mdTablePanel.add(this.mdiskTable);
        this.mdTablePanel.add(Box.createHorizontalGlue());
        mdgPanel.add(this.mdTablePanel);
        this.mdiskTable.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.noDataLabel = new JLabel(Util.getString("DISK_NO_DATA_LABEL"));
        this.noDataLabel.setAlignmentX(0.0f);
        this.addMDiskButton = new JButton(Util.getString("DISK_VDISK_ADDMDISK_LABEL"));
        this.addMDiskButton.addActionListener(this);
        mdgPanel.add(Box.createHorizontalGlue());
        mdgPanel.add(this.addMDiskButton);
        mdgPanel.add(Box.createHorizontalGlue());
        pane.add(mdgPanel);
        JPanel checkPanel = new JPanel();
        checkPanel.setLayout(new BoxLayout(checkPanel, 3));
        checkPanel.setAlignmentX(1.0f);
        this.roundRobinCheckBox = new JCheckBox(Util.getString("DISK_VDISK_ROUNDROBIN_LABEL"), true);
        checkPanel.add(this.roundRobinCheckBox);
        this.roundRobinCheckBox.setEnabled(false);
        this.roundRobinCheckBox.setSelected(false);
        GuiUtil.setAccessible(this.roundRobinCheckBox, this.roundRobinCheckBox.getText(), this.roundRobinCheckBox.getText());
        checkPanel.add(Box.createHorizontalGlue());
        this.formatCheckBox = new JCheckBox(Util.getString("DISK_VDISK_FORMAT_LABEL"), true);
        checkPanel.add(this.formatCheckBox);
        checkPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        GuiUtil.setAccessible(this.formatCheckBox, this.formatCheckBox.getText(), this.formatCheckBox.getText());
        pane.add(checkPanel);
        this.setIOGroups();
        this.setMDiskGroups();
        return pane;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = null;
        int selectedIndex = 0;
        if (e == null) {
            return;
        }
        source = e.getSource();
        if (source == null) {
            return;
        }
        if (source.equals(this.typeComboBox)) {
            if (1 == this.typeComboBox.getSelectedIndex()) {
                int q = Integer.parseInt(this.vdiskQuantitySpinner.getValue().toString());
                if (q > 1) {
                    this.roundRobinCheckBox.setEnabled(true);
                }
            } else {
                this.roundRobinCheckBox.setSelected(false);
                this.roundRobinCheckBox.setEnabled(false);
            }
        }
        if (source.equals(this.ioGroupComboBox)) {
            int currentVdiskq;
            int vdiskq = 0;
            if (0 != this.ioGroupComboBox.getSelectedIndex()) {
                this.ioGroup = (GUIIOGroup)this.ioGroupComboBox.getModel().getSelectedItem();
                this.getVDisksQuantityForIOGroup(this.ioGroup);
            }
            if ((currentVdiskq = Integer.valueOf(this.vdiskQuantitySpinner.getModel().getValue().toString()).intValue()) > (vdiskq = ((Integer)((SpinnerNumberModel)this.vdiskQuantitySpinner.getModel()).getMaximum()).intValue())) {
                String[] args = new String[]{String.valueOf(vdiskq)};
                String s = Util.getString("DMSG_DISK_VDISK_MAX_QUANTITY", args);
                JOptionPane.showMessageDialog(this, s, Util.getString("DISK_VDISK_QUANTITY_LABEL"), 0);
            }
        }
        if (source.equals(this.mdGroupComboBox)) {
            this.invalidateMDGroups();
        }
        if (source.equals(this.addMDiskButton)) {
            String mds = (String)this.mdGroupComboBox.getModel().getSelectedItem();
            selectedIndex = this.mdiskGroupStrings.indexOf(mds);
            this.mdiskGroup = (GUIMDiskGroup)this.mdiskGroups.get(mds);
            if (this.mdiskGroup != null) {
                CreateVDiskAddMDiskDialog addMDisk = CreateVDiskAddMDiskDialog.getAddMDiskDialogInstance(this, this.svcID, this.mdiskGroup);
                addMDisk.pack();
                GuiUtil.centerDialog(addMDisk);
                addMDisk.show();
            }
        }
    }

    public void invalidateMDGroups() {
        String mdiskGroupID = null;
        int selectedIndex = 0;
        String mds = (String)this.mdGroupComboBox.getModel().getSelectedItem();
        selectedIndex = this.mdiskGroupStrings.indexOf(mds);
        this.mdiskGroup = (GUIMDiskGroup)this.mdiskGroups.get(mds);
        mdiskGroupID = this.mdiskGroup.getId();
        this.fillData(this.svcID, mdiskGroupID);
        long ss = this.getMaxVDiskSize(this.mdiskGroup);
        long currentSize = Long.valueOf(this.vdiskSizeSpinner.getModel().getValue().toString());
        this.vdiskSizeBytes = GUIEntityUtil.convertStorageCapacity(currentSize, this.unitsComboBox.getSelectedIndex(), 0);
        if (this.vdiskSizeBytes > ss) {
            if (ss > Integer.MAX_VALUE) {
                ss = Integer.MAX_VALUE;
            }
            ss = GUIEntityUtil.convertStorageCapacity(ss, 0, this.unitsComboBox.getSelectedIndex());
            this.vdiskSizeSpinner.setValue(new Integer(String.valueOf(ss)));
        }
        if (this.vdiskSizeBytes > ss) {
            String[] args = new String[]{String.valueOf(ss)};
            String s = Util.getString("DMSG_DISK_VDISK_MAX_SIZE", args);
            JOptionPane.showMessageDialog(this, s, Util.getString("DISK_VDISK_SIZE_LABEL"), 0);
        }
        this.invalidate();
    }

    private void enableControls(boolean enable) {
        if (enable && this.isMdiskQueryComplete && this.isIOGroupQueryComplete && this.isMDGroupQueryComplete) {
            this.nextButton.setEnabled(enable);
            this.addMDiskButton.setEnabled(enable);
        } else {
            this.nextButton.setEnabled(false);
            this.addMDiskButton.setEnabled(false);
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object source = null;
        if (e == null) {
            return;
        }
        source = e.getSource();
        if (source == null) {
            return;
        }
        if (source.equals(this.vdiskQuantitySpinner)) {
            int q = Integer.parseInt(this.vdiskQuantitySpinner.getValue().toString());
            if (1 == this.typeComboBox.getSelectedIndex() && q > 1) {
                this.roundRobinCheckBox.setEnabled(true);
            } else {
                this.roundRobinCheckBox.setEnabled(false);
            }
            q = q < 10 ? 1 : (q < 100 ? 2 : (q < 1000 ? 3 : 4));
            this.nameLen = 15 - q;
            String nameText = this.vdiskNameTextField.getText();
            PlainDocument pd = new PlainDocument(){

                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    if (str != null && str.length() + this.getLength() <= CreateVDiskSetCharacteristicsStep.this.nameLen) {
                        super.insertString(offs, str, a);
                    }
                }
            };
            this.vdiskNameTextField.setDocument(pd);
            this.vdiskNameTextField.setColumns(this.nameLen);
            if (nameText.length() > this.nameLen) {
                nameText = nameText.substring(0, this.nameLen);
            }
            this.vdiskNameTextField.setText(nameText);
        }
    }

    public boolean select(int viewRow, int viewCol) {
        boolean selectIt = true;
        if (this.dblClick) {
            this.dblClick = false;
            selectIt = false;
        }
        return selectIt;
    }

    public void showDefaultChart(int dataRow) {
    }

    public void selectionChanged(boolean state) {
    }

    public void doubleClick(int dataRow, int dataCol) {
        this.dblClick = true;
    }

    public void showPopup(int dataRow, int dataCol, Component c, int x, int y) {
    }

    private void setIOGroups() {
        this.ioGroups = new Vector();
        this.enableControls(false);
        this.diskAccessor.getIOGroupsBySVC(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4 && response != null) {
                    CreateVDiskSetCharacteristicsStep.this.iogroupsmap = (HashMap)response.responseData;
                    if (CreateVDiskSetCharacteristicsStep.this.iogroupsmap != null) {
                        CreateVDiskSetCharacteristicsStep.this.ioGroups = new Vector(CreateVDiskSetCharacteristicsStep.this.iogroupsmap.values());
                    }
                    CreateVDiskSetCharacteristicsStep.this.ioGroups = GUIEntityUtil.sort(CreateVDiskSetCharacteristicsStep.this.ioGroups);
                    CreateVDiskSetCharacteristicsStep.this.ioGroups.insertElementAt(Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL"), 0);
                    DefaultComboBoxModel ioModel = new DefaultComboBoxModel(CreateVDiskSetCharacteristicsStep.this.ioGroups);
                    CreateVDiskSetCharacteristicsStep.this.ioGroupComboBox.setModel(ioModel);
                    CreateVDiskSetCharacteristicsStep.this.ioGroupComboBox.setSelectedIndex(0);
                }
                CreateVDiskSetCharacteristicsStep.this.isIOGroupQueryComplete = true;
                CreateVDiskSetCharacteristicsStep.this.enableControls(true);
            }
        }, this.svcID);
    }

    public JDialog getWizardDialog() {
        CreateVDiskWizard cvWizard = (CreateVDiskWizard)this.getParent();
        JDialog wizardDialog = (JDialog)cvWizard.getParent().getParent().getParent().getParent();
        return wizardDialog;
    }

    private void setMDiskGroups() {
        this.mdiskGroups = new HashMap();
        this.mdiskGroupStrings = new Vector();
        this.enableControls(false);
        this.diskAccessor.getMDiskGroupsBySVC(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4 && response != null) {
                    CreateVDiskSetCharacteristicsStep.this.mdgroupsmap = (HashMap)response.responseData;
                    GUIMDiskGroup mdgrp2 = null;
                    String mdString = new String();
                    float cap = 0.0f;
                    if (CreateVDiskSetCharacteristicsStep.this.mdgroupsmap != null) {
                        for (GUIMDiskGroup mdgrp2 : CreateVDiskSetCharacteristicsStep.this.mdgroupsmap.values()) {
                            cap = mdgrp2.getUnusedCapacity();
                            cap = GUIEntityUtil.convertStorageCapacityDecimal(mdgrp2.getUnusedCapacity(), 0, 3, 2);
                            mdString = mdgrp2.getDeviceId() + " (" + cap + " " + CreateVDiskSetCharacteristicsStep.this.unitsArray[3] + " )";
                            CreateVDiskSetCharacteristicsStep.this.mdiskGroupStrings.add(mdString);
                            CreateVDiskSetCharacteristicsStep.this.mdiskGroups.put(mdString, mdgrp2);
                        }
                        Collections.sort(CreateVDiskSetCharacteristicsStep.this.mdiskGroupStrings);
                    }
                    DefaultComboBoxModel mdModel = new DefaultComboBoxModel(CreateVDiskSetCharacteristicsStep.this.mdiskGroupStrings);
                    CreateVDiskSetCharacteristicsStep.this.mdGroupComboBox.setModel(mdModel);
                    if (CreateVDiskSetCharacteristicsStep.this.mdiskGroupStrings.size() > 0) {
                        CreateVDiskSetCharacteristicsStep.this.mdGroupComboBox.setSelectedIndex(0);
                    }
                }
                CreateVDiskSetCharacteristicsStep.this.isMDGroupQueryComplete = true;
                CreateVDiskSetCharacteristicsStep.this.enableControls(true);
            }
        }, this.svcID);
    }

    private Vector getselectedMDisks() {
        Vector<GUIMDisk> selectedMDisks = new Vector<GUIMDisk>();
        if (!this.mdiskTable.isVisible() || this.mdiskGroup == null) {
            return selectedMDisks;
        }
        int[] selectedRows = this.mdiskTable.getSelectedRows();
        if (selectedRows == null) {
            return selectedMDisks;
        }
        if (selectedRows.length <= 0) {
            return selectedMDisks;
        }
        GUIMDisk mdsk = null;
        mdiskTableModel mt = (mdiskTableModel)this.mdiskTable.getDataSource();
        for (int i = 0; mt != null && i < selectedRows.length; ++i) {
            mdsk = mt.getMDisk(selectedRows[i]);
            if (mdsk == null) continue;
            selectedMDisks.add(mdsk);
        }
        return selectedMDisks;
    }

    private long getMaxVDiskSize(GUIMDiskGroup mdg) {
        long size = 0L;
        long capacity = -1L;
        long vdiskno = -1L;
        capacity = mdg.getUnusedCapacity();
        vdiskno = Long.valueOf(this.vdiskQuantitySpinner.getModel().getValue().toString());
        if (vdiskno > 0L) {
            size = capacity / vdiskno;
        }
        return size;
    }

    private int getVDisksQuantityForIOGroup(GUIIOGroup ioGroup) {
        int vdiskno = 0;
        if (ioGroup == null) {
            return vdiskno;
        }
        this.nextButton.setEnabled(false);
        this.addMDiskButton.setEnabled(false);
        this.diskAccessor.getVDiskIdsByIOGroup(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4 && response != null) {
                    CreateVDiskSetCharacteristicsStep.access$1002(CreateVDiskSetCharacteristicsStep.this, (String[])response.responseData);
                    int vdiskq = CreateVDiskSetCharacteristicsStep.this.vdiskIDs.length;
                    vdiskq = 1024 - vdiskq;
                    ((SpinnerNumberModel)CreateVDiskSetCharacteristicsStep.this.vdiskQuantitySpinner.getModel()).setMaximum(new Integer(vdiskq));
                }
                CreateVDiskSetCharacteristicsStep.this.nextButton.setEnabled(true);
                CreateVDiskSetCharacteristicsStep.this.addMDiskButton.setEnabled(true);
            }
        }, this.svcID, ioGroup.getId());
        return vdiskno;
    }

    private boolean validateName(String name) {
        if (name.length() == 0) {
            return true;
        }
        if (name.toLowerCase(this.getLocale()).startsWith(Util.getString("DISK_TOOLTIP_VDISK_LABEL").toLowerCase(this.getLocale()))) {
            return false;
        }
        char[] nameArray = name.toCharArray();
        if (Character.isDigit(nameArray[0])) {
            return false;
        }
        if (nameArray[0] == '-') {
            return false;
        }
        for (int idx = 0; idx < nameArray.length; ++idx) {
            if (nameArray[idx] >= 'a' && nameArray[idx] <= 'z' || nameArray[idx] >= 'A' && nameArray[idx] <= 'Z' || nameArray[idx] >= '0' && nameArray[idx] <= '9' || nameArray[idx] == '_' || nameArray[idx] == '-') continue;
            return false;
        }
        return true;
    }

    private boolean validateSize(long vdisksize, long maxSize) {
        if (vdisksize < 512L || vdisksize / 512L * 512L != vdisksize) {
            return false;
        }
        return vdisksize <= maxSize;
    }

    private boolean validateSizeQuantity(long vdisksize) {
        Object md = null;
        long lext = -1L;
        long sum = 0L;
        long vcount = Long.parseLong(this.vdiskQuantity);
        switch (this.typeComboBox.getSelectedIndex()) {
            case 0: {
                for (int i = 0; i < this.mdisks.size(); ++i) {
                    lext = ((GUIMDisk)this.mdisks.get(i)).getUnusedCapacity();
                    if (lext == -1L) {
                        return false;
                    }
                    sum += lext;
                }
                this.maxVDiskSize = sum / vcount;
                break;
            }
            case 1: {
                sum = Long.MAX_VALUE;
                for (int i = 0; i < this.mdisks.size(); ++i) {
                    lext = ((GUIMDisk)this.mdisks.get(i)).getUnusedCapacity();
                    if (lext == -1L) {
                        return false;
                    }
                    if (lext >= sum) continue;
                    sum = lext;
                }
                this.maxVDiskSize = sum / vcount;
            }
        }
        return this.vdiskSizeBytes <= this.maxVDiskSize;
    }

    public void fillData(String sID, String mID) {
        this.enableControls(true);
        this.diskAccessor.getMDisksByMDiskGroup(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4 && response != null) {
                    CreateVDiskSetCharacteristicsStep.this.mdiskMap = (HashMap)response.responseData;
                    CreateVDiskSetCharacteristicsStep.access$1302(CreateVDiskSetCharacteristicsStep.this, CreateVDiskSetCharacteristicsStep.this.mdiskMap.keySet().toArray(new String[0]));
                    int mdgrowCount = CreateVDiskSetCharacteristicsStep.this.mdiskMap.size();
                    CreateVDiskSetCharacteristicsStep.this.tableModel = new mdiskTableModel();
                    CreateVDiskSetCharacteristicsStep.this.mdiskTable.setBaseTableModel(CreateVDiskSetCharacteristicsStep.this.tableModel);
                    if (mdgrowCount <= 0) {
                        CreateVDiskSetCharacteristicsStep.this.mdiskTable.setVisible(false);
                        CreateVDiskSetCharacteristicsStep.this.mdTablePanel.add(CreateVDiskSetCharacteristicsStep.this.noDataLabel);
                        CreateVDiskSetCharacteristicsStep.this.mdTablePanel.add(Box.createHorizontalGlue());
                    } else {
                        CreateVDiskSetCharacteristicsStep.this.mdTablePanel.remove(CreateVDiskSetCharacteristicsStep.this.noDataLabel);
                        CreateVDiskSetCharacteristicsStep.this.mdiskTable.setVisible(true);
                        CreateVDiskSetCharacteristicsStep.this.mdiskTable.sortByColumn(0, 1);
                        CreateVDiskSetCharacteristicsStep.this.mdiskTable.setFrozenColumns(0);
                    }
                }
                CreateVDiskSetCharacteristicsStep.this.isMdiskQueryComplete = true;
                CreateVDiskSetCharacteristicsStep.this.enableControls(true);
            }
        }, sID, mID);
    }

    public boolean nextBegin() {
        int index = -1;
        String tempIOGroup = new String();
        this.vdiskType = (String)this.typeComboBox.getModel().getSelectedItem();
        index = this.ioGroupComboBox.getSelectedIndex();
        this.ioGroup = index == 0 ? null : (GUIIOGroup)this.ioGroups.get(index);
        String mdg = (String)this.mdGroupComboBox.getSelectedItem();
        this.mdiskGroup = (GUIMDiskGroup)this.mdiskGroups.get(mdg);
        this.vdiskQuantity = this.vdiskQuantitySpinner.getModel().getValue().toString();
        this.vdiskSize = this.vdiskSizeSpinner.getModel().getValue().toString();
        this.units = (String)this.unitsComboBox.getModel().getSelectedItem();
        this.mdisks = this.getselectedMDisks();
        this.roundRobin = this.roundRobinCheckBox.isSelected() ? Util.getString("FabricDetails_true") : Util.getString("FabricDetails_false");
        this.format = this.formatCheckBox.isSelected() ? Util.getString("FabricDetails_true") : Util.getString("FabricDetails_false");
        this.vdiskName = this.vdiskNameTextField.getText();
        this.vdiskSizeBytes = GUIEntityUtil.convertStorageCapacity(Long.parseLong(this.vdiskSize), this.unitsComboBox.getSelectedIndex(), 0);
        if (this.mdisks.size() <= 0) {
            if (1 == this.typeComboBox.getSelectedIndex() || this.mdiskGroup == null) {
                String s = Util.getString("DMSG_DISK_VDISK_MDISK");
                JOptionPane.showMessageDialog(this, s, Util.getString("DISK_VDISK_MDISKS_LABEL"), 0);
                return false;
            }
            int rows = ((mdiskTableModel)this.mdiskTable.getDataSource()).getNumRows();
            for (int i = 0; i < rows; ++i) {
                this.mdisks.add(((mdiskTableModel)this.mdiskTable.getDataSource()).getMDisk(i));
            }
        }
        if (!this.validateName(this.vdiskName)) {
            String s = Util.getString("DMSG_DISK_VDISK_NAME");
            JOptionPane.showMessageDialog(this, s, Util.getString("DISK_VDISK_NAME_LABEL"), 0);
            return false;
        }
        if (this.typeComboBox.getSelectedIndex() == 1) {
            if (this.roundRobinCheckBox.isEnabled()) {
                if (this.roundRobinCheckBox.isSelected()) {
                    if (Integer.parseInt(this.vdiskQuantity) != this.mdisks.size()) {
                        String[] args = new String[]{this.vdiskQuantity};
                        String s = Util.getString("DMSG_DISK_VDISK_SEQENTIAL_ROUNDROBIN_QUANTITY", args);
                        JOptionPane.showMessageDialog(this, s, Util.getString("DISK_VDISK_QUANTITY_LABEL"), 0);
                        return false;
                    }
                } else if (this.mdisks.size() != 1) {
                    String s = Util.getString("DMSG_DISK_VDISK_SEQENTIAL_QUANTITY");
                    JOptionPane.showMessageDialog(this, s, Util.getString("DISK_VDISK_QUANTITY_LABEL"), 0);
                    return false;
                }
            } else if (Integer.parseInt(this.vdiskQuantity) != this.mdisks.size()) {
                String[] args = new String[]{this.vdiskQuantity};
                String s = Util.getString("DMSG_DISK_VDISK_SEQENTIAL_ROUNDROBIN_QUANTITY", args);
                JOptionPane.showMessageDialog(this, s, Util.getString("DISK_VDISK_QUANTITY_LABEL"), 0);
                return false;
            }
        }
        long asize = this.getMaxVDiskSize(this.mdiskGroup);
        if (this.vdiskSizeBytes == 0L) {
            String[] args = new String[]{String.valueOf(512) + " " + this.unitsArray[0]};
            String s = Util.getString("DMSG_DISK_VOLUME_MIN_SIZE", args);
            JOptionPane.showMessageDialog(this, s, Util.getString("DISK_VDISK_SIZE_LABEL"), 0);
            return false;
        }
        if (!this.validateSize(this.vdiskSizeBytes, asize)) {
            asize = GUIEntityUtil.convertStorageCapacity(asize, 0, this.unitsComboBox.getSelectedIndex());
            String[] args = new String[]{String.valueOf(asize) + " " + this.units};
            String s = Util.getString("DMSG_DISK_VDISK_SIZE", args);
            JOptionPane.showMessageDialog(this, s, Util.getString("DISK_VDISK_SIZE_LABEL"), 0);
            return false;
        }
        int vdiskq = this.getVDisksQuantityForIOGroup(this.ioGroup);
        if (Integer.valueOf(this.vdiskQuantity) <= 0) {
            String[] args = new String[]{String.valueOf(vdiskq)};
            String s = Util.getString("DMSG_DISK_VDISK_QUANTITY", args);
            JOptionPane.showMessageDialog(this, s, Util.getString("DISK_VDISK_QUANTITY_LABEL"), 0);
            return false;
        }
        if (!this.validateSizeQuantity(this.vdiskSizeBytes)) {
            this.maxVDiskSize = GUIEntityUtil.convertStorageCapacity(this.maxVDiskSize, 0, this.unitsComboBox.getSelectedIndex());
            String[] args = new String[]{String.valueOf(this.maxVDiskSize) + " " + this.units};
            String s = Util.getString("DMSG_DISK_VDISK_MAX_SIZE", args);
            JOptionPane.showMessageDialog(this, s, Util.getString("DISK_VDISK_SIZE_LABEL"), 0);
            return false;
        }
        this.cvWizard = (CreateVDiskWizard)this.getParent();
        this.cvWizard.addVDiskData(Util.getString("DISK_TYPE_LABEL"), this.vdiskType);
        this.cvWizard.addVDiskData(Util.getString("DISK_VDISK_QUANTITY_LABEL"), this.vdiskQuantity);
        this.cvWizard.addVDiskData(Util.getString("DISK_VDISK_SIZE_LABEL"), this.vdiskSize);
        this.cvWizard.addVDiskData(Util.getString("DISK_UNITS_LABEL"), this.units);
        this.cvWizard.addVDiskData(Util.getString("DISK_VDISK_NAME_LABEL"), this.vdiskName);
        this.cvWizard.addVDiskData(Util.getString("DISK_VDISK_IOGROUP_LABEL"), this.ioGroup);
        this.cvWizard.addVDiskData(Util.getString("DISK_VDISK_MDGROUP_LABEL"), this.mdiskGroup);
        this.cvWizard.addVDiskData(Util.getString("DISK_VDISK_MDISKS_LABEL"), this.mdisks);
        this.cvWizard.addVDiskData(Util.getString("DISK_VDISK_ROUNDROBIN_LABEL"), this.roundRobin);
        this.cvWizard.addVDiskData(Util.getString("DISK_VDISK_FORMAT_LABEL"), this.format);
        return true;
    }

    static /* synthetic */ String[] access$1002(CreateVDiskSetCharacteristicsStep x0, String[] x1) {
        x0.vdiskIDs = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1302(CreateVDiskSetCharacteristicsStep x0, String[] x1) {
        x0.mdiskIDs = x1;
        return x1;
    }

    protected class mdiskTableModel
    extends BaseTableModel {
        private String[] mdiskStatus = new String[]{Util.getString("DISK_MDISK_STATUS_OFFLINE"), Util.getString("DISK_MDISK_STATUS_ONLINE"), Util.getString("DISK_MDISK_STATUS_DEGRADED"), Util.getString("DISK_MDISK_STATUS_EXCLUDED")};

        public mdiskTableModel() {
            this.columnNames = COL_NAMES;
            this.rowCount = CreateVDiskSetCharacteristicsStep.this.mdiskMap.size();
        }

        public GUIMDisk getMDisk(int row) {
            return (GUIMDisk)CreateVDiskSetCharacteristicsStep.this.mdiskMap.get(CreateVDiskSetCharacteristicsStep.this.mdiskIDs[row]);
        }

        public Object getTableDataItem(int row, int col) {
            this.rowCount = CreateVDiskSetCharacteristicsStep.this.mdiskMap.size();
            if (this.rowCount <= 0) {
                return null;
            }
            GUIMDisk mdisk = (GUIMDisk)CreateVDiskSetCharacteristicsStep.this.mdiskMap.get(CreateVDiskSetCharacteristicsStep.this.mdiskIDs[row]);
            switch (col) {
                case 0: {
                    return mdisk.getId();
                }
                case 1: {
                    return mdisk.getName();
                }
                case 2: {
                    return this.mdiskStatus[mdisk.getNativeStatus()];
                }
                case 3: {
                    long ll = new Long(mdisk.getCapacity());
                    ll = GUIEntityUtil.convertStorageCapacity(ll, 0, 2);
                    return new BigDecimal(ll);
                }
            }
            return "";
        }
    }
}

