/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.disk.common.DiskConstants;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.volume.PortAssignmentSelectHostPortsStep;
import org.eclipse.aperi.gui.disk.volume.PortAssignmentSelectSubsystemPortsStep;
import org.eclipse.aperi.gui.disk.volume.PortAssignmentWizard;
import org.eclipse.aperi.gui.disk.volume.PortAssignmentZoneActionStep;

public class PortAssignmentReviewStep
extends WizardPage {
    private JPanel subSystemPortPanel = null;
    private JPanel subSystemLabelPanel = null;
    private JLabel titleLabel = null;
    private JTextArea descLabel = null;
    private JLabel zoneActionLabel = null;
    private JLabel hostPortLabel = null;
    private JLabel unAssignHostPortLabel = null;
    private JLabel subSystemPortLabel = null;
    private JList zoneActionList = null;
    private JList hostPortList = null;
    private JList unAssignHostPortList = null;
    private JList subSystemPortList = null;
    private DefaultListModel zoneActionListModel = null;
    private DefaultListModel hostPortListModel = null;
    private DefaultListModel unAssignhostPortListModel = null;
    private DefaultListModel subSystemPortListModel = null;
    private PortAssignmentWizard paWizard = null;
    private HashMap portData = null;
    private int width = 0;
    private int height = 0;
    private boolean isHelpSet = false;

    public PortAssignmentReviewStep(int buttonFlags) {
        super(buttonFlags);
        this.setName("PortAssignmentReviewStep");
        Container pane = this.getContentPane();
        pane.add(this.create());
        this.setUpHelp(DiskConstants.DISK_ASSIGN_REVIEW);
    }

    public Object next() {
        return null;
    }

    public Container create() {
        GridBagPanel tempPanel = new GridBagPanel();
        tempPanel.setDefaultInsets(new Insets(0, 12, 0, 8));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        this.titleLabel = new JLabel(Util.getString("DISK_VOLUME_REVIEW_SETTINGS_LABEL"));
        this.titleLabel.setAlignmentX(0.0f);
        titlePanel.add(this.titleLabel);
        titlePanel.add(Box.createHorizontalGlue());
        Font font = this.titleLabel.getFont();
        GuiUtil.setAccessible(this.titleLabel, this.titleLabel.getText(), this.titleLabel.getText());
        this.titleLabel.setFont(font.deriveFont(1));
        tempPanel.add((JComponent)titlePanel, 23);
        tempPanel.newRow();
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BoxLayout(descPanel, 0));
        this.descLabel = new JTextArea(Util.getString("DISK_PORT_ASSIGNMENT_REVIEW_SETTINGS_DESC_LABEL"));
        this.descLabel.setEditable(false);
        this.descLabel.setLineWrap(true);
        this.descLabel.setWrapStyleWord(true);
        this.descLabel.setBackground((Color)UIManager.get("Label.background"));
        this.descLabel.setForeground((Color)UIManager.get("Label.foreground"));
        this.descLabel.setFont((Font)UIManager.get("Label.font"));
        this.descLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        descPanel.add(this.descLabel);
        descPanel.add(Box.createHorizontalGlue());
        tempPanel.add((JComponent)descPanel, 0, 1, 2);
        tempPanel.newRow();
        tempPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        JPanel zoneListPanel = new JPanel();
        JPanel zoneLabelPanel = new JPanel();
        zoneLabelPanel.setLayout(new BoxLayout(zoneLabelPanel, 0));
        this.zoneActionLabel = new JLabel(Util.getString("DISK_ZONE_ACTIONS_LABEL"));
        zoneLabelPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        zoneLabelPanel.add(this.zoneActionLabel);
        zoneLabelPanel.add(Box.createHorizontalGlue());
        zoneListPanel.setLayout(new BoxLayout(zoneListPanel, 0));
        this.zoneActionList = new JList();
        JScrollPane zoneScrollPanel = new JScrollPane(this.zoneActionList);
        this.zoneActionList.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        zoneListPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        zoneListPanel.add(zoneScrollPanel);
        this.width = 16 * this.zoneActionList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.zoneActionList.getFontMetrics(this.getFont()).getHeight() + 1) * 5;
        zoneListPanel.setMinimumSize(new Dimension(this.width, this.height));
        zoneListPanel.setPreferredSize(new Dimension(this.width, this.height));
        zoneListPanel.setMaximumSize(new Dimension(this.width * 2, this.height));
        zoneListPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        tempPanel.add(zoneLabelPanel);
        tempPanel.newRow();
        tempPanel.add((JComponent)zoneListPanel, 0, 1, 2);
        tempPanel.newRow();
        JPanel assignPortPanel = new JPanel();
        assignPortPanel.setLayout(new BoxLayout(assignPortPanel, 1));
        this.hostPortLabel = new JLabel(Util.getString("DISK_HOSTPORTS_LABEL"));
        this.hostPortList = new JList();
        JScrollPane portScrollPanel = new JScrollPane(this.hostPortList);
        assignPortPanel.add(this.hostPortLabel);
        assignPortPanel.add(portScrollPanel);
        this.width = 16 * this.hostPortList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.hostPortList.getFontMetrics(this.getFont()).getHeight() + 1) * 5;
        assignPortPanel.setMinimumSize(new Dimension(this.width, this.height));
        assignPortPanel.setPreferredSize(new Dimension(this.width, this.height));
        assignPortPanel.setMaximumSize(new Dimension(this.width * 2, this.height));
        assignPortPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        JPanel unAssignPortPanel = new JPanel();
        unAssignPortPanel.setLayout(new BoxLayout(unAssignPortPanel, 1));
        this.unAssignHostPortLabel = new JLabel(Util.getString("DISK_UNASSIGN_HOSTPORTS_LABEL"));
        this.unAssignHostPortList = new JList();
        JScrollPane unAssignportScrollPanel = new JScrollPane(this.unAssignHostPortList);
        unAssignPortPanel.add(this.unAssignHostPortLabel);
        unAssignPortPanel.add(unAssignportScrollPanel);
        this.width = 16 * this.unAssignHostPortList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.unAssignHostPortList.getFontMetrics(this.getFont()).getHeight() + 1) * 5;
        unAssignPortPanel.setMinimumSize(new Dimension(this.width, this.height));
        unAssignPortPanel.setPreferredSize(new Dimension(this.width, this.height));
        unAssignPortPanel.setMaximumSize(new Dimension(this.width * 2, this.height));
        unAssignPortPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        tempPanel.add(assignPortPanel);
        tempPanel.add((JComponent)unAssignPortPanel, 0, 1, 2);
        tempPanel.newRow();
        this.subSystemPortPanel = new JPanel();
        this.subSystemLabelPanel = new JPanel();
        this.subSystemLabelPanel.setLayout(new BoxLayout(this.subSystemLabelPanel, 0));
        this.subSystemPortLabel = new JLabel(Util.getString("DISK_SUBSYSTEMPORTS_LABEL"));
        this.subSystemLabelPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.subSystemLabelPanel.add(this.subSystemPortLabel);
        this.subSystemLabelPanel.add(Box.createHorizontalGlue());
        this.subSystemPortPanel.setLayout(new BoxLayout(this.subSystemPortPanel, 0));
        this.subSystemPortList = new JList();
        JScrollPane subSystemScrollPanel = new JScrollPane(this.subSystemPortList);
        this.subSystemPortList.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.subSystemPortPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.subSystemPortPanel.add(subSystemScrollPanel);
        this.width = 16 * this.subSystemPortList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.subSystemPortList.getFontMetrics(this.getFont()).getHeight() + 1) * 5;
        this.subSystemPortPanel.setMinimumSize(new Dimension(this.width, this.height));
        this.subSystemPortPanel.setPreferredSize(new Dimension(this.width, this.height));
        this.subSystemPortPanel.setMaximumSize(new Dimension(this.width * 2, this.height));
        this.subSystemPortPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        tempPanel.add(this.subSystemLabelPanel);
        tempPanel.newRow();
        tempPanel.add((JComponent)this.subSystemPortPanel, 0, 1, 2);
        tempPanel.newRow();
        tempPanel.add((JComponent)new JLabel(), 1);
        this.getNextButton().setEnabled(false);
        this.paWizard = (PortAssignmentWizard)this.getParent();
        return tempPanel;
    }

    public void fillData() {
        this.paWizard = (PortAssignmentWizard)this.getParent();
        this.portData = this.paWizard.getData();
        Vector hostports = (Vector)this.portData.get(PortAssignmentSelectHostPortsStep.HOSTPORTS_DATA);
        Vector<String> hostportString = new Vector<String>();
        GUIPort port = null;
        String portname = new String();
        String hostname = new String();
        for (int i = 0; hostports != null && i < hostports.size(); ++i) {
            port = (GUIPort)hostports.get(i);
            if (port != null) {
                portname = port.getName();
                hostname = port.getHostName();
                if (hostname != null && hostname.trim().length() > 0) {
                    portname = portname + " (" + hostname + ")";
                }
                hostportString.add(portname);
                continue;
            }
            hostportString.add((String)hostports.get(i));
        }
        this.hostPortListModel = this.addVectorToModel(hostportString);
        this.hostPortList.setModel(this.hostPortListModel);
        Vector unAssignhostports = (Vector)this.portData.get(PortAssignmentSelectHostPortsStep.HOSTPORTS_UNASSIGNED_HOSTS_DATA);
        this.unAssignhostPortListModel = this.addVectorToModel(unAssignhostports);
        this.unAssignHostPortList.setModel(this.unAssignhostPortListModel);
        HashMap assignhostports = (HashMap)this.portData.get(PortAssignmentSelectHostPortsStep.HOSTPORTS_ASSIGNED_DATA);
        Vector sshostports = (Vector)this.portData.get(PortAssignmentSelectSubsystemPortsStep.SUBSYSTEM_DATA);
        Vector<String> sshostportString = new Vector<String>();
        port = null;
        for (int i = 0; sshostports != null && i < sshostports.size(); ++i) {
            port = (GUIPort)sshostports.get(i);
            sshostportString.add(port.getWwpn() + "(" + port.getHostName() + ")");
        }
        this.subSystemPortListModel = this.addVectorToModel(sshostportString);
        this.subSystemPortList.setModel(this.subSystemPortListModel);
        HashMap zoneAction = (HashMap)this.portData.get(PortAssignmentZoneActionStep.ZONE_LIST_DATA);
        Vector<Object> zoneVector = new Vector();
        if (zoneAction != null) {
            zoneVector = new Vector(zoneAction.values());
        }
        this.zoneActionListModel = this.addVectorToModel(zoneVector);
        this.zoneActionList.setModel(this.zoneActionListModel);
    }

    public boolean nextBegin() {
        return false;
    }

    private DefaultListModel addVectorToModel(Vector vv) {
        DefaultListModel model = new DefaultListModel();
        if (vv == null) {
            return model;
        }
        for (int i = 0; i < vv.size(); ++i) {
            model.add(i, vv.get(i));
        }
        return model;
    }
}

