/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.gui.GuiDeviceJob;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.Wizard;
import org.eclipse.aperi.gui.WizardEvent;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.DiskDataController;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.common.model.GUIVolume;
import org.eclipse.aperi.gui.disk.volume.BaseZoneActionStep;
import org.eclipse.aperi.gui.disk.volume.PortAssignmentReviewStep;
import org.eclipse.aperi.gui.disk.volume.PortAssignmentSelectHostPortsStep;
import org.eclipse.aperi.gui.disk.volume.PortAssignmentSelectSubsystemPortsStep;
import org.eclipse.aperi.gui.disk.volume.PortAssignmentZoneActionStep;
import org.eclipse.aperi.request.Response;

public class PortAssignmentWizard
extends Wizard {
    private PortAssignmentSelectHostPortsStep hostStep = null;
    private PortAssignmentSelectSubsystemPortsStep portStep = null;
    private PortAssignmentZoneActionStep zoneStep = null;
    private PortAssignmentReviewStep reviewStep = null;
    private String SS_ID = null;
    private String deviceID = null;
    private GUIVolume selectedVolume = null;
    private DiskDataAccessor diskAccessor = null;
    private Vector mapVector = new Vector();
    private JDialog wizardDialog = null;
    private GUIStorageSubsystem subSystem = null;
    private DiskDataController diskController = null;
    private String[] volumeIDs = null;
    private Vector hostportWWPNs = new Vector();
    private Vector ssportWWPNs = new Vector();
    private Vector unhostportWWPNs = new Vector();
    private Vector unssportWWPNs = new Vector();
    private String[] ssportsArray = null;
    private HashMap portData = null;
    private int WIZARD_FLAGS = 31;

    public PortAssignmentWizard(GUIStorageSubsystem ss, GUIVolume volume) {
        this.subSystem = ss;
        this.SS_ID = this.subSystem.getId();
        this.selectedVolume = volume;
        this.deviceID = this.subSystem.getDeviceId();
        this.addWizardListener(this);
        this.portData = new HashMap();
        this.hostStep = new PortAssignmentSelectHostPortsStep(this.WIZARD_FLAGS, this.subSystem);
        this.add(this.hostStep);
        if (this.subSystem.isTargetPortRestrictionSupported() && 4 != this.subSystem.getCapabilityData().getPortsPerView() && this.subSystem.getType() != 4) {
            this.portStep = new PortAssignmentSelectSubsystemPortsStep(this.WIZARD_FLAGS, this.subSystem);
            this.add(this.portStep);
        }
        this.zoneStep = new PortAssignmentZoneActionStep(this.WIZARD_FLAGS, this.SS_ID);
        this.add(this.zoneStep);
        this.reviewStep = new PortAssignmentReviewStep(this.WIZARD_FLAGS);
        this.add(this.reviewStep);
    }

    public GUIVolume getSelectedVolume() {
        return this.selectedVolume;
    }

    public PortAssignmentSelectSubsystemPortsStep getSubsystemPortsStep() {
        return this.portStep;
    }

    public PortAssignmentSelectHostPortsStep getHostPortsStep() {
        return this.hostStep;
    }

    public WizardPage getCurrentStep() {
        return (WizardPage)this.getCurrentPage();
    }

    public void addData(String key, Object data) {
        this.portData.put(key, data);
    }

    public void removeData(String key) {
        this.portData.remove(key);
    }

    public HashMap getData() {
        return this.portData;
    }

    public void nextBegin(WizardEvent e) {
        e.setAllowChange(((WizardPage)e.getCurrentPage()).nextBegin());
        if ((WizardPage)e.getCurrentPage() == this.hostStep) {
            if (this.hostStep.skipSubsystemStep()) {
                e.setNewPage(this.zoneStep);
            }
            if (this.hostStep.skipToReviewStep()) {
                e.setNewPage(this.reviewStep);
            }
        }
    }

    public void nextComplete(WizardEvent e) {
        e.setAllowChange(((WizardPage)e.getCurrentPage()).nextComplete());
        if ((WizardPage)e.getNewPage() == this.hostStep) {
            this.hostStep.getSSPortsFromSystem();
        }
        if ((WizardPage)e.getNewPage() == this.portStep) {
            this.portStep.fillData();
        }
        if ((WizardPage)e.getNewPage() == this.zoneStep) {
            this.zoneStep.fillData();
        }
        if ((WizardPage)e.getNewPage() == this.reviewStep) {
            this.reviewStep.fillData();
        }
    }

    public void previousBegin(WizardEvent e) {
        e.setAllowChange(((WizardPage)e.getCurrentPage()).previousBegin());
        if ((WizardPage)e.getCurrentPage() == this.reviewStep) {
            if (this.hostStep.skipSubsystemStep()) {
                e.setNewPage(this.zoneStep);
            }
            if (this.hostStep.skipToReviewStep()) {
                e.setNewPage(this.hostStep);
            }
        }
    }

    public void finished(WizardEvent e) {
        super.finished(e);
        if (((WizardPage)e.getCurrentPage()).equals(this.reviewStep)) {
            String s = Util.getString("DISK_PORT_ASSIGNMENT_WIZARD_FINISHED");
            JOptionPane.showMessageDialog(this, s, Util.getString("DISK_HPA_WIZARD_LABEL", this.deviceID), 1);
            this.closeWizard();
            AssignmentThread at = new AssignmentThread(this);
            at.run();
        }
    }

    public void canceled(WizardEvent e) {
        int action = JOptionPane.showConfirmDialog(this, Util.getString("DISK_PORT_ASSIGNMENT_WIZARD_CANCELED"), Util.getString("DISK_HPA_WIZARD_LABEL", this.deviceID), 0);
        switch (action) {
            case 0: {
                super.canceled(e);
                this.closeWizard();
                break;
            }
        }
    }

    private void closeWizard() {
        this.wizardDialog = (JDialog)this.getParent().getParent().getParent().getParent();
        this.wizardDialog.dispose();
    }

    static /* synthetic */ String[] access$202(PortAssignmentWizard x0, String[] x1) {
        x0.volumeIDs = x1;
        return x1;
    }

    static /* synthetic */ String[] access$802(PortAssignmentWizard x0, String[] x1) {
        x0.ssportsArray = x1;
        return x1;
    }

    public class JobResultThread
    extends Thread {
        protected int jobID = 0;
        protected String fabricID = null;

        public JobResultThread(int jobID) {
            this.jobID = jobID;
        }

        public JobResultThread(int jobID, String fabricID) {
            this.jobID = jobID;
            this.fabricID = fabricID;
        }

        public void run() {
            Response jobStatusResponse = GuiDeviceJob.getJobStatus(this.jobID, true);
            if (this.fabricID != null) {
                AsyncResult result;
                boolean errorOccured = false;
                if (jobStatusResponse != null && (result = (AsyncResult)jobStatusResponse.responseData) != null && (result.getReturnException() != null || result.getRc() > 0)) {
                    errorOccured = true;
                }
                if (errorOccured) {
                    PortAssignmentWizard.this.diskController.rollbackFabricTransaction(new GuiRequestor(){

                        public void handleResponse(short status, Response response) {
                        }
                    }, this.fabricID);
                } else {
                    PortAssignmentWizard.this.diskController.releaseFabric(new GuiRequestor(){

                        public void handleResponse(short status, Response response) {
                        }
                    }, this.fabricID);
                }
            }
            if (jobStatusResponse != null) {
                AsyncResult result = (AsyncResult)jobStatusResponse.responseData;
                AsyncResult[] subResults = result.getSubJobResults();
                for (int i = 0; subResults != null && i < subResults.length; ++i) {
                    Exception tpcEx = subResults[i].getReturnException();
                    if (tpcEx != null) {
                        String errorMsg = tpcEx.getMessage();
                        if (tpcEx instanceof SRMRuntimeException) {
                            errorMsg = ((SRMRuntimeException)tpcEx).getLocalizedMessage();
                        }
                        if (errorMsg != null) {
                            // empty if block
                        }
                    }
                    if (subResults[i] == null || subResults[i].getResults() == null || subResults[i].getRc() > 0) continue;
                    Object[] retvals = subResults[i].getResults();
                }
            }
        }
    }

    public class ZoneRequestor
    implements GuiRequestor {
        String fabricID = null;

        public ZoneRequestor(String fabricID) {
            this.fabricID = fabricID;
        }

        public void handleResponse(short status, Response response) {
            if (status <= 4) {
                int jobID = (Integer)response.responseData;
                new JobResultThread(jobID, this.fabricID).start();
            }
        }
    }

    private class AssignmentThread
    extends Thread {
        private PortAssignmentWizard wizard;

        public AssignmentThread(PortAssignmentWizard paWizard) {
            this.wizard = paWizard;
        }

        public void run() {
            this.portsAssign();
        }

        public void portsAssign() {
            int i;
            PortAssignmentWizard.this.wizardDialog = (JDialog)this.wizard.getParent().getParent().getParent().getParent();
            PortAssignmentWizard.this.diskController = DiskDataController.getInstance();
            PortAssignmentWizard.access$202(PortAssignmentWizard.this, new String[1]);
            ((PortAssignmentWizard)PortAssignmentWizard.this).volumeIDs[0] = PortAssignmentWizard.this.selectedVolume.getId();
            Vector hostports = (Vector)PortAssignmentWizard.this.portData.get(PortAssignmentSelectHostPortsStep.HOSTPORTS_DATA);
            Vector ssports = (Vector)PortAssignmentWizard.this.portData.get(PortAssignmentSelectSubsystemPortsStep.SUBSYSTEM_DATA);
            PortAssignmentWizard.this.unhostportWWPNs = (Vector)PortAssignmentWizard.this.portData.get(PortAssignmentSelectHostPortsStep.HOSTPORTS_UNASSIGNED_DATA);
            String temp = new String();
            for (i = 0; ssports != null && i < ssports.size(); ++i) {
                try {
                    temp = ((GUIPort)ssports.get(i)).getWwpn();
                }
                catch (ClassCastException ce) {
                    temp = (String)ssports.get(i);
                }
                PortAssignmentWizard.this.ssportWWPNs.add(temp);
            }
            if (PortAssignmentWizard.this.subSystem.isTargetPortRestrictionSupported() && 4 != PortAssignmentWizard.this.subSystem.getCapabilityData().getPortsPerView()) {
                PortAssignmentWizard.access$802(PortAssignmentWizard.this, PortAssignmentWizard.this.ssportWWPNs.toArray(new String[0]));
            }
            for (i = 0; i < hostports.size(); ++i) {
                PortAssignmentWizard.this.hostportWWPNs.add(((GUIPort)hostports.get(i)).getWwpn());
            }
            HashMap zoneActionSteps = (HashMap)PortAssignmentWizard.this.portData.get(PortAssignmentZoneActionStep.ZONE_ACTION_DATA);
            if (zoneActionSteps != null) {
                Iterator iter = zoneActionSteps.values().iterator();
                Vector vv = new Vector(zoneActionSteps.values());
                while (iter.hasNext()) {
                    int i2;
                    String[] portWWpn;
                    Vector ports;
                    BaseZoneActionStep.ZoneAction zoneAction = (BaseZoneActionStep.ZoneAction)iter.next();
                    if (zoneAction.action == 0) {
                        zoneAction.hostPorts.addAll(zoneAction.ssPorts);
                        ports = zoneAction.hostPorts;
                        portWWpn = new String[ports.size()];
                        for (i2 = 0; i2 < ports.size(); ++i2) {
                            portWWpn[i2] = ((GUIPort)ports.get(i2)).getWwpn();
                        }
                        PortAssignmentWizard.this.diskController.createZone(new ZoneRequestor(zoneAction.fabricID), zoneAction.fabricID, zoneAction.zoneset.getName(), zoneAction.zoneName, portWWpn);
                        continue;
                    }
                    if (zoneAction.action != 1) continue;
                    zoneAction.hostPorts.addAll(zoneAction.ssPorts);
                    ports = zoneAction.hostPorts;
                    portWWpn = new String[ports.size()];
                    for (i2 = 0; i2 < ports.size(); ++i2) {
                        portWWpn[i2] = ((GUIPort)ports.get(i2)).getWwpn();
                    }
                    PortAssignmentWizard.this.diskController.updateZone(new ZoneRequestor(zoneAction.fabricID), zoneAction.fabricID, zoneAction.zoneset.getName(), zoneAction.zoneName, portWWpn);
                }
            }
            if (PortAssignmentWizard.this.unhostportWWPNs.size() > 0) {
                PortAssignmentWizard.this.diskController.unassignPorts(new GuiRequestor(){

                    public void handleResponse(short status, Response response) {
                    }
                }, PortAssignmentWizard.this.volumeIDs, PortAssignmentWizard.this.unhostportWWPNs.toArray(new String[0]), false);
            }
            if (PortAssignmentWizard.this.hostportWWPNs.size() > 0) {
                PortAssignmentWizard.this.diskController.assignPorts(new GuiRequestor(){

                    public void handleResponse(short status, Response response) {
                    }
                }, PortAssignmentWizard.this.volumeIDs, PortAssignmentWizard.this.ssportsArray, PortAssignmentWizard.this.hostportWWPNs.toArray(new String[0]), false);
            }
        }
    }
}

