/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.IconFactory;

public class FabricGuiUtil {
    public static String FHELP_ZC_FABRICS = "bta_dlg_zonecontrol_fabricstab";
    public static String FHELP_ZC_ZONING = "bta_dlg_zonecontrol_zoningtab";
    public static String FHELP_ZC_DEFINITION = "bta_dlg_zonecontrol_definitiontab";
    public static String FHELP_ZC_ZWIZ1 = "bta_dlg_zonecontrol_createzonewiz1";
    public static String FHELP_ZC_ZWIZ2 = "bta_dlg_zonecontrol_createzonewiz2";
    public static String FHELP_ZC_ZWIZ3 = "bta_dlg_zonecontrol_createzonewiz3";
    public static String FHELP_ZC_ZSWIZ1 = "bta_dlg_zonecontrol_createzonesetwiz1";
    public static String FHELP_ZC_ZSWIZ2 = "bta_dlg_zonecontrol_createzonesetwiz2";
    public static String FHELP_AGENT_INBAND = "adm_dlg_agents_inband";
    public static String FHELP_AGENT_OUTBAND = "adm_dlg_agents_outband";
    public static String FHELP_AGENT_OUTBAND_ADD = "adm_dlg_agents_addoutband";
    public static String FHELP_AGENT_OUTBAND_OPTIONS = "adm_dlg_dsc_outbandoptions";
    public static String FHELP_REPORTS_PORTCONN = "tpc_dlg_systemreports_fabric_portconnections";
    public static String FHELP_REPORTS_SANASSETS = "tpc_dlg_systemreports_fabric_san_assets";
    public static String FHELP_ALERTLOG_TAPE = "tpc_dlg_alerting_alertlog_tapelibs";
    public static String FHELP_ALERTLOG_SWITCH = "tpc_dlg_alerting_alertlog_switch";
    public static String FHELP_ALERTLOG_FABRIC = "tpc_dlg_alerting_alertlog_fabricgroups";
    public static String FHELP_ALERTLOG_ENDPOINT = "tpc_dlg_alerting_alertlog_endpoints";
    public static String FHELP_ALERT_FABRIC = "bta_dlg_alerting_fabricalerts";
    public static String FHELP_ALERT_SELECT = "bta_dlg_alerting_selectionlisttab";
    public static String FHELP_ALERT_SWITCH = "bta_dlg_alerting_switchalerts";
    public static String FHELP_ALERT_ENDPOINT = "bta_dlg_alerting_endpointalerts";
    public static String FHELP_GROUPS_FABRIC = "bta_dlg_fabric_monitoring_creategroup";
    public static String FHELP_JOBS_FABRIC = "bta_ovw_fabric_monitoring";
    private static ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.xmsg.FabricGuiResources", Locale.getDefault());
    public static final int DISPLAY_ICON_BRIDGE = 100;
    public static final int DISPLAY_ICON_DISK = 101;
    public static final int DISPLAY_ICON_ESS = 102;
    public static final int DISPLAY_ICON_NAS = 103;
    public static final int DISPLAY_ICON_SERVER = 104;
    public static final int DISPLAY_ICON_SUBSYSTEM = 105;
    public static final int DISPLAY_ICON_SVC = 106;
    public static final int DISPLAY_ICON_SWITCH = 107;
    public static final int DISPLAY_ICON_TAPE = 108;
    public static final int DISPLAY_ICON_UNKNOWN = 109;

    public static String getString(String key) {
        String sillystring = null;
        try {
            sillystring = FabricGuiUtil.cleanStrings(rb.getString(key));
        }
        catch (Exception e) {
            sillystring = key + " Unavailable";
            System.out.println("FabricGUI_utils::getResourceString() -- " + key + " not found in resource bundle.");
        }
        return sillystring;
    }

    public static String cleanStrings(String bigString) {
        StringTokenizer st = new StringTokenizer(bigString, "\f\r\t");
        if (st.hasMoreTokens()) {
            String newString = st.nextToken();
            while (st.hasMoreTokens()) {
                newString = newString + " " + st.nextToken();
            }
            return newString;
        }
        return bigString;
    }

    public static Object getStatusString(int value) {
        String result;
        switch (value) {
            case 0: {
                result = FabricGuiUtil.getString("FabricStatusNormal");
                break;
            }
            case 1: {
                result = FabricGuiUtil.getString("FabricStatusWarning");
                break;
            }
            case 2: {
                result = FabricGuiUtil.getString("FabricStatusCritical");
                break;
            }
            case 99: {
                result = "";
                break;
            }
            default: {
                result = FabricGuiUtil.getString("FabricStatusUnknown");
            }
        }
        return result;
    }

    public static JLabel getConsolidatedStateLabel(int state) {
        String labelText = "";
        ImageIcon labelIcon = null;
        switch (state) {
            case 0: {
                labelText = FabricGuiUtil.getString("FabricStatusNormal");
                labelIcon = IconFactory.getStateUpIcon();
                break;
            }
            case 1: {
                labelText = FabricGuiUtil.getString("FabricStatusWarning");
                labelIcon = IconFactory.getStateWarningIcon();
                break;
            }
            case 2: {
                labelText = FabricGuiUtil.getString("FabricStatusMissing");
                labelIcon = IconFactory.getStateFailedIcon();
                break;
            }
            default: {
                labelText = FabricGuiUtil.getString("FabricStatusUnknown");
                labelIcon = IconFactory.getStateUreachableIcon();
            }
        }
        if (labelIcon != null) {
            labelIcon.setDescription(labelText);
        }
        return new JLabel(labelText, labelIcon, 10);
    }

    public static JLabel getDetectableStateLabel(int state) {
        String labelText = "";
        ImageIcon labelIcon = null;
        switch (state) {
            case 0: {
                labelText = FabricGuiUtil.getString("FabricStatusMissing");
                labelIcon = IconFactory.getStateFailedIcon();
                break;
            }
            case 1: {
                labelText = FabricGuiUtil.getString("FabricStatusNormal");
                labelIcon = IconFactory.getStateUpIcon();
                break;
            }
            default: {
                labelText = FabricGuiUtil.getString("FabricStatusUnknown");
                labelIcon = IconFactory.getStateUreachableIcon();
            }
        }
        if (labelIcon != null) {
            labelIcon.setDescription(labelText);
        }
        return new JLabel(labelText, labelIcon, 10);
    }

    public static String getDetectableStatusString(int value) {
        String result;
        switch (value) {
            case 0: {
                result = FabricGuiUtil.getString("FabricStatusMissing");
                break;
            }
            case 1: {
                result = FabricGuiUtil.getString("FabricStatusNormal");
                break;
            }
            default: {
                result = FabricGuiUtil.getString("FabricStatusUnknown");
            }
        }
        return result;
    }

    public static boolean isSwitchPort(String portType) {
        return portType.equalsIgnoreCase("4") || portType.equalsIgnoreCase("6") || portType.equalsIgnoreCase("7") || portType.equalsIgnoreCase("9") || portType.equalsIgnoreCase("10") || portType.equalsIgnoreCase("11") || portType.equalsIgnoreCase("12") || portType.equalsIgnoreCase("13") || portType.equalsIgnoreCase("14") || portType.equalsIgnoreCase("15") || portType.equalsIgnoreCase("16") || portType.equalsIgnoreCase("17") || portType.equalsIgnoreCase("18");
    }

    public static boolean isSwitchPort(int portType) {
        return portType == 4 || portType == 6 || portType == 7 || portType == 9 || portType == 10 || portType == 11 || portType == 12 || portType == 13 || portType == 14 || portType == 15 || portType == 16 || portType == 17 || portType == 18;
    }

    public static String getPortTypeString(int portType) {
        String result;
        if (FabricGuiUtil.isSwitchPort(portType)) {
            result = FabricGuiUtil.getString("FabricDetails_switch");
        } else {
            switch (portType) {
                case 100: {
                    result = FabricGuiUtil.getString("FabricDetails_IconBridge");
                    break;
                }
                case 101: {
                    result = FabricGuiUtil.getString("FabricDetails_IconDisk");
                    break;
                }
                case 102: {
                    result = FabricGuiUtil.getString("FabricDetails_IconESS");
                    break;
                }
                case 103: {
                    result = FabricGuiUtil.getString("FabricDetails_IconNAS");
                    break;
                }
                case 104: {
                    result = FabricGuiUtil.getString("FabricDetails_IconServer");
                    break;
                }
                case 105: {
                    result = FabricGuiUtil.getString("FabricDetails_IconSubsystem");
                    break;
                }
                case 106: {
                    result = FabricGuiUtil.getString("FabricDetails_IconSVC");
                    break;
                }
                case 107: {
                    result = FabricGuiUtil.getString("FabricDetails_IconSwitch");
                    break;
                }
                case 108: {
                    result = FabricGuiUtil.getString("FabricDetails_IconTape");
                    break;
                }
                case 109: {
                    result = FabricGuiUtil.getString("FabricDetails_IconUnknown");
                    break;
                }
                case 99: {
                    result = "";
                    break;
                }
                default: {
                    result = FabricGuiUtil.getString("FabricDetails_IconUnknown");
                }
            }
        }
        return result;
    }

    public static String getNodeTypeString(int nodeType) {
        switch (nodeType) {
            case 1: {
                return FabricGuiUtil.getString("FabricDetails_Unknown");
            }
            case 2: {
                return FabricGuiUtil.getString("FabricDetails_other");
            }
            case 3: {
                return FabricGuiUtil.getString("FabricDetails_bridge");
            }
            case 4: {
                return FabricGuiUtil.getString("FabricDetails_Converter");
            }
            case 5: {
                return FabricGuiUtil.getString("FabricDetails_hub");
            }
            case 6: {
                return FabricGuiUtil.getString("FabricDetails_HBA");
            }
            case 7: {
                return FabricGuiUtil.getString("FabricDetails_switch");
            }
            case 8: {
                return FabricGuiUtil.getString("FabricDetails_StorageDevice");
            }
            case 9: {
                return FabricGuiUtil.getString("FabricDetails_host");
            }
            case 10: {
                return FabricGuiUtil.getString("FabricDetails_StorageSubsystem");
            }
            case 11: {
                return FabricGuiUtil.getString("FabricDetails_Module");
            }
            case 12: {
                return FabricGuiUtil.getString("FabricDetails_StorageDriver");
            }
            case 13: {
                return FabricGuiUtil.getString("FabricDetails_StorageAccessDevice");
            }
            case 14: {
                return FabricGuiUtil.getString("FabricDetails_SoftwareProxyAgent");
            }
            case 15: {
                return FabricGuiUtil.getString("FabricDetails_Reserved");
            }
            case 16: {
                return FabricGuiUtil.getString("FabricDetails_Shark");
            }
            case 17: {
                return FabricGuiUtil.getString("FabricDetails_Lodestone");
            }
            case 18: {
                return FabricGuiUtil.getString("FabricDetails_DS6000");
            }
            case 19: {
                return FabricGuiUtil.getString("FabricDetails_DS8000");
            }
            case 100: {
                return FabricGuiUtil.getString("FabricDetails_IconBridge");
            }
            case 101: {
                return FabricGuiUtil.getString("FabricDetails_IconDisk");
            }
            case 102: {
                return FabricGuiUtil.getString("FabricDetails_IconESS");
            }
            case 103: {
                return FabricGuiUtil.getString("FabricDetails_IconNAS");
            }
            case 104: {
                return FabricGuiUtil.getString("FabricDetails_IconServer");
            }
            case 105: {
                return FabricGuiUtil.getString("FabricDetails_IconSubsystem");
            }
            case 106: {
                return FabricGuiUtil.getString("FabricDetails_IconSVC");
            }
            case 107: {
                return FabricGuiUtil.getString("FabricDetails_IconSwitch");
            }
            case 108: {
                return FabricGuiUtil.getString("FabricDetails_IconTape");
            }
            case 109: {
                return FabricGuiUtil.getString("FabricDetails_IconUnknown");
            }
        }
        return Util.getString("FabricDetails_Unknown");
    }

    public static String getNodeTypeString(String nodeType) {
        int nT = Integer.parseInt(nodeType);
        switch (nT) {
            case 1: {
                return FabricGuiUtil.getString("FabricDetails_Unknown");
            }
            case 2: {
                return FabricGuiUtil.getString("FabricDetails_other");
            }
            case 3: {
                return FabricGuiUtil.getString("FabricDetails_bridge");
            }
            case 4: {
                return FabricGuiUtil.getString("FabricDetails_Converter");
            }
            case 5: {
                return FabricGuiUtil.getString("FabricDetails_hub");
            }
            case 6: {
                return FabricGuiUtil.getString("FabricDetails_HBA");
            }
            case 7: {
                return FabricGuiUtil.getString("FabricDetails_switch");
            }
            case 8: {
                return FabricGuiUtil.getString("FabricDetails_StorageDevice");
            }
            case 9: {
                return FabricGuiUtil.getString("FabricDetails_host");
            }
            case 10: {
                return FabricGuiUtil.getString("FabricDetails_StorageSubsystem");
            }
            case 11: {
                return FabricGuiUtil.getString("FabricDetails_Module");
            }
            case 12: {
                return FabricGuiUtil.getString("FabricDetails_StorageDriver");
            }
            case 13: {
                return FabricGuiUtil.getString("FabricDetails_StorageAccessDevice");
            }
            case 14: {
                return FabricGuiUtil.getString("FabricDetails_SoftwareProxyAgent");
            }
            case 15: {
                return FabricGuiUtil.getString("FabricDetails_Reserved");
            }
            case 16: {
                return FabricGuiUtil.getString("FabricDetails_Shark");
            }
            case 17: {
                return FabricGuiUtil.getString("FabricDetails_Lodestone");
            }
            case 18: {
                return FabricGuiUtil.getString("FabricDetails_DS6000");
            }
            case 19: {
                return FabricGuiUtil.getString("FabricDetails_DS8000");
            }
            case 100: {
                return FabricGuiUtil.getString("FabricDetails_IconBridge");
            }
            case 101: {
                return FabricGuiUtil.getString("FabricDetails_IconDisk");
            }
            case 102: {
                return FabricGuiUtil.getString("FabricDetails_IconESS");
            }
            case 103: {
                return FabricGuiUtil.getString("FabricDetails_IconNAS");
            }
            case 104: {
                return FabricGuiUtil.getString("FabricDetails_IconServer");
            }
            case 105: {
                return FabricGuiUtil.getString("FabricDetails_IconSubsystem");
            }
            case 106: {
                return FabricGuiUtil.getString("FabricDetails_IconSVC");
            }
            case 107: {
                return FabricGuiUtil.getString("FabricDetails_IconSwitch");
            }
            case 108: {
                return FabricGuiUtil.getString("FabricDetails_IconTape");
            }
            case 109: {
                return FabricGuiUtil.getString("FabricDetails_IconUnknown");
            }
        }
        return Util.getString("FabricDetails_Unknown");
    }

    public static String getPeTypeString(int peType) {
        if (peType <= 30 || peType >= 100) {
            return FabricGuiUtil.getNodeTypeString(peType);
        }
        switch (peType) {
            case 31: {
                return FabricGuiUtil.getString("FabricDetails_disk");
            }
            case 32: {
                return FabricGuiUtil.getString("FabricDetails_tape");
            }
            case 33: {
                return FabricGuiUtil.getString("FabricDetails_printer");
            }
            case 34: {
                return FabricGuiUtil.getString("FabricDetails_ExternalController");
            }
            case 35: {
                return FabricGuiUtil.getString("FabricDetails_Worm");
            }
            case 36: {
                return FabricGuiUtil.getString("FabricDetails_CdRom");
            }
            case 37: {
                return FabricGuiUtil.getString("FabricDetails_PeripheralScanner");
            }
            case 38: {
                return FabricGuiUtil.getString("FabricDetails_OpticalDisk");
            }
            case 39: {
                return FabricGuiUtil.getString("FabricDetails_MediaChangers");
            }
            case 40: {
                return FabricGuiUtil.getString("FabricDetails_OtherPeripheral");
            }
            case 41: {
                return FabricGuiUtil.getString("FabricDetails_SmartEnclosure");
            }
        }
        return Util.getString("FabricDetails_Unknown");
    }

    public static String getPeTypeString(String peType) {
        int pT = Integer.parseInt(peType);
        if (pT <= 30 || pT >= 100) {
            return FabricGuiUtil.getNodeTypeString(peType);
        }
        switch (pT) {
            case 31: {
                return FabricGuiUtil.getString("FabricDetails_disk");
            }
            case 32: {
                return FabricGuiUtil.getString("FabricDetails_tape");
            }
            case 33: {
                return FabricGuiUtil.getString("FabricDetails_printer");
            }
            case 34: {
                return FabricGuiUtil.getString("FabricDetails_ExternalController");
            }
            case 35: {
                return FabricGuiUtil.getString("FabricDetails_Worm");
            }
            case 36: {
                return FabricGuiUtil.getString("FabricDetails_CdRom");
            }
            case 37: {
                return FabricGuiUtil.getString("FabricDetails_PeripheralScanner");
            }
            case 38: {
                return FabricGuiUtil.getString("FabricDetails_OpticalDisk");
            }
            case 39: {
                return FabricGuiUtil.getString("FabricDetails_MediaChangers");
            }
            case 40: {
                return FabricGuiUtil.getString("FabricDetails_OtherPeripheral");
            }
            case 41: {
                return FabricGuiUtil.getString("FabricDetails_SmartEnclosure");
            }
        }
        return Util.getString("FabricDetails_Unknown");
    }

    public static String getInbandFabricAgentStatusString(int status) {
        switch (status) {
            case 1: {
                return FabricGuiUtil.getString("FabricAgent_Active");
            }
            case 0: {
                return FabricGuiUtil.getString("FabricAgent_Inactive");
            }
        }
        return FabricGuiUtil.getString("FabricAgent_Unknown");
    }

    public static String getIconTypeString(int portType) {
        String result;
        if (FabricGuiUtil.isSwitchPort(portType)) {
            result = Util.getString("TOPO_LABEL_ENTITY_SWITCH");
        } else {
            switch (portType) {
                case 100: {
                    result = FabricGuiUtil.getString("FabricDetails_bridge");
                    break;
                }
                case 101: {
                    result = Util.getString("TOPO_LABEL_ENTITY_DISK");
                    break;
                }
                case 103: {
                    result = FabricGuiUtil.getString("FabricDetails_IconNAS");
                    break;
                }
                case 104: {
                    result = Util.getString("TOPO_LABEL_ENTITY_COMPUTER");
                    break;
                }
                case 105: {
                    result = Util.getString("TOPO_LABEL_ENTITY_SUBSYSTEM");
                    break;
                }
                case 107: {
                    result = Util.getString("TOPO_LABEL_ENTITY_SWITCH");
                    break;
                }
                case 108: {
                    result = Util.getString("TOPO_LABEL_ENTITY_TAPELIBRARY");
                    break;
                }
                case 109: {
                    result = Util.getString("TOPO_LABEL_ENTITY_OTHER");
                    break;
                }
                default: {
                    result = Util.getString("TOPO_LABEL_ENTITY_OTHER");
                }
            }
        }
        return result;
    }
}

