/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.details;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiMain;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.details.DetailTextField;
import org.eclipse.aperi.gui.fabric.details.DetailsDDI;
import org.eclipse.aperi.gui.fabric.details.DoRequestThread;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.fabric.details.GuiDetailsReq;

public class BaseDetailsPanel
extends JPanel
implements GuiRequestor,
ActionListener {
    String entityType;
    String entityID;
    GuiDetailsReq dataInDb = null;
    protected String[] fieldNames;
    protected static final boolean DEBUG_LAYOUT = false;
    private static final boolean dbg = false;
    protected Insets panelInsets;
    protected GridBagConstraints leftLabelGbc = new GridBagConstraints();
    protected GridBagConstraints rightLabelGbc = new GridBagConstraints();
    protected Vector leftComponents = new Vector();
    protected Vector rightComponents = new Vector();
    protected JButton okButton;
    protected JButton cancelButton;
    boolean wantButtons = true;
    private boolean menuHooked = false;
    IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    protected static String[][] fieldLabels = new String[][]{{"cluster", "FabricDetails_Label", "FabricDetails_ID"}, {"server", "FabricDetails_Label", "FabricDetails_Type", "FabricDetails_State", "FabricDetails_IPAddress", "FabricDetails_Hostname", "FabricDetails_Guid", "FabricDetails_UserAttrib1", "FabricDetails_UserAttrib2", "FabricDetails_UserAttrib3"}, {"pe", "FabricDetails_Type", "FabricDetails_Label", "FabricDetails_SerialNumber", "FabricDetails_VendorID", "FabricDetails_Revision", "FabricDetails_ManagementURLAddress"}, {"fabric", "FabricDetails_Label", "FabricDetails_Type", "FabricDetails_WWN", "FabricDetails_UserAttrib1", "FabricDetails_UserAttrib2", "FabricDetails_UserAttrib3"}, {"hba", "FabricDetails_Label", "FabricDetails_SerialNumber", "FabricDetails_Manufacturer", "FabricDetails_Model", "FabricDetails_DriverName", "FabricDetails_DriverVersion", "FabricDetails_OptionROMVersion", "FabricDetails_HardwareVersion", "FabricDetails_FirmwareVersion", "FabricDetails_APIVersion"}, {"phys_infrastructure", "FabricDetails_Label"}, {"port", "FabricDetails_Label", "FabricDetails_Type", "FabricDetails_WWN"}, {"node", "FabricDetails_Label", "FabricDetails_Type", "FabricDetails_WWN"}, {"subsystem", "FabricDetails_StorageSubsystem", "FabricDetails_Label", "FabricDetails_State", "FabricDetails_VendorID", "FabricDetails_Type", "FabricDetails_UniqueID", "FabricDetails_SerialNumber", "FabricDetails_Revision", "FabricDetails_Location"}, {"switch", "FabricDetails_Label", "FabricDetails_Description", "FabricDetails_State", "FabricDetails_IPAddress", "FabricDetails_LogicalName", "FabricDetails_VendorID", "FabricDetails_Model", "FabricDetails_Version", "FabricDetails_SerialNumber", "FabricDetails_Domain", "FabricDetails_Contact", "FabricDetails_WWN", "FabricDetails_Location", "FabricDetails_PhysicalSwitchWWN", "FabricDetails_UserAttrib1", "FabricDetails_UserAttrib2", "FabricDetails_UserAttrib3", "FabricDetails_ManagementID", "FabricDetails_ManagementAddress"}, {"tape", "FabricDetails_Library", "FabricDetails_Name", "FabricDetails_Description", "FabricDetails_State", "FabricDetails_Drives", "FabricDetails_MediaChangers", "FabricDetails_IOPorts", "FabricDetails_Frames", "FabricDetails_CartridgeCapacity", "FabricDetails_FirmwareVersion", "FabricDetails_ElementManager"}, {"vdisk", "FabricDetails_subsystem", "FabricDetails_SubsystemName", "FabricDetails_ID", "FabricDetails_Name", "FabricDetails_IOGroupID", "FabricDetails_IOGroupName", "FabricDetails_State", "FabricDetails_MdiskGroupID", "FabricDetails_MdiskGroupName", "FabricDetails_Capacity", "FabricDetails_Type", "FabricDetails_Formatted", "FabricDetails_MdiskID", "FabricDetails_MdiskName", "FabricDetails_FlashCopyID", "FabricDetails_FlashCopyName", "FabricDetails_MetroMirrorID", "FabricDetails_MetroMirrorName", "FabricDetails_IoThrottling", "FabricDetails_PreferredIoNode", "FabricDetails_MappedToHost", "FabricDetails_FastWriteState", "FabricDetails_UID"}, {"disk", "FabricDetails_Volume", "FabricDetails_VolumeSize", "FabricDetails_Array", "FabricDetails_RaidLevel", "FabricDetails_subsystem", "FabricDetails_SubsystemName", "FabricDetails_LCU", "FabricDetails_SubsystemPorts", "FabricDetails_HostPorts"}, {"zone", "FabricDetails_Label", "FabricDetails_Type"}, {"zoneset", "FabricDetails_Label", "FabricDetails_Active"}};

    String[] getFieldLabels(String eType) {
        int len = 0;
        for (int i = 0; i < fieldLabels.length; ++i) {
            if (!fieldLabels[i][0].equals(eType)) continue;
            len = fieldLabels[i].length - 1;
            String[] res = new String[len];
            for (int j = 0; j < len; ++j) {
                res[j] = fieldLabels[i][j + 1];
            }
            return res;
        }
        return null;
    }

    public BaseDetailsPanel(String entityType, String entityID) {
        this(entityType, entityID, new Insets(32, 32, 5, 5), true);
    }

    public BaseDetailsPanel(String entityType, String entityID, Insets insets, boolean wantButtons) {
        this.entityType = entityType;
        this.entityID = entityID;
        this.fieldNames = this.getFieldLabels(entityType);
        this.panelInsets = insets;
        this.wantButtons = wantButtons;
        this.buildPanel();
        this.doAccessibility();
    }

    public void doRequest(GuiRequestor requestor, Request request) {
        new DoRequestThread(requestor, request);
    }

    public void queryData() {
        GuiDetailsReq gdr = new GuiDetailsReq(this.entityType, this.entityID, 0);
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.fabric.GuiDetailsHndlr", gdr);
        this.doRequest(this, request);
    }

    public String getTheTitle(GuiDetailsReq data) {
        if (data != null && data.data != null) {
            return "" + data.data.get("FabricDetails_Label") + " " + FabricGuiUtil.getString("FabricDetails_DetailsTwistie");
        }
        return "";
    }

    public void handleResponse(short status, Response response) {
        if (response != null && status == 0) {
            GuiDetailsReq data = (GuiDetailsReq)response.responseData;
            if (data.mode == 0) {
                this.dataInDb = data;
                this.displayDataInPanel(data);
                if (this.guiMain instanceof GuiMain) {
                    GuiMain.setTheTitle(this.getTheTitle(data));
                }
                DetailsDDI.setDDIDescription(this, this.getTheTitle(data));
            }
            if (data.mode != 1) {
                // empty if block
            }
        }
    }

    public void saveDataFromPanel() {
        GuiDetailsReq gdr = new GuiDetailsReq(this.entityType, this.entityID, 1);
        this.getDataFromPanel(gdr);
        if (this.dataInDb != null) {
            this.dataInDb.data = gdr.data;
        }
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.fabric.GuiDetailsHndlr", gdr);
        this.doRequest(this, request);
    }

    public void buildPanel() {
        GridBagConstraints panelGbc = new GridBagConstraints();
        GridBagConstraints buttonPanelGbc = new GridBagConstraints();
        GridBagConstraints rightFillerGbc = new GridBagConstraints();
        GridBagConstraints bottomFillerGbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        panelGbc.anchor = 18;
        panelGbc.weightx = 0.0;
        panelGbc.weighty = 0.0;
        panelGbc.insets = this.panelInsets;
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(0, 15));
        p.add((Component)this.makeDetailPanel(), "North");
        this.add((Component)p, panelGbc);
        rightFillerGbc.gridwidth = 0;
        rightFillerGbc.fill = 1;
        rightFillerGbc.gridheight = 2;
        JPanel fillerPanel = new JPanel();
        this.add((Component)fillerPanel, rightFillerGbc);
        bottomFillerGbc.weightx = 1.0;
        bottomFillerGbc.weighty = 1.0;
        bottomFillerGbc.gridwidth = 0;
        bottomFillerGbc.gridheight = 0;
        bottomFillerGbc.fill = 1;
        JPanel bfillerPanel = new JPanel();
        this.add((Component)bfillerPanel, bottomFillerGbc);
    }

    protected JPanel makeButtonPanel() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0));
        this.okButton = new JButton(Util.getString("LABEL_OK"));
        p.add(this.okButton);
        this.cancelButton = new JButton(Util.getString("LABEL_CANCEL"));
        p.add(this.cancelButton);
        this.okButton.setActionCommand(Util.getString("LABEL_OK"));
        this.cancelButton.setActionCommand(Util.getString("LABEL_CANCEL"));
        return p;
    }

    protected JPanel makeDetailPanel() {
        JPanel p = new JPanel();
        this.setupLabelValuePairPanel(p);
        for (int i = 0; i < this.fieldNames.length; ++i) {
            String fname = this.fieldNames[i];
            JLabel l = this.getFieldLabel(fname);
            Font f = l.getFont().deriveFont(1);
            l.setFont(f);
            l.setName(fname);
            this.addLeft(p, l);
            JComponent c = this.createFieldValueComponent(fname);
            c.setName(fname);
            this.addRight(p, c);
        }
        return p;
    }

    protected void setupLabelValuePairPanel(JPanel p) {
        p.setLayout(new GridBagLayout());
        this.leftLabelGbc.insets = new Insets(2, 5, 2, 5);
        this.leftLabelGbc.anchor = 17;
        this.rightLabelGbc.anchor = 17;
        this.rightLabelGbc.gridwidth = 0;
        this.rightLabelGbc.insets = new Insets(2, 50, 2, 5);
        this.rightLabelGbc.weightx = 1.0;
        this.rightLabelGbc.weighty = 0.0;
        this.leftComponents = new Vector();
        this.rightComponents = new Vector();
    }

    protected void addLeft(JPanel p, Component c) {
        this.leftComponents.add(c);
        p.add(c, this.leftLabelGbc);
    }

    protected void addRight(JPanel p, Component c) {
        this.rightComponents.add(c);
        p.add(c, this.rightLabelGbc);
    }

    protected JLabel getFieldLabel(String fname) {
        return new JLabel(FabricGuiUtil.getString(fname));
    }

    protected JComponent createFieldValueComponent(String fname) {
        return new JLabel("");
    }

    protected String getFieldValue(JComponent c) {
        return "";
    }

    protected void setFieldValue(JComponent c, Object value) {
        JLabel l = (JLabel)c;
        l.setText((String)value);
    }

    public boolean isEditable() {
        return false;
    }

    public void displayDataInPanel(GuiDetailsReq data) {
        for (int i = 0; i < this.fieldNames.length; ++i) {
            JComponent c;
            String value = (String)data.data.get(this.fieldNames[i]);
            if (value == null || (c = this.findFieldValueComponent(this.fieldNames[i])) == null) continue;
            this.setFieldValue(c, value);
        }
    }

    public boolean isFieldChanged(String fieldName) {
        JComponent c;
        boolean result = false;
        String value = (String)this.dataInDb.data.get(fieldName);
        if (value == null) {
            value = new String("");
        }
        if (!((c = this.findFieldValueComponent(fieldName)) instanceof JLabel) && !this.getFieldValue(c).trim().equals(value.trim())) {
            result = true;
        }
        return result;
    }

    public boolean changesPending() {
        if (this.dataInDb != null && this.dataInDb.data != null) {
            for (int i = 0; i < this.fieldNames.length; ++i) {
                if (!this.isFieldChanged(this.fieldNames[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void dump() {
        Enumeration en = this.dataInDb.data.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = (String)this.dataInDb.data.get(key);
            System.out.println("dump [" + key + "]  [" + value + "]");
        }
    }

    public void getDataFromPanel(GuiDetailsReq data) {
        if (data != null && data.data != null) {
            Hashtable h = data.data;
            for (int i = 0; i < this.fieldNames.length; ++i) {
                String value = (String)data.data.get(this.fieldNames[i]);
                JComponent c = this.findFieldValueComponent(this.fieldNames[i]);
                if (c == null || c instanceof JLabel || this.getFieldValue(c).trim().equals(value)) continue;
                data.data.remove(this.fieldNames[i]);
                data.data.put(this.fieldNames[i], this.getFieldValue(c).trim());
            }
        }
    }

    public void close() {
    }

    protected JComponent findFieldValueComponent(String fname) {
        Enumeration en = this.rightComponents.elements();
        while (en.hasMoreElements()) {
            JComponent c = (JComponent)en.nextElement();
            if (!c.getName().equals(fname)) continue;
            return c;
        }
        return null;
    }

    protected void resizeComponents(Vector comps) {
        Dimension d;
        JComponent c;
        int max = 200;
        Enumeration en = comps.elements();
        while (en.hasMoreElements()) {
            c = (JComponent)en.nextElement();
            d = c.getPreferredSize();
            if (d.width <= max) continue;
            max = d.width;
        }
        en = comps.elements();
        while (en.hasMoreElements()) {
            c = (JComponent)en.nextElement();
            d = c.getPreferredSize();
            c.setPreferredSize(new Dimension(max, d.height));
        }
    }

    public void makeComponentAccessible(Component c, JLabel l) {
    }

    protected void resizeComponents() {
        this.resizeComponents(this.leftComponents);
        this.resizeComponents(this.rightComponents);
    }

    protected void doAccessibility() {
        for (int i = 0; i < this.leftComponents.size(); ++i) {
            if (i >= this.rightComponents.size()) continue;
            this.makeComponentAccessible((Component)this.rightComponents.elementAt(i), (JLabel)this.leftComponents.elementAt(i));
        }
    }

    public void addButtonListener(ActionListener listener) {
        if (this.okButton != null) {
            this.okButton.addActionListener(listener);
        }
        if (this.cancelButton != null) {
            this.cancelButton.addActionListener(listener);
        }
    }

    public JTextField createATextField(String s) {
        return new DetailTextField(s);
    }

    public JTextField createATextField(String s, int maxChars) {
        DetailTextField tf = new DetailTextField(s);
        tf.setMaxChars(maxChars);
        return tf;
    }

    public synchronized void hookMenu() {
        if (this.isEditable()) {
            this.guiMain.setSaveActionEnabled(true, true);
            this.guiMain.setSaveActionToolTip(Util.getString("ROLES_CFG_SAVE"));
            if (!this.menuHooked) {
                this.menuHooked = true;
                this.guiMain.addSaveActionListener(this);
            }
        } else {
            this.guiMain.setSaveActionEnabled(false, false);
            this.guiMain.setSaveActionToolTip(null);
        }
    }

    public synchronized void unhookMenu() {
        if (this.menuHooked) {
            this.menuHooked = false;
            this.guiMain.removeSaveActionListener(this);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.saveDataFromPanel();
    }
}

