/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.jobs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.gui.NameListToTreeNode;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.fabric.jobs.FabricJobsHelper;
import org.eclipse.aperi.request.Response;

public class FabricJobsNode
extends BaseTreeNode
implements ActionListener {
    private static final String COMMAND_HISTORY = "command_history";
    private static final String COMMAND_REFRESH = "command_refresh";
    private static final String COMMAND_UPDATE = "command_update";
    private FabricJobsHelper jobsHelper;
    private JPopupMenu menu;

    public FabricJobsNode() {
        this.setUserObject(Util.getString("FabricMonitorNode_Jobs"));
        this.expandBranch = 1;
        this.jobsHelper = new FabricJobsHelper(this, Util.getString("Fabric100"), 114);
    }

    public void showPopupMenu(MouseEvent event) {
        this.menu = this.getPopupMenu();
        this.showPopupMenu(this.menu, event);
    }

    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        this.menu.addPopupMenuListener(this);
        this.addMenuItem(this.menu, "", COMMAND_REFRESH, true, "REFRESH_JOB_LIST");
        this.addMenuItem(this.menu, "GUI0165L", COMMAND_UPDATE, true, "UPDATE_JOB_STATUS");
        this.addMenuItem(this.menu, "GUI0052L", COMMAND_HISTORY, true, null);
        return this.menu;
    }

    public void expand(TreeExpansionEvent event) {
        if (this.getChildCount() == 0) {
            this.jobsHelper.sendRequest();
        }
    }

    public void refresh(Response response, NameListToTreeNode generator) {
        MutableInteger key;
        BaseTreeNode node;
        NameList head = GuiUtil.sortNameList((NameList)response.responseData);
        int selectedID = Integer.MIN_VALUE;
        TreePath path = BaseTree.pBaseTree.getSelectionPath();
        BaseTreeNode selectedNode = path != null ? (BaseTreeNode)path.getLastPathComponent() : null;
        HashMap<MutableInteger, DataDisplayInfo> map = new HashMap<MutableInteger, DataDisplayInfo>();
        BaseTreeNode[] children = new BaseTreeNode[this.getChildCount()];
        int index = 0;
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            node = (BaseTreeNode)e.nextElement();
            NameList element = (NameList)node.getUserObject();
            element.nlName = Util.getTranslatedName(element.nlName);
            key = new MutableInteger(generator.getKey(element));
            map.put(key, node.ddi);
            if (node == selectedNode) {
                selectedID = key.value;
            }
            children[index] = node;
            ++index;
        }
        for (index = 0; index < children.length; ++index) {
            BaseTree.MyTree.removeNodeFromParent(children[index]);
        }
        selectedNode = null;
        key = new MutableInteger();
        index = 0;
        while (head != null) {
            DataDisplayInfo ddi;
            head.nlName = Util.getTranslatedName(head.nlName);
            node = generator.makeChild(head);
            key.value = generator.getKey(head);
            if (key.value == selectedID) {
                selectedNode = node;
            }
            if ((ddi = (DataDisplayInfo)map.get(key)) != null) {
                node.ddi = ddi;
                ddi.treeNode = node;
            }
            BaseTree.MyTree.insertNodeInto(node, this, index);
            ++index;
            head = head.nlNext;
        }
        if (selectedNode != null) {
            BaseTree.pBaseTree.reselect(selectedNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(COMMAND_REFRESH)) {
            this.jobsHelper.sendRequest();
        } else if (cmd.equals(COMMAND_UPDATE)) {
            this.jobsHelper.sendUpdateRequest();
        } else if (cmd.equals(COMMAND_HISTORY)) {
            this.jobsHelper.makeRunDDI();
        }
        guiMain.getBaseTree().requestFocus();
    }

    private void addMenuItem(JPopupMenu menu, String msgID, String cmd, boolean enabled, String resourceID) {
        String s = resourceID == null ? Util.getString(msgID) : Util.getString(resourceID);
        JMenuItem item = new JMenuItem(s);
        item.setName(s);
        item.setActionCommand(cmd);
        item.addActionListener(this);
        item.setEnabled(enabled);
        menu.add(item);
    }

    public void popupMenuCanceled(PopupMenuEvent pme) {
        BaseTree.pBaseTree.setSelectionPath(BaseTree.selectedPath);
        BaseTree.pBaseTree.requestFocus();
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
        BaseTree.pBaseTree.setSelectionPath(BaseTree.selectedPath);
        BaseTree.pBaseTree.requestFocus();
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
    }
}

