/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.fabric.reports.FabricAssetsAdjuster;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.fabric.reports.RespFabricAssets;

public class FabricAssetsTable
extends JPanel
implements GuiRequestor {
    private MegaTable table = new MegaTable();
    FabricAssetsModel FabricAssetsModel;
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private RespFabricAssets[] data;
    private FabricAssetsAdjuster adjuster;
    private TJCTableMouseAdapter myMouseListener = new SelectListener();

    public FabricAssetsTable(GuiReportReq grr, ReportingDDI ddi) {
        this.grr = grr;
        this.ddi = ddi;
        GuiReportRequest request = new GuiReportRequest(grr);
        GuiClient.doRequest(this, request);
        this.setLayout(new BorderLayout());
        this.adjuster = new FabricAssetsAdjuster(grr);
    }

    public void handleResponse(short status, Response response) {
        this.data = status <= 4 ? (RespFabricAssets[])response.responseData : null;
        int cnt = this.data != null ? this.data.length : 0;
        if (cnt == 0) {
            this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            return;
        }
        this.adjuster.adjust(this.data, false);
        this.data = (RespFabricAssets[])this.adjuster.getArray();
        this.FabricAssetsModel = new FabricAssetsModel();
        this.table.setMouseListener(this.myMouseListener);
        this.table.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        this.table.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
        this.table.setFrozenColumns(this.adjuster.frozenColumns);
        this.table.setFrozenRows(this.adjuster.frozenRows);
        int[] hiddenColumns = this.adjuster.getHiddenColumns();
        if (hiddenColumns != null) {
            for (int i = 0; i < hiddenColumns.length; ++i) {
                this.table.setColumnHidden(hiddenColumns[i], true);
            }
        }
        this.table.setBaseTableModel(this.FabricAssetsModel);
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.table, "Center");
    }

    public TJCTableMouseInterface getShowsPopup() {
        return this.myMouseListener;
    }

    public class SelectListener
    extends TJCTableMouseAdapter {
        public boolean select(int viewRow, int viewCol) {
            return viewRow >= ((FabricAssetsTable)FabricAssetsTable.this).adjuster.frozenLabels;
        }

        public void doubleClick(int dataRow, int dataCol) {
            if ((dataRow -= ((FabricAssetsTable)FabricAssetsTable.this).adjuster.frozenLabels) < 0 || FabricAssetsTable.this.adjuster.hasTotalsRow() && dataRow == 0) {
                return;
            }
        }
    }

    private class FabricAssetsModel
    extends BaseTableModel
    implements AskForRowIconInterface {
        FabricAssetsModel() {
            this.columnNames = ((FabricAssetsTable)FabricAssetsTable.this).adjuster.colNames;
            this.rowCount = FabricAssetsTable.this.data.length + ((FabricAssetsTable)FabricAssetsTable.this).adjuster.frozenLabels;
            this.commonAdjuster = FabricAssetsTable.this.adjuster;
        }

        public boolean changeIcon(int rowNum) {
            return rowNum < ((FabricAssetsTable)FabricAssetsTable.this).adjuster.frozenRows;
        }

        public Object getTableDataItem(int row, int col) {
            return FabricAssetsTable.this.adjuster.getCellData(row, FabricAssetsTable.this.adjuster.translateColumn(col));
        }
    }
}

