/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneControlTabbedPane;
import org.eclipse.aperi.gui.tables.MegaTable;

public class FabricTablePanel
extends JPanel
implements ActionListener {
    private MegaTable fabricTable = new MegaTable();
    protected JButton displayButton = new JButton(FabricGuiUtil.getString("FabricZone_DisplayZones"));
    private FabricTableModel fabricModel;
    private FabricData[] fabricTableData;
    private ZoneControlTabbedPane zcTabPane = null;
    private JPanel tablePanel;
    private static final int FABRIC_COL = 0;
    private static final int FABRIC_WWN_COL = 1;
    private static final int FABRIC_STATE_COL = 2;
    private static final int FABRIC_ACTIVE_COL = 3;
    private static final String[] FABRIC_COL_NAMES = new String[]{FabricGuiUtil.getString("FabricZone_FabricColumn"), FabricGuiUtil.getString("FabricZone_PhysicalFabricColumn2"), FabricGuiUtil.getString("FabricZone_State_Column"), FabricGuiUtil.getString("FabricZone_ActiveColumn")};

    public FabricTablePanel(HashMap[] sans, ZoneControlTabbedPane newPane) {
        this.zcTabPane = newPane;
        this.populateFabricData(sans);
        this.setLayout(new BorderLayout());
        GuiUtil.setAccessible(this.displayButton, FabricGuiUtil.getString("FabricZone_DisplayZones"), FabricGuiUtil.getString("FabricZone_DisplayZones"));
        this.displayButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZone_DisplayZones_M")));
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        buttonPanel.add(this.displayButton);
        this.add((Component)buttonPanel, "North");
        this.displayButton.addActionListener(this);
        this.tablePanel = this.createFabricTable();
        this.add((Component)this.tablePanel, "Center");
    }

    private void populateFabricData(HashMap[] sans) {
        if (sans != null && sans.length > 0) {
            this.fabricTableData = new FabricData[sans.length];
            for (int i = 0; i < sans.length; ++i) {
                HashMap currMap = sans[i];
                this.fabricTableData[i] = new FabricData((String)currMap.get("WWN"), (String)currMap.get("Label"), (Integer)currMap.get("State"), (Integer)currMap.get("Active"));
            }
        }
    }

    private JPanel createFabricTable() {
        JPanel fabricPanel = GuiUtil.getPanel();
        fabricPanel.setBorder(new TitledBorder(Util.getString("Fabric_TabTitle")));
        fabricPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridheight = 0;
        gbc.insets.bottom = 0;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 0.5;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.initializeZoneTable();
        fabricPanel.add((Component)this.fabricTable, gbc);
        return fabricPanel;
    }

    private void initializeZoneTable() {
        this.fabricTable.setSelectionPolicy(0);
        this.fabricModel = new FabricTableModel();
        this.fabricTable.setCellRenderer(JLabel.class, new LabelIconRenderer());
        boolean vColIndex = false;
        this.fabricTable.setBaseTableModel(this.fabricModel);
        this.fabricTable.sortByColumn(0, 1);
    }

    public void refreshTable(HashMap[] sans) {
        this.populateFabricData(sans);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridheight = 0;
        gbc.insets.bottom = 0;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 0.5;
        gbc.insets = new Insets(4, 4, 4, 4);
        boolean empty = this.fabricModel.refreshTableData();
        if (!empty) {
            this.fabricModel.tableDataReset();
            this.tablePanel.removeAll();
            this.tablePanel.add((Component)this.fabricTable, gbc);
        } else {
            this.tablePanel.removeAll();
            this.tablePanel.add((Component)ReportingDDI.getNoDataMessage(null), gbc);
        }
        this.repaint();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.displayButton) {
            FabricData[] sans = this.getSelectedFabrics();
            if (sans != null && sans.length > 0) {
                for (int i = 0; i < sans.length; ++i) {
                    if (sans[i] == null) continue;
                    this.zcTabPane.addZoneConfigTab(sans[i].getWWN(), sans[i].getLabel());
                }
            } else {
                JOptionPane.showMessageDialog(this, FabricGuiUtil.getString("FabricZone_SanNotSelected"));
            }
        }
    }

    private FabricData[] getSelectedFabrics() {
        int[] selected = this.fabricTable.getSelectedRows();
        FabricData[] sans = new FabricData[selected.length];
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] >= this.fabricTableData.length) continue;
            sans[i] = this.fabricTableData[selected[i]];
        }
        return sans;
    }

    private static class LabelIconRenderer
    extends DefaultTableCellRenderer {
        private LabelIconRenderer() {
        }

        public void setValue(Object o) {
            String str = ((JLabel)o).getText();
            this.setText(str);
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(10);
            Icon icon = ((JLabel)o).getIcon();
            this.setIcon(icon);
        }
    }

    private class FabricData {
        String label = "";
        String wwn = "";
        String active = "";
        int state = 0;

        public FabricData(String newWWN, String newLabel, Integer newState, Integer newActive) {
            this.label = newLabel;
            this.wwn = newWWN;
            this.active = this.getActive(newActive);
            this.state = newState;
        }

        private String getActive(Integer activeState) {
            if (activeState != null) {
                switch (activeState) {
                    case 0: {
                        return FabricGuiUtil.getString("FabricZoneSetPage_InactiveZoneSet");
                    }
                }
                return FabricGuiUtil.getString("FabricZoneSetPage_ActiveZoneSet");
            }
            return "";
        }

        private JLabel getState(Integer currState) {
            if (currState != null) {
                return FabricGuiUtil.getDetectableStateLabel(currState);
            }
            return new JLabel();
        }

        public String getLabel() {
            return this.label;
        }

        public String getWWN() {
            return this.wwn;
        }

        public String getActive() {
            return this.active;
        }

        public int getState() {
            return this.state;
        }
    }

    private class FabricTableModel
    extends BaseTableModel {
        FabricTableModel() {
            this.populateTable();
            this.tableDataReset();
        }

        public int getNumRows() {
            return this.rowCount;
        }

        public boolean populateTable() {
            boolean empty = false;
            this.columnNames = FABRIC_COL_NAMES;
            if (FabricTablePanel.this.fabricTableData == null || FabricTablePanel.this.fabricTableData.length == 0) {
                empty = true;
                return empty;
            }
            return empty;
        }

        public void tableDataReset() {
            this.rowCount = FabricTablePanel.this.fabricTableData != null ? FabricTablePanel.this.fabricTableData.length : 0;
            this.fireTableDataChanged();
        }

        public boolean refreshTableData() {
            return this.populateTable();
        }

        public Object getTableDataItem(int row, int col) {
            try {
                switch (col) {
                    case 0: {
                        return FabricTablePanel.this.fabricTableData[row].getLabel();
                    }
                    case 1: {
                        return FabricTablePanel.this.fabricTableData[row].getWWN();
                    }
                    case 2: {
                        JLabel stateLabel = FabricGuiUtil.getDetectableStateLabel(FabricTablePanel.this.fabricTableData[row].getState());
                        return stateLabel;
                    }
                    case 3: {
                        return FabricTablePanel.this.fabricTableData[row].getActive();
                    }
                }
                return Util.getString("FabricStatusUnknown");
            }
            catch (Exception ex) {
                return "";
            }
        }

        public void addRow() {
            ++this.rowCount;
            this.fireTableDataChanged();
            FabricTablePanel.this.fabricTable.sortByColumn(0, -1);
        }

        public void deleteRow() {
            --this.rowCount;
            this.fireTableDataChanged();
            FabricTablePanel.this.fabricTable.sortByColumn(0, -1);
        }
    }
}

