/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;

public class ZoneMemberPanel
extends JPanel
implements ActionListener {
    private Zone zone = new Zone("temp");
    private boolean newZone = false;
    private ZoneCNS zoneCNS;
    private Vector zoneAssets = new Vector();
    private ZoneMember[] origZoneMems = null;
    protected JButton addButton;
    protected JButton delButton;
    protected JPanel leftPane;
    protected JPanel rightPane;
    protected JPanel middlePane;
    protected JLabel leftTitle;
    protected JLabel rightTitle;
    private JList assetList;
    private JTree assetTree;
    private short N_PORT = (short)11;
    private short SWITCHPORT = (short)12;
    private short FCID = (short)13;
    private short DEVICE_PORT = (short)10;
    private short NODE_PORT = (short)14;
    private DefaultMutableTreeNode topNode = new DefaultMutableTreeNode();
    private HashMap switchNodes = new HashMap();
    private HashMap domainPorts = new HashMap();
    private HashMap fcidPorts = new HashMap();
    private HashMap wwnPorts = new HashMap();
    private DefaultMutableTreeNode switchNode = new DefaultMutableTreeNode(new AssetNode(Util.getString("FabricZonePanel_Switches")));
    private DefaultMutableTreeNode deviceNode = new DefaultMutableTreeNode(new AssetNode(Util.getString("FabricZonePanel_Devices")));
    private DefaultMutableTreeNode aliasNode = new DefaultMutableTreeNode(new AssetNode(Util.getString("FabricZonePanel_ZoneAliases")));
    HashMap assetMap = new HashMap();

    public ZoneMemberPanel(boolean newz, Zone z, ZoneCNS cns, ZoneMember[] origMems) {
        this.newZone = newz;
        this.zoneCNS = cns;
        this.zone = z;
        this.origZoneMems = origMems;
        this.init();
    }

    public void init() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.addButton = new JButton(">>");
        Font boldFont = this.addButton.getFont().deriveFont(1);
        this.addButton.setFont(boldFont);
        this.delButton = new JButton("<<");
        this.delButton.setFont(boldFont);
        this.assetTree = new JTree(this.topNode);
        this.assetTree.setRootVisible(false);
        this.assetTree.setShowsRootHandles(true);
        this.assetTree.getSelectionModel().setSelectionMode(4);
        DefaultTreeCellRenderer treeCellRenderer = new DefaultTreeCellRenderer();
        treeCellRenderer.setLeafIcon(null);
        treeCellRenderer.setOpenIcon(null);
        treeCellRenderer.setClosedIcon(null);
        this.assetTree.setCellRenderer(treeCellRenderer);
        this.assetTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)ZoneMemberPanel.this.assetTree.getLastSelectedPathComponent();
                if (node == null) {
                    ZoneMemberPanel.this.addButton.setEnabled(false);
                    return;
                }
                AssetNode assetNode = (AssetNode)node.getUserObject();
                if (ZoneMemberPanel.this.isAsset(assetNode) || assetNode.isSwitch() && ZoneMemberPanel.this.zoneCNS.getZoneCapabilities().isSupportsDomainPort() || assetNode.isDevice()) {
                    ZoneMemberPanel.this.addButton.setEnabled(true);
                    ZoneMemberPanel.this.delButton.setEnabled(false);
                    ZoneMemberPanel.this.assetList.clearSelection();
                } else {
                    ZoneMemberPanel.this.addButton.setEnabled(false);
                }
            }
        });
        this.populateAssetTree();
        JScrollPane treeScroll = new JScrollPane(this.assetTree);
        treeScroll.setName(Util.getString("FabricZonePanel_AssetTreeTitle"));
        this.zoneAssets = this.populateMemberList();
        this.assetList = new JList(this.zoneAssets);
        this.assetList.setSelectionMode(2);
        this.assetList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AssetNode id = (AssetNode)ZoneMemberPanel.this.assetList.getSelectedValue();
                if (id == null) {
                    ZoneMemberPanel.this.delButton.setEnabled(false);
                    return;
                }
                ZoneMemberPanel.this.assetTree.clearSelection();
                ZoneMemberPanel.this.addButton.setEnabled(false);
                ZoneMemberPanel.this.delButton.setEnabled(true);
            }
        });
        JScrollPane listScroll = new JScrollPane(this.assetList);
        this.leftTitle = new JLabel(Util.getString("FabricZonePanel_AssetTreeTitle"));
        this.leftTitle.setFont(boldFont);
        this.rightTitle = new JLabel(Util.getString("FabricZonePanel_AssetListTitle"));
        this.rightTitle.setFont(boldFont);
        this.leftTitle.setDisplayedMnemonic(GuiUtil.getMnemonic("MNEMONIC_PROBE_TREE_AVAILABLE"));
        this.leftTitle.setLabelFor(treeScroll);
        this.rightTitle.setDisplayedMnemonic(GuiUtil.getMnemonic("MNEMONIC_PROBE_TREE_SELECTED"));
        this.rightTitle.setLabelFor(listScroll);
        this.leftPane = this.getPane(treeScroll, this.leftTitle);
        this.rightPane = this.getPane(listScroll, this.rightTitle);
        this.middlePane = new JPanel(new GridBagLayout());
        gbc.gridwidth = 0;
        gbc.anchor = 15;
        gbc.insets.bottom = 10;
        this.middlePane.add((Component)this.addButton, gbc);
        gbc.gridheight = 0;
        gbc.anchor = 11;
        gbc.insets.bottom = 0;
        gbc.insets.top = 10;
        this.middlePane.add((Component)this.delButton, gbc);
        gbc.gridwidth = 1;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 0.5;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.leftPane, gbc);
        gbc.fill = 3;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.add((Component)this.middlePane, gbc);
        gbc.fill = 1;
        gbc.weightx = 0.5;
        gbc.gridwidth = 0;
        this.add((Component)this.rightPane, gbc);
        this.addButton.setEnabled(false);
        this.delButton.setEnabled(false);
        this.addButton.addActionListener(this);
        this.delButton.addActionListener(this);
    }

    private JPanel getPane(JComponent component, JLabel title) {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(component);
        scrollPane.setPreferredSize(new Dimension(225, 380));
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        pane.add((Component)title, "North");
        pane.add((Component)scrollPane, "Center");
        return pane;
    }

    private Vector populateMemberList() {
        Vector<AssetNode> returnMembers = new Vector<AssetNode>();
        if (!this.newZone) {
            ZoneMember[] returnZoneMembers = this.origZoneMems;
            for (int i = 0; i < returnZoneMembers.length; ++i) {
                AssetNode assetNode;
                if (returnZoneMembers[i].getType() == this.SWITCHPORT) {
                    assetNode = new AssetNode(Util.getString("FabricZonePanel_Port") + " " + returnZoneMembers[i].getName(), returnZoneMembers[i]);
                    returnMembers.add(assetNode);
                    this.assetMap.put(Util.getString("FabricZonePanel_Port") + " " + returnZoneMembers[i].getName(), assetNode);
                    continue;
                }
                if (returnZoneMembers[i].getType() == this.N_PORT) {
                    assetNode = new AssetNode(Util.getString("FabricZonePanel_PortWWN") + " " + returnZoneMembers[i].getName(), returnZoneMembers[i]);
                    returnMembers.add(assetNode);
                    this.assetMap.put(Util.getString("FabricZonePanel_PortWWN") + " " + returnZoneMembers[i].getName(), assetNode);
                    continue;
                }
                if (returnZoneMembers[i].getType() == this.FCID) {
                    assetNode = new AssetNode(Util.getString("FabricZonePanel_FCID") + " " + returnZoneMembers[i].getName(), returnZoneMembers[i]);
                    returnMembers.add(assetNode);
                    this.assetMap.put(Util.getString("FabricZonePanel_FCID") + " " + returnZoneMembers[i].getName(), assetNode);
                    continue;
                }
                if (returnZoneMembers[i].getType() == this.DEVICE_PORT) {
                    assetNode = new AssetNode(Util.getString("FabricZonePanel_DevicePort") + " " + returnZoneMembers[i].getName(), returnZoneMembers[i]);
                    returnMembers.add(assetNode);
                    this.assetMap.put(Util.getString("FabricZonePanel_DevicePort") + " " + returnZoneMembers[i].getName(), assetNode);
                    continue;
                }
                if (returnZoneMembers[i].getType() == this.NODE_PORT) {
                    assetNode = new AssetNode(Util.getString("FabricDetails_Node") + " " + returnZoneMembers[i].getName(), returnZoneMembers[i]);
                    returnMembers.add(assetNode);
                    this.assetMap.put(Util.getString("FabricDetails_Node") + " " + returnZoneMembers[i].getName(), assetNode);
                    continue;
                }
                if (returnZoneMembers[i].getName().equals("0000000000000000")) continue;
                assetNode = new AssetNode(returnZoneMembers[i].getName(), returnZoneMembers[i]);
                returnMembers.add(assetNode);
                this.assetMap.put(returnZoneMembers[i].getName(), assetNode);
            }
            ZoneAlias[] zoneAliases = this.zoneCNS.getZoneAliases(this.zone);
            for (int i = 0; i < zoneAliases.length; ++i) {
                AssetNode assetNode = new AssetNode(Util.getString("FabricZonePanel_Alias") + " " + zoneAliases[i].getName(), zoneAliases[i]);
                returnMembers.add(assetNode);
                this.assetMap.put(Util.getString("FabricZonePanel_Alias") + " " + zoneAliases[i].getName(), assetNode);
            }
        }
        return returnMembers;
    }

    public void populateAssetTree() {
        String methodName = "populateAssetTree";
        DefaultMutableTreeNode switchNode = new DefaultMutableTreeNode(new AssetNode(Util.getString("FabricZonePanel_Switches")));
        DefaultMutableTreeNode deviceNode = new DefaultMutableTreeNode(new AssetNode(Util.getString("FabricZonePanel_Devices")));
        DefaultMutableTreeNode aliasNode = new DefaultMutableTreeNode(new AssetNode(Util.getString("FabricZonePanel_ZoneAliases")));
        if (ZoneCNS.DEBUG) {
            int i;
            int switchNum = 5;
            short num = 1;
            for (i = 0; i < switchNum; ++i) {
                AssetNode switchMember = new AssetNode("Domain " + i + " (Switch " + i + ")");
                DefaultMutableTreeNode switchMemNode = new DefaultMutableTreeNode(switchMember);
                for (int j = 0; j < 5; ++j) {
                    AssetNode portMember = new AssetNode("Port " + j, new ZoneMember(num, "Port " + j));
                    DefaultMutableTreeNode portMemNode = new DefaultMutableTreeNode(portMember);
                    DefaultMutableTreeNode fcidMemNode = new DefaultMutableTreeNode(new AssetNode("FCID " + j, new ZoneMember(num, "FCID " + j)));
                    DefaultMutableTreeNode portWWNMemNode = new DefaultMutableTreeNode(new AssetNode("Port WWN " + j, new ZoneMember(num, "Port WWN " + j)));
                    fcidMemNode.add(portWWNMemNode);
                    portMemNode.add(fcidMemNode);
                    switchMemNode.add(portMemNode);
                }
                switchNode.add(switchMemNode);
            }
            for (i = 0; i < 25; ++i) {
                DefaultMutableTreeNode deviceSPNode = new DefaultMutableTreeNode(new AssetNode("Device " + i));
                DefaultMutableTreeNode deviceMemNode = new DefaultMutableTreeNode(new AssetNode("Device " + i, new ZoneMember(num, "Device " + i)));
                deviceSPNode.add(deviceMemNode);
                deviceNode.add(deviceSPNode);
            }
            for (i = 0; i < 15; ++i) {
                DefaultMutableTreeNode aliasMemNode = new DefaultMutableTreeNode(new AssetNode("Alias " + i, new ZoneAlias("Alias" + i)));
                aliasNode.add(aliasMemNode);
            }
        } else {
            String switchName = null;
            DefaultMutableTreeNode switchMemNode = null;
            HashMap[] switchMems = this.zoneCNS.getSwitchZMHash();
            String sanWWN = this.zoneCNS.getSanWWN();
            HashMap currMap = new HashMap();
            if (switchMems != null) {
                for (int i = 0; i < switchMems.length; ++i) {
                    currMap = switchMems[i];
                    String switchWWN = (String)currMap.get(new String("SWITCHWWN"));
                    switchMemNode = this.getAssetSwitchNode(switchName, switchWWN, currMap);
                    switchNode.add(switchMemNode);
                    String epportwwn = (String)currMap.get(new String("EPPORTWWN"));
                    DefaultMutableTreeNode portWWNMemNode = null;
                    if (epportwwn != null && !FabricGuiUtil.isSwitchPort((Integer)currMap.get("EPPORTTYPE"))) {
                        portWWNMemNode = this.getPortWWNNode(epportwwn);
                    }
                    Integer epfcidInt = (Integer)currMap.get("EPFCID");
                    String epfcid = this.getFCIDHex(epfcidInt);
                    DefaultMutableTreeNode fcidMemNode = null;
                    if (this.zoneCNS.getZoneCapabilities().isSupportsFCID() && epfcid != null) {
                        fcidMemNode = this.getFcidPortNode(epfcid);
                    }
                    String portWWN = (String)currMap.get("SWITCHPORTWWN");
                    String domainPort = (String)currMap.get("DOMAIN") + "," + (String)currMap.get("PORTPHY");
                    DefaultMutableTreeNode portMemNode = null;
                    if (this.isDomainPortZoneable(portWWN, switchWWN, sanWWN, currMap)) {
                        portMemNode = this.getDomainPortNode(domainPort);
                    }
                    if (portMemNode != null) {
                        if (fcidMemNode != null) {
                            if (portWWNMemNode != null) {
                                fcidMemNode.add(portWWNMemNode);
                            }
                            portMemNode.add(fcidMemNode);
                        } else if (portWWNMemNode != null) {
                            portMemNode.add(portWWNMemNode);
                        }
                        switchMemNode.add(portMemNode);
                        continue;
                    }
                    if (fcidMemNode != null) {
                        if (portWWNMemNode != null) {
                            fcidMemNode.add(portWWNMemNode);
                        }
                        switchMemNode.add(fcidMemNode);
                        continue;
                    }
                    if (portWWNMemNode == null) continue;
                    switchMemNode.add(portWWNMemNode);
                }
            }
            HashMap<String, DefaultMutableTreeNode> deviceSPMap = new HashMap<String, DefaultMutableTreeNode>();
            HashMap<String, DefaultMutableTreeNode> nodeMemMap = new HashMap<String, DefaultMutableTreeNode>();
            HashMap<String, DefaultMutableTreeNode> deviceMemMap = new HashMap<String, DefaultMutableTreeNode>();
            HashMap<String, DefaultMutableTreeNode> portMap = new HashMap<String, DefaultMutableTreeNode>();
            for (int i = 0; i < 4; ++i) {
                String deviceLabel = Util.getString("FabricZonePanel_Device") + " ";
                String devicePortLabel = Util.getString("FabricZonePanel_DevicePort") + " ";
                HashMap[] currMaps = null;
                switch (i) {
                    case 0: {
                        currMaps = this.zoneCNS.getDeviceSPZMHash();
                        break;
                    }
                    case 1: {
                        currMaps = this.zoneCNS.getDeviceZMHash();
                        break;
                    }
                    case 2: {
                        currMaps = this.zoneCNS.getNodeZMHash();
                        break;
                    }
                    case 3: {
                        currMaps = this.zoneCNS.getPortZMHash();
                    }
                }
                String deviceName = null;
                DefaultMutableTreeNode deviceSPNode = null;
                if (currMaps == null) continue;
                for (int j = 0; j < currMaps.length; ++j) {
                    String nodeWWN;
                    if (deviceName == null || (String)currMaps[j].get("Label") != deviceName) {
                        deviceName = (String)currMaps[j].get("Label");
                        AssetNode assetNode = new AssetNode(deviceLabel + (String)currMaps[j].get("Label"));
                        assetNode.setTypeToDevice();
                        if (deviceSPMap.containsKey(deviceName)) {
                            deviceSPNode = (DefaultMutableTreeNode)deviceSPMap.get(deviceName);
                        } else {
                            deviceSPNode = new DefaultMutableTreeNode(assetNode);
                            deviceSPMap.put(deviceName, deviceSPNode);
                            deviceNode.add(deviceSPNode);
                        }
                    }
                    if ((nodeWWN = (String)currMaps[j].get("NODEWWN")) != null && this.zoneCNS.isNodeZoneAsset() && !nodeWWN.equals("")) {
                        DefaultMutableTreeNode nodeMemNode = new DefaultMutableTreeNode(new AssetNode(Util.getString("FabricDetails_Node") + " " + nodeWWN, new ZoneMember(this.NODE_PORT, nodeWWN)));
                        if (nodeMemMap.containsKey(nodeWWN)) {
                            nodeMemNode = (DefaultMutableTreeNode)nodeMemMap.get(nodeWWN);
                        } else {
                            deviceSPNode.add(nodeMemNode);
                            nodeMemMap.put(nodeWWN, nodeMemNode);
                        }
                        String portWWN = (String)currMaps[j].get("PORTWWN");
                        DefaultMutableTreeNode deviceMemNode = new DefaultMutableTreeNode(new AssetNode(devicePortLabel + portWWN, new ZoneMember(this.N_PORT, portWWN)));
                        if (deviceMemMap.containsKey(portWWN)) continue;
                        nodeMemNode.add(deviceMemNode);
                        deviceMemMap.put(portWWN, deviceMemNode);
                        continue;
                    }
                    String portWWN = (String)currMaps[j].get("PORTWWN");
                    DefaultMutableTreeNode deviceMemNode = new DefaultMutableTreeNode(new AssetNode(devicePortLabel + portWWN, new ZoneMember(this.N_PORT, portWWN)));
                    if (portMap.containsKey(portWWN)) continue;
                    deviceSPNode.add(deviceMemNode);
                    portMap.put(portWWN, deviceMemNode);
                }
            }
            if (this.zoneCNS.getZoneCapabilities().isSupportsAliases()) {
                ZoneAlias[] za = this.zoneCNS.getAllZoneAliases();
                for (int i = 0; i < za.length; ++i) {
                    DefaultMutableTreeNode aliasMemNode = new DefaultMutableTreeNode(new AssetNode(Util.getString("FabricZonePanel_Alias") + " " + za[i].getName(), za[i]));
                    aliasNode.add(aliasMemNode);
                }
            }
        }
        this.topNode.add(switchNode);
        this.topNode.add(deviceNode);
        if (!ZoneCNS.DEBUG && this.zoneCNS.getZoneCapabilities().isSupportsAliases()) {
            this.topNode.add(aliasNode);
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(this.topNode);
        this.assetTree.setModel(treeModel);
    }

    protected Vector getZoneMembers() {
        Vector<Comparable> returnMembers = new Vector<Comparable>();
        Enumeration e = this.zoneAssets.elements();
        while (e.hasMoreElements()) {
            AssetNode node = (AssetNode)e.nextElement();
            if (node.isZoneMember()) {
                returnMembers.add(node.getZoneMember());
                continue;
            }
            returnMembers.add(node.getZoneAlias());
        }
        return returnMembers;
    }

    public void actionPerformed(ActionEvent e) {
        Object[] ids;
        Object source = e.getSource();
        if (source == this.addButton) {
            if (!ZoneCNS.DEBUG && this.zoneCNS.getZoneCapabilities().getMaxMembersInZone() == this.assetList.getModel().getSize()) {
                JOptionPane.showMessageDialog(this, Util.getString("FabricZonePanel_MaxZoneMembers"));
            } else {
                TreePath[] paths = this.assetTree.getSelectionPaths();
                for (int i = 0; i < paths.length; ++i) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                    AssetNode assetNode = (AssetNode)node.getUserObject();
                    if (this.isAsset(assetNode) && !this.assetMap.containsKey(assetNode.name) && assetNode.name != null) {
                        this.zoneAssets.add(assetNode);
                        this.assetList.setListData(this.zoneAssets);
                        this.assetMap.put(assetNode.name, assetNode);
                        continue;
                    }
                    if ((!assetNode.isSwitch() || !this.zoneCNS.getZoneCapabilities().isSupportsDomainPort()) && !assetNode.isDevice()) continue;
                    AssetNode childAssetNode = null;
                    Enumeration<TreeNode> en = node.children();
                    while (en.hasMoreElements()) {
                        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)en.nextElement();
                        childAssetNode = (AssetNode)childNode.getUserObject();
                        if (this.assetMap.containsKey(childAssetNode.name) || childAssetNode.name == null) continue;
                        this.zoneAssets.add(childAssetNode);
                        this.assetMap.put(childAssetNode.name, childAssetNode);
                    }
                    this.assetList.setListData(this.zoneAssets);
                }
            }
        } else if (source == this.delButton && (ids = this.assetList.getSelectedValues()) != null) {
            for (int i = 0; i < ids.length; ++i) {
                AssetNode id = (AssetNode)ids[i];
                this.zoneAssets.remove(id);
                if (!this.assetMap.containsKey(id.name)) continue;
                this.assetMap.remove(id.name);
            }
            this.assetList.setListData(this.zoneAssets);
        }
    }

    private boolean isAsset(AssetNode node) {
        return node.getZoneMember() != null || node.isAlias();
    }

    public String getPortMode(int mode) {
        String returnString = new String();
        switch (mode) {
            case 1: {
                returnString = Util.getString("FabricAvantiMode_Initiator");
                break;
            }
            case 2: {
                returnString = Util.getString("FabricAvantiMode_Target");
                break;
            }
            case 3: {
                returnString = Util.getString("FabricAvantiMode_Both");
            }
        }
        return returnString;
    }

    private DefaultMutableTreeNode getAssetSwitchNode(String switchName, String newSwitchName, HashMap hm) {
        DefaultMutableTreeNode switchMemNode = new DefaultMutableTreeNode();
        if (switchName == null || newSwitchName != switchName) {
            switchName = newSwitchName;
            if (!this.switchNodes.containsKey(switchName)) {
                String switchLabel = switchName;
                String domain = new String();
                try {
                    domain = (String)hm.get("DOMAIN");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                AssetNode switchMember = new AssetNode(Util.getString("FabricZonePanel_Domain") + " " + domain + " (" + Util.getString("FabricZonePanel_Switch") + switchLabel + ")");
                switchMember.setTypeToSwitch();
                switchMemNode = new DefaultMutableTreeNode(switchMember);
                this.switchNode.add(switchMemNode);
                this.switchNodes.put(switchName, switchMemNode);
            } else {
                switchMemNode = (DefaultMutableTreeNode)this.switchNodes.get(switchName);
            }
            return switchMemNode;
        }
        return switchMemNode;
    }

    private DefaultMutableTreeNode getDomainPortNode(String domainPort) {
        DefaultMutableTreeNode portMemNode;
        if (!this.domainPorts.containsKey(domainPort)) {
            AssetNode portMember = new AssetNode(Util.getString("FabricZonePanel_Port") + " " + domainPort, new ZoneMember(this.SWITCHPORT, domainPort));
            portMemNode = new DefaultMutableTreeNode(portMember);
            this.domainPorts.put(domainPort, portMemNode);
        } else {
            portMemNode = (DefaultMutableTreeNode)this.domainPorts.get(domainPort);
        }
        return portMemNode;
    }

    private DefaultMutableTreeNode getFcidPortNode(String epfcid) {
        DefaultMutableTreeNode fcidMemNode;
        if (!this.fcidPorts.containsKey(epfcid)) {
            fcidMemNode = new DefaultMutableTreeNode(new AssetNode(Util.getString("FabricZonePanel_FCID") + " " + epfcid, new ZoneMember(this.FCID, epfcid)));
            this.fcidPorts.put(epfcid, fcidMemNode);
        } else {
            fcidMemNode = (DefaultMutableTreeNode)this.fcidPorts.get(epfcid);
        }
        return fcidMemNode;
    }

    private String getFCIDHex(Integer epfcidInt) {
        String returnString = null;
        if (epfcidInt != null) {
            returnString = Integer.toHexString(epfcidInt);
            switch (returnString.length()) {
                case 0: {
                    returnString = "000000" + returnString;
                    break;
                }
                case 1: {
                    returnString = "00000" + returnString;
                    break;
                }
                case 2: {
                    returnString = "0000" + returnString;
                    break;
                }
                case 3: {
                    returnString = "000" + returnString;
                    break;
                }
                case 4: {
                    returnString = "00" + returnString;
                    break;
                }
                case 5: {
                    returnString = "0" + returnString;
                    break;
                }
            }
        }
        return returnString;
    }

    private DefaultMutableTreeNode getPortWWNNode(String epportwwn) {
        DefaultMutableTreeNode portWWNMemNode;
        if (!this.wwnPorts.containsKey(epportwwn)) {
            portWWNMemNode = new DefaultMutableTreeNode(new AssetNode(Util.getString("FabricZonePanel_PortWWN") + " " + epportwwn, new ZoneMember(this.N_PORT, epportwwn)));
            this.wwnPorts.put(epportwwn, portWWNMemNode);
        } else {
            portWWNMemNode = (DefaultMutableTreeNode)this.wwnPorts.get(epportwwn);
        }
        return portWWNMemNode;
    }

    private boolean isDomainPortZoneable(String portWWN, String switchWWN, String sanWWN, HashMap currMap) {
        boolean portState = this.getDetectable((Integer)currMap.get("PORTSTATE"));
        boolean port2switchState = this.getDetectable((Integer)currMap.get("SWITCH2PORTSTATE"));
        boolean switch2fabricState = this.getDetectable((Integer)currMap.get("FABRIC2SWITCHSTATE"));
        if (portState) {
            return port2switchState && switch2fabricState;
        }
        return true;
    }

    private boolean getDetectable(Integer state) {
        return state != null && state.equals(new Integer(1));
    }

    class AssetTreeCellRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon treeIcon;

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(this.treeIcon);
            return this;
        }
    }

    class AssetListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        AssetListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = ((ZoneMember)value).getName();
            this.setText(s);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            return this;
        }
    }

    class AssetNode {
        protected String name;
        protected int type = 0;
        protected ZoneMember zoneMember = null;
        protected ZoneAlias aliasMember = null;

        public AssetNode(String newName) {
            this.name = newName;
        }

        public AssetNode(String newName, ZoneMember newZM) {
            this.zoneMember = newZM;
            this.name = newName;
        }

        public AssetNode(String newName, ZoneAlias newAlias) {
            this.aliasMember = newAlias;
            this.setTypeToAlias();
            this.name = newName;
        }

        public boolean isDevice() {
            return this.type == 3;
        }

        public boolean isSwitch() {
            return this.type == 2;
        }

        public boolean isAlias() {
            return this.type == 1;
        }

        public boolean isZoneMember() {
            return this.type == 0;
        }

        public void setTypeToDevice() {
            this.type = 3;
        }

        public void setTypeToSwitch() {
            this.type = 2;
        }

        public void setTypeToAlias() {
            this.type = 1;
        }

        public void setTypeToZoneMember() {
            this.type = 0;
        }

        public String toString() {
            return this.name;
        }

        public ZoneMember getZoneMember() {
            return this.zoneMember;
        }

        public ZoneAlias getZoneAlias() {
            return this.aliasMember;
        }
    }
}

