/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.Wizard;
import org.eclipse.aperi.gui.WizardEvent;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.AssignZonesStep;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.gui.fabric.zone.ZoneSetNameDescriptionStep;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.eclipse.aperi.xmsg.IntlMessageFormat;

public class ZoneSetWizard
extends Wizard {
    private ZoneCNS zoneCNS;
    private AssignZonesStep assignZonesStep = null;
    private ZoneSetNameDescriptionStep nameDescStep = null;
    private int NO_BACK_WIZARD_FLAGS = 26;
    private int NO_NEXT_WIZARD_FLAGS = 29;
    private ZoneSet zs = null;
    private ZoneSet origZS = null;
    private Zone[] zonesInZS = null;
    private boolean duplicate = false;
    private boolean isActive = false;
    private boolean isOrigActive = false;
    private boolean isEditZS = false;

    public ZoneSetWizard(ZoneSet newZS, ZoneCNS cns, boolean dup, boolean edit) {
        this.zoneCNS = cns;
        if (edit) {
            this.isActive = this.zoneCNS.isZoneSetActive(newZS);
        }
        if (edit) {
            this.isOrigActive = this.zoneCNS.isOriginalActiveZoneSet(newZS);
        }
        this.zs = newZS;
        this.duplicate = dup;
        this.isEditZS = edit;
        this.origZS = newZS;
        if (this.duplicate) {
            String newZSName = IntlMessageFormat.format(FabricGuiUtil.getString("FabricZone_ZoneSetNameCopy"), new Object[]{newZS.getName()});
            this.zs = new ZoneSet(newZSName.trim());
            this.zs.setDescription(newZS.getDescription());
        }
        this.zonesInZS = this.zoneCNS.getZones(newZS);
        this.addWizardListener(this);
        this.nameDescStep = new ZoneSetNameDescriptionStep(this.NO_BACK_WIZARD_FLAGS, false, this.zs.getName(), this.zs.getDescription());
        this.add(this.nameDescStep);
        this.assignZonesStep = new AssignZonesStep(this.NO_NEXT_WIZARD_FLAGS, this.zs, this.zoneCNS, this.zonesInZS);
        this.add(this.assignZonesStep);
    }

    public ZoneSetWizard(ZoneCNS cns) {
        this.zoneCNS = cns;
        this.zs = new ZoneSet("");
        this.addWizardListener(this);
        this.nameDescStep = new ZoneSetNameDescriptionStep(this.NO_BACK_WIZARD_FLAGS, true, this.zs.getName(), this.zs.getDescription());
        this.add(this.nameDescStep);
        this.assignZonesStep = new AssignZonesStep(this.NO_NEXT_WIZARD_FLAGS, this.zs, this.zoneCNS, this.zonesInZS);
        this.add(this.assignZonesStep);
    }

    public boolean hasZoneSet(String name) {
        return this.zoneCNS.containsZoneSet(name);
    }

    public boolean isSupportsSameZoneSetAndZoneName() {
        return this.zoneCNS.getZoneCapabilities().isSupportsSameZoneSetAndZoneName();
    }

    public boolean hasZone(String name) {
        return this.zoneCNS.getZone(name) != null;
    }

    public String checkZSNameString(String name) {
        String error = null;
        if (name.indexOf(32) != -1) {
            return Util.getString("FabricZoneSetFrame_BadCharZoneSetNameErrorMsg");
        }
        if (!this.zoneCNS.getZoneCapabilities().isAllowsNumericNameStart() && this.zoneCNS.isNum(name.charAt(0))) {
            error = Util.getString("FabricZoneSetFrame_NumericalZoneSetNameErrorMsg");
            return error;
        }
        if (!this.zoneCNS.getZoneCapabilities().isSupportsSpecialCharacters() && this.zoneCNS.isUnsupportedChar(name)) {
            error = Util.getString("FabricZoneSetFrame_BadCharZoneSetNameErrorMsg");
            return error;
        }
        if (this.zoneCNS.containsZoneSet(name) && !this.isEditZS) {
            error = Util.getString("FabricZoneSetFrame_DuplicateZoneSetNameErrorMsg");
        }
        return error;
    }

    public void setZSNameDesc(String name, String desc) {
        this.zs = new ZoneSet(name);
        this.zs.setDescription(desc);
    }

    public WizardPage getCurrentStep() {
        return (WizardPage)this.getCurrentPage();
    }

    public void nextBegin(WizardEvent e) {
        e.setAllowChange(((WizardPage)e.getCurrentPage()).nextBegin());
        if ((WizardPage)e.getCurrentPage() == this.nameDescStep) {
            e.setNewPage(this.assignZonesStep);
        }
    }

    public void finished(WizardEvent e) {
        block8: {
            Vector orphanZones;
            block10: {
                ArrayList list;
                block9: {
                    super.finished(e);
                    if ((WizardPage)e.getCurrentPage() != this.assignZonesStep) break block8;
                    if (!this.duplicate || this.isEditZS) {
                        this.zoneCNS.deleteZoneSet(this.origZS);
                    }
                    if ((list = this.assignZonesStep.getSelectedList()) != null && !list.isEmpty()) break block9;
                    int result = JOptionPane.showConfirmDialog(this, Util.getString("FabricZoneSetFrame_ZoneNotAssignedWarningMsg"), Util.getString("FabricZoneSetFrame_ZoneSetConfigurationErrorTitle"), 0);
                    if (result != 0) break block10;
                    this.zoneCNS.addZoneSetConfigError(this.zs.getName());
                    this.zoneCNS.addZoneSet(this.zs);
                    if (this.isActive) {
                        this.zoneCNS.activateZoneSet(this.zs);
                    }
                    if (!this.isOrigActive) break block10;
                    this.zoneCNS.setOriginalActivatedZoneSet(this.zs);
                    break block10;
                }
                Integer maxZones = new Integer(this.zoneCNS.getZoneCapabilities().getMaxZonesInSet());
                Integer numZones = new Integer(list.size());
                if (!maxZones.equals(new Integer(-1)) && numZones > maxZones) {
                    Object[] parms = new Integer[]{numZones, maxZones};
                    String msgLabel = IntlMessageFormat.format(Util.getString("FabricZoneFrame_MaxZonesInSet"), parms);
                    JOptionPane.showMessageDialog(this, msgLabel);
                    return;
                }
                this.zoneCNS.addZoneSet(this.zs);
                if (this.isActive) {
                    this.zoneCNS.activateZoneSet(this.zs);
                }
                if (this.isOrigActive) {
                    this.zoneCNS.setOriginalActivatedZoneSet(this.zs);
                }
                this.zoneCNS.removeZoneSetConfigError(this.zs.getName());
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    Zone zone = this.zoneCNS.getZone((String)iter.next());
                    if (zone == null) continue;
                    this.zoneCNS.addZone(zone, this.zs);
                    this.zoneCNS.removeZoneConfigError(zone.getName());
                }
            }
            if (!this.zoneCNS.getZoneCapabilities().isSupportsOrphanZones() && (orphanZones = this.zoneCNS.checkForOrphanZones()) != null && orphanZones.size() > 0) {
                for (int j = 0; j < orphanZones.size(); ++j) {
                    this.zoneCNS.addZoneConfigError(((Zone)orphanZones.get(j)).getName());
                }
            }
            this.zoneCNS.refreshDefinitionPanel();
            this.closeWizard();
        }
    }

    public void canceled(WizardEvent e) {
        super.canceled(e);
        this.closeWizard();
    }

    private void closeWizard() {
        JDialog wizardDialog = (JDialog)this.getParent().getParent().getParent().getParent();
        wizardDialog.dispose();
    }
}

