/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.Wizard;
import org.eclipse.aperi.gui.WizardEvent;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.AssignZoneMembersStep;
import org.eclipse.aperi.gui.fabric.zone.AssignZoneSetsStep;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.gui.fabric.zone.ZoneNameDescriptionStep;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.eclipse.aperi.xmsg.IntlMessageFormat;

public class ZoneWizard
extends Wizard {
    private ZoneCNS zoneCNS;
    private AssignZoneSetsStep assignZoneSetsStep = null;
    private ZoneNameDescriptionStep nameDescStep = null;
    private AssignZoneMembersStep zoneMemStep = null;
    private int NO_BACK_WIZARD_FLAGS = 26;
    private int BACK_NEXT_WIZARD_FLAGS = 27;
    private int NO_NEXT_WIZARD_FLAGS = 29;
    private Zone zone = null;
    private Zone origZone = null;
    private ZoneSet[] zsInZone = null;
    private ZoneMember[] memInZone = null;
    private boolean duplicate = false;
    private boolean isEditZone = false;
    private boolean isNewZone = true;

    public ZoneWizard(Zone newZone, ZoneCNS ddi, boolean dup, boolean editZone) {
        this.zoneCNS = ddi;
        this.zone = newZone;
        this.duplicate = dup;
        this.origZone = newZone;
        this.isEditZone = editZone;
        if (this.isEditZone || this.duplicate) {
            this.isNewZone = false;
            this.memInZone = this.zoneCNS.getZoneMembers(this.origZone);
        }
        if (this.duplicate) {
            String newZoneName = IntlMessageFormat.format(FabricGuiUtil.getString("FabricZone_ZoneNameCopy"), new Object[]{newZone.getName()});
            this.zone = new Zone(newZoneName.trim());
            this.zone.setDescription(newZone.getDescription());
        }
        this.zsInZone = this.zoneCNS.getZoneSets(newZone);
        this.addWizardListener(this);
        this.nameDescStep = new ZoneNameDescriptionStep(this.NO_BACK_WIZARD_FLAGS, false, this.zone.getName(), this.zone.getDescription());
        this.add(this.nameDescStep);
        this.zoneMemStep = new AssignZoneMembersStep(this.BACK_NEXT_WIZARD_FLAGS, this.zone, this.zoneCNS, this.isNewZone, this.memInZone);
        this.add(this.zoneMemStep);
        this.assignZoneSetsStep = new AssignZoneSetsStep(this.NO_NEXT_WIZARD_FLAGS, this.zone, this.zoneCNS, this.zsInZone);
        this.add(this.assignZoneSetsStep);
    }

    public ZoneWizard(ZoneCNS cns) {
        this.zoneCNS = cns;
        this.zone = new Zone("");
        this.addWizardListener(this);
        this.nameDescStep = new ZoneNameDescriptionStep(this.NO_BACK_WIZARD_FLAGS, false, this.zone.getName(), this.zone.getDescription());
        this.add(this.nameDescStep);
        this.zoneMemStep = new AssignZoneMembersStep(this.BACK_NEXT_WIZARD_FLAGS, this.zone, cns, this.isNewZone, this.memInZone);
        this.add(this.zoneMemStep);
        this.assignZoneSetsStep = new AssignZoneSetsStep(this.NO_NEXT_WIZARD_FLAGS, this.zone, this.zoneCNS, this.zsInZone);
        this.add(this.assignZoneSetsStep);
    }

    public boolean supportsEmptyZone() {
        return this.zoneCNS.getZoneCapabilities().isSupportsEmptyZones();
    }

    public int maxZoneMembers() {
        return this.zoneCNS.getZoneCapabilities().getMaxMembersInZone();
    }

    public boolean isSupportsSameZoneSetAndZoneName() {
        return this.zoneCNS.getZoneCapabilities().isSupportsSameZoneSetAndZoneName();
    }

    public boolean hasZoneSet(String name) {
        return this.zoneCNS.containsZoneSet(name);
    }

    public boolean hasZone(String name) {
        return this.zoneCNS.getZone(name) != null;
    }

    public String checkZoneNameString(String name) {
        String error = null;
        if (name.indexOf(32) != -1) {
            return Util.getString("FabricZoneFrame_BadCharZoneNameErrorMsg");
        }
        if (!this.zoneCNS.getZoneCapabilities().isAllowsNumericNameStart() && this.zoneCNS.isNum(name.charAt(0))) {
            error = Util.getString("FabricZoneFrame_NumericalZoneNameErrorMsg");
            return error;
        }
        if (!this.zoneCNS.getZoneCapabilities().isSupportsSpecialCharacters() && this.zoneCNS.isUnsupportedChar(name)) {
            error = Util.getString("FabricZoneFrame_BadCharZoneNameErrorMsg");
            return error;
        }
        if (this.zoneCNS.containsZone(name) && !this.isEditZone) {
            error = Util.getString("FabricZoneFrame_DuplicateZoneNameErrorMsg");
        }
        return error;
    }

    public void setZoneNameDesc(String name, String desc) {
        this.zone = new Zone(name);
        this.zone.setDescription(desc);
    }

    public WizardPage getCurrentStep() {
        return (WizardPage)this.getCurrentPage();
    }

    public void nextBegin(WizardEvent e) {
        e.setAllowChange(((WizardPage)e.getCurrentPage()).nextBegin());
        if ((WizardPage)e.getCurrentPage() == this.nameDescStep) {
            e.setNewPage(this.zoneMemStep);
        } else if ((WizardPage)e.getCurrentPage() == this.zoneMemStep) {
            e.setNewPage(this.assignZoneSetsStep);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finished(WizardEvent e) {
        super.finished(e);
        if ((WizardPage)e.getCurrentPage() != this.assignZoneSetsStep) return;
        ArrayList list = this.assignZoneSetsStep.getSelectedList();
        if ((list == null || list.isEmpty()) && !this.zoneCNS.getZoneCapabilities().isSupportsOrphanZones()) {
            int result = JOptionPane.showConfirmDialog(this, Util.getString("FabricZoneSetFrame_ZoneNotAssignedWarningMsg"), Util.getString("FabricZoneFrame_ZoneConfigurationErrorTitle"), 0);
            if (result != 0) return;
            this.zoneCNS.addZoneConfigError(this.zone.getName());
            this.zoneCNS.addZone(this.zone);
        } else if (list != null && !list.isEmpty()) {
            ZoneSet[] missingZS;
            Integer maxZS = new Integer(this.zoneCNS.getZoneCapabilities().getMaxZonesInSet());
            Integer numZS = new Integer(list.size());
            if (!maxZS.equals(new Integer(-1)) && numZS > maxZS) {
                JOptionPane.showMessageDialog(this, Util.getString("FabricZonePanel_MaxZoneMembers"));
                return;
            }
            Iterator iter = list.iterator();
            ZoneSet[] zoneSets = new ZoneSet[list.size()];
            int z = 0;
            while (iter.hasNext()) {
                ZoneSet zoneSet;
                String zsName = (String)iter.next();
                zoneSets[z] = zoneSet = this.zoneCNS.getZoneSet(zsName);
                ++z;
            }
            if (this.isEditZone && (missingZS = this.zoneCNS.deleteZones(this.origZone)).length != 0) {
                for (int j = 0; j < missingZS.length; ++j) {
                    this.zoneCNS.addZoneSet(missingZS[j]);
                    this.zoneCNS.addZoneSetConfigError(missingZS[j].getName());
                }
            }
            this.zoneCNS.addZone(this.zone);
            this.zoneCNS.removeZoneConfigError(this.zone.getName());
            Iterator it = list.iterator();
            while (it.hasNext()) {
                ZoneSet zs = this.zoneCNS.getZoneSet((String)it.next());
                if (zs == null) continue;
                this.zoneCNS.addZone(this.zone, zs);
                this.zoneCNS.removeZoneSetConfigError(zs.getName());
            }
        } else {
            ZoneSet[] missingZS;
            if (this.isEditZone && (missingZS = this.zoneCNS.deleteZones(this.origZone)).length != 0) {
                for (int j = 0; j < missingZS.length; ++j) {
                    this.zoneCNS.addZoneSet(missingZS[j]);
                    this.zoneCNS.addZoneSetConfigError(missingZS[j].getName());
                }
            }
            this.zoneCNS.addZone(this.zone);
            if (!this.zoneCNS.getZoneCapabilities().isSupportsOrphanZones()) {
                this.zoneCNS.addZoneConfigError(this.zone.getName());
            }
        }
        Vector zMems = this.zoneMemStep.getZoneMembers();
        Enumeration en = zMems.elements();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            if (o instanceof ZoneMember) {
                this.zoneCNS.addZoneMember((ZoneMember)o, this.zone);
                continue;
            }
            if (!(o instanceof ZoneAlias)) continue;
            this.zoneCNS.addZoneAlias((ZoneAlias)o, this.zone);
        }
        this.zoneCNS.refreshDefinitionPanel();
        this.closeWizard();
    }

    public void canceled(WizardEvent e) {
        super.canceled(e);
        this.closeWizard();
    }

    private void closeWizard() {
        JDialog wizardDialog = (JDialog)this.getParent().getParent().getParent().getParent();
        wizardDialog.dispose();
    }
}

