/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.cartridges;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tape.cartridges.CartridgesDDI;
import org.eclipse.aperi.gui.tape.cartridges.CartridgesTableModel;
import org.eclipse.aperi.gui.tape.common.TapeGuiTable;

public class CartridgesListPanel
extends JPanel
implements TJCTableMouseInterface {
    private static final String ACTION_VIEW_DETAILS = "TAPE_VIEW_DETAILS_LABEL";
    private CartridgesDDI theDDI;
    private TapeGuiTable table = new TapeGuiTable();
    private CartridgesTableModel tableModel;
    private JPanel p = new JPanel();
    private JPanel tablePanel = new JPanel();
    private boolean dblClick = false;

    public CartridgesListPanel(CartridgesDDI ddi) {
        this.theDDI = ddi;
    }

    public JComponent getComponent() {
        this.setLayout(new BorderLayout());
        this.p.setLayout(new BorderLayout());
        this.tablePanel.setLayout(new GridBagLayout());
        this.tablePanel = GuiUtil.getPanel();
        this.tablePanel.setBorder(new TitledBorder(Util.getString("TAPE_CARTRIDGES_LABEL") + " " + this.theDDI.library.getDisplayName()));
        GridBagConstraints tgbc = new GridBagConstraints();
        tgbc.gridheight = 0;
        tgbc.insets.bottom = 0;
        tgbc.insets.top = 10;
        tgbc.gridwidth = 1;
        tgbc.anchor = 10;
        tgbc.fill = 1;
        tgbc.weighty = 1.0;
        tgbc.weightx = 0.5;
        tgbc.insets = new Insets(3, 3, 3, 3);
        this.buildtable();
        this.table.setMouseListener(this);
        this.tablePanel.add((Component)this.table, tgbc);
        this.add((Component)this.p, "Center");
        this.p.add((Component)this.tablePanel, "Center");
        return this;
    }

    public boolean select(int viewRow, int viewCol) {
        boolean selectIt = true;
        if (this.dblClick) {
            this.dblClick = false;
            selectIt = false;
        }
        return selectIt;
    }

    public void showPopup(int dataRow, int dataCol, Component c, int x, int y) {
        if (dataRow < 0 || dataCol < 0) {
            return;
        }
        int selectedRow = this.table.getPointedRow(y);
        this.table.setSelectedRows(selectedRow, selectedRow);
        this.selectionChanged(true);
    }

    public void selectionChanged(boolean state) {
    }

    public void selectionChangedBlockedSize(boolean state) {
    }

    public void doubleClick(int dataRow, int dataCol) {
    }

    public void showDefaultChart(int dataRow) {
    }

    public void buildtable() {
        this.tableModel = new CartridgesTableModel(this.theDDI);
        this.table.setCellRenderer(Double.class, TableCellRenderers.number);
        this.table.setFrozenColumns(1);
        this.table.setBaseTableModel(this.tableModel);
        this.table.sortByColumn(0, 1);
        this.table.setSelectionPolicy(0);
        this.table.updateUI();
    }
}

