/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphDisk;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphLun;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool2Disk;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Disk;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphZone;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric2Zone;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric2ZoneSet;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneSet;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneSet2Zone;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class GraphGroupingUtilities {
    public static final Integer GROUPBY_ALL = new Integer(0);
    public static final Integer GROUPBY_HEALTH = new Integer(2);
    public static final Integer GROUPBY_UDP1 = new Integer(4);
    public static final Integer GROUPBY_UDP2 = new Integer(8);
    public static final Integer GROUPBY_UDP3 = new Integer(16);
    public static final Integer GROUPBY_COMPUTERBYOS = new Integer(32);
    public static final Integer GROUPBY_SWBYFABRIC = new Integer(64);
    public static final Integer GROUPBY_SUBSYSTEMBYMODEL = new Integer(128);
    public static final Integer GROUPBY_DISKBYPOOL = new Integer(256);
    public static final Integer GROUPBY_DISKBYSUBSYSTEM = new Integer(512);
    public static final Integer GROUPBY_POOLBYRAID = new Integer(1024);
    public static final Integer GROUPBY_VOLUMEBYPOOL = new Integer(2048);
    public static final Integer GROUPBY_VOLUMEBYSUBSYSTEM = new Integer(4096);
    public static final Integer GROUPBY_LUNBYDEVICE = new Integer(8192);
    protected static final Hashtable groupByH = new Hashtable();

    public static Hashtable applyGrouping(Vector entityV, Integer groupByBitmap, GraphModel dataModel) {
        IGroupingMethod groupBy;
        Hashtable groupH = new Hashtable();
        GraphGroupKey key = new GraphGroupKey();
        groupH.put(key, entityV);
        int bitmap = groupByBitmap;
        if (bitmap == 0) {
            IGroupingMethod groupBy2 = (IGroupingMethod)groupByH.get(GROUPBY_ALL);
            groupH = groupBy2.applyGrouping(groupH, dataModel);
            return groupH;
        }
        if ((bitmap & GROUPBY_HEALTH) != 0) {
            groupBy = (IGroupingMethod)groupByH.get(GROUPBY_HEALTH);
            groupH = groupBy.applyGrouping(groupH, dataModel);
        }
        if ((bitmap & GROUPBY_UDP1) != 0) {
            groupBy = (IGroupingMethod)groupByH.get(GROUPBY_UDP1);
            groupH = groupBy.applyGrouping(groupH, dataModel);
        }
        if ((bitmap & GROUPBY_UDP2) != 0) {
            groupBy = (IGroupingMethod)groupByH.get(GROUPBY_UDP2);
            groupH = groupBy.applyGrouping(groupH, dataModel);
        }
        if ((bitmap & GROUPBY_UDP3) != 0) {
            groupBy = (IGroupingMethod)groupByH.get(GROUPBY_UDP3);
            groupH = groupBy.applyGrouping(groupH, dataModel);
        }
        if ((bitmap & GROUPBY_COMPUTERBYOS) != 0) {
            groupBy = (IGroupingMethod)groupByH.get(GROUPBY_COMPUTERBYOS);
            groupH = groupBy.applyGrouping(groupH, dataModel);
        }
        if ((bitmap & GROUPBY_SWBYFABRIC) != 0) {
            groupBy = (IGroupingMethod)groupByH.get(GROUPBY_SWBYFABRIC);
            groupH = groupBy.applyGrouping(groupH, dataModel);
        }
        if ((bitmap & GROUPBY_SUBSYSTEMBYMODEL) != 0) {
            groupBy = (IGroupingMethod)groupByH.get(GROUPBY_SUBSYSTEMBYMODEL);
            groupH = groupBy.applyGrouping(groupH, dataModel);
        }
        if ((bitmap & GROUPBY_DISKBYPOOL) != 0) {
            groupBy = (IGroupingMethod)groupByH.get(GROUPBY_DISKBYPOOL);
            groupH = groupBy.applyGrouping(groupH, dataModel);
        }
        if ((bitmap & GROUPBY_DISKBYSUBSYSTEM) != 0) {
            groupBy = (IGroupingMethod)groupByH.get(GROUPBY_DISKBYSUBSYSTEM);
            groupH = groupBy.applyGrouping(groupH, dataModel);
        }
        if ((bitmap & GROUPBY_POOLBYRAID) != 0) {
            groupBy = (IGroupingMethod)groupByH.get(GROUPBY_POOLBYRAID);
            groupH = groupBy.applyGrouping(groupH, dataModel);
        }
        if ((bitmap & GROUPBY_VOLUMEBYPOOL) != 0) {
            groupBy = (IGroupingMethod)groupByH.get(GROUPBY_VOLUMEBYPOOL);
            groupH = groupBy.applyGrouping(groupH, dataModel);
        }
        if ((bitmap & GROUPBY_VOLUMEBYSUBSYSTEM) != 0) {
            groupBy = (IGroupingMethod)groupByH.get(GROUPBY_VOLUMEBYSUBSYSTEM);
            groupH = groupBy.applyGrouping(groupH, dataModel);
        }
        if ((bitmap & GROUPBY_LUNBYDEVICE) != 0) {
            groupBy = (IGroupingMethod)groupByH.get(GROUPBY_LUNBYDEVICE);
            groupH = groupBy.applyGrouping(groupH, dataModel);
        }
        return groupH;
    }

    protected static void groupOrphanZone(GraphModel model) {
        GraphZoneSet zset = null;
        GraphEntity.ID zsetID = null;
        Enumeration zoneIDEnu = model.enumerateID(GraphZone.TYPE);
        while (zoneIDEnu.hasMoreElements()) {
            GraphZone.ID zoneID = (GraphZone.ID)zoneIDEnu.nextElement();
            Enumeration zsetIDEnu = model.associatorID(GraphZoneSet2Zone.TYPE, zoneID);
            if (zsetIDEnu.hasMoreElements()) continue;
            if (zset == null) {
                zset = new GraphZoneSet("Orphan");
                zsetID = (GraphZoneSet.ID)zset.getEntityID();
                zset.setDisplayName(GuiUtil.getString("TOPO_LABEL_ENTITY_ORPHANZONES"));
                zset.setActive(Boolean.FALSE);
                zset.addScope("Orphan");
                model.put(zset);
                Enumeration zfabricIDEnu = model.associatorID(GraphZoneFabric2Zone.TYPE, zoneID);
                while (zfabricIDEnu.hasMoreElements()) {
                    GraphZoneFabric.ID zfabricID = (GraphZoneFabric.ID)zfabricIDEnu.nextElement();
                    GraphZoneFabric2ZoneSet zfabric2zset = new GraphZoneFabric2ZoneSet(zfabricID.getID() + "+" + zsetID.getID());
                    zfabric2zset.setZoneFabricID(zfabricID);
                    zfabric2zset.setZoneSetID((GraphZoneSet.ID)zsetID);
                    model.put(zfabric2zset);
                }
            }
            GraphZoneSet2Zone zset2zone = new GraphZoneSet2Zone(zsetID.getID() + "+" + zoneID.getID());
            zset2zone.setZoneSetID((GraphZoneSet.ID)zsetID);
            zset2zone.setZoneID(zoneID);
            model.put(zset2zone);
        }
    }

    static {
        groupByH.put(GROUPBY_ALL, new GroupingMethod_All());
        groupByH.put(GROUPBY_HEALTH, new GroupingMethod_Health());
        groupByH.put(GROUPBY_UDP1, new GroupingMethod_UDP1());
        groupByH.put(GROUPBY_UDP2, new GroupingMethod_UDP2());
        groupByH.put(GROUPBY_UDP3, new GroupingMethod_UDP3());
        groupByH.put(GROUPBY_COMPUTERBYOS, new GroupingMethod_ComputerByOS());
        groupByH.put(GROUPBY_SWBYFABRIC, new GroupingMethod_SwitchByFabric());
        groupByH.put(GROUPBY_SUBSYSTEMBYMODEL, new GroupingMethod_SubsystemByModel());
        groupByH.put(GROUPBY_DISKBYPOOL, new GroupingMethod_DiskByPool());
        groupByH.put(GROUPBY_DISKBYSUBSYSTEM, new GroupingMethod_DiskBySubsystem());
        groupByH.put(GROUPBY_POOLBYRAID, new GroupingMethod_PoolByRAID());
        groupByH.put(GROUPBY_VOLUMEBYPOOL, new GroupingMethod_VolumeByPool());
        groupByH.put(GROUPBY_VOLUMEBYSUBSYSTEM, new GroupingMethod_VolumeBySubsystem());
        groupByH.put(GROUPBY_LUNBYDEVICE, new GroupingMethod_LunByDevice());
    }

    protected static class GroupingMethod_LunByDevice
    implements IGroupingMethod {
        protected GroupingMethod_LunByDevice() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYDEVICE");
        }

        public Hashtable applyGrouping(Hashtable groupH, GraphModel dataModel) {
            Hashtable newGroupH = new Hashtable();
            Enumeration enu = groupH.keys();
            while (enu.hasMoreElements()) {
                GraphGroupKey key = (GraphGroupKey)enu.nextElement();
                Vector entityV = (Vector)groupH.get(key);
                Hashtable<GraphLun.ID, GraphLun> lunH = new Hashtable<GraphLun.ID, GraphLun>();
                for (int i = 0; i < entityV.size(); ++i) {
                    GraphLun entity = (GraphLun)entityV.elementAt(i);
                    GraphLun.ID entityID = (GraphLun.ID)entity.getEntityID();
                    lunH.put(entityID, entity);
                }
                Hashtable computerH = new Hashtable();
                Hashtable otherH = new Hashtable();
                Enumeration enu2 = dataModel.enumerate(GraphComputer2Lun.TYPE);
                while (enu2.hasMoreElements()) {
                    String value;
                    GraphComputer2Lun computer2lun = (GraphComputer2Lun)enu2.nextElement();
                    GraphLun.ID lunID = computer2lun.getLunID();
                    GraphLun entity = (GraphLun)lunH.remove(lunID);
                    if (entity == null) continue;
                    GraphComputer.ID computerID = computer2lun.getComputerID();
                    GraphComputer computer = (GraphComputer)computerH.get(computerID);
                    if (computer == null) {
                        computer = (GraphComputer)dataModel.get(computerID);
                    }
                    if ((value = computer.getDisplayName()) == null) {
                        value = computerID.toString();
                    }
                    GraphGroupKey newKey = new GraphGroupKey(key);
                    GraphGroupKey.Key k = new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value), value.toString());
                    k.setJumping(computer, TopoResource.ICON_COMPUTER_16_SELECTED, TopoResource.ICON_COMPUTER_16_UNSELECTED);
                    newKey.addKey(k);
                    Vector<GraphLun> v = (Vector<GraphLun>)newGroupH.get(newKey);
                    if (v == null) {
                        v = new Vector<GraphLun>();
                        newGroupH.put(newKey, v);
                    }
                    v.add(entity);
                }
                Enumeration enu4 = dataModel.enumerate(GraphOther2Lun.TYPE);
                while (enu4.hasMoreElements()) {
                    String value;
                    GraphOther2Lun other2lun = (GraphOther2Lun)enu4.nextElement();
                    GraphLun.ID lunID = other2lun.getLunID();
                    GraphLun entity = (GraphLun)lunH.remove(lunID);
                    if (entity == null) continue;
                    GraphOther.ID otherID = other2lun.getOtherID();
                    GraphOther other = (GraphOther)otherH.get(otherID);
                    if (other == null) {
                        other = (GraphOther)dataModel.get(otherID);
                    }
                    if ((value = other.getDisplayName()) == null) {
                        value = otherID.toString();
                    }
                    GraphGroupKey newKey = new GraphGroupKey(key);
                    GraphGroupKey.Key k = new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value), value.toString());
                    k.setJumping(other, TopoResource.ICON_OTHER_16_SELECTED, TopoResource.ICON_OTHER_16_UNSELECTED);
                    newKey.addKey(k);
                    Vector<GraphLun> v = (Vector<GraphLun>)newGroupH.get(newKey);
                    if (v == null) {
                        v = new Vector<GraphLun>();
                        newGroupH.put(newKey, v);
                    }
                    v.add(entity);
                }
                GraphGroupKey newKey = new GraphGroupKey(key);
                String value = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                newKey.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value)));
                Vector<GraphLun> v = new Vector<GraphLun>();
                Enumeration enu3 = lunH.elements();
                while (enu3.hasMoreElements()) {
                    GraphLun entity = (GraphLun)enu3.nextElement();
                    v.add(entity);
                }
                if (v.size() <= 0) continue;
                newGroupH.put(newKey, v);
            }
            return newGroupH;
        }
    }

    protected static class GroupingMethod_VolumeByPool
    implements IGroupingMethod {
        protected GroupingMethod_VolumeByPool() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYPOOL");
        }

        public Hashtable applyGrouping(Hashtable groupH, GraphModel dataModel) {
            Hashtable newGroupH = new Hashtable();
            Enumeration enu = groupH.keys();
            while (enu.hasMoreElements()) {
                GraphGroupKey key = (GraphGroupKey)enu.nextElement();
                Vector entityV = (Vector)groupH.get(key);
                Hashtable<GraphVolume.ID, GraphVolume> volumeH = new Hashtable<GraphVolume.ID, GraphVolume>();
                for (int i = 0; i < entityV.size(); ++i) {
                    GraphVolume entity = (GraphVolume)entityV.elementAt(i);
                    GraphVolume.ID entityID = (GraphVolume.ID)entity.getEntityID();
                    volumeH.put(entityID, entity);
                }
                Hashtable poolH = new Hashtable();
                Enumeration enu2 = dataModel.enumerate(GraphPool2Volume.TYPE);
                while (enu2.hasMoreElements()) {
                    String value;
                    GraphPool2Volume pool2volume = (GraphPool2Volume)enu2.nextElement();
                    GraphVolume.ID volumeID = pool2volume.getVolumeID();
                    GraphVolume entity = (GraphVolume)volumeH.remove(volumeID);
                    if (entity == null) continue;
                    GraphPool.ID poolID = pool2volume.getPoolID();
                    GraphPool pool = (GraphPool)poolH.get(poolID);
                    if (pool == null) {
                        pool = (GraphPool)dataModel.get(poolID);
                    }
                    if ((value = pool.getDisplayName()) == null) {
                        value = poolID.toString();
                    }
                    GraphGroupKey newKey = new GraphGroupKey(key);
                    newKey.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value)));
                    Vector<GraphVolume> v = (Vector<GraphVolume>)newGroupH.get(newKey);
                    if (v == null) {
                        v = new Vector<GraphVolume>();
                        newGroupH.put(newKey, v);
                    }
                    v.add(entity);
                }
                GraphGroupKey newKey = new GraphGroupKey(key);
                String value = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                newKey.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value)));
                Vector<GraphVolume> v = new Vector<GraphVolume>();
                Enumeration enu3 = volumeH.elements();
                while (enu3.hasMoreElements()) {
                    GraphVolume entity = (GraphVolume)enu3.nextElement();
                    v.add(entity);
                }
                if (v.size() <= 0) continue;
                newGroupH.put(newKey, v);
            }
            return newGroupH;
        }
    }

    protected static class GroupingMethod_VolumeBySubsystem
    implements IGroupingMethod {
        protected GroupingMethod_VolumeBySubsystem() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYSUBSYSTEM");
        }

        public Hashtable applyGrouping(Hashtable groupH, GraphModel dataModel) {
            Hashtable newGroupH = new Hashtable();
            Enumeration enu = groupH.keys();
            while (enu.hasMoreElements()) {
                GraphGroupKey key = (GraphGroupKey)enu.nextElement();
                Vector entityV = (Vector)groupH.get(key);
                Hashtable<GraphVolume.ID, GraphVolume> volumeH = new Hashtable<GraphVolume.ID, GraphVolume>();
                for (int i = 0; i < entityV.size(); ++i) {
                    GraphVolume entity = (GraphVolume)entityV.elementAt(i);
                    GraphVolume.ID entityID = (GraphVolume.ID)entity.getEntityID();
                    volumeH.put(entityID, entity);
                }
                Hashtable subsystemH = new Hashtable();
                Enumeration enu2 = dataModel.enumerate(GraphSubsystem2Volume.TYPE);
                while (enu2.hasMoreElements()) {
                    String value;
                    GraphSubsystem2Volume subsystem2volume = (GraphSubsystem2Volume)enu2.nextElement();
                    GraphVolume.ID volumeID = subsystem2volume.getVolumeID();
                    GraphVolume entity = (GraphVolume)volumeH.remove(volumeID);
                    if (entity == null) continue;
                    GraphSubsystem.ID subsystemID = subsystem2volume.getSubsystemID();
                    GraphSubsystem subsystem = (GraphSubsystem)subsystemH.get(subsystemID);
                    if (subsystem == null) {
                        subsystem = (GraphSubsystem)dataModel.get(subsystemID);
                    }
                    if ((value = subsystem.getDisplayName()) == null) {
                        value = subsystemID.toString();
                    }
                    GraphGroupKey newKey = new GraphGroupKey(key);
                    GraphGroupKey.Key k = new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value), value.toString());
                    if (Boolean.TRUE.equals(subsystem.getIsSVC())) {
                        k.setJumping(subsystem, TopoResource.ICON_SVC_16_SELECTED, TopoResource.ICON_SVC_16_UNSELECTED);
                    } else {
                        k.setJumping(subsystem, TopoResource.ICON_SUBSYSTEM_16_SELECTED, TopoResource.ICON_SUBSYSTEM_16_UNSELECTED);
                    }
                    newKey.addKey(k);
                    Vector<GraphVolume> v = (Vector<GraphVolume>)newGroupH.get(newKey);
                    if (v == null) {
                        v = new Vector<GraphVolume>();
                        newGroupH.put(newKey, v);
                    }
                    v.add(entity);
                }
                GraphGroupKey newKey = new GraphGroupKey(key);
                String value = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                newKey.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value)));
                Vector<GraphVolume> v = new Vector<GraphVolume>();
                Enumeration enu3 = volumeH.elements();
                while (enu3.hasMoreElements()) {
                    GraphVolume entity = (GraphVolume)enu3.nextElement();
                    v.add(entity);
                }
                if (v.size() <= 0) continue;
                newGroupH.put(newKey, v);
            }
            return newGroupH;
        }
    }

    protected static class GroupingMethod_PoolByRAID
    implements IGroupingMethod {
        protected GroupingMethod_PoolByRAID() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYRAID");
        }

        public Hashtable applyGrouping(Hashtable groupH, GraphModel dataModel) {
            Hashtable<GraphGroupKey, Vector<GraphPool>> newGroupH = new Hashtable<GraphGroupKey, Vector<GraphPool>>();
            Enumeration enu = groupH.keys();
            while (enu.hasMoreElements()) {
                GraphGroupKey key = (GraphGroupKey)enu.nextElement();
                Vector entityV = (Vector)groupH.get(key);
                for (int i = 0; i < entityV.size(); ++i) {
                    GraphPool entity = (GraphPool)entityV.elementAt(i);
                    String value = entity.getRAIDLevel();
                    if (value == null) {
                        value = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                    }
                    GraphGroupKey newKey = new GraphGroupKey(key);
                    newKey.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value)));
                    Vector<GraphPool> v = (Vector<GraphPool>)newGroupH.get(newKey);
                    if (v == null) {
                        v = new Vector<GraphPool>();
                        newGroupH.put(newKey, v);
                    }
                    v.add(entity);
                }
            }
            return newGroupH;
        }
    }

    protected static class GroupingMethod_DiskByPool
    implements IGroupingMethod {
        protected GroupingMethod_DiskByPool() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYPOOL");
        }

        public Hashtable applyGrouping(Hashtable groupH, GraphModel dataModel) {
            Hashtable newGroupH = new Hashtable();
            Enumeration enu = groupH.keys();
            while (enu.hasMoreElements()) {
                GraphGroupKey key = (GraphGroupKey)enu.nextElement();
                Vector entityV = (Vector)groupH.get(key);
                Hashtable<GraphDisk.ID, GraphDisk> diskH = new Hashtable<GraphDisk.ID, GraphDisk>();
                for (int i = 0; i < entityV.size(); ++i) {
                    GraphDisk entity = (GraphDisk)entityV.elementAt(i);
                    GraphDisk.ID entityID = (GraphDisk.ID)entity.getEntityID();
                    diskH.put(entityID, entity);
                }
                Hashtable poolH = new Hashtable();
                Enumeration enu2 = dataModel.enumerate(GraphPool2Disk.TYPE);
                while (enu2.hasMoreElements()) {
                    String value;
                    GraphPool2Disk pool2disk = (GraphPool2Disk)enu2.nextElement();
                    GraphDisk.ID diskID = pool2disk.getDiskID();
                    GraphDisk entity = (GraphDisk)diskH.remove(diskID);
                    if (entity == null) continue;
                    GraphPool.ID poolID = pool2disk.getPoolID();
                    GraphPool pool = (GraphPool)poolH.get(poolID);
                    if (pool == null) {
                        pool = (GraphPool)dataModel.get(poolID);
                    }
                    if ((value = pool.getDisplayName()) == null) {
                        value = poolID.toString();
                    }
                    GraphGroupKey newKey = new GraphGroupKey(key);
                    newKey.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value)));
                    Vector<GraphDisk> v = (Vector<GraphDisk>)newGroupH.get(newKey);
                    if (v == null) {
                        v = new Vector<GraphDisk>();
                        newGroupH.put(newKey, v);
                    }
                    v.add(entity);
                }
                GraphGroupKey newKey = new GraphGroupKey(key);
                String value = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                newKey.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value)));
                Vector<GraphDisk> v = new Vector<GraphDisk>();
                Enumeration enu3 = diskH.elements();
                while (enu3.hasMoreElements()) {
                    GraphDisk entity = (GraphDisk)enu3.nextElement();
                    v.add(entity);
                }
                if (v.size() <= 0) continue;
                newGroupH.put(newKey, v);
            }
            return newGroupH;
        }
    }

    protected static class GroupingMethod_DiskBySubsystem
    implements IGroupingMethod {
        protected GroupingMethod_DiskBySubsystem() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYSUBSYSTEM");
        }

        public Hashtable applyGrouping(Hashtable groupH, GraphModel dataModel) {
            Hashtable newGroupH = new Hashtable();
            Enumeration enu = groupH.keys();
            while (enu.hasMoreElements()) {
                GraphGroupKey key = (GraphGroupKey)enu.nextElement();
                Vector entityV = (Vector)groupH.get(key);
                Hashtable<GraphDisk.ID, GraphDisk> diskH = new Hashtable<GraphDisk.ID, GraphDisk>();
                for (int i = 0; i < entityV.size(); ++i) {
                    GraphDisk entity = (GraphDisk)entityV.elementAt(i);
                    GraphDisk.ID entityID = (GraphDisk.ID)entity.getEntityID();
                    diskH.put(entityID, entity);
                }
                Hashtable subsystemH = new Hashtable();
                Enumeration enu2 = dataModel.enumerate(GraphSubsystem2Disk.TYPE);
                while (enu2.hasMoreElements()) {
                    String value;
                    GraphSubsystem2Disk subsystem2disk = (GraphSubsystem2Disk)enu2.nextElement();
                    GraphDisk.ID diskID = subsystem2disk.getDiskID();
                    GraphDisk entity = (GraphDisk)diskH.remove(diskID);
                    if (entity == null) continue;
                    GraphSubsystem.ID subsystemID = subsystem2disk.getSubsystemID();
                    GraphSubsystem subsystem = (GraphSubsystem)subsystemH.get(subsystemID);
                    if (subsystem == null) {
                        subsystem = (GraphSubsystem)dataModel.get(subsystemID);
                    }
                    if ((value = subsystem.getDisplayName()) == null) {
                        value = subsystemID.toString();
                    }
                    GraphGroupKey newKey = new GraphGroupKey(key);
                    GraphGroupKey.Key k = new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value), value.toString());
                    if (Boolean.TRUE.equals(subsystem.getIsSVC())) {
                        k.setJumping(subsystem, TopoResource.ICON_SVC_16_SELECTED, TopoResource.ICON_SVC_16_UNSELECTED);
                    } else {
                        k.setJumping(subsystem, TopoResource.ICON_SUBSYSTEM_16_SELECTED, TopoResource.ICON_SUBSYSTEM_16_UNSELECTED);
                    }
                    newKey.addKey(k);
                    Vector<GraphDisk> v = (Vector<GraphDisk>)newGroupH.get(newKey);
                    if (v == null) {
                        v = new Vector<GraphDisk>();
                        newGroupH.put(newKey, v);
                    }
                    v.add(entity);
                }
                GraphGroupKey newKey = new GraphGroupKey(key);
                String value = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                newKey.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value)));
                Vector<GraphDisk> v = new Vector<GraphDisk>();
                Enumeration enu3 = diskH.elements();
                while (enu3.hasMoreElements()) {
                    GraphDisk entity = (GraphDisk)enu3.nextElement();
                    v.add(entity);
                }
                if (v.size() <= 0) continue;
                newGroupH.put(newKey, v);
            }
            return newGroupH;
        }
    }

    protected static class GroupingMethod_SubsystemByModel
    implements IGroupingMethod {
        protected GroupingMethod_SubsystemByModel() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYMODEL");
        }

        public Hashtable applyGrouping(Hashtable groupH, GraphModel dataModel) {
            Hashtable<GraphGroupKey, Vector<GraphSubsystem>> newGroupH = new Hashtable<GraphGroupKey, Vector<GraphSubsystem>>();
            Enumeration enu = groupH.keys();
            while (enu.hasMoreElements()) {
                GraphGroupKey key = (GraphGroupKey)enu.nextElement();
                Vector entityV = (Vector)groupH.get(key);
                for (int i = 0; i < entityV.size(); ++i) {
                    GraphSubsystem entity = (GraphSubsystem)entityV.elementAt(i);
                    String value = entity.getModel();
                    if (value == null) {
                        value = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                    }
                    GraphGroupKey newKey = new GraphGroupKey(key);
                    newKey.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value)));
                    Vector<GraphSubsystem> v = (Vector<GraphSubsystem>)newGroupH.get(newKey);
                    if (v == null) {
                        v = new Vector<GraphSubsystem>();
                        newGroupH.put(newKey, v);
                    }
                    v.add(entity);
                }
            }
            return newGroupH;
        }
    }

    protected static class GroupingMethod_SwitchByFabric
    implements IGroupingMethod {
        protected GroupingMethod_SwitchByFabric() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYFABRIC");
        }

        public Hashtable applyGrouping(Hashtable groupH, GraphModel dataModel) {
            Hashtable newGroupH = new Hashtable();
            Enumeration enu = groupH.keys();
            while (enu.hasMoreElements()) {
                GraphGroupKey key = (GraphGroupKey)enu.nextElement();
                Vector entityV = (Vector)groupH.get(key);
                Hashtable<GraphSwitch.ID, GraphSwitch> swH = new Hashtable<GraphSwitch.ID, GraphSwitch>();
                for (int i = 0; i < entityV.size(); ++i) {
                    GraphSwitch entity = (GraphSwitch)entityV.elementAt(i);
                    GraphSwitch.ID entityID = (GraphSwitch.ID)entity.getEntityID();
                    swH.put(entityID, entity);
                }
                Hashtable fabricH = new Hashtable();
                Enumeration enu2 = dataModel.enumerate(GraphFabric2Switch.TYPE);
                while (enu2.hasMoreElements()) {
                    String value;
                    GraphFabric2Switch fabric2sw = (GraphFabric2Switch)enu2.nextElement();
                    GraphSwitch.ID swID = fabric2sw.getSwitchID();
                    GraphSwitch entity = (GraphSwitch)swH.remove(swID);
                    if (entity == null) continue;
                    GraphFabric.ID fabricID = fabric2sw.getFabricID();
                    GraphFabric fabric = (GraphFabric)fabricH.get(fabricID);
                    if (fabric == null) {
                        fabric = (GraphFabric)dataModel.get(fabricID);
                    }
                    if ((value = fabric.getDisplayName()) == null) {
                        value = fabricID.toString();
                    }
                    GraphGroupKey newKey = new GraphGroupKey(key);
                    GraphGroupKey.Key k = new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value), value.toString());
                    k.setJumping(fabric, TopoResource.ICON_FABRIC_16_SELECTED, TopoResource.ICON_FABRIC_16_UNSELECTED);
                    newKey.addKey(k);
                    Vector<GraphSwitch> v = (Vector<GraphSwitch>)newGroupH.get(newKey);
                    if (v == null) {
                        v = new Vector<GraphSwitch>();
                        newGroupH.put(newKey, v);
                    }
                    v.add(entity);
                }
                GraphGroupKey newKey = new GraphGroupKey(key);
                String value = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                newKey.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value)));
                Vector<GraphSwitch> v = new Vector<GraphSwitch>();
                Enumeration enu3 = swH.elements();
                while (enu3.hasMoreElements()) {
                    GraphSwitch entity = (GraphSwitch)enu3.nextElement();
                    v.add(entity);
                }
                if (v.size() <= 0) continue;
                newGroupH.put(newKey, v);
            }
            return newGroupH;
        }
    }

    protected static class GroupingMethod_ComputerByOS
    implements IGroupingMethod {
        protected GroupingMethod_ComputerByOS() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYOS");
        }

        public Hashtable applyGrouping(Hashtable groupH, GraphModel dataModel) {
            Hashtable<GraphGroupKey, Vector<GraphComputer>> newGroupH = new Hashtable<GraphGroupKey, Vector<GraphComputer>>();
            Enumeration enu = groupH.keys();
            while (enu.hasMoreElements()) {
                GraphGroupKey key = (GraphGroupKey)enu.nextElement();
                Vector entityV = (Vector)groupH.get(key);
                for (int i = 0; i < entityV.size(); ++i) {
                    GraphComputer entity = (GraphComputer)entityV.elementAt(i);
                    String value = entity.getOSType();
                    if (value == null) {
                        value = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                    }
                    GraphGroupKey newKey = new GraphGroupKey(key);
                    newKey.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value)));
                    Vector<GraphComputer> v = (Vector<GraphComputer>)newGroupH.get(newKey);
                    if (v == null) {
                        v = new Vector<GraphComputer>();
                        newGroupH.put(newKey, v);
                    }
                    v.add(entity);
                }
            }
            return newGroupH;
        }
    }

    protected static class GroupingMethod_UDP3
    implements IGroupingMethod {
        protected GroupingMethod_UDP3() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYUDP3");
        }

        public Hashtable applyGrouping(Hashtable groupH, GraphModel dataModel) {
            Hashtable<GraphGroupKey, Vector<GraphEntity>> newGroupH = new Hashtable<GraphGroupKey, Vector<GraphEntity>>();
            Enumeration enu = groupH.keys();
            while (enu.hasMoreElements()) {
                GraphGroupKey key = (GraphGroupKey)enu.nextElement();
                Vector entityV = (Vector)groupH.get(key);
                for (int i = 0; i < entityV.size(); ++i) {
                    GraphEntity entity = (GraphEntity)entityV.elementAt(i);
                    String value = entity.getUDP3();
                    if (value == null) {
                        value = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                    }
                    GraphGroupKey newKey = new GraphGroupKey(key);
                    newKey.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value)));
                    Vector<GraphEntity> v = (Vector<GraphEntity>)newGroupH.get(newKey);
                    if (v == null) {
                        v = new Vector<GraphEntity>();
                        newGroupH.put(newKey, v);
                    }
                    v.add(entity);
                }
            }
            return newGroupH;
        }
    }

    protected static class GroupingMethod_UDP2
    implements IGroupingMethod {
        protected GroupingMethod_UDP2() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYUDP2");
        }

        public Hashtable applyGrouping(Hashtable groupH, GraphModel dataModel) {
            Hashtable<GraphGroupKey, Vector<GraphEntity>> newGroupH = new Hashtable<GraphGroupKey, Vector<GraphEntity>>();
            Enumeration enu = groupH.keys();
            while (enu.hasMoreElements()) {
                GraphGroupKey key = (GraphGroupKey)enu.nextElement();
                Vector entityV = (Vector)groupH.get(key);
                for (int i = 0; i < entityV.size(); ++i) {
                    GraphEntity entity = (GraphEntity)entityV.elementAt(i);
                    String value = entity.getUDP2();
                    if (value == null) {
                        value = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                    }
                    GraphGroupKey newKey = new GraphGroupKey(key);
                    newKey.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value)));
                    Vector<GraphEntity> v = (Vector<GraphEntity>)newGroupH.get(newKey);
                    if (v == null) {
                        v = new Vector<GraphEntity>();
                        newGroupH.put(newKey, v);
                    }
                    v.add(entity);
                }
            }
            return newGroupH;
        }
    }

    protected static class GroupingMethod_UDP1
    implements IGroupingMethod {
        protected GroupingMethod_UDP1() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYUDP1");
        }

        public Hashtable applyGrouping(Hashtable groupH, GraphModel dataModel) {
            Hashtable<GraphGroupKey, Vector<GraphEntity>> newGroupH = new Hashtable<GraphGroupKey, Vector<GraphEntity>>();
            Enumeration enu = groupH.keys();
            while (enu.hasMoreElements()) {
                GraphGroupKey key = (GraphGroupKey)enu.nextElement();
                Vector entityV = (Vector)groupH.get(key);
                for (int i = 0; i < entityV.size(); ++i) {
                    GraphEntity entity = (GraphEntity)entityV.elementAt(i);
                    String value = entity.getUDP1();
                    if (value == null) {
                        value = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
                    }
                    GraphGroupKey newKey = new GraphGroupKey(key);
                    newKey.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value)));
                    Vector<GraphEntity> v = (Vector<GraphEntity>)newGroupH.get(newKey);
                    if (v == null) {
                        v = new Vector<GraphEntity>();
                        newGroupH.put(newKey, v);
                    }
                    v.add(entity);
                }
            }
            return newGroupH;
        }
    }

    protected static class GroupingMethod_Health
    implements IGroupingMethod {
        protected GroupingMethod_Health() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYHEALTH");
        }

        public Hashtable applyGrouping(Hashtable groupH, GraphModel dataModel) {
            Hashtable<GraphGroupKey, Vector<GraphEntity>> newGroupH = new Hashtable<GraphGroupKey, Vector<GraphEntity>>();
            Enumeration enu = groupH.keys();
            while (enu.hasMoreElements()) {
                GraphGroupKey key = (GraphGroupKey)enu.nextElement();
                Vector entityV = (Vector)groupH.get(key);
                for (int i = 0; i < entityV.size(); ++i) {
                    GraphEntity entity = (GraphEntity)entityV.elementAt(i);
                    Integer value = entity.getHealthStatus();
                    if (value == null) {
                        value = GraphModelConstant.STATUS_NA;
                    }
                    String valueAlias = GraphModelUtilities.getStatusAlias(value);
                    GraphGroupKey newKey = new GraphGroupKey(key);
                    newKey.addKey(new GraphGroupKey.Key(this.getMethodName(), value, valueAlias));
                    Vector<GraphEntity> v = (Vector<GraphEntity>)newGroupH.get(newKey);
                    if (v == null) {
                        v = new Vector<GraphEntity>();
                        newGroupH.put(newKey, v);
                    }
                    v.add(entity);
                }
            }
            return newGroupH;
        }
    }

    protected static class GroupingMethod_All
    implements IGroupingMethod {
        protected GroupingMethod_All() {
        }

        public String getMethodName() {
            return GuiUtil.getString("TOPO_LABEL_GROUPING_BYSINGLEGROUP");
        }

        public Hashtable applyGrouping(Hashtable groupH, GraphModel dataModel) {
            Hashtable<GraphGroupKey, Vector> newGroupH = new Hashtable<GraphGroupKey, Vector>();
            Enumeration enu = groupH.keys();
            while (enu.hasMoreElements()) {
                GraphGroupKey key = (GraphGroupKey)enu.nextElement();
                Vector entityV = (Vector)groupH.get(key);
                String value = GuiUtil.getString("TOPO_LABEL_GROUPING_ALL");
                GraphGroupKey newKey = new GraphGroupKey(key);
                newKey.addKey(new GraphGroupKey.Key(this.getMethodName(), (Comparable)((Object)value)));
                newGroupH.put(newKey, entityV);
            }
            return newGroupH;
        }
    }

    protected static interface IGroupingMethod {
        public String getMethodName();

        public Hashtable applyGrouping(Hashtable var1, GraphModel var2);
    }
}

