/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.model.GraphGroupingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPortGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPortGroup2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphLun;
import org.eclipse.aperi.gui.topo.model.bean.GraphLunGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphLunGroup2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewOtherL2Connectivity;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewOtherL2Device;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolumeGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolumeGroup2Volume;

public class GraphModelOtherL2
extends GraphModel {
    public static final GraphScopedType SWGROUP = new GraphScopedType(GraphSwitchGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType VOLUMEGROUP = new GraphScopedType(GraphVolumeGroup.TYPE, GraphModelConstant.SCOPE_NULL);

    public GraphModelOtherL2(ID modelID) {
        super(modelID);
    }

    protected void initGroupByCapabilities() {
        int bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_SWBYFABRIC;
        Integer groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(SWGROUP, groupByBitmap);
        bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_VOLUMEBYSUBSYSTEM;
        groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(VOLUMEGROUP, groupByBitmap);
    }

    public void applyScope() {
        Enumeration otherEnu = this.enumerate(GraphOther.TYPE);
        while (otherEnu.hasMoreElements()) {
            GraphOther other = (GraphOther)otherEnu.nextElement();
            GraphOther.ID otherID = (GraphOther.ID)other.getEntityID();
            Enumeration fcportEnu = this.associator(GraphOther2FCPort.TYPE, otherID);
            while (fcportEnu.hasMoreElements()) {
                GraphFCPort fcport = (GraphFCPort)fcportEnu.nextElement();
                fcport.addScope("Focus");
            }
        }
    }

    public void applyGrouping(Hashtable groupBySet) {
        this.groupFocus();
        this.groupSubviewConnectivityFCPortBySingleGroup();
        this.groupSubviewConnectivitySwitch(groupBySet);
        this.groupSubviewConnectivity();
        this.groupSubviewDeviceLunBySingleGroup();
        this.groupSubviewDeviceVolume(groupBySet);
        this.groupSubviewDevice();
        GraphGroupingUtilities.groupOrphanZone(this);
    }

    private void groupFocus() {
        GraphOther.ID otherID = (GraphOther.ID)((ID)this.modelID).getFocusEntityID();
        String otherGroupIDStr = "Focus";
        GraphOtherGroup otherGroup = new GraphOtherGroup(otherGroupIDStr);
        GraphOtherGroup.ID otherGroupID = (GraphOtherGroup.ID)otherGroup.getEntityID();
        otherGroup.setIsHelper(Boolean.TRUE);
        this.put(otherGroup);
        GraphOtherGroup2Other assoc = new GraphOtherGroup2Other(otherGroupID.getID() + "+" + otherID.getID());
        assoc.setOtherGroupID(otherGroupID);
        assoc.setOtherID(otherID);
        this.put(assoc);
    }

    private void groupSubviewConnectivityFCPortBySingleGroup() {
        this.removeAll(GraphFCPortGroup.TYPE);
        this.removeAll(GraphFCPortGroup2FCPort.TYPE);
        Vector entityV = new Vector();
        Enumeration fcportEnu = this.enumerate(GraphFCPort.TYPE);
        while (fcportEnu.hasMoreElements()) {
            GraphFCPort fcport = (GraphFCPort)fcportEnu.nextElement();
            if (!fcport.containScope("Focus")) continue;
            entityV.add(fcport);
        }
        Integer groupByBitmap = GraphGroupingUtilities.GROUPBY_ALL;
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration fcportGroupKeyEnu = groupH.keys();
        while (fcportGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)fcportGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphFCPortGroup fcportGroup = new GraphFCPortGroup(idStr);
            GraphFCPortGroup.ID fcportGroupID = (GraphFCPortGroup.ID)fcportGroup.getEntityID();
            fcportGroup.setDisplayName(key.getLabel());
            fcportGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            fcportGroup.setSortingValue(key);
            fcportGroup.setGroupKey(key);
            this.put(fcportGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphFCPort fcport = (GraphFCPort)entityV.elementAt(i);
                GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
                GraphFCPortGroup2FCPort assoc = new GraphFCPortGroup2FCPort(fcportGroupID.getID() + "+" + fcportID.getID());
                assoc.setFCPortGroupID(fcportGroupID);
                assoc.setFCPortID(fcportID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivitySwitch(Hashtable groupBySet) {
        this.removeAll(GraphSwitchGroup.TYPE);
        this.removeAll(GraphSwitchGroup2Switch.TYPE);
        Vector entityV = new Vector();
        Enumeration swEnu = this.enumerate(GraphSwitch.TYPE);
        while (swEnu.hasMoreElements()) {
            GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
            entityV.add(sw);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(SWGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration swGroupKeyEnu = groupH.keys();
        while (swGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)swGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphSwitchGroup swGroup = new GraphSwitchGroup(idStr);
            GraphSwitchGroup.ID swGroupID = (GraphSwitchGroup.ID)swGroup.getEntityID();
            swGroup.setDisplayName(key.getLabel());
            swGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            swGroup.setSortingValue(key);
            swGroup.setGroupKey(key);
            this.put(swGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphSwitch sw = (GraphSwitch)entityV.elementAt(i);
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                GraphSwitchGroup2Switch assoc = new GraphSwitchGroup2Switch(swGroupID.getID() + "+" + swID.getID());
                assoc.setSwitchGroupID(swGroupID);
                assoc.setSwitchID(swID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivity() {
        GraphSubviewOtherL2Connectivity connectivity = new GraphSubviewOtherL2Connectivity("Connectivity");
        GraphSubviewOtherL2Connectivity.ID connectivityID = (GraphSubviewOtherL2Connectivity.ID)connectivity.getEntityID();
        connectivity.setDisplayName(GuiUtil.getString("TOPO_LABEL_TASK_CONNECTIVITY"));
        this.put(connectivity);
        Enumeration fcportGroupEnu = this.enumerate(GraphFCPortGroup.TYPE);
        while (fcportGroupEnu.hasMoreElements()) {
            GraphFCPortGroup fcportGroup = (GraphFCPortGroup)fcportGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), fcportGroup.getHealthStatus()));
        }
        Enumeration swGroupEnu = this.enumerate(GraphSwitchGroup.TYPE);
        while (swGroupEnu.hasMoreElements()) {
            GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), swGroup.getHealthStatus()));
        }
    }

    private void groupSubviewDeviceLunBySingleGroup() {
        this.removeAll(GraphLunGroup.TYPE);
        this.removeAll(GraphLunGroup2Lun.TYPE);
        Vector entityV = new Vector();
        Enumeration lunEnu = this.enumerate(GraphLun.TYPE);
        while (lunEnu.hasMoreElements()) {
            GraphLun lun = (GraphLun)lunEnu.nextElement();
            entityV.add(lun);
        }
        Integer groupByBitmap = GraphGroupingUtilities.GROUPBY_ALL;
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration lunGroupKeyEnu = groupH.keys();
        while (lunGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)lunGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphLunGroup lunGroup = new GraphLunGroup(idStr);
            GraphLunGroup.ID lunGroupID = (GraphLunGroup.ID)lunGroup.getEntityID();
            lunGroup.setDisplayName(key.getLabel());
            lunGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            lunGroup.setSortingValue(key);
            lunGroup.setGroupKey(key);
            this.put(lunGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphLun lun = (GraphLun)entityV.elementAt(i);
                GraphLun.ID lunID = (GraphLun.ID)lun.getEntityID();
                GraphLunGroup2Lun assoc = new GraphLunGroup2Lun(lunGroupID.getID() + "+" + lunID.getID());
                assoc.setLunGroupID(lunGroupID);
                assoc.setLunID(lunID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewDeviceVolume(Hashtable groupBySet) {
        this.removeAll(GraphVolumeGroup.TYPE);
        this.removeAll(GraphVolumeGroup2Volume.TYPE);
        Vector entityV = new Vector();
        Enumeration volumeEnu = this.enumerate(GraphVolume.TYPE);
        while (volumeEnu.hasMoreElements()) {
            GraphVolume volume = (GraphVolume)volumeEnu.nextElement();
            entityV.add(volume);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(VOLUMEGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration volumeGroupKeyEnu = groupH.keys();
        while (volumeGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)volumeGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphVolumeGroup volumeGroup = new GraphVolumeGroup(idStr);
            GraphVolumeGroup.ID volumeGroupID = (GraphVolumeGroup.ID)volumeGroup.getEntityID();
            volumeGroup.setDisplayName(key.getLabel());
            volumeGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            volumeGroup.setSortingValue(key);
            volumeGroup.setGroupKey(key);
            this.put(volumeGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphVolume volume = (GraphVolume)entityV.elementAt(i);
                GraphVolume.ID volumeID = (GraphVolume.ID)volume.getEntityID();
                GraphVolumeGroup2Volume assoc = new GraphVolumeGroup2Volume(volumeGroupID.getID() + "+" + volumeID.getID());
                assoc.setVolumeGroupID(volumeGroupID);
                assoc.setVolumeID(volumeID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewDevice() {
        GraphSubviewOtherL2Device device = new GraphSubviewOtherL2Device("Device");
        GraphSubviewOtherL2Device.ID deviceID = (GraphSubviewOtherL2Device.ID)device.getEntityID();
        device.setDisplayName(GuiUtil.getString("TOPO_LABEL_TASK_DEVICE"));
        this.put(device);
        Enumeration lunGroupEnu = this.enumerate(GraphLunGroup.TYPE);
        while (lunGroupEnu.hasMoreElements()) {
            GraphLunGroup lunGroup = (GraphLunGroup)lunGroupEnu.nextElement();
            device.setHealthStatus(GraphModelUtilities.aggregateStatus(device.getHealthStatus(), lunGroup.getHealthStatus()));
        }
        Enumeration volumeGroupEnu = this.enumerate(GraphVolumeGroup.TYPE);
        while (volumeGroupEnu.hasMoreElements()) {
            GraphVolumeGroup volumeGroup = (GraphVolumeGroup)volumeGroupEnu.nextElement();
            device.setHealthStatus(GraphModelUtilities.aggregateStatus(device.getHealthStatus(), volumeGroup.getHealthStatus()));
        }
    }

    public void applyFiltering(int filteringLevel) {
        GraphVolume2Lun volume2lun;
        Enumeration volume2lunEnu;
        Boolean filterable;
        GraphFCPort2FCPort fcp2fcport;
        Enumeration otherGroupEnu = this.enumerate(GraphOtherGroup.TYPE);
        while (otherGroupEnu.hasMoreElements()) {
            GraphOtherGroup otherGroup = (GraphOtherGroup)otherGroupEnu.nextElement();
            GraphOtherGroup.ID otherGroupID = (GraphOtherGroup.ID)otherGroup.getEntityID();
            Enumeration otherEnu = this.associator(GraphOtherGroup2Other.TYPE, otherGroupID);
            while (otherEnu.hasMoreElements()) {
                GraphOther other = (GraphOther)otherEnu.nextElement();
                other.setIsFilterable(Boolean.FALSE);
            }
            otherGroup.setIsFilterable(Boolean.FALSE);
        }
        Enumeration fcportGroupEnu = this.enumerate(GraphFCPortGroup.TYPE);
        while (fcportGroupEnu.hasMoreElements()) {
            GraphFCPortGroup fcportGroup = (GraphFCPortGroup)fcportGroupEnu.nextElement();
            GraphFCPortGroup.ID fcportGroupID = (GraphFCPortGroup.ID)fcportGroup.getEntityID();
            int totalCountUsed = 0;
            int unfilteredCountUsed = 0;
            int totalCountEmpty = 0;
            int unfilteredCountEmpty = 0;
            Enumeration fcportEnu = this.associator(GraphFCPortGroup2FCPort.TYPE, fcportGroupID);
            while (fcportEnu.hasMoreElements()) {
                Boolean filterable2;
                GraphFCPort fcport = (GraphFCPort)fcportEnu.nextElement();
                GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
                Enumeration fcport2fcportEnu = this.reference(GraphFCPort2FCPort.TYPE, fcportID);
                if (fcport2fcportEnu.hasMoreElements()) {
                    ++totalCountUsed;
                    if (filteringLevel == 0) {
                        filterable2 = Boolean.FALSE;
                    } else if (GraphModelUtilities.isAbnormal(fcport)) {
                        filterable2 = Boolean.FALSE;
                    } else {
                        filterable2 = Boolean.TRUE;
                        if (filteringLevel == 1) {
                            GraphSwitch sw;
                            Enumeration swEnu;
                            GraphFCPort.ID fcpID;
                            fcp2fcport = (GraphFCPort2FCPort)fcport2fcportEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(fcp2fcport)) {
                                filterable2 = Boolean.FALSE;
                            }
                            if ((fcpID = fcp2fcport.getFCPort1ID()).equals(fcportID)) {
                                fcpID = fcp2fcport.getFCPort2ID();
                            }
                            if ((swEnu = this.associator(GraphSwitch2FCPort.TYPE, fcpID)).hasMoreElements() && GraphModelUtilities.isAbnormal(sw = (GraphSwitch)swEnu.nextElement())) {
                                filterable2 = Boolean.FALSE;
                            }
                        }
                    }
                    if (!filterable2.booleanValue()) {
                        ++unfilteredCountUsed;
                    }
                } else {
                    ++totalCountEmpty;
                    filterable2 = filteringLevel == 0 ? Boolean.FALSE : (GraphModelUtilities.isAbnormal(fcport) ? Boolean.FALSE : Boolean.TRUE);
                    if (!filterable2.booleanValue()) {
                        ++unfilteredCountEmpty;
                    }
                }
                fcport.setIsFilterable(filterable2);
            }
            fcportGroup.setNumOfFCPortsInUse(new Integer(totalCountUsed));
            fcportGroup.setNumOfAbnormalFCPortsInUse(new Integer(unfilteredCountUsed));
            fcportGroup.setNumOfFCPortsEmpty(new Integer(totalCountEmpty));
            fcportGroup.setNumOfAbnormalFCPortsEmpty(new Integer(unfilteredCountEmpty));
            fcportGroup.setIsFilterable(unfilteredCountUsed + unfilteredCountEmpty == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration swGroupEnu = this.enumerate(GraphSwitchGroup.TYPE);
        while (swGroupEnu.hasMoreElements()) {
            GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu.nextElement();
            GraphSwitchGroup.ID swGroupID = (GraphSwitchGroup.ID)swGroup.getEntityID();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration swEnu = this.associator(GraphSwitchGroup2Switch.TYPE, swGroupID);
            while (swEnu.hasMoreElements()) {
                GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(sw)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        Enumeration fcpIDEnu = this.associatorID(GraphSwitch2FCPort.TYPE, swID);
                        while (fcpIDEnu.hasMoreElements()) {
                            GraphFCPort fcport;
                            GraphFCPort.ID fcpID = (GraphFCPort.ID)fcpIDEnu.nextElement();
                            Enumeration fcp2fcportEnu = this.reference(GraphFCPort2FCPort.TYPE, fcpID);
                            if (!fcp2fcportEnu.hasMoreElements()) continue;
                            fcp2fcport = (GraphFCPort2FCPort)fcp2fcportEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(fcp2fcport)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            GraphFCPort.ID fcportID = fcp2fcport.getFCPort1ID();
                            if (fcportID.equals(fcpID)) {
                                fcportID = fcp2fcport.getFCPort2ID();
                            }
                            if (!GraphModelUtilities.isAbnormal(fcport = (GraphFCPort)this.get(fcportID))) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                sw.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            swGroup.setNumOfSwitches(new Integer(totalCount));
            swGroup.setNumOfAbnormalSwitches(new Integer(unfilteredCount));
            swGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration lunGroupEnu = this.enumerate(GraphLunGroup.TYPE);
        while (lunGroupEnu.hasMoreElements()) {
            GraphLunGroup lunGroup = (GraphLunGroup)lunGroupEnu.nextElement();
            GraphLunGroup.ID lunGroupID = (GraphLunGroup.ID)lunGroup.getEntityID();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration lunEnu = this.associator(GraphLunGroup2Lun.TYPE, lunGroupID);
            while (lunEnu.hasMoreElements()) {
                GraphLun lun = (GraphLun)lunEnu.nextElement();
                GraphLun.ID lunID = (GraphLun.ID)lun.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(lun)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        volume2lunEnu = this.reference(GraphVolume2Lun.TYPE, lunID);
                        while (volume2lunEnu.hasMoreElements()) {
                            volume2lun = (GraphVolume2Lun)volume2lunEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(volume2lun)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            GraphVolume.ID volumeID = volume2lun.getVolumeID();
                            GraphVolume volume = (GraphVolume)this.get(volumeID);
                            if (!GraphModelUtilities.isAbnormal(volume)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                lun.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            lunGroup.setNumOfLuns(new Integer(totalCount));
            lunGroup.setNumOfAbnormalLuns(new Integer(unfilteredCount));
            lunGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration volumeGroupEnu = this.enumerate(GraphVolumeGroup.TYPE);
        while (volumeGroupEnu.hasMoreElements()) {
            GraphVolumeGroup volumeGroup = (GraphVolumeGroup)volumeGroupEnu.nextElement();
            GraphVolumeGroup.ID volumeGroupID = (GraphVolumeGroup.ID)volumeGroup.getEntityID();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration volumeEnu = this.associator(GraphVolumeGroup2Volume.TYPE, volumeGroupID);
            while (volumeEnu.hasMoreElements()) {
                GraphVolume volume = (GraphVolume)volumeEnu.nextElement();
                GraphVolume.ID volumeID = (GraphVolume.ID)volume.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(volume)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        volume2lunEnu = this.reference(GraphVolume2Lun.TYPE, volumeID);
                        while (volume2lunEnu.hasMoreElements()) {
                            volume2lun = (GraphVolume2Lun)volume2lunEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(volume2lun)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            GraphLun.ID lunID = volume2lun.getLunID();
                            GraphLun lun = (GraphLun)this.get(lunID);
                            if (!GraphModelUtilities.isAbnormal(lun)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                volume.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            volumeGroup.setNumOfVolumes(new Integer(totalCount));
            volumeGroup.setNumOfAbnormalVolumes(new Integer(unfilteredCount));
            volumeGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration connectivityEnu = this.enumerate(GraphSubviewOtherL2Connectivity.TYPE);
        while (connectivityEnu.hasMoreElements()) {
            GraphSubviewOtherL2Connectivity connectivity = (GraphSubviewOtherL2Connectivity)connectivityEnu.nextElement();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration fgEnu = this.enumerate(GraphFCPortGroup.TYPE);
            while (fgEnu.hasMoreElements()) {
                GraphFCPortGroup fg = (GraphFCPortGroup)fgEnu.nextElement();
                totalCount += fg.getNumOfFCPortsInUse() + fg.getNumOfFCPortsEmpty();
                unfilteredCount += fg.getNumOfAbnormalFCPortsInUse() + fg.getNumOfAbnormalFCPortsEmpty();
            }
            connectivity.setNumOfFCPorts(new Integer(totalCount));
            connectivity.setNumOfAbnormalFCPorts(new Integer(unfilteredCount));
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration swGroupEnu2 = this.enumerate(GraphSwitchGroup.TYPE);
            while (swGroupEnu2.hasMoreElements()) {
                GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu2.nextElement();
                totalCount += swGroup.getNumOfSwitches().intValue();
                unfilteredCount += swGroup.getNumOfAbnormalSwitches().intValue();
            }
            connectivity.setNumOfSwitches(new Integer(totalCount));
            connectivity.setNumOfAbnormalSwitches(new Integer(unfilteredCount));
            connectivity.setIsFilterable(Boolean.FALSE);
        }
        Enumeration deviceEnu = this.enumerate(GraphSubviewOtherL2Device.TYPE);
        while (deviceEnu.hasMoreElements()) {
            GraphSubviewOtherL2Device device = (GraphSubviewOtherL2Device)deviceEnu.nextElement();
            int totalCount = 0;
            int abnormalCount = 0;
            Enumeration lunGroupEnu2 = this.enumerate(GraphLunGroup.TYPE);
            while (lunGroupEnu2.hasMoreElements()) {
                GraphLunGroup lunGroup = (GraphLunGroup)lunGroupEnu2.nextElement();
                totalCount += lunGroup.getNumOfLuns().intValue();
                abnormalCount += lunGroup.getNumOfAbnormalLuns().intValue();
            }
            device.setNumOfLuns(new Integer(totalCount));
            device.setNumOfAbnormalLuns(new Integer(abnormalCount));
            totalCount = 0;
            abnormalCount = 0;
            Enumeration volumeGroupEnu2 = this.enumerate(GraphVolumeGroup.TYPE);
            while (volumeGroupEnu2.hasMoreElements()) {
                GraphVolumeGroup volumeGroup = (GraphVolumeGroup)volumeGroupEnu2.nextElement();
                totalCount += volumeGroup.getNumOfVolumes().intValue();
                abnormalCount += volumeGroup.getNumOfAbnormalVolumes().intValue();
            }
            device.setNumOfVolumes(new Integer(totalCount));
            device.setNumOfAbnormalVolumes(new Integer(abnormalCount));
            device.setIsFilterable(Boolean.FALSE);
        }
    }

    public static class ID
    extends GraphModel.ID {
        public ID(GraphOther focusEntity) {
            super("OtherL2", focusEntity.getEntityID());
        }
    }
}

