/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.model.GraphGroupingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerGroup2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2SwitchFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPortGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPortGroup2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewSwitchL2Connectivity;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2SwitchPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup2TapeLibrary;

public class GraphModelSwitchL2
extends GraphModel {
    public static final GraphScopedType COMPUTERGROUP = new GraphScopedType(GraphComputerGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType SWGROUP = new GraphScopedType(GraphSwitchGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType SUBSYSTEMGROUP = new GraphScopedType(GraphSubsystemGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType TAPELIBRARYGROUP = new GraphScopedType(GraphTapeLibraryGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType OTHERGROUP = new GraphScopedType(GraphOtherGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    private int portPerRow = 16;

    public GraphModelSwitchL2(ID modelID) {
        super(modelID);
    }

    protected void initGroupByCapabilities() {
        int bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_COMPUTERBYOS;
        Integer groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(COMPUTERGROUP, groupByBitmap);
        bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_SWBYFABRIC;
        groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(SWGROUP, groupByBitmap);
        bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_SUBSYSTEMBYMODEL;
        groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(SUBSYSTEMGROUP, groupByBitmap);
        bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3;
        groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(TAPELIBRARYGROUP, groupByBitmap);
        bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3;
        groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(OTHERGROUP, groupByBitmap);
    }

    public void applyScope() {
        GraphSwitch.ID swID = (GraphSwitch.ID)this.modelID.getFocusEntityID();
        GraphSwitch sw = (GraphSwitch)this.get(swID);
        if (sw != null) {
            sw.addScope("Focus");
        }
        Enumeration focusEnu = this.enumerate(GraphSwitch.TYPE);
        while (focusEnu.hasMoreElements()) {
            sw = (GraphSwitch)focusEnu.nextElement();
            GraphSwitch.ID swID2 = (GraphSwitch.ID)sw.getEntityID();
            if (!sw.containScope("Focus")) continue;
            Enumeration fcportEnu = this.associator(GraphSwitch2FCPort.TYPE, swID2);
            while (fcportEnu.hasMoreElements()) {
                GraphFCPort fcport = (GraphFCPort)fcportEnu.nextElement();
                fcport.addScope("Focus");
            }
        }
    }

    public void applyPerfStatus() {
        Enumeration swEnu = this.enumerate(GraphSwitch.TYPE);
        while (swEnu.hasMoreElements()) {
            Enumeration enu;
            GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
            GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
            if (!sw.containScope("Focus") || !(enu = this.associator(GraphSwitch2SwitchPerf.TYPE, swID)).hasMoreElements()) continue;
            GraphSwitchPerf perf = (GraphSwitchPerf)enu.nextElement();
            sw.setPerfStatus(perf.getHealthStatus());
        }
        Enumeration fcportEnu = this.enumerate(GraphFCPort.TYPE);
        while (fcportEnu.hasMoreElements()) {
            Enumeration enu;
            GraphFCPort fcport = (GraphFCPort)fcportEnu.nextElement();
            GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
            if (!fcport.containScope("Focus") || !(enu = this.associator(GraphFCPort2SwitchFCPortPerf.TYPE, fcportID)).hasMoreElements()) continue;
            GraphSwitchFCPortPerf perf = (GraphSwitchFCPortPerf)enu.nextElement();
            fcport.setPerfStatus(perf.getHealthStatus());
        }
    }

    public void applyGrouping(Hashtable groupBySet) {
        this.groupFocus();
        this.groupSubviewConnectivityFCPortByPortNumber();
        this.groupSubviewConnectivityComputer(groupBySet);
        this.groupSubviewConnectivitySwitch(groupBySet);
        this.groupSubviewConnectivitySubsystem(groupBySet);
        this.groupSubviewConnectivityTapeLibrary(groupBySet);
        this.groupSubviewConnectivityOther(groupBySet);
        this.groupSubviewConnectivity();
        GraphGroupingUtilities.groupOrphanZone(this);
    }

    private void groupFocus() {
        GraphSwitch.ID swID = (GraphSwitch.ID)((ID)this.modelID).getFocusEntityID();
        String swGroupIDStr = "Focus";
        GraphSwitchGroup swGroup = new GraphSwitchGroup(swGroupIDStr);
        GraphSwitchGroup.ID swGroupID = (GraphSwitchGroup.ID)swGroup.getEntityID();
        swGroup.addScope("Focus");
        swGroup.setIsHelper(Boolean.TRUE);
        this.put(swGroup);
        GraphSwitchGroup2Switch assoc = new GraphSwitchGroup2Switch(swGroupID.getID() + "+" + swID.getID());
        assoc.setSwitchGroupID(swGroupID);
        assoc.setSwitchID(swID);
        this.put(assoc);
    }

    private void groupSubviewConnectivityFCPortByPortNumber() {
        int i;
        this.removeAll(GraphFCPortGroup.TYPE);
        this.removeAll(GraphFCPortGroup2FCPort.TYPE);
        Vector entityV = new Vector();
        Enumeration fcportEnu = this.enumerate(GraphFCPort.TYPE);
        while (fcportEnu.hasMoreElements()) {
            GraphFCPort fcport = (GraphFCPort)fcportEnu.nextElement();
            if (!fcport.containScope("Focus")) continue;
            entityV.add(fcport);
            Integer number = null;
            try {
                String portNumber = fcport.getPortNumber();
                if (portNumber != null) {
                    number = new Integer(Integer.parseInt(portNumber));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (number == null) continue;
            fcport.setSortingValue(number);
        }
        Collections.sort(entityV, GraphModelUtilities.DEFAULT_COMPARATOR);
        Hashtable<GraphGroupKey, Vector> groupH = new Hashtable<GraphGroupKey, Vector>();
        Vector<Vector> rowV = new Vector<Vector>();
        Vector v = null;
        for (i = 0; i < entityV.size(); ++i) {
            if (v == null) {
                v = new Vector();
                rowV.add(v);
            }
            v.add(entityV.elementAt(i));
            if (v.size() != this.portPerRow) continue;
            v = null;
        }
        for (i = 0; i < rowV.size(); ++i) {
            v = (Vector)rowV.elementAt(i);
            GraphFCPort startFCPort = (GraphFCPort)v.elementAt(0);
            GraphFCPort endFCPort = (GraphFCPort)v.elementAt(v.size() - 1);
            StringBuffer sb = new StringBuffer();
            sb.append(startFCPort.getPortNumber() != null ? startFCPort.getPortNumber() : startFCPort.getDisplayName());
            sb.append("-");
            sb.append(endFCPort.getPortNumber() != null ? endFCPort.getPortNumber() : endFCPort.getDisplayName());
            GraphGroupKey key = new GraphGroupKey();
            key.addKey(new GraphGroupKey.Key(GuiUtil.getString("TOPO_LABEL_ATTR_FCPORT_PORTNUMBER"), new Integer(i), sb.toString()));
            groupH.put(key, v);
        }
        Enumeration fcportGroupKeyEnu = groupH.keys();
        while (fcportGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)fcportGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphFCPortGroup fcportGroup = new GraphFCPortGroup(idStr);
            GraphFCPortGroup.ID fcportGroupID = (GraphFCPortGroup.ID)fcportGroup.getEntityID();
            fcportGroup.setDisplayName(key.getLabel());
            fcportGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            fcportGroup.setPerfStatus(GraphModelUtilities.aggregatePerfStatus(entityV));
            fcportGroup.setSortingValue(key);
            fcportGroup.setGroupKey(key);
            this.put(fcportGroup);
            for (int i2 = 0; i2 < entityV.size(); ++i2) {
                GraphFCPort fcport = (GraphFCPort)entityV.elementAt(i2);
                GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
                GraphFCPortGroup2FCPort assoc = new GraphFCPortGroup2FCPort(fcportGroupID.getID() + "+" + fcportID.getID());
                assoc.setFCPortGroupID(fcportGroupID);
                assoc.setFCPortID(fcportID);
                this.put(assoc);
            }
        }
        Integer healthStatus = null;
        Integer perfStatus = null;
        Enumeration fcportGroupenu = this.enumerate(GraphFCPortGroup.TYPE);
        while (fcportGroupenu.hasMoreElements()) {
            GraphFCPortGroup fcportGroup = (GraphFCPortGroup)fcportGroupenu.nextElement();
            GraphFCPortGroup.ID fcportGroupID = (GraphFCPortGroup.ID)fcportGroup.getEntityID();
            healthStatus = GraphModelUtilities.aggregateStatus(healthStatus, fcportGroup.getHealthStatus());
            perfStatus = GraphModelUtilities.aggregateStatus(perfStatus, fcportGroup.getPerfStatus());
        }
        String rootFcportGroupIDStr = "Root";
        GraphFCPortGroup rootFcportGroup = new GraphFCPortGroup(rootFcportGroupIDStr);
        GraphFCPortGroup.ID rootFcportGroupID = (GraphFCPortGroup.ID)rootFcportGroup.getEntityID();
        rootFcportGroup.addScope("Root");
        rootFcportGroup.setDisplayName(GuiUtil.getString("TOPO_LABEL_GROUPING_ALL"));
        rootFcportGroup.setHealthStatus(healthStatus);
        rootFcportGroup.setPerfStatus(perfStatus);
        this.put(rootFcportGroup);
    }

    private void groupSubviewConnectivityComputer(Hashtable groupBySet) {
        this.removeAll(GraphComputerGroup.TYPE);
        this.removeAll(GraphComputerGroup2Computer.TYPE);
        Vector entityV = new Vector();
        Enumeration computerEnu = this.enumerate(GraphComputer.TYPE);
        while (computerEnu.hasMoreElements()) {
            GraphComputer computer = (GraphComputer)computerEnu.nextElement();
            entityV.add(computer);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(COMPUTERGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration computerGroupKeyEnu = groupH.keys();
        while (computerGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)computerGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphComputerGroup computerGroup = new GraphComputerGroup(idStr);
            GraphComputerGroup.ID computerGroupID = (GraphComputerGroup.ID)computerGroup.getEntityID();
            computerGroup.setDisplayName(key.getLabel());
            computerGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            computerGroup.setSortingValue(key);
            computerGroup.setGroupKey(key);
            this.put(computerGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphComputer computer = (GraphComputer)entityV.elementAt(i);
                GraphComputer.ID computerID = (GraphComputer.ID)computer.getEntityID();
                GraphComputerGroup2Computer assoc = new GraphComputerGroup2Computer(computerGroupID.getID() + "+" + computerID.getID());
                assoc.setComputerGroupID(computerGroupID);
                assoc.setComputerID(computerID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivitySwitch(Hashtable groupBySet) {
        int i;
        GraphSwitchGroup.ID swGroupID;
        Vector<GraphSwitchGroup.ID> swGroupIDV = new Vector<GraphSwitchGroup.ID>();
        Vector<GraphSwitchGroup2Switch.ID> swGroup2swIDV = new Vector<GraphSwitchGroup2Switch.ID>();
        Enumeration swGroupEnu = this.enumerate(GraphSwitchGroup.TYPE);
        while (swGroupEnu.hasMoreElements()) {
            GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu.nextElement();
            if (swGroup.containScope("Focus")) continue;
            GraphSwitchGroup.ID swGroupID2 = (GraphSwitchGroup.ID)swGroup.getEntityID();
            swGroupIDV.add(swGroupID2);
        }
        Enumeration swGroup2swEnu = this.enumerate(GraphSwitchGroup2Switch.TYPE);
        while (swGroup2swEnu.hasMoreElements()) {
            GraphSwitchGroup2Switch swGroup2sw = (GraphSwitchGroup2Switch)swGroup2swEnu.nextElement();
            swGroupID = swGroup2sw.getSwitchGroupID();
            if (!swGroupIDV.contains(swGroupID)) continue;
            GraphSwitchGroup2Switch.ID swGroup2swID = (GraphSwitchGroup2Switch.ID)swGroup2sw.getEntityID();
            swGroup2swIDV.add(swGroup2swID);
        }
        for (i = 0; i < swGroupIDV.size(); ++i) {
            swGroupID = (GraphSwitchGroup.ID)swGroupIDV.elementAt(i);
            this.remove(swGroupID);
        }
        for (i = 0; i < swGroup2swIDV.size(); ++i) {
            GraphSwitchGroup2Switch.ID swGroup2swID = (GraphSwitchGroup2Switch.ID)swGroup2swIDV.elementAt(i);
            this.remove(swGroup2swID);
        }
        Vector entityV = new Vector();
        Enumeration swEnu = this.enumerate(GraphSwitch.TYPE);
        while (swEnu.hasMoreElements()) {
            GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
            if (sw.containScope("Focus")) continue;
            entityV.add(sw);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(SWGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration swGroupKeyEnu = groupH.keys();
        while (swGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)swGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphSwitchGroup swGroup = new GraphSwitchGroup(idStr);
            GraphSwitchGroup.ID swGroupID3 = (GraphSwitchGroup.ID)swGroup.getEntityID();
            swGroup.setDisplayName(key.getLabel());
            swGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            swGroup.setSortingValue(key);
            swGroup.setGroupKey(key);
            this.put(swGroup);
            for (int i2 = 0; i2 < entityV.size(); ++i2) {
                GraphSwitch sw = (GraphSwitch)entityV.elementAt(i2);
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                GraphSwitchGroup2Switch assoc = new GraphSwitchGroup2Switch(swGroupID3.getID() + "+" + swID.getID());
                assoc.setSwitchGroupID(swGroupID3);
                assoc.setSwitchID(swID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivitySubsystem(Hashtable groupBySet) {
        this.removeAll(GraphSubsystemGroup.TYPE);
        this.removeAll(GraphSubsystemGroup2Subsystem.TYPE);
        Vector entityV = new Vector();
        Enumeration subsystemEnu = this.enumerate(GraphSubsystem.TYPE);
        while (subsystemEnu.hasMoreElements()) {
            GraphSubsystem subsystem = (GraphSubsystem)subsystemEnu.nextElement();
            entityV.add(subsystem);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(SUBSYSTEMGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration subsystemGroupKeyEnu = groupH.keys();
        while (subsystemGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)subsystemGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphSubsystemGroup subsystemGroup = new GraphSubsystemGroup(idStr);
            GraphSubsystemGroup.ID subsystemGroupID = (GraphSubsystemGroup.ID)subsystemGroup.getEntityID();
            subsystemGroup.setDisplayName(key.getLabel());
            subsystemGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            subsystemGroup.setSortingValue(key);
            subsystemGroup.setGroupKey(key);
            this.put(subsystemGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphSubsystem subsystem = (GraphSubsystem)entityV.elementAt(i);
                GraphSubsystem.ID subsystemID = (GraphSubsystem.ID)subsystem.getEntityID();
                GraphSubsystemGroup2Subsystem assoc = new GraphSubsystemGroup2Subsystem(subsystemGroupID.getID() + "+" + subsystemID.getID());
                assoc.setSubsystemGroupID(subsystemGroupID);
                assoc.setSubsystemID(subsystemID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivityTapeLibrary(Hashtable groupBySet) {
        this.removeAll(GraphTapeLibraryGroup.TYPE);
        this.removeAll(GraphTapeLibraryGroup2TapeLibrary.TYPE);
        Vector entityV = new Vector();
        Enumeration tapeLibraryEnu = this.enumerate(GraphTapeLibrary.TYPE);
        while (tapeLibraryEnu.hasMoreElements()) {
            GraphTapeLibrary tapeLibrary = (GraphTapeLibrary)tapeLibraryEnu.nextElement();
            entityV.add(tapeLibrary);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(TAPELIBRARYGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration tapeLibraryGroupKeyEnu = groupH.keys();
        while (tapeLibraryGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)tapeLibraryGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphTapeLibraryGroup tapeLibraryGroup = new GraphTapeLibraryGroup(idStr);
            GraphTapeLibraryGroup.ID tapeLibraryGroupID = (GraphTapeLibraryGroup.ID)tapeLibraryGroup.getEntityID();
            tapeLibraryGroup.setDisplayName(key.getLabel());
            tapeLibraryGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            tapeLibraryGroup.setSortingValue(key);
            tapeLibraryGroup.setGroupKey(key);
            this.put(tapeLibraryGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphTapeLibrary tapeLibrary = (GraphTapeLibrary)entityV.elementAt(i);
                GraphTapeLibrary.ID tapeLibraryID = (GraphTapeLibrary.ID)tapeLibrary.getEntityID();
                GraphTapeLibraryGroup2TapeLibrary assoc = new GraphTapeLibraryGroup2TapeLibrary(tapeLibraryGroupID.getID() + "+" + tapeLibraryID.getID());
                assoc.setTapeLibraryGroupID(tapeLibraryGroupID);
                assoc.setTapeLibraryID(tapeLibraryID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivityOther(Hashtable groupBySet) {
        this.removeAll(GraphOtherGroup.TYPE);
        this.removeAll(GraphOtherGroup2Other.TYPE);
        Vector entityV = new Vector();
        Enumeration otherEnu = this.enumerate(GraphOther.TYPE);
        while (otherEnu.hasMoreElements()) {
            GraphOther other = (GraphOther)otherEnu.nextElement();
            entityV.add(other);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(OTHERGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration otherGroupKeyEnu = groupH.keys();
        while (otherGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)otherGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphOtherGroup otherGroup = new GraphOtherGroup(idStr);
            GraphOtherGroup.ID otherGroupID = (GraphOtherGroup.ID)otherGroup.getEntityID();
            otherGroup.setDisplayName(key.getLabel());
            otherGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            otherGroup.setSortingValue(key);
            otherGroup.setGroupKey(key);
            this.put(otherGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphOther other = (GraphOther)entityV.elementAt(i);
                GraphOther.ID otherID = (GraphOther.ID)other.getEntityID();
                GraphOtherGroup2Other assoc = new GraphOtherGroup2Other(otherGroupID.getID() + "+" + otherID.getID());
                assoc.setOtherGroupID(otherGroupID);
                assoc.setOtherID(otherID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivity() {
        GraphSubviewSwitchL2Connectivity connectivity = new GraphSubviewSwitchL2Connectivity("Connectivity");
        GraphSubviewSwitchL2Connectivity.ID connectivityID = (GraphSubviewSwitchL2Connectivity.ID)connectivity.getEntityID();
        connectivity.setDisplayName(GuiUtil.getString("TOPO_LABEL_TASK_CONNECTIVITY"));
        this.put(connectivity);
        Enumeration fcportGroupEnu = this.enumerate(GraphFCPortGroup.TYPE);
        while (fcportGroupEnu.hasMoreElements()) {
            GraphFCPortGroup fcportGroup = (GraphFCPortGroup)fcportGroupEnu.nextElement();
            if (!fcportGroup.containScope("Root")) continue;
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), fcportGroup.getHealthStatus()));
        }
        Enumeration computerGroupEnu = this.enumerate(GraphComputerGroup.TYPE);
        while (computerGroupEnu.hasMoreElements()) {
            GraphComputerGroup computerGroup = (GraphComputerGroup)computerGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), computerGroup.getHealthStatus()));
        }
        Enumeration swGroupEnu = this.enumerate(GraphSwitchGroup.TYPE);
        while (swGroupEnu.hasMoreElements()) {
            GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu.nextElement();
            if (swGroup.containScope("Focus")) continue;
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), swGroup.getHealthStatus()));
        }
        Enumeration subsystemGroupEnu = this.enumerate(GraphSubsystemGroup.TYPE);
        while (subsystemGroupEnu.hasMoreElements()) {
            GraphSubsystemGroup subsystemGroup = (GraphSubsystemGroup)subsystemGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), subsystemGroup.getHealthStatus()));
        }
        Enumeration tapeLibraryGroupEnu = this.enumerate(GraphTapeLibraryGroup.TYPE);
        while (tapeLibraryGroupEnu.hasMoreElements()) {
            GraphTapeLibraryGroup tapeLibraryGroup = (GraphTapeLibraryGroup)tapeLibraryGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), tapeLibraryGroup.getHealthStatus()));
        }
        Enumeration otherGroupEnu = this.enumerate(GraphOtherGroup.TYPE);
        while (otherGroupEnu.hasMoreElements()) {
            GraphOtherGroup otherGroup = (GraphOtherGroup)otherGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), otherGroup.getHealthStatus()));
        }
    }

    public void applyFiltering(int filteringLevel) {
        GraphFCPort fcport;
        GraphFCPort.ID fcportID;
        Enumeration fcp2fcportEnu;
        GraphFCPort.ID fcpID;
        Enumeration fcpIDEnu;
        Boolean filterable;
        GraphFCPort2FCPort fcp2fcport;
        int unfilteredCountEmpty;
        int totalCountEmpty;
        GraphSwitchGroup.ID swGroupID;
        GraphSwitchGroup swGroup;
        Enumeration swGroupEnu = this.enumerate(GraphSwitchGroup.TYPE);
        while (swGroupEnu.hasMoreElements()) {
            swGroup = (GraphSwitchGroup)swGroupEnu.nextElement();
            swGroupID = (GraphSwitchGroup.ID)swGroup.getEntityID();
            if (!swGroup.containScope("Focus")) continue;
            Enumeration swEnu = this.associator(GraphSwitchGroup2Switch.TYPE, swGroupID);
            while (swEnu.hasMoreElements()) {
                GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
                sw.setIsFilterable(Boolean.FALSE);
            }
            swGroup.setIsFilterable(Boolean.FALSE);
        }
        Enumeration fcportGroupEnu = this.enumerate(GraphFCPortGroup.TYPE);
        while (fcportGroupEnu.hasMoreElements()) {
            GraphFCPortGroup fcportGroup = (GraphFCPortGroup)fcportGroupEnu.nextElement();
            GraphFCPortGroup.ID fcportGroupID = (GraphFCPortGroup.ID)fcportGroup.getEntityID();
            if (fcportGroup.containScope("Root")) continue;
            int totalCountUsed = 0;
            int unfilteredCountUsed = 0;
            totalCountEmpty = 0;
            unfilteredCountEmpty = 0;
            Enumeration fcportEnu = this.associator(GraphFCPortGroup2FCPort.TYPE, fcportGroupID);
            while (fcportEnu.hasMoreElements()) {
                Boolean filterable2;
                GraphFCPort fcport2 = (GraphFCPort)fcportEnu.nextElement();
                GraphFCPort.ID fcportID2 = (GraphFCPort.ID)fcport2.getEntityID();
                Enumeration fcport2fcportEnu = this.reference(GraphFCPort2FCPort.TYPE, fcportID2);
                if (fcport2fcportEnu.hasMoreElements()) {
                    ++totalCountUsed;
                    if (filteringLevel == 0) {
                        filterable2 = Boolean.FALSE;
                    } else if (GraphModelUtilities.isAbnormal(fcport2)) {
                        filterable2 = Boolean.FALSE;
                    } else {
                        filterable2 = Boolean.TRUE;
                        if (filteringLevel == 1) {
                            GraphTapeLibrary tapeLibrary;
                            Enumeration tapeLibraryEnu;
                            GraphSubsystem subsystem;
                            Enumeration subsystemEnu;
                            GraphComputer computer;
                            Enumeration computerEnu;
                            GraphSwitch sw;
                            Enumeration swEnu;
                            GraphFCPort.ID fcpID2;
                            fcp2fcport = (GraphFCPort2FCPort)fcport2fcportEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(fcp2fcport)) {
                                filterable2 = Boolean.FALSE;
                            }
                            if ((fcpID2 = fcp2fcport.getFCPort1ID()).equals(fcportID2)) {
                                fcpID2 = fcp2fcport.getFCPort2ID();
                            }
                            if ((swEnu = this.associator(GraphSwitch2FCPort.TYPE, fcpID2)).hasMoreElements() && GraphModelUtilities.isAbnormal(sw = (GraphSwitch)swEnu.nextElement())) {
                                filterable2 = Boolean.FALSE;
                            }
                            if ((computerEnu = this.associator(GraphComputer2FCPort.TYPE, fcpID2)).hasMoreElements() && GraphModelUtilities.isAbnormal(computer = (GraphComputer)computerEnu.nextElement())) {
                                filterable2 = Boolean.FALSE;
                            }
                            if ((subsystemEnu = this.associator(GraphSubsystem2FCPort.TYPE, fcpID2)).hasMoreElements() && GraphModelUtilities.isAbnormal(subsystem = (GraphSubsystem)subsystemEnu.nextElement())) {
                                filterable2 = Boolean.FALSE;
                            }
                            if ((tapeLibraryEnu = this.associator(GraphTapeLibrary2FCPort.TYPE, fcpID2)).hasMoreElements() && GraphModelUtilities.isAbnormal(tapeLibrary = (GraphTapeLibrary)tapeLibraryEnu.nextElement())) {
                                filterable2 = Boolean.FALSE;
                            }
                            Enumeration otherEnu = this.associator(GraphOther2FCPort.TYPE, fcpID2);
                            while (otherEnu.hasMoreElements()) {
                                GraphOther other = (GraphOther)otherEnu.nextElement();
                                if (!GraphModelUtilities.isAbnormal(other)) continue;
                                filterable2 = Boolean.FALSE;
                            }
                        }
                    }
                    if (!filterable2.booleanValue()) {
                        ++unfilteredCountUsed;
                    }
                } else {
                    ++totalCountEmpty;
                    filterable2 = filteringLevel == 0 ? Boolean.FALSE : (GraphModelUtilities.isAbnormal(fcport2) ? Boolean.FALSE : Boolean.TRUE);
                    if (!filterable2.booleanValue()) {
                        ++unfilteredCountEmpty;
                    }
                }
                fcport2.setIsFilterable(filterable2);
            }
            fcportGroup.setNumOfFCPortsInUse(new Integer(totalCountUsed));
            fcportGroup.setNumOfAbnormalFCPortsInUse(new Integer(unfilteredCountUsed));
            fcportGroup.setNumOfFCPortsEmpty(new Integer(totalCountEmpty));
            fcportGroup.setNumOfAbnormalFCPortsEmpty(new Integer(unfilteredCountEmpty));
            fcportGroup.setIsFilterable(unfilteredCountUsed + unfilteredCountEmpty == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration rootFcportGroupEnu = this.enumerate(GraphFCPortGroup.TYPE);
        while (rootFcportGroupEnu.hasMoreElements()) {
            GraphFCPortGroup rootFcportGroup = (GraphFCPortGroup)rootFcportGroupEnu.nextElement();
            GraphFCPortGroup.ID rootFcportGroupID = (GraphFCPortGroup.ID)rootFcportGroup.getEntityID();
            if (!rootFcportGroup.containScope("Root")) continue;
            int totalCountUsed = 0;
            int unfilteredCountUsed = 0;
            totalCountEmpty = 0;
            unfilteredCountEmpty = 0;
            Enumeration fcportGroupEnu2 = this.enumerate(GraphFCPortGroup.TYPE);
            while (fcportGroupEnu2.hasMoreElements()) {
                GraphFCPortGroup fcportGroup = (GraphFCPortGroup)fcportGroupEnu2.nextElement();
                GraphFCPortGroup.ID fcportGroupID = (GraphFCPortGroup.ID)fcportGroup.getEntityID();
                if (fcportGroup.containScope("Root")) continue;
                totalCountUsed += fcportGroup.getNumOfFCPortsInUse().intValue();
                unfilteredCountUsed += fcportGroup.getNumOfAbnormalFCPortsInUse().intValue();
                totalCountEmpty += fcportGroup.getNumOfFCPortsEmpty().intValue();
                unfilteredCountEmpty += fcportGroup.getNumOfAbnormalFCPortsEmpty().intValue();
            }
            rootFcportGroup.setNumOfFCPortsInUse(new Integer(totalCountUsed));
            rootFcportGroup.setNumOfAbnormalFCPortsInUse(new Integer(unfilteredCountUsed));
            rootFcportGroup.setNumOfFCPortsEmpty(new Integer(totalCountEmpty));
            rootFcportGroup.setNumOfAbnormalFCPortsEmpty(new Integer(unfilteredCountEmpty));
            rootFcportGroup.setIsFilterable(unfilteredCountUsed + unfilteredCountEmpty == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        swGroupEnu = this.enumerate(GraphSwitchGroup.TYPE);
        while (swGroupEnu.hasMoreElements()) {
            swGroup = (GraphSwitchGroup)swGroupEnu.nextElement();
            swGroupID = (GraphSwitchGroup.ID)swGroup.getEntityID();
            if (swGroup.containScope("Focus")) continue;
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration swEnu = this.associator(GraphSwitchGroup2Switch.TYPE, swGroupID);
            while (swEnu.hasMoreElements()) {
                GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(sw)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        fcpIDEnu = this.associatorID(GraphSwitch2FCPort.TYPE, swID);
                        while (fcpIDEnu.hasMoreElements()) {
                            fcpID = (GraphFCPort.ID)fcpIDEnu.nextElement();
                            fcp2fcportEnu = this.reference(GraphFCPort2FCPort.TYPE, fcpID);
                            if (!fcp2fcportEnu.hasMoreElements()) continue;
                            fcp2fcport = (GraphFCPort2FCPort)fcp2fcportEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(fcp2fcport)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            fcportID = fcp2fcport.getFCPort1ID();
                            if (fcportID.equals(fcpID)) {
                                fcportID = fcp2fcport.getFCPort2ID();
                            }
                            if (!GraphModelUtilities.isAbnormal(fcport = (GraphFCPort)this.get(fcportID))) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                sw.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            swGroup.setNumOfSwitches(new Integer(totalCount));
            swGroup.setNumOfAbnormalSwitches(new Integer(unfilteredCount));
            swGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration computerGroupEnu = this.enumerate(GraphComputerGroup.TYPE);
        while (computerGroupEnu.hasMoreElements()) {
            GraphComputerGroup computerGroup = (GraphComputerGroup)computerGroupEnu.nextElement();
            GraphComputerGroup.ID computerGroupID = (GraphComputerGroup.ID)computerGroup.getEntityID();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration computerEnu = this.associator(GraphComputerGroup2Computer.TYPE, computerGroupID);
            while (computerEnu.hasMoreElements()) {
                GraphComputer computer = (GraphComputer)computerEnu.nextElement();
                GraphComputer.ID computerID = (GraphComputer.ID)computer.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(computer)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        fcpIDEnu = this.associatorID(GraphComputer2FCPort.TYPE, computerID);
                        while (fcpIDEnu.hasMoreElements()) {
                            fcpID = (GraphFCPort.ID)fcpIDEnu.nextElement();
                            fcp2fcportEnu = this.reference(GraphFCPort2FCPort.TYPE, fcpID);
                            if (!fcp2fcportEnu.hasMoreElements()) continue;
                            fcp2fcport = (GraphFCPort2FCPort)fcp2fcportEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(fcp2fcport)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            fcportID = fcp2fcport.getFCPort1ID();
                            if (fcportID.equals(fcpID)) {
                                fcportID = fcp2fcport.getFCPort2ID();
                            }
                            if (!GraphModelUtilities.isAbnormal(fcport = (GraphFCPort)this.get(fcportID))) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                computer.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            computerGroup.setNumOfComputers(new Integer(totalCount));
            computerGroup.setNumOfAbnormalComputers(new Integer(unfilteredCount));
            computerGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration subsystemGroupEnu = this.enumerate(GraphSubsystemGroup.TYPE);
        while (subsystemGroupEnu.hasMoreElements()) {
            GraphSubsystemGroup subsystemGroup = (GraphSubsystemGroup)subsystemGroupEnu.nextElement();
            GraphSubsystemGroup.ID subsystemGroupID = (GraphSubsystemGroup.ID)subsystemGroup.getEntityID();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration subsystemEnu = this.associator(GraphSubsystemGroup2Subsystem.TYPE, subsystemGroupID);
            while (subsystemEnu.hasMoreElements()) {
                GraphSubsystem subsystem = (GraphSubsystem)subsystemEnu.nextElement();
                GraphSubsystem.ID subsystemID = (GraphSubsystem.ID)subsystem.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(subsystem)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        fcpIDEnu = this.associatorID(GraphSubsystem2FCPort.TYPE, subsystemID);
                        while (fcpIDEnu.hasMoreElements()) {
                            fcpID = (GraphFCPort.ID)fcpIDEnu.nextElement();
                            fcp2fcportEnu = this.reference(GraphFCPort2FCPort.TYPE, fcpID);
                            if (!fcp2fcportEnu.hasMoreElements()) continue;
                            fcp2fcport = (GraphFCPort2FCPort)fcp2fcportEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(fcp2fcport)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            fcportID = fcp2fcport.getFCPort1ID();
                            if (fcportID.equals(fcpID)) {
                                fcportID = fcp2fcport.getFCPort2ID();
                            }
                            if (!GraphModelUtilities.isAbnormal(fcport = (GraphFCPort)this.get(fcportID))) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                subsystem.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            subsystemGroup.setNumOfSubsystems(new Integer(totalCount));
            subsystemGroup.setNumOfAbnormalSubsystems(new Integer(unfilteredCount));
            subsystemGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration tapeLibraryGroupEnu = this.enumerate(GraphTapeLibraryGroup.TYPE);
        while (tapeLibraryGroupEnu.hasMoreElements()) {
            GraphTapeLibraryGroup tapeLibraryGroup = (GraphTapeLibraryGroup)tapeLibraryGroupEnu.nextElement();
            GraphTapeLibraryGroup.ID tapeLibraryGroupID = (GraphTapeLibraryGroup.ID)tapeLibraryGroup.getEntityID();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration tapeLibraryEnu = this.associator(GraphTapeLibraryGroup2TapeLibrary.TYPE, tapeLibraryGroupID);
            while (tapeLibraryEnu.hasMoreElements()) {
                GraphTapeLibrary tapeLibrary = (GraphTapeLibrary)tapeLibraryEnu.nextElement();
                GraphTapeLibrary.ID tapeLibraryID = (GraphTapeLibrary.ID)tapeLibrary.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(tapeLibrary)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        fcpIDEnu = this.associatorID(GraphTapeLibrary2FCPort.TYPE, tapeLibraryID);
                        while (fcpIDEnu.hasMoreElements()) {
                            fcpID = (GraphFCPort.ID)fcpIDEnu.nextElement();
                            fcp2fcportEnu = this.reference(GraphFCPort2FCPort.TYPE, fcpID);
                            if (!fcp2fcportEnu.hasMoreElements()) continue;
                            fcp2fcport = (GraphFCPort2FCPort)fcp2fcportEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(fcp2fcport)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            fcportID = fcp2fcport.getFCPort1ID();
                            if (fcportID.equals(fcpID)) {
                                fcportID = fcp2fcport.getFCPort2ID();
                            }
                            if (!GraphModelUtilities.isAbnormal(fcport = (GraphFCPort)this.get(fcportID))) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                tapeLibrary.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            tapeLibraryGroup.setNumOfTapeLibraries(new Integer(totalCount));
            tapeLibraryGroup.setNumOfAbnormalTapeLibraries(new Integer(unfilteredCount));
            tapeLibraryGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration otherGroupEnu = this.enumerate(GraphOtherGroup.TYPE);
        while (otherGroupEnu.hasMoreElements()) {
            GraphOtherGroup otherGroup = (GraphOtherGroup)otherGroupEnu.nextElement();
            GraphOtherGroup.ID otherGroupID = (GraphOtherGroup.ID)otherGroup.getEntityID();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration otherEnu = this.associator(GraphOtherGroup2Other.TYPE, otherGroupID);
            while (otherEnu.hasMoreElements()) {
                GraphOther other = (GraphOther)otherEnu.nextElement();
                GraphOther.ID otherID = (GraphOther.ID)other.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(other)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        fcpIDEnu = this.associatorID(GraphOther2FCPort.TYPE, otherID);
                        while (fcpIDEnu.hasMoreElements()) {
                            fcpID = (GraphFCPort.ID)fcpIDEnu.nextElement();
                            fcp2fcportEnu = this.reference(GraphFCPort2FCPort.TYPE, fcpID);
                            if (!fcp2fcportEnu.hasMoreElements()) continue;
                            fcp2fcport = (GraphFCPort2FCPort)fcp2fcportEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(fcp2fcport)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            fcportID = fcp2fcport.getFCPort1ID();
                            if (fcportID.equals(fcpID)) {
                                fcportID = fcp2fcport.getFCPort2ID();
                            }
                            if (!GraphModelUtilities.isAbnormal(fcport = (GraphFCPort)this.get(fcportID))) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                other.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            otherGroup.setNumOfOthers(new Integer(totalCount));
            otherGroup.setNumOfAbnormalOthers(new Integer(unfilteredCount));
            otherGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration connectivityEnu = this.enumerate(GraphSubviewSwitchL2Connectivity.TYPE);
        while (connectivityEnu.hasMoreElements()) {
            GraphSubviewSwitchL2Connectivity connectivity = (GraphSubviewSwitchL2Connectivity)connectivityEnu.nextElement();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration fcportGroupEnu3 = this.enumerate(GraphFCPortGroup.TYPE);
            while (fcportGroupEnu3.hasMoreElements()) {
                GraphFCPortGroup fcportGroup = (GraphFCPortGroup)fcportGroupEnu3.nextElement();
                if (!fcportGroup.containScope("Root")) continue;
                totalCount += fcportGroup.getNumOfFCPortsInUse() + fcportGroup.getNumOfFCPortsEmpty();
                unfilteredCount += fcportGroup.getNumOfAbnormalFCPortsInUse() + fcportGroup.getNumOfAbnormalFCPortsEmpty();
            }
            connectivity.setNumOfFCPorts(new Integer(totalCount));
            connectivity.setNumOfAbnormalFCPorts(new Integer(unfilteredCount));
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration swGroupEnu2 = this.enumerate(GraphSwitchGroup.TYPE);
            while (swGroupEnu2.hasMoreElements()) {
                GraphSwitchGroup swGroup2 = (GraphSwitchGroup)swGroupEnu2.nextElement();
                if (swGroup2.containScope("Focus")) continue;
                totalCount += swGroup2.getNumOfSwitches().intValue();
                unfilteredCount += swGroup2.getNumOfAbnormalSwitches().intValue();
            }
            connectivity.setNumOfSwitches(new Integer(totalCount));
            connectivity.setNumOfAbnormalSwitches(new Integer(unfilteredCount));
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration computerGroupEnu2 = this.enumerate(GraphComputerGroup.TYPE);
            while (computerGroupEnu2.hasMoreElements()) {
                GraphComputerGroup computerGroup = (GraphComputerGroup)computerGroupEnu2.nextElement();
                totalCount += computerGroup.getNumOfComputers().intValue();
                unfilteredCount += computerGroup.getNumOfAbnormalComputers().intValue();
            }
            connectivity.setNumOfComputers(new Integer(totalCount));
            connectivity.setNumOfAbnormalComputers(new Integer(unfilteredCount));
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration subsystemGroupEnu2 = this.enumerate(GraphSubsystemGroup.TYPE);
            while (subsystemGroupEnu2.hasMoreElements()) {
                GraphSubsystemGroup subsystemGroup = (GraphSubsystemGroup)subsystemGroupEnu2.nextElement();
                totalCount += subsystemGroup.getNumOfSubsystems().intValue();
                unfilteredCount += subsystemGroup.getNumOfAbnormalSubsystems().intValue();
            }
            connectivity.setNumOfSubsystems(new Integer(totalCount));
            connectivity.setNumOfAbnormalSubsystems(new Integer(unfilteredCount));
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration tapeLibraryGroupEnu2 = this.enumerate(GraphTapeLibraryGroup.TYPE);
            while (tapeLibraryGroupEnu2.hasMoreElements()) {
                GraphTapeLibraryGroup tapeLibraryGroup = (GraphTapeLibraryGroup)tapeLibraryGroupEnu2.nextElement();
                totalCount += tapeLibraryGroup.getNumOfTapeLibraries().intValue();
                unfilteredCount += tapeLibraryGroup.getNumOfAbnormalTapeLibraries().intValue();
            }
            connectivity.setNumOfTapeLibraries(new Integer(totalCount));
            connectivity.setNumOfAbnormalTapeLibraries(new Integer(unfilteredCount));
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration otherGroupEnu2 = this.enumerate(GraphOtherGroup.TYPE);
            while (otherGroupEnu2.hasMoreElements()) {
                GraphOtherGroup otherGroup = (GraphOtherGroup)otherGroupEnu2.nextElement();
                totalCount += otherGroup.getNumOfOthers().intValue();
                unfilteredCount += otherGroup.getNumOfAbnormalOthers().intValue();
            }
            connectivity.setNumOfOthers(new Integer(totalCount));
            connectivity.setNumOfAbnormalOthers(new Integer(unfilteredCount));
            connectivity.setIsFilterable(Boolean.FALSE);
        }
    }

    public static class ID
    extends GraphModel.ID {
        public ID(GraphSwitch focusEntity) {
            super("SwitchL2", focusEntity.getEntityID());
        }
    }
}

