/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.text.CollationKey;
import java.util.Comparator;
import java.util.Vector;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;

public class GraphModelUtilities {
    public static Comparator DEFAULT_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            GraphEntity entity1 = (GraphEntity)o1;
            GraphEntity entity2 = (GraphEntity)o2;
            if (entity1 == null && entity2 == null) {
                return 0;
            }
            if (entity1 == null) {
                return 1;
            }
            if (entity2 == null) {
                return -1;
            }
            Comparable c1 = entity1.getSortingValue();
            Comparable c2 = entity2.getSortingValue();
            if (c1 != null && c2 != null) {
                return c1.compareTo(c2);
            }
            if (c1 != null) {
                return -1;
            }
            if (c2 != null) {
                return 1;
            }
            CollationKey k1 = entity1.getCollationKey();
            CollationKey k2 = entity2.getCollationKey();
            if (k1 != null && k2 != null) {
                return k1.compareTo(k2);
            }
            if (k1 != null) {
                return -1;
            }
            if (k2 != null) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            return this.equals(obj);
        }
    };
    protected static Long UNIT_KB = new Long(1024L);
    protected static Long UNIT_MB = new Long(0x100000L);
    protected static Long UNIT_GB = new Long(0x40000000L);
    public static final String TOOLTIP_HEALTH_NA = GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_HEALTH") + ": " + GuiUtil.getString("TOPO_LABEL_COMMON_NA");
    public static final String TOOLTIP_HEALTH_UNKNOWN = GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_HEALTH") + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_UNKNOWN");
    public static final String TOOLTIP_HEALTH_NORMAL = GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_HEALTH") + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_NORMAL");
    public static final String TOOLTIP_HEALTH_WARNING = GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_HEALTH") + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_WARNING");
    public static final String TOOLTIP_HEALTH_CRITICAL = GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_HEALTH") + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_CRITICAL");
    public static final String TOOLTIP_HEALTH_MISSING = GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_HEALTH") + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_MISSING");
    public static final String TOOLTIP_PERF_NA = GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_PERF") + ": " + GuiUtil.getString("TOPO_LABEL_COMMON_NA");
    public static final String TOOLTIP_PERF_UNKNOWN = GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_PERF") + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_UNKNOWN");
    public static final String TOOLTIP_PERF_NORMAL = GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_PERF") + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_NORMAL");
    public static final String TOOLTIP_PERF_WARNING = GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_PERF") + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_WARNING");
    public static final String TOOLTIP_PERF_CRITICAL = GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_PERF") + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_CRITICAL");
    public static final String TOOLTIP_PERF_MISSING = GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_PERF") + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_MISSING");
    public static final String TOOLTIP_PIN_TRUE = GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_PINNED");
    public static final String TOOLTIP_PIN_FALSE = null;

    public static boolean isAbnormal(GraphEntity entity) {
        return entity.getHealthStatus() != null && !entity.getHealthStatus().equals(GraphModelConstant.STATUS_UNKNOWN) && !entity.getHealthStatus().equals(GraphModelConstant.STATUS_NORMAL);
    }

    public static Integer aggregateStatus(Integer oldStatus, Integer newStatus) {
        if (oldStatus == null) {
            return newStatus;
        }
        if (newStatus == null) {
            return oldStatus;
        }
        if (oldStatus.equals(newStatus)) {
            return oldStatus;
        }
        if (GraphModelConstant.STATUS_UNKNOWN.equals(oldStatus) && GraphModelConstant.STATUS_NORMAL.equals(newStatus) || GraphModelConstant.STATUS_UNKNOWN.equals(newStatus) && GraphModelConstant.STATUS_NORMAL.equals(oldStatus)) {
            return GraphModelConstant.STATUS_NORMAL;
        }
        if (GraphModelConstant.STATUS_MISSING.equals(oldStatus) && GraphModelConstant.STATUS_CRITICAL.equals(newStatus) || GraphModelConstant.STATUS_MISSING.equals(newStatus) && GraphModelConstant.STATUS_CRITICAL.equals(oldStatus)) {
            return GraphModelConstant.STATUS_CRITICAL;
        }
        return GraphModelConstant.STATUS_WARNING;
    }

    public static Integer aggregateHealthStatus(Vector entityV) {
        Integer healthStatus = null;
        for (int i = 0; i < entityV.size(); ++i) {
            GraphEntity entity = (GraphEntity)entityV.elementAt(i);
            healthStatus = GraphModelUtilities.aggregateStatus(healthStatus, entity.getHealthStatus());
        }
        return healthStatus;
    }

    public static Integer aggregatePerfStatus(Vector entityV) {
        Integer perfStatus = null;
        for (int i = 0; i < entityV.size(); ++i) {
            GraphEntity entity = (GraphEntity)entityV.elementAt(i);
            perfStatus = GraphModelUtilities.aggregateStatus(perfStatus, entity.getPerfStatus());
        }
        return perfStatus;
    }

    public static String getBooleanStr(Boolean b) {
        if (b == null) {
            return null;
        }
        if (b.booleanValue()) {
            return GuiUtil.getString("TOPO_LABEL_COMMON_TRUE");
        }
        return GuiUtil.getString("TOPO_LABEL_COMMON_FALSE");
    }

    public static String byte2ByteString(Long byteValue) {
        if (byteValue == null) {
            return null;
        }
        return byteValue.toString();
    }

    public static String byte2KBString(Long byteValue) {
        if (byteValue == null) {
            return null;
        }
        double d = byteValue.doubleValue() / UNIT_KB.doubleValue();
        double a = 0.0;
        double p = 100.0;
        while (a == 0.0 && d != 0.0) {
            a = Math.rint(d * p) / p;
            if (!((p *= 10.0) > UNIT_KB.doubleValue())) continue;
            a = d;
            break;
        }
        return String.valueOf(a);
    }

    public static String byte2MBString(Long byteValue) {
        if (byteValue == null) {
            return null;
        }
        double d = byteValue.doubleValue() / UNIT_MB.doubleValue();
        double a = 0.0;
        double p = 100.0;
        while (a == 0.0 && d != 0.0) {
            a = Math.rint(d * p) / p;
            if (!((p *= 10.0) > UNIT_MB.doubleValue())) continue;
            a = d;
            break;
        }
        return String.valueOf(a);
    }

    public static String byte2GBString(Long byteValue) {
        if (byteValue == null) {
            return null;
        }
        double d = byteValue.doubleValue() / UNIT_GB.doubleValue();
        double a = 0.0;
        double p = 100.0;
        while (a == 0.0 && d != 0.0) {
            a = Math.rint(d * p) / p;
            if (!((p *= 10.0) > UNIT_GB.doubleValue())) continue;
            a = d;
            break;
        }
        return String.valueOf(a);
    }

    public static String formatInteger(Integer value) {
        return value == null ? "" : value.toString();
    }

    public static String formatDouble(Double value) {
        String s = "";
        if (value != null) {
            s = String.valueOf((double)Math.round(value * 100.0) / 100.0);
        }
        return s;
    }

    public static String getSubsystemType(String typeStr) {
        if (typeStr == null) {
            return null;
        }
        String resultType = null;
        String prefix = "OTHER:";
        if (typeStr.startsWith(prefix)) {
            String s = typeStr.substring(prefix.length());
            try {
                resultType = GraphModelUtilities.getOtherType(new Integer(s));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            resultType = typeStr.equals("ESS") ? GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_ESS") : (typeStr.equals("DS6000") ? GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_DS6000") : (typeStr.equals("DS8000") ? GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_DS8000") : (typeStr.equals("SVC") ? GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_SVC") : (typeStr.equals("FAStT") ? GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_FASTT") : (typeStr.equals("HDS") ? GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_HDS") : (typeStr.equals("EMC") ? GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_EMC") : GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_OTHER")))))));
        }
        return resultType;
    }

    public static String getOtherType(Integer type) {
        if (type == null) {
            return null;
        }
        String res = null;
        res = type >= 30 ? FabricGuiUtil.getPeTypeString(type) : FabricGuiUtil.getNodeTypeString(type);
        return res;
    }

    public static String getOperationalStatus(Integer operationalStatus) {
        if (operationalStatus == null) {
            return null;
        }
        Vector<String> multiStatus = new Vector<String>();
        try {
            int opInt = operationalStatus;
            int bitlength = 19;
            for (int i = bitlength - 1; i >= 0; --i) {
                double bitValue = Math.pow(2.0, i);
                double division = (double)opInt / bitValue;
                if (!(division >= 1.0)) continue;
                multiStatus.addElement(String.valueOf(i));
                opInt = (int)((double)opInt - bitValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Vector<String> v = new Vector<String>();
        for (String value : multiStatus) {
            String key = null;
            if (value.equals("0")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_UKNOWN");
            } else if (value.equals("1")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_OTHER");
            } else if (value.equals("2")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_OPERATIONAL");
            } else if (value.equals("3")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_DEGRADED");
            } else if (value.equals("4")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_STRESSED");
            } else if (value.equals("5")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_PREDICTIVE_ERROR");
            } else if (value.equals("6")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_ERROR");
            } else if (value.equals("7")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_NONRECOVERABLE_ERROR");
            } else if (value.equals("8")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_STARTING");
            } else if (value.equals("9")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_STOPPING");
            } else if (value.equals("10")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_STOPPED");
            } else if (value.equals("11")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_IN_SERVICE");
            } else if (value.equals("12")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_NO_CONTACT");
            } else if (value.equals("13")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_LOST_COMMUNICATION");
            } else if (value.equals("14")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_ABORTED");
            } else if (value.equals("15")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_DORMANT");
            } else if (value.equals("16")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_SUPPORTING_ENTITY_IN_ERROR");
            } else if (value.equals("17")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_COMPLETED");
            } else if (value.equals("18")) {
                key = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_POWER_MODE");
            }
            if (key == null) continue;
            v.add(key);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < v.size(); ++i) {
            String s = (String)v.elementAt(i);
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String getStatusAlias(Integer status) {
        String s = null;
        if (status == null || GraphModelConstant.STATUS_NA.equals(status)) {
            s = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
        } else if (GraphModelConstant.STATUS_UNKNOWN.equals(status)) {
            s = GuiUtil.getString("TOPO_LABEL_STATUS_UNKNOWN");
        } else if (GraphModelConstant.STATUS_NORMAL.equals(status)) {
            s = GuiUtil.getString("TOPO_LABEL_STATUS_NORMAL");
        } else if (GraphModelConstant.STATUS_WARNING.equals(status)) {
            s = GuiUtil.getString("TOPO_LABEL_STATUS_WARNING");
        } else if (GraphModelConstant.STATUS_CRITICAL.equals(status)) {
            s = GuiUtil.getString("TOPO_LABEL_STATUS_CRITICAL");
        } else if (GraphModelConstant.STATUS_MISSING.equals(status)) {
            s = GuiUtil.getString("TOPO_LABEL_STATUS_MISSING");
        }
        return s;
    }

    public static String getTooltipHealth(Integer status) {
        String s = null;
        if (status == null || GraphModelConstant.STATUS_NA.equals(status)) {
            s = TOOLTIP_HEALTH_NA;
        } else if (GraphModelConstant.STATUS_UNKNOWN.equals(status)) {
            s = TOOLTIP_HEALTH_UNKNOWN;
        } else if (GraphModelConstant.STATUS_NORMAL.equals(status)) {
            s = TOOLTIP_HEALTH_NORMAL;
        } else if (GraphModelConstant.STATUS_WARNING.equals(status)) {
            s = TOOLTIP_HEALTH_WARNING;
        } else if (GraphModelConstant.STATUS_CRITICAL.equals(status)) {
            s = TOOLTIP_HEALTH_CRITICAL;
        } else if (GraphModelConstant.STATUS_MISSING.equals(status)) {
            s = TOOLTIP_HEALTH_MISSING;
        }
        return s;
    }

    public static String getTooltipPerf(Integer status) {
        String s = null;
        if (status == null || GraphModelConstant.STATUS_NA.equals(status)) {
            s = TOOLTIP_PERF_NA;
        } else if (GraphModelConstant.STATUS_UNKNOWN.equals(status)) {
            s = TOOLTIP_PERF_UNKNOWN;
        } else if (GraphModelConstant.STATUS_NORMAL.equals(status)) {
            s = TOOLTIP_PERF_NORMAL;
        } else if (GraphModelConstant.STATUS_WARNING.equals(status)) {
            s = TOOLTIP_PERF_WARNING;
        } else if (GraphModelConstant.STATUS_CRITICAL.equals(status)) {
            s = TOOLTIP_PERF_CRITICAL;
        } else if (GraphModelConstant.STATUS_MISSING.equals(status)) {
            s = TOOLTIP_PERF_MISSING;
        }
        return s;
    }

    public static String getTooltipPin(boolean b) {
        return b ? TOOLTIP_PIN_TRUE : TOOLTIP_PIN_FALSE;
    }

    public static String getViewAlias(String focusLevel) {
        String s = null;
        if (focusLevel != null) {
            if ("Overview".equals(focusLevel)) {
                s = GuiUtil.getString("TOPO_LABEL_VIEW_OVERVIEW");
            } else if ("FabricL0".equals(focusLevel)) {
                s = GuiUtil.getString("TOPO_LABEL_VIEW_L0FABRIC");
            } else if ("FabricL1".equals(focusLevel)) {
                s = GuiUtil.getString("TOPO_LABEL_VIEW_L1FABRIC");
            } else if ("FabricL2".equals(focusLevel)) {
                s = GuiUtil.getString("TOPO_LABEL_VIEW_L2FABRIC");
            } else if ("ComputerL0".equals(focusLevel)) {
                s = GuiUtil.getString("TOPO_LABEL_VIEW_L0COMPUTER");
            } else if ("ComputerL1".equals(focusLevel)) {
                s = GuiUtil.getString("TOPO_LABEL_VIEW_L1COMPUTER");
            } else if ("ComputerL2".equals(focusLevel)) {
                s = GuiUtil.getString("TOPO_LABEL_VIEW_L2COMPUTER");
            } else if ("SwitchL0".equals(focusLevel)) {
                s = GuiUtil.getString("TOPO_LABEL_VIEW_L0SWITCH");
            } else if ("SwitchL1".equals(focusLevel)) {
                s = GuiUtil.getString("TOPO_LABEL_VIEW_L1SWITCH");
            } else if ("SwitchL2".equals(focusLevel)) {
                s = GuiUtil.getString("TOPO_LABEL_VIEW_L2SWITCH");
            } else if ("StorageL0".equals(focusLevel)) {
                s = GuiUtil.getString("TOPO_LABEL_VIEW_L0STORAGE");
            } else if ("SubsystemL1".equals(focusLevel)) {
                s = GuiUtil.getString("TOPO_LABEL_VIEW_L1SUBSYSTEM");
            } else if ("SubsystemL2".equals(focusLevel)) {
                s = GuiUtil.getString("TOPO_LABEL_VIEW_L2SUBSYSTEM");
            } else if ("TapeLibraryL1".equals(focusLevel)) {
                s = GuiUtil.getString("TOPO_LABEL_VIEW_L1TAPELIBRARY");
            } else if ("TapeLibraryL2".equals(focusLevel)) {
                s = GuiUtil.getString("TOPO_LABEL_VIEW_L2TAPELIBRARY");
            } else if ("OtherL0".equals(focusLevel)) {
                s = GuiUtil.getString("TOPO_LABEL_VIEW_L0OTHER");
            } else if ("OtherL1".equals(focusLevel)) {
                s = GuiUtil.getString("TOPO_LABEL_VIEW_L1OTHER");
            } else if ("OtherL2".equals(focusLevel)) {
                s = GuiUtil.getString("TOPO_LABEL_VIEW_L2OTHER");
            }
        }
        return s;
    }
}

