/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.tool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class BeanGenerator {
    private static final String PREFIX = "Graph";

    public static void main(String[] args) {
        try {
            String defFile = "com/ibm/tpc/gui/topo/tool/GraphModel.txt";
            Vector defV = BeanGenerator.parse(defFile);
            String outDir = "com/ibm/tpc/gui/topo/model/bean";
            BeanGenerator.generateModel(outDir, defV);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void generateModel(String outDir, Vector defV) throws Exception {
        File outDirF = new File(outDir);
        for (int i = 0; i < defV.size(); ++i) {
            String variable;
            Property p;
            int j;
            String type;
            int j2;
            ClassDef def = (ClassDef)defV.elementAt(i);
            Vector propertyV = def.getProperties();
            Vector constantV = def.getConstants();
            String className = def.getClassName();
            String parentClassName = def.getParentClassName();
            boolean isAssoc = def.isAssociation;
            File f = new File(outDir, className + ".java");
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(f)));
            String copyright = "/****************************************** {COPYRIGHT-TOP} **\r\n* Aperi Storage Manager\r\n* (C) Copyright IBM Corp. 2005, 2006\r\n* All rights reserved. This program and the accompanying materials\r\n* are made available under the terms of the Eclipse Public License v1.0\r\n* which accompanies this distribution, and is available at\r\n* http://www.eclipse.org/legal/epl-v10.html\r\n******************************************* {COPYRIGHT-END} **/\r\n";
            pw.println(copyright);
            String packageName = outDir.replace('/', '.');
            pw.println("package " + packageName + ";");
            pw.println();
            String modelPackageName = packageName.substring(0, packageName.lastIndexOf(46));
            pw.println("import " + modelPackageName + ".GraphEntity;");
            if (isAssoc) {
                pw.println("import " + modelPackageName + ".GraphAssociation;");
            }
            for (j2 = 0; j2 < propertyV.size(); ++j2) {
                Property p2 = (Property)propertyV.elementAt(j2);
                type = p2.getType();
                if (!type.equals("Vector")) continue;
                pw.println("import java.util.Vector;");
                break;
            }
            pw.println();
            if (className.equals("GraphAssociation")) {
                pw.println("public class " + className + " extends " + parentClassName + " implements IGraphAssociativeEntity {");
            } else {
                pw.println("public class " + className + " extends " + parentClassName + " {");
            }
            pw.println("\tpublic static final GraphEntity.Type TYPE = new Type(\"" + className + "\", " + (isAssoc ? "true" : "false") + ");");
            pw.println();
            for (j2 = 0; j2 < constantV.size(); ++j2) {
                Constant c = (Constant)constantV.elementAt(j2);
                type = c.getType();
                String name = c.getName();
                String value = c.getValue();
                pw.println("\tpublic static final " + type + " " + name + " = new " + type + "(" + value + ");");
            }
            pw.println();
            int count = 0;
            for (j = 0; j < propertyV.size(); ++j) {
                p = (Property)propertyV.elementAt(j);
                boolean isParentVariableReused = p.isParentVariableReused();
                if (!isParentVariableReused) {
                    String type2 = p.getType();
                    String variable2 = p.getVariable();
                    pw.println("\tprotected " + type2 + " " + variable2 + ";");
                }
                ++count;
            }
            pw.println();
            pw.println("\tpublic " + className + "() {");
            pw.println("\t\tthis((String)null);");
            pw.println("\t}");
            pw.println();
            pw.println("\tpublic " + className + "(String id) {");
            pw.println("\t\tthis(new ID(id));");
            pw.println("\t}");
            pw.println();
            pw.println("\tpublic " + className + "(GraphEntity.ID entityID) {");
            pw.println("\t\tsuper(entityID);");
            pw.println("\t}");
            pw.println();
            pw.println("\tprotected void toString_helper(StringBuffer sb) {");
            pw.println("\t\tsuper.toString_helper(sb);");
            for (j = 0; j < propertyV.size(); ++j) {
                p = (Property)propertyV.elementAt(j);
                String type3 = p.getType();
                String name = p.getName();
                boolean isParentVaribleReused = p.isParentVariableReused();
                variable = p.getVariable();
                if (isParentVaribleReused) {
                    pw.println("\t\tsb.append(\"" + name + "=\"+(" + type3 + ")" + variable + "+\",\");");
                    continue;
                }
                pw.println("\t\tsb.append(\"" + name + "=\"+" + variable + "+\",\");");
            }
            pw.println("\t}");
            pw.println();
            pw.println("\tpublic Object clone() {");
            pw.println("\t\t" + className + " o = new " + className + "((" + className + ".ID)entityID.clone());");
            pw.println("\t\tclone_helper(o);");
            pw.println("\t\treturn o;");
            pw.println("\t}");
            pw.println();
            pw.println("\tprotected void clone_helper(GraphEntity entity) {");
            pw.println("\t\tsuper.clone_helper(entity);");
            pw.println("\t\t" + className + " o = (" + className + ")entity;");
            for (j = 0; j < propertyV.size(); ++j) {
                p = (Property)propertyV.elementAt(j);
                String name = p.getName();
                boolean isParentVaribleReused = p.isParentVariableReused();
                String variable3 = p.getVariable();
                if (isParentVaribleReused) {
                    pw.println("\t\to.set" + name + "(get" + name + "());");
                    continue;
                }
                pw.println("\t\to.set" + name + "(" + variable3 + ");");
            }
            pw.println("\t}");
            pw.println();
            for (j = 0; j < propertyV.size(); ++j) {
                p = (Property)propertyV.elementAt(j);
                String type4 = p.getType();
                String name = p.getName();
                boolean isParentVaribleReused = p.isParentVariableReused();
                variable = p.getVariable();
                pw.println("\tpublic " + type4 + " get" + name + "() {");
                if (isParentVaribleReused) {
                    pw.println("\t\treturn (" + type4 + ")" + variable + ";");
                } else {
                    pw.println("\t\treturn " + variable + ";");
                }
                pw.println("\t}");
                pw.println();
                pw.println("\tpublic void set" + name + "(" + type4 + " value) {");
                pw.println("\t\tthis." + variable + " = value;");
                pw.println("\t}");
                pw.println();
                if (!isAssoc) continue;
                String nodeType = type4.substring(0, type4.length() - 3);
                pw.println("\tpublic void set" + name + "(" + nodeType + " value) {");
                pw.println("\t\tthis." + variable + " = value.getEntityID();");
                pw.println("\t}");
                pw.println();
            }
            pw.println("\tpublic static class ID extends " + parentClassName + ".ID {");
            pw.println("\t\tpublic ID() {");
            pw.println("\t\t\tthis(null);");
            pw.println("\t\t}");
            pw.println();
            pw.println("\t\tpublic ID(String id) {");
            pw.println("\t\t\tthis(TYPE, id);");
            pw.println("\t\t}");
            pw.println();
            pw.println("\t\tprotected ID(GraphEntity.Type entityType, String id) {");
            pw.println("\t\t\tsuper(entityType, id);");
            pw.println("\t\t}");
            pw.println();
            pw.println("\t\tpublic Object clone() {");
            pw.println("\t\t\treturn new ID((String)id);");
            pw.println("\t\t}");
            pw.println("\t}");
            pw.println();
            pw.println("}");
            pw.flush();
            pw.close();
            System.out.println("generate " + className);
        }
    }

    private static Vector parse(String fileName) throws Exception {
        String aLine;
        Vector<ClassDef> defV = new Vector<ClassDef>();
        File f = new File(fileName);
        BufferedReader br = new BufferedReader(new FileReader(f));
        ClassDef currentDef = null;
        while ((aLine = br.readLine()) != null) {
            String name;
            StringTokenizer st;
            System.out.println("aLine=" + aLine);
            if ((aLine = aLine.trim()).startsWith("//") || aLine.equals("")) continue;
            if (aLine.startsWith("class")) {
                String tag;
                if (currentDef != null) {
                    defV.add(currentDef);
                }
                st = new StringTokenizer(aLine, " \t\r\n");
                String s = st.nextToken();
                String className = st.nextToken();
                String parentClassName = null;
                st.nextToken();
                parentClassName = st.nextToken();
                boolean isAssociation = false;
                if (st.hasMoreTokens() && (tag = st.nextToken()).equalsIgnoreCase("[assocication]")) {
                    isAssociation = true;
                }
                currentDef = new ClassDef(className, parentClassName, isAssociation);
                continue;
            }
            st = new StringTokenizer(aLine, " \t\r\n");
            boolean isRef = false;
            String type = st.nextToken();
            if (type.equalsIgnoreCase("constant")) {
                type = st.nextToken();
                name = st.nextToken();
                st.nextToken();
                String value = st.nextToken();
                Constant c = new Constant(type, name, value);
                currentDef.addConstant(c);
                continue;
            }
            if (type.equalsIgnoreCase("ref")) {
                isRef = true;
                type = st.nextToken();
            } else if (type.equalsIgnoreCase("constant")) {
                // empty if block
            }
            name = st.nextToken();
            String reusedVariable = null;
            if (st.hasMoreTokens()) {
                reusedVariable = st.nextToken();
            }
            Property p = new Property(type, isRef, name, reusedVariable);
            currentDef.addProperty(p);
        }
        if (currentDef != null) {
            defV.add(currentDef);
        }
        br.close();
        return defV;
    }

    private static class Property {
        private String type;
        private boolean isRef;
        private String name;
        private String variable;
        private boolean isParentVariableReused;

        public Property(String type, boolean isRef, String name, String reusedVariable) {
            this.type = isRef ? BeanGenerator.PREFIX + type : type;
            this.isRef = isRef;
            this.name = name;
            this.isParentVariableReused = reusedVariable != null;
            this.variable = this.isParentVariableReused ? reusedVariable : name;
        }

        public String toString() {
            return "(" + this.type + "," + this.isRef + "," + this.name + "," + this.variable + ")";
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean isRef() {
            return this.isRef;
        }

        public void setRef(boolean isRef) {
            this.isRef = isRef;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVariable() {
            return this.variable;
        }

        public void setVariable(String variable) {
            this.variable = variable;
        }

        public boolean isParentVariableReused() {
            return this.isParentVariableReused;
        }

        public void setParentVaribleReused(boolean b) {
            this.isParentVariableReused = b;
        }
    }

    private static class Constant {
        private String type;
        private String name;
        private String value;

        public Constant(String type, String name, String value) {
            this.type = type;
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return "(" + this.type + "," + this.name + "," + this.value + ")";
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    private static class ClassDef {
        private String className;
        private String parentClassName;
        private boolean isAssociation;
        private Vector propertyV;
        private Vector constantV;

        public ClassDef(String className, String parentClassName, boolean isAssociation) {
            this.className = BeanGenerator.PREFIX + className;
            this.parentClassName = BeanGenerator.PREFIX + parentClassName;
            this.isAssociation = isAssociation;
            this.propertyV = new Vector();
            this.constantV = new Vector();
        }

        public String toString() {
            return this.className + "(parentClassName=" + this.parentClassName + ", propertyV=" + this.propertyV + ", constantV=" + this.constantV + ")";
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getParentClassName() {
            return this.parentClassName;
        }

        public void setParentClassName(String parentClassName) {
            this.parentClassName = parentClassName;
        }

        public boolean isAssociation() {
            return this.isAssociation;
        }

        public void setAssociation(boolean b) {
            this.isAssociation = b;
        }

        public void addProperty(Property p) {
            this.propertyV.add(p);
        }

        public Vector getProperties() {
            return this.propertyV;
        }

        public void addConstant(Constant c) {
            this.constantV.add(c);
        }

        public Vector getConstants() {
            return this.constantV;
        }
    }
}

