/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.border.LineBorder;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoNode;
import org.eclipse.aperi.gui.topo.widget.ITopoEntityModel;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public abstract class AbstractJTopoIcon
extends AbstractJTopoNode {
    public static final int LABELMODE_COMPACT = 0;
    public static final int LABELMODE_RELAX = 1;
    public static final int LABELMODE_FULL = 2;
    protected static final int GAP3 = 3;
    protected int maxLabelWidth_compact = 60;
    protected int maxLabelWidth_relax = 180;
    protected String strLabel;
    protected String tooltipLabel;
    protected String tooltipHealth;
    protected String tooltipPerf;
    protected String tooltipPin;
    protected ImageIcon iconType;
    protected ImageIcon iconHealth;
    protected ImageIcon iconPerf;
    protected ImageIcon iconPin;
    protected boolean isOverlayHealthEnabled;
    protected boolean isOverlayPerfEnabled;
    protected int labelMode;
    protected String clippedStrLabel;
    protected Point strLabelP = new Point();
    protected Rectangle strLabelR = new Rectangle();
    protected Rectangle iconTypeR = new Rectangle();
    protected Rectangle iconHealthR = new Rectangle();
    protected Rectangle iconPerfR = new Rectangle();
    protected Rectangle iconPinR = new Rectangle();
    protected Dimension preferredSizeD = new Dimension();

    protected AbstractJTopoIcon() {
        this((ITopoNodeModel)null, true);
    }

    protected AbstractJTopoIcon(ITopoNodeModel nodeModel, boolean isWidgetModelListener) {
        super(nodeModel, isWidgetModelListener);
        this.setToolTipText("");
        this.initState();
    }

    private void initState() {
        this.strLabel = null;
        this.tooltipLabel = null;
        this.tooltipHealth = null;
        this.tooltipPerf = null;
        this.tooltipPin = null;
        this.iconType = null;
        this.iconHealth = null;
        this.iconPerf = null;
        this.iconPin = null;
        this.labelMode = 0;
        this.clippedStrLabel = null;
        this.strLabelP.setLocation(0, 0);
        this.strLabelR.setBounds(0, 0, 0, 0);
        this.iconTypeR.setBounds(0, 0, 0, 0);
        this.iconHealthR.setBounds(0, 0, 0, 0);
        this.iconPerfR.setBounds(0, 0, 0, 0);
        this.iconPinR.setBounds(0, 0, 0, 0);
        this.preferredSizeD.setSize(0, 0);
    }

    public void resetState() {
        super.resetState();
        this.initState();
    }

    public void modelChanged() {
        this.modelChanged_setLabel();
        this.modelChanged_setTooltip();
        this.modelChanged_setHealth();
        this.modelChanged_setPerf();
        this.modelChanged_setPin();
        this.modelChanged_setSelection();
        this.modelChanged_setHighlight();
        this.revalidate();
        this.repaint();
    }

    public void selectionChanged() {
        this.modelChanged_setSelection();
        this.repaint();
    }

    public void highlightChanged() {
        this.modelChanged_setHighlight();
        this.repaint();
    }

    public void pinChanged() {
        this.modelChanged_setPin();
        this.revalidate();
        this.repaint();
    }

    protected void modelChanged_setLabel() {
        ITopoEntityModel entityModel = (ITopoEntityModel)this.widgetModel;
        this.strLabel = entityModel.getLabel();
    }

    protected void modelChanged_setTooltip() {
        ITopoEntityModel entityModel = (ITopoEntityModel)this.widgetModel;
        String label = entityModel.getLabel();
        String type = entityModel.getType();
        StringBuffer sb = new StringBuffer();
        sb.append(type);
        sb.append(": ");
        sb.append(label);
        this.tooltipLabel = sb.toString();
    }

    protected void modelChanged_setHealth() {
        if (this.isOverlayHealthEnabled) {
            ITopoEntityModel entityModel = (ITopoEntityModel)this.widgetModel;
            Integer health = entityModel.getHealth();
            this.iconHealth = TopoResource.getIconHealth(health);
            this.tooltipHealth = GraphModelUtilities.getTooltipHealth(health);
        } else {
            this.iconHealth = null;
        }
    }

    protected void modelChanged_setPerf() {
        if (this.isOverlayPerfEnabled) {
            ITopoEntityModel entityModel = (ITopoEntityModel)this.widgetModel;
            Integer perf = entityModel.getPerf();
            this.iconPerf = TopoResource.getIconPerf(perf);
            this.tooltipPerf = entityModel.getPerfTooltip();
            if (this.tooltipPerf == null) {
                this.tooltipPerf = GraphModelUtilities.getTooltipPerf(perf);
            }
        } else {
            this.iconPerf = null;
        }
    }

    protected void modelChanged_setPin() {
        ITopoEntityModel entityModel = (ITopoEntityModel)this.widgetModel;
        boolean isPinned = entityModel.isPinned();
        this.iconPin = isPinned ? TopoResource.ICON_PIN_ON : null;
        this.tooltipPin = GraphModelUtilities.getTooltipPin(isPinned);
    }

    protected void modelChanged_setSelection() {
        ITopoNodeModel nodeModel = (ITopoNodeModel)this.widgetModel;
        this.iconType = nodeModel.isSelected() ? nodeModel.getIconSelected() : (GraphModelConstant.STATUS_MISSING.equals(nodeModel.getHealth()) ? nodeModel.getIconMissing() : nodeModel.getIconUnselected());
    }

    protected void modelChanged_setHighlight() {
        ITopoEntityModel entityModel = (ITopoEntityModel)this.widgetModel;
        LineBorder border = null;
        border = entityModel.isHighlighted() ? TopoResource.BORDER_HIGHLIGHTED : TopoResource.BORDER_UNHIGHLIGHTED;
        this.setBorder(border);
    }

    protected void handleMouseClick(MouseEvent e) {
        Point p = e.getPoint();
        if (this.strLabelR.contains(p) || this.iconTypeR.contains(p) || this.iconHealthR.contains(p) || this.iconPerfR.contains(p) || this.iconPinR.contains(p)) {
            this.handleMouseClick_regular(e);
        } else {
            this.handleMouseClick_background(e);
        }
    }

    public String getToolTipText(MouseEvent e) {
        Point p = e.getPoint();
        String s = null;
        if (this.strLabelR.contains(p)) {
            s = this.tooltipLabel;
        } else if (this.iconHealthR.contains(p)) {
            s = this.tooltipHealth;
        } else if (this.iconPerfR.contains(p)) {
            s = this.tooltipPerf;
        } else if (this.iconPinR.contains(p)) {
            s = this.tooltipPin;
        }
        return s;
    }

    protected Point getConnectingPoint() {
        Point p = null;
        p = this.iconType != null ? new Point(this.getX() + this.iconTypeR.x + this.iconTypeR.width / 2, this.getY() + this.iconTypeR.y + this.iconTypeR.height / 2) : super.getConnectingPoint();
        return p;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return this.preferredSizeD;
    }

    public void invalidate() {
        super.invalidate();
        this.layoutItself();
    }

    protected void layoutItself() {
        try {
            Graphics g = this.getGraphics();
            if (g == null) {
                return;
            }
            if (this.focusEntity == null) {
                return;
            }
            g.setFont(TopoResource.FONT_PLAIN);
            FontMetrics fm = g.getFontMetrics();
            int strLabelW = 0;
            int strLabelH = 0;
            int strOffset = 0;
            if (this.strLabel != null) {
                strLabelW = fm.stringWidth(this.strLabel);
                strLabelH = fm.getHeight();
                strOffset = fm.getAscent();
            }
            Insets insets = this.getInsets();
            int minimumTopWidth = 28 + this.iconType.getIconWidth();
            int minimumTopHeight = 19 > this.iconType.getIconHeight() ? 20 : this.iconType.getIconHeight();
            minimumTopHeight = minimumTopHeight;
            int totalWidth = insets.left + insets.right;
            int totalHeight = insets.top + insets.bottom;
            int w = 0;
            w = this.labelMode == 0 ? this.maxLabelWidth_compact : (this.labelMode == 1 ? (strLabelW < this.maxLabelWidth_relax ? strLabelW : this.maxLabelWidth_relax) : strLabelW);
            int n = w > minimumTopWidth ? w : minimumTopWidth;
            totalHeight += minimumTopHeight;
            this.preferredSizeD = new Dimension(totalWidth += n, totalHeight += strLabelH);
            totalWidth = this.getWidth();
            totalHeight = this.getHeight();
            if (totalWidth != 0 && totalHeight != 0) {
                int nextX = insets.left;
                int nextY = insets.top;
                int offsetX = totalWidth - insets.left - insets.right;
                nextX += (offsetX -= minimumTopWidth) > 0 ? offsetX / 2 : 0;
                if (this.iconHealth != null) {
                    this.iconHealthR.setBounds(nextX, nextY, this.iconHealth.getIconWidth(), this.iconHealth.getIconHeight());
                } else {
                    this.iconHealthR.setBounds(0, 0, 0, 0);
                }
                if (this.iconPerf != null) {
                    this.iconPerfR.setBounds(nextX, nextY + 11, this.iconPerf.getIconWidth(), this.iconPerf.getIconHeight());
                } else {
                    this.iconPerfR.setBounds(0, 0, 0, 0);
                }
                this.iconTypeR.setBounds(nextX += 11, nextY, this.iconType.getIconWidth(), this.iconType.getIconHeight());
                nextX += this.iconType.getIconWidth() + 3;
                if (this.iconPin != null) {
                    this.iconPinR.setBounds(nextX, nextY, this.iconPin.getIconWidth(), this.iconPin.getIconHeight());
                } else {
                    this.iconPinR.setBounds(0, 0, 0, 0);
                }
                nextX = insets.left;
                nextY += minimumTopHeight;
                if (this.strLabel != null) {
                    int max = totalWidth - insets.left - insets.right;
                    offsetX = max - strLabelW;
                    this.strLabelP.setLocation(nextX += offsetX > 0 ? offsetX / 2 : 0, nextY + strOffset);
                    this.strLabelR.setBounds(nextX, nextY, offsetX > 0 ? strLabelW : max, strLabelH);
                    if (offsetX < 0) {
                        String s;
                        int w2;
                        this.clippedStrLabel = "";
                        for (int i = 0; i < this.strLabel.length() && (w2 = fm.stringWidth(s = this.strLabel.substring(0, i) + "...")) <= max; ++i) {
                            this.clippedStrLabel = s;
                        }
                    } else {
                        this.clippedStrLabel = this.strLabel;
                    }
                } else {
                    this.strLabelR.setBounds(0, 0, 0, 0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.iconHealth != null) {
            this.iconHealth.paintIcon(this, g, this.iconHealthR.x, this.iconHealthR.y);
        }
        if (this.iconPerf != null) {
            this.iconPerf.paintIcon(this, g, this.iconPerfR.x, this.iconPerfR.y);
        }
        if (this.iconType != null) {
            this.iconType.paintIcon(this, g, this.iconTypeR.x, this.iconTypeR.y);
        }
        if (this.iconPin != null) {
            this.iconPin.paintIcon(this, g, this.iconPinR.x, this.iconPinR.y);
        }
        if (this.strLabel != null) {
            g.setFont(TopoResource.FONT_PLAIN);
            g.setColor(TopoResource.COLOR_FONT);
            g.drawString(this.clippedStrLabel, this.strLabelP.x, this.strLabelP.y);
        }
    }

    public void setOverlayHealthEnabled(boolean b) {
        this.isOverlayHealthEnabled = b;
        this.modelChanged_setHealth();
        this.revalidate();
        this.repaint();
    }

    public void setOverlayPerfEnabled(boolean b) {
        this.isOverlayPerfEnabled = b;
        this.modelChanged_setPerf();
        this.revalidate();
        this.repaint();
    }

    public void setArrange(AbstractJTopoCanvas.ArrangeRecord r) {
    }

    public void setLabelMode(int mode) {
        this.labelMode = mode;
    }

    protected LayoutManager createDefaultLayout() {
        return null;
    }
}

