/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.JLabel;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoUnit;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;

public abstract class AbstractJTopoSummary
extends AbstractJTopoUnit {
    protected Vector summaryLabelV = new Vector();

    protected AbstractJTopoSummary() {
        this((ITopoGroupModel)null, true);
    }

    protected AbstractJTopoSummary(ITopoGroupModel groupModel, boolean isWidgetModelListener) {
        super(groupModel, isWidgetModelListener);
        this.initState();
    }

    private void initState() {
        this.summaryLabelV.clear();
        this.removeAll();
    }

    public void resetState() {
        super.resetState();
        this.initState();
    }

    protected Object createWidgetModel() {
        return new DefaultTopoGroupModel();
    }

    public void modelChanged() {
        this.modelChanged_setSummary();
        super.modelChanged();
    }

    protected void modelChanged_setSummary() {
        JLabel label;
        int i;
        ITopoGroupModel summaryModel = (ITopoGroupModel)this.widgetModel;
        Vector summaryV = summaryModel.getSummaries();
        int c1 = this.summaryLabelV.size();
        int c2 = summaryV.size();
        for (i = c1; i > c2; --i) {
            label = (JLabel)this.summaryLabelV.remove(i - 1);
            this.remove(label);
        }
        for (i = c1; i < c2; ++i) {
            label = new JLabel();
            label.setFont(TopoResource.FONT_PLAIN);
            this.summaryLabelV.add(label);
            this.add(label);
        }
        TopoSetting setting = this.canvas.getControllerView().getControllerApp().getTopoSetting();
        int filteringLevel = setting.getFilteringLevel();
        for (int i2 = 0; i2 < c2; ++i2) {
            ITopoGroupModel.Summary summary = (ITopoGroupModel.Summary)summaryV.elementAt(i2);
            String s = this.modelChanged_setSummary_helper(summary, filteringLevel);
            ITopoGroupModel.Summary auxSummary = summary.getAuxSummary();
            if (auxSummary != null) {
                String aux = this.modelChanged_setSummary_helper(auxSummary, filteringLevel);
                s = s + " (" + aux + ")";
            }
            JLabel label2 = (JLabel)this.summaryLabelV.elementAt(i2);
            label2.setText(s);
        }
    }

    protected String modelChanged_setSummary_helper(ITopoGroupModel.Summary summary, int filteringLevel) {
        int total = summary.getTotal();
        int unfiltered = summary.getUnfiltered();
        String typeSingle = summary.getTypeSingle();
        String typePlural = summary.getTypePlural();
        StringBuffer sb = new StringBuffer();
        if (filteringLevel != 0) {
            sb.append(unfiltered);
            sb.append(" / ");
        }
        sb.append(total);
        sb.append(" ");
        if (total == 1) {
            sb.append(typeSingle);
        } else {
            sb.append(typePlural);
        }
        return sb.toString();
    }

    public Vector getSummaries() {
        ITopoGroupModel summaryModel = (ITopoGroupModel)this.widgetModel;
        return summaryModel.getSummaries();
    }

    public void setSummaries(Vector summaryV) {
        ITopoGroupModel summaryModel = (ITopoGroupModel)this.widgetModel;
        summaryModel.setSummaries(summaryV);
    }

    public void addSummary(ITopoGroupModel.Summary summary) {
        ITopoGroupModel summaryModel = (ITopoGroupModel)this.widgetModel;
        summaryModel.addSummary(summary);
    }

    public void removeSummary(ITopoGroupModel.Summary summary) {
        ITopoGroupModel summaryModel = (ITopoGroupModel)this.widgetModel;
        summaryModel.removeSummary(summary);
    }

    public void removeAllSummaries() {
        ITopoGroupModel summaryModel = (ITopoGroupModel)this.widgetModel;
        summaryModel.removeAllSummaries();
    }

    public void setOverlayHealthEnabled(boolean b) {
    }

    public void setOverlayPerfEnabled(boolean b) {
    }

    public void setArrange(AbstractJTopoCanvas.ArrangeRecord r) {
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class DefaultLayout
    extends TopoLayoutUtilities.VerticalLayout {
        public DefaultLayout() {
            this.setSpacing(5);
            this.setMargin(5);
        }
    }
}

