/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.border.CompoundBorder;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoGroupTitle;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoNode;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoSummary;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoEntityModel;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public abstract class AbstractJTopoSummaryWithTitle
extends AbstractJTopoNode {
    protected TitlePanel titlePanel;
    protected SummaryPanel summaryPanel;

    protected AbstractJTopoSummaryWithTitle() {
        this((ITopoGroupModel)null, true);
    }

    protected AbstractJTopoSummaryWithTitle(ITopoGroupModel groupModel, boolean isWidgetModelListener) {
        super(groupModel, isWidgetModelListener);
        groupModel = (ITopoGroupModel)this.widgetModel;
        this.titlePanel = new TitlePanel(groupModel);
        this.summaryPanel = new SummaryPanel(groupModel);
        this.initState();
    }

    private void initState() {
        this.titlePanel.setLogicalParent(this);
        this.summaryPanel.setLogicalParent(this);
        this.add(this.titlePanel);
        this.add(this.summaryPanel);
    }

    public void resetState() {
        super.resetState();
        this.titlePanel.resetState();
        this.summaryPanel.resetState();
        this.initState();
    }

    public void setSessionModel(AbstractJTopoCanvas canvas, String scope) {
        super.setSessionModel(canvas, scope);
        this.titlePanel.setSessionModel(canvas, scope);
        this.summaryPanel.setSessionModel(canvas, scope);
    }

    public void setDataModel(GraphEntity focusEntity) {
        super.setDataModel(focusEntity);
        this.titlePanel.setDataModel(focusEntity);
        this.summaryPanel.setDataModel(focusEntity);
    }

    public TitlePanel getTitlePanel() {
        return this.titlePanel;
    }

    public SummaryPanel getSummaryPanel() {
        return this.summaryPanel;
    }

    protected Object createWidgetModel() {
        return new DefaultTopoGroupModel();
    }

    public void modelChanged() {
        this.modelChanged_setHighlight();
        this.titlePanel.modelChanged();
        this.summaryPanel.modelChanged();
    }

    public void selectionChanged() {
        this.titlePanel.selectionChanged();
        this.summaryPanel.selectionChanged();
    }

    public void highlightChanged() {
        this.modelChanged_setHighlight();
        this.titlePanel.highlightChanged();
        this.summaryPanel.highlightChanged();
    }

    protected void modelChanged_setHighlight() {
        ITopoEntityModel entityModel = (ITopoEntityModel)this.widgetModel;
        CompoundBorder border = null;
        border = entityModel.isHighlighted() ? TopoResource.BORDER_CONTAINERHIGHLIGHTED : TopoResource.BORDER_CONTAINERUNHIGHLIGHTED;
        this.setBorder(border);
    }

    public Vector getSummaries() {
        ITopoGroupModel summaryModel = (ITopoGroupModel)this.widgetModel;
        return summaryModel.getSummaries();
    }

    public void setSummaries(Vector summaryV) {
        ITopoGroupModel summaryModel = (ITopoGroupModel)this.widgetModel;
        summaryModel.setSummaries(summaryV);
    }

    public void addSummary(ITopoGroupModel.Summary summary) {
        ITopoGroupModel summaryModel = (ITopoGroupModel)this.widgetModel;
        summaryModel.addSummary(summary);
    }

    public void removeSummary(ITopoGroupModel.Summary summary) {
        ITopoGroupModel summaryModel = (ITopoGroupModel)this.widgetModel;
        summaryModel.removeSummary(summary);
    }

    public void removeAllSummaries() {
        ITopoGroupModel summaryModel = (ITopoGroupModel)this.widgetModel;
        summaryModel.removeAllSummaries();
    }

    protected Point getConnectingPoint() {
        Point p2 = this.titlePanel.getConnectingPoint();
        Point p = new Point(this.getX() + p2.x, this.getY() + p2.y);
        return p;
    }

    public void setOverlayHealthEnabled(boolean b) {
        this.titlePanel.setOverlayHealthEnabled(b);
        this.summaryPanel.setOverlayHealthEnabled(b);
    }

    public void setOverlayPerfEnabled(boolean b) {
        this.titlePanel.setOverlayPerfEnabled(b);
        this.summaryPanel.setOverlayPerfEnabled(b);
    }

    public void setArrange(AbstractJTopoCanvas.ArrangeRecord r) {
        this.titlePanel.setArrange(r);
        this.summaryPanel.setArrange(r);
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class DefaultLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            int w = 0;
            int h = 0;
            Dimension d = AbstractJTopoSummaryWithTitle.this.titlePanel.getPreferredSize();
            h += d.height;
            d = AbstractJTopoSummaryWithTitle.this.summaryPanel.getPreferredSize();
            w = d.width > (w += d.width) ? d.width : w;
            dim.width += w;
            dim.height += (h += d.height);
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int nextX = insets.left;
            int nextY = insets.top;
            Dimension d = AbstractJTopoSummaryWithTitle.this.titlePanel.getPreferredSize();
            Rectangle r = new Rectangle();
            r.x = nextX;
            r.y = nextY;
            r.width = parent.getWidth() - insets.left - insets.right;
            r.height = d.height;
            AbstractJTopoSummaryWithTitle.this.titlePanel.setBounds(r);
            d = AbstractJTopoSummaryWithTitle.this.summaryPanel.getPreferredSize();
            r = new Rectangle();
            r.x = nextX;
            r.y = nextY += AbstractJTopoSummaryWithTitle.this.titlePanel.getHeight();
            r.width = AbstractJTopoSummaryWithTitle.this.titlePanel.getWidth();
            r.height = d.height;
            AbstractJTopoSummaryWithTitle.this.summaryPanel.setBounds(r);
        }
    }

    protected class SummaryPanel
    extends AbstractJTopoSummary {
        public SummaryPanel(ITopoGroupModel groupModel) {
            super(groupModel, false);
        }

        protected void reattach() {
        }
    }

    protected class TitlePanel
    extends AbstractJTopoGroupTitle {
        public TitlePanel(ITopoNodeModel nodeModel) {
            super(nodeModel, false);
            this.setStrCounterEnabled(false);
        }

        protected void reattach() {
        }

        protected void modelChanged_setCounter() {
        }
    }
}

