/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphScopedID;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBase;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoGroup;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.TopoEventSource;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.gui.topo.widget.event.TopoUnitModelListener;

public abstract class AbstractJTopoUnit
extends AbstractJTopoBase
implements TopoUnitModelListener {
    protected AbstractJTopoCanvas canvas;
    protected String scope;
    protected GraphScopedID scopedID;
    protected GraphEntity.ID focusEntityID;
    protected GraphEntity focusEntity;
    protected Object widgetModel;
    protected boolean isWidgetModelListener;
    protected ML_Click mlClick;
    protected ML_Drag mlDrag;
    protected boolean isAlwaysVisible;
    protected boolean isChecked;
    protected AbstractJTopoEntity logicalParent;

    protected AbstractJTopoUnit() {
        this((ITopoUnitModel)null, true);
    }

    protected AbstractJTopoUnit(ITopoUnitModel unitModel, boolean isWidgetModelListener) {
        if (unitModel == null) {
            this.widgetModel = this.createWidgetModel();
            this.isWidgetModelListener = true;
        } else {
            this.widgetModel = unitModel;
            this.isWidgetModelListener = isWidgetModelListener;
        }
        this.setLayout(this.createDefaultLayout());
        this.setBackground(TopoResource.COLOR_BACKGROUND);
        this.mlClick = new ML_Click();
        this.addMouseListener(this.mlClick);
        this.mlDrag = new ML_Drag();
        this.addMouseListener(this.mlDrag);
        this.addMouseMotionListener(this.mlDrag);
        this.initState();
    }

    private void initState() {
        this.canvas = null;
        this.scope = null;
        this.scopedID = null;
        this.focusEntityID = null;
        this.focusEntity = null;
        this.isAlwaysVisible = false;
        this.isChecked = false;
        this.logicalParent = null;
        Container parent = this.getParent();
        if (parent != null) {
            parent.remove(this);
        }
        this.setBounds(0, 0, 0, 0);
        this.setVisible(true);
        ITopoUnitModel unitModel = (ITopoUnitModel)this.widgetModel;
        if (this.isWidgetModelListener) {
            unitModel.init();
            unitModel.addModelChangeListener(this);
        }
    }

    public void resetState() {
        this.initState();
    }

    public AbstractJTopoCanvas getCanvas() {
        return this.canvas;
    }

    public String getScope() {
        return this.scope;
    }

    public GraphScopedID getScopedID() {
        return this.scopedID;
    }

    public void setSessionModel(AbstractJTopoCanvas canvas, String scope) {
        this.canvas = canvas;
        this.scope = scope;
        TopoSetting setting = canvas.getControllerView().getControllerApp().getTopoSetting();
        this.setOverlayHealthEnabled(setting.isOverlayHealthEnabled());
        this.setOverlayPerfEnabled(setting.isOverlayPerfEnabled());
    }

    public GraphEntity.ID getFocusEntityID() {
        return this.focusEntityID;
    }

    public GraphEntity getFocusEntity() {
        return this.focusEntity;
    }

    public void setDataModel(GraphEntity focusEntity) {
        if (focusEntity != null) {
            this.focusEntity = focusEntity;
            this.focusEntityID = focusEntity.getEntityID();
            this.scopedID = new GraphScopedID(this.focusEntityID, this.scope);
        }
        this.updateContainer();
    }

    protected abstract Object createWidgetModel();

    public Object getWidgetModel() {
        return this.widgetModel;
    }

    public void setWidgetModel(Object widgetModel) {
        this.widgetModel = widgetModel;
    }

    public void modelChanged() {
    }

    public void selectionChanged() {
    }

    public void highlightChanged() {
    }

    public void pinChanged() {
    }

    public void setVisible(boolean b) {
        boolean b2 = this.isAlwaysVisible ? true : b;
        super.setVisible(b2);
    }

    public AbstractJTopoEntity getLogicalParent() {
        return this.logicalParent;
    }

    public void setLogicalParent(AbstractJTopoEntity logicalParent) {
        this.logicalParent = logicalParent;
    }

    public abstract void setOverlayHealthEnabled(boolean var1);

    public abstract void setOverlayPerfEnabled(boolean var1);

    public abstract void setArrange(AbstractJTopoCanvas.ArrangeRecord var1);

    public boolean isAlwaysVisible() {
        return this.isAlwaysVisible;
    }

    public void setAlwaysVisible(boolean b) {
        this.isAlwaysVisible = b;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean b) {
        this.isChecked = b;
    }

    public AbstractJTopoUnit getLastVisibleUnit() {
        AbstractJTopoUnit target = this;
        for (AbstractJTopoUnit c = this; c != null; c = c.getLogicalParent()) {
            if (!(c instanceof AbstractJTopoGroup) || ((AbstractJTopoGroup)c).isExpanded()) continue;
            target = c;
        }
        return target;
    }

    protected Point getConnectingPoint() {
        return new Point(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2);
    }

    protected void handleMouseClick(MouseEvent e) {
        this.handleMouseClick_background(e);
    }

    protected final void handleMouseClick_background(MouseEvent e) {
        if (this.logicalParent != null) {
            this.logicalParent.handleMouseClick_regular(e);
        } else {
            this.canvas.handleMouseClick(e);
        }
    }

    protected final void handleMouseClick_regular(MouseEvent e) {
        TopoEventSource eventSource = (TopoEventSource)e.getSource();
        eventSource.setHandler(this);
        boolean recursive = false;
        this.canvas.handleUnitClick(e, recursive);
    }

    protected final void handleMouseClick_recursive(MouseEvent e) {
        TopoEventSource eventSource = (TopoEventSource)e.getSource();
        eventSource.setHandler(this.logicalParent);
        boolean recursive = true;
        this.canvas.handleUnitClick(e, recursive);
    }

    protected abstract LayoutManager createDefaultLayout();

    protected class ML_Drag
    extends MouseAdapter
    implements MouseMotionListener {
        protected Point last;
        protected boolean isCursorSet;

        protected ML_Drag() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.isAltDown()) {
                this.last = e.getPoint();
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (e.isAltDown()) {
                if (!this.isCursorSet) {
                    AbstractJTopoUnit.this.canvas.setCursor(Cursor.getPredefinedCursor(13));
                    this.isCursorSet = true;
                }
                Point drag = e.getPoint();
                Point offset = new Point(drag.x - this.last.x, drag.y - this.last.y);
                AbstractJTopoUnit.this.canvas.handleUnitMouseDrag(offset);
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.last = null;
            if (this.isCursorSet) {
                AbstractJTopoUnit.this.canvas.setCursor(Cursor.getPredefinedCursor(0));
                this.isCursorSet = false;
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    protected class ML_Click
    extends MouseAdapter {
        protected ML_Click() {
        }

        public void mouseClicked(MouseEvent e) {
            e.setSource(new TopoEventSource(e));
            AbstractJTopoUnit.this.handleMouseClick(e);
        }
    }
}

