/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelPinList;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2TapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2VirtualFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabricGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabricGroup2Fabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBox;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoGroup;
import org.eclipse.aperi.gui.topo.widget.ITopoPinContainerWidget;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxFabric;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxVirtualFabricGroup;
import org.eclipse.aperi.gui.topo.widget.JTopoView;
import org.eclipse.aperi.gui.topo.widget.PinList;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoUtilities;
import org.eclipse.aperi.gui.topo.widget.WidgetPool;

public class JTopoCanvasFabricL0
extends AbstractJTopoCanvas {
    protected static final String WIDGET_FABRIC = "WIDGET_FABRIC";

    public JTopoCanvasFabricL0() {
        this.widgetH.put(WIDGET_FABRIC, new Hashtable());
    }

    public String getViewName() {
        return GuiUtil.getString("TOPO_LABEL_VIEW_L0FABRIC");
    }

    protected void reattach() {
        GraphFabric.ID fabricID;
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("---------------JTopoCanvasFabricL0, reattach()---------------");
        }
        WidgetPool widgetPool = WidgetPool.getInstance();
        GraphFabricGroup.ID fabricGroupID = null;
        Enumeration fabricGroupEnu = this.dataModel.enumerateID(GraphFabricGroup.TYPE);
        if (fabricGroupEnu.hasMoreElements()) {
            fabricGroupID = (GraphFabricGroup.ID)fabricGroupEnu.nextElement();
        }
        if (fabricGroupID == null) {
            return;
        }
        Integer canvasStatus = this.dataModel.get(fabricGroupID).getHealthStatus();
        JTopoView topoView = this.controllerView.getTopoView();
        topoView.setStatus(canvasStatus);
        Hashtable fabricH = (Hashtable)this.widgetH.get(WIDGET_FABRIC);
        Enumeration<Object> enu = fabricH.elements();
        while (enu.hasMoreElements()) {
            AbstractJTopoBox widget = (AbstractJTopoBox)enu.nextElement();
            widget.setChecked(false);
        }
        Vector<GraphFabric> fabricV = new Vector<GraphFabric>();
        Enumeration fabricEnu = this.dataModel.associator(GraphFabricGroup2Fabric.TYPE, fabricGroupID);
        while (fabricEnu.hasMoreElements()) {
            GraphFabric fabric = (GraphFabric)fabricEnu.nextElement();
            if (Boolean.TRUE.equals(fabric.getIsFilterable())) continue;
            fabricV.add(fabric);
        }
        Collections.sort(fabricV, GraphModelUtilities.DEFAULT_COMPARATOR);
        for (int i = 0; i < fabricV.size(); ++i) {
            AbstractJTopoBox fabricWidget;
            GraphFabric fabric = (GraphFabric)fabricV.elementAt(i);
            fabricID = (GraphFabric.ID)fabric.getEntityID();
            boolean isVirtualFabricGroup = false;
            Vector<GraphFabric> virtualFabricV = new Vector<GraphFabric>();
            Enumeration virtualFabricEnu = this.dataModel.associator(GraphFabric2VirtualFabric.TYPE, fabricID);
            while (virtualFabricEnu.hasMoreElements()) {
                GraphFabric virtualFabric = (GraphFabric)virtualFabricEnu.nextElement();
                isVirtualFabricGroup = true;
                if (Boolean.TRUE.equals(virtualFabric.getIsFilterable())) continue;
                virtualFabricV.add(virtualFabric);
            }
            if (isVirtualFabricGroup) {
                fabricWidget = (JTopoBoxVirtualFabricGroup)fabricH.get(fabricID);
                if (fabricWidget == null) {
                    fabricWidget = (JTopoBoxVirtualFabricGroup)widgetPool.getWidget(JTopoBoxVirtualFabricGroup.class);
                    fabricWidget.setSessionModel(this, GraphModelConstant.SCOPE_NULL);
                    fabricWidget.setExpanded(true);
                    fabricWidget.setGroupByEnabled(false);
                    fabricH.put(fabricID, fabricWidget);
                }
                fabricWidget.setDataModel(fabric);
                if (!TopoUtilities.contain(this.canvasPanel, fabricWidget)) {
                    this.canvasPanel.add(fabricWidget);
                }
                fabricWidget.setChecked(true);
                for (int j = 0; j < virtualFabricV.size(); ++j) {
                    GraphFabric virtualFabric = (GraphFabric)virtualFabricV.elementAt(j);
                    GraphFabric.ID virtualFabricID = (GraphFabric.ID)virtualFabric.getEntityID();
                    JTopoBoxFabric virtualFabricWidget = (JTopoBoxFabric)fabricH.get(virtualFabricID);
                    if (virtualFabricWidget == null) {
                        virtualFabricWidget = (JTopoBoxFabric)widgetPool.getWidget(JTopoBoxFabric.class);
                        virtualFabricWidget.setSessionModel(this, GraphModelConstant.SCOPE_NULL);
                        virtualFabricWidget.setGroupByEnabled(false);
                        fabricH.put(virtualFabricID, virtualFabricWidget);
                    }
                    virtualFabricWidget.setDataModel(virtualFabric);
                    if (!fabricWidget.isContainLogicalChild(virtualFabricWidget)) {
                        fabricWidget.addLogicalChild(virtualFabricWidget);
                    }
                    virtualFabricWidget.setChecked(true);
                }
                continue;
            }
            fabricWidget = (JTopoBoxFabric)fabricH.get(fabricID);
            if (fabricWidget == null) {
                fabricWidget = (JTopoBoxFabric)widgetPool.getWidget(JTopoBoxFabric.class);
                fabricWidget.setSessionModel(this, GraphModelConstant.SCOPE_NULL);
                fabricWidget.setGroupByEnabled(false);
                fabricH.put(fabricID, fabricWidget);
            }
            fabricWidget.setDataModel(fabric);
            if (!TopoUtilities.contain(this.canvasPanel, fabricWidget)) {
                this.canvasPanel.add(fabricWidget);
            }
            fabricWidget.setChecked(true);
        }
        Vector<GraphFabric.ID> removeV = new Vector<GraphFabric.ID>();
        enu = fabricH.keys();
        while (enu.hasMoreElements()) {
            GraphFabric.ID fabricID2 = (GraphFabric.ID)enu.nextElement();
            AbstractJTopoBox fabricWidget = (AbstractJTopoBox)fabricH.get(fabricID2);
            if (fabricWidget.isChecked()) continue;
            JTopoBoxVirtualFabricGroup virtualFabricGroupWidget = (JTopoBoxVirtualFabricGroup)fabricWidget.getLogicalParent();
            if (virtualFabricGroupWidget != null) {
                virtualFabricGroupWidget.removeLogicalChild(fabricWidget);
            } else {
                this.canvasPanel.remove(fabricWidget);
            }
            removeV.add(fabricID2);
        }
        for (int i = 0; i < removeV.size(); ++i) {
            fabricID = (GraphFabric.ID)removeV.elementAt(i);
            fabricH.remove(fabricID);
        }
        this.arrange();
    }

    public Vector getPinContainers(GraphEntity.ID entityID) {
        PinList pinList = this.controllerView.getControllerApp().getPinList();
        GraphModelPinList pinListModel = (GraphModelPinList)pinList.getModel();
        Vector<AbstractJTopoEntity> v = new Vector<AbstractJTopoEntity>();
        Enumeration enu = null;
        if (entityID instanceof GraphComputer.ID) {
            enu = pinListModel.associatorID(GraphFabric2Computer.TYPE, entityID);
        } else if (entityID instanceof GraphSwitch.ID) {
            enu = pinListModel.associatorID(GraphFabric2Switch.TYPE, entityID);
        } else if (entityID instanceof GraphSubsystem.ID) {
            enu = pinListModel.associatorID(GraphFabric2Subsystem.TYPE, entityID);
        } else if (entityID instanceof GraphTapeLibrary.ID) {
            enu = pinListModel.associatorID(GraphFabric2TapeLibrary.TYPE, entityID);
        } else if (entityID instanceof GraphOther.ID) {
            enu = pinListModel.associatorID(GraphFabric2Other.TYPE, entityID);
        }
        if (enu != null) {
            while (enu.hasMoreElements()) {
                GraphFabric.ID fabricID = (GraphFabric.ID)enu.nextElement();
                Vector fabricWidgetsV = this.getWidgets(fabricID);
                for (int j = 0; j < fabricWidgetsV.size(); ++j) {
                    AbstractJTopoEntity fabricWidget;
                    for (AbstractJTopoEntity w = fabricWidget = (AbstractJTopoEntity)fabricWidgetsV.elementAt(j); w != null; w = w.getLogicalParent()) {
                        if (!(w instanceof ITopoPinContainerWidget)) continue;
                        v.add(w);
                    }
                }
            }
        }
        return v;
    }

    protected Vector getFirstLevelGroup() {
        Vector<AbstractJTopoGroup> groupWidgetV = new Vector<AbstractJTopoGroup>();
        Hashtable h = (Hashtable)this.widgetH.get(WIDGET_FABRIC);
        Enumeration enu = h.elements();
        while (enu.hasMoreElements()) {
            AbstractJTopoGroup widget = (AbstractJTopoGroup)enu.nextElement();
            groupWidgetV.add(widget);
        }
        return groupWidgetV;
    }

    protected void clearAllLines() {
    }

    protected HashSet addLine(AbstractJTopoEntity widget, boolean isAutoExpand) {
        return new HashSet();
    }

    protected void removeLine(AbstractJTopoEntity widget) {
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class ShowLines
    implements Runnable {
        protected ShowLines() {
        }

        public void run() {
        }
    }

    protected class DefaultLayout
    extends TopoLayoutUtilities.SquareGridLayout {
        public void layoutContainer(Container parent) {
            super.layoutContainer(parent);
            SwingUtilities.invokeLater(new ShowLines());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JTopoCanvasFabricL0.this.controllerView.canvasLayoutChanged();
                }
            });
        }
    }
}

