/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphGroupingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;
import org.eclipse.aperi.gui.topo.widget.ControllerView;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;

public class JTopoDialogGroupBy
extends JDialog {
    private ControllerView controllerView;
    private HashSet scopedTypeHS;
    private TopoSetting.SettingPerViewType settingPerViewType;
    private JCheckBox singleGroupCB;
    private JLabel groupByLabel;
    private JCheckBox byHealthCB;
    private JCheckBox byUDP1CB;
    private JCheckBox byUDP2CB;
    private JCheckBox byUDP3CB;
    private JCheckBox computerByOSCB;
    private JCheckBox swByFabricCB;
    private JCheckBox subsystemByModelCB;
    private JCheckBox diskBySubsystemCB;
    private JCheckBox diskByPoolCB;
    private JCheckBox poolByRAIDCB;
    private JCheckBox volumeBySubsystemCB;
    private JCheckBox volumeByPoolCB;
    private JCheckBox lunByComputerCB;

    public JTopoDialogGroupBy(Frame frame, ControllerView controllerView, HashSet scopedTypeHS) {
        super(frame, GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_TITLE"), true);
        this.controllerView = controllerView;
        this.scopedTypeHS = scopedTypeHS;
        TopoSetting setting = controllerView.getControllerApp().getTopoSetting();
        this.settingPerViewType = setting.getSettingPerViewType(controllerView.getModelID().getFocusLevel());
        int bitmap = Integer.MAX_VALUE;
        GraphModel dataModel = controllerView.getDataModel();
        for (GraphScopedType scopedType : scopedTypeHS) {
            Integer cap = dataModel.getGroupByCapabilities(scopedType);
            bitmap &= cap.intValue();
        }
        int valueBitmap = Integer.MAX_VALUE;
        for (GraphScopedType scopedType : scopedTypeHS) {
            Integer value = this.settingPerViewType.getGroupByBitmap(scopedType);
            valueBitmap &= value.intValue();
        }
        JPanel content = (JPanel)this.getContentPane();
        content.setLayout(new BorderLayout());
        this.setResizable(false);
        JPanel mainP = new JPanel();
        mainP.setBorder(new EmptyBorder(5, 5, 5, 5));
        TopoLayoutUtilities.VerticalLayout layout = new TopoLayoutUtilities.VerticalLayout();
        mainP.setLayout(layout);
        content.add((Component)mainP, "Center");
        this.singleGroupCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_GROUPING_BYSINGLEGROUP"));
        this.singleGroupCB.setBorder(new EmptyBorder(10, 2, 2, 2));
        this.singleGroupCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTopoDialogGroupBy.this.check();
            }
        });
        this.singleGroupCB.setSelected(valueBitmap == 0);
        mainP.add(this.singleGroupCB);
        if (bitmap != 0) {
            this.groupByLabel = new JLabel(GuiUtil.getString("TOPO_LABEL_MENU_CONTAINER_GROUPBY") + ":");
            this.groupByLabel.setBorder(new EmptyBorder(10, 2, 2, 2));
            mainP.add(this.groupByLabel);
            if ((bitmap & GraphGroupingUtilities.GROUPBY_HEALTH) != 0) {
                this.byHealthCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_GROUPING_BYHEALTH"));
                this.byHealthCB.setBorder(new EmptyBorder(2, 20, 2, 2));
                this.byHealthCB.setSelected((valueBitmap & GraphGroupingUtilities.GROUPBY_HEALTH) != 0);
                mainP.add(this.byHealthCB);
            }
            if ((bitmap & GraphGroupingUtilities.GROUPBY_UDP1) != 0) {
                this.byUDP1CB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_GROUPING_BYUDP1"));
                this.byUDP1CB.setBorder(new EmptyBorder(2, 20, 2, 2));
                this.byUDP1CB.setSelected((valueBitmap & GraphGroupingUtilities.GROUPBY_UDP1) != 0);
                mainP.add(this.byUDP1CB);
            }
            if ((bitmap & GraphGroupingUtilities.GROUPBY_UDP2) != 0) {
                this.byUDP2CB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_GROUPING_BYUDP2"));
                this.byUDP2CB.setBorder(new EmptyBorder(2, 20, 2, 2));
                this.byUDP2CB.setSelected((valueBitmap & GraphGroupingUtilities.GROUPBY_UDP2) != 0);
                mainP.add(this.byUDP2CB);
            }
            if ((bitmap & GraphGroupingUtilities.GROUPBY_UDP3) != 0) {
                this.byUDP3CB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_GROUPING_BYUDP3"));
                this.byUDP3CB.setBorder(new EmptyBorder(2, 20, 2, 2));
                this.byUDP3CB.setSelected((valueBitmap & GraphGroupingUtilities.GROUPBY_UDP3) != 0);
                mainP.add(this.byUDP3CB);
            }
            if ((bitmap & GraphGroupingUtilities.GROUPBY_COMPUTERBYOS) != 0) {
                this.computerByOSCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_GROUPING_BYOS"));
                this.computerByOSCB.setBorder(new EmptyBorder(2, 20, 2, 2));
                this.computerByOSCB.setSelected((valueBitmap & GraphGroupingUtilities.GROUPBY_COMPUTERBYOS) != 0);
                mainP.add(this.computerByOSCB);
            }
            if ((bitmap & GraphGroupingUtilities.GROUPBY_SWBYFABRIC) != 0) {
                this.swByFabricCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_GROUPING_BYFABRIC"));
                this.swByFabricCB.setBorder(new EmptyBorder(2, 20, 2, 2));
                this.swByFabricCB.setSelected((valueBitmap & GraphGroupingUtilities.GROUPBY_SWBYFABRIC) != 0);
                mainP.add(this.swByFabricCB);
            }
            if ((bitmap & GraphGroupingUtilities.GROUPBY_SUBSYSTEMBYMODEL) != 0) {
                this.subsystemByModelCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_GROUPING_BYMODEL"));
                this.subsystemByModelCB.setBorder(new EmptyBorder(2, 20, 2, 2));
                this.subsystemByModelCB.setSelected((valueBitmap & GraphGroupingUtilities.GROUPBY_SUBSYSTEMBYMODEL) != 0);
                mainP.add(this.subsystemByModelCB);
            }
            if ((bitmap & GraphGroupingUtilities.GROUPBY_DISKBYPOOL) != 0) {
                this.diskByPoolCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_GROUPING_BYPOOL"));
                this.diskByPoolCB.setBorder(new EmptyBorder(2, 20, 2, 2));
                this.diskByPoolCB.setSelected((valueBitmap & GraphGroupingUtilities.GROUPBY_DISKBYPOOL) != 0);
                mainP.add(this.diskByPoolCB);
            }
            if ((bitmap & GraphGroupingUtilities.GROUPBY_DISKBYSUBSYSTEM) != 0) {
                this.diskBySubsystemCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_GROUPING_BYSUBSYSTEM"));
                this.diskBySubsystemCB.setBorder(new EmptyBorder(2, 20, 2, 2));
                this.diskBySubsystemCB.setSelected((valueBitmap & GraphGroupingUtilities.GROUPBY_DISKBYSUBSYSTEM) != 0);
                mainP.add(this.diskBySubsystemCB);
            }
            if ((bitmap & GraphGroupingUtilities.GROUPBY_POOLBYRAID) != 0) {
                this.poolByRAIDCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_GROUPING_BYRAID"));
                this.poolByRAIDCB.setBorder(new EmptyBorder(2, 20, 2, 2));
                this.poolByRAIDCB.setSelected((valueBitmap & GraphGroupingUtilities.GROUPBY_POOLBYRAID) != 0);
                mainP.add(this.poolByRAIDCB);
            }
            if ((bitmap & GraphGroupingUtilities.GROUPBY_VOLUMEBYPOOL) != 0) {
                this.volumeByPoolCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_GROUPING_BYPOOL"));
                this.volumeByPoolCB.setBorder(new EmptyBorder(2, 20, 2, 2));
                this.volumeByPoolCB.setSelected((valueBitmap & GraphGroupingUtilities.GROUPBY_VOLUMEBYPOOL) != 0);
                mainP.add(this.volumeByPoolCB);
            }
            if ((bitmap & GraphGroupingUtilities.GROUPBY_VOLUMEBYSUBSYSTEM) != 0) {
                this.volumeBySubsystemCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_GROUPING_BYSUBSYSTEM"));
                this.volumeBySubsystemCB.setBorder(new EmptyBorder(2, 20, 2, 2));
                this.volumeBySubsystemCB.setSelected((valueBitmap & GraphGroupingUtilities.GROUPBY_VOLUMEBYSUBSYSTEM) != 0);
                mainP.add(this.volumeBySubsystemCB);
            }
            if ((bitmap & GraphGroupingUtilities.GROUPBY_LUNBYDEVICE) != 0) {
                this.lunByComputerCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_GROUPING_BYDEVICE"));
                this.lunByComputerCB.setBorder(new EmptyBorder(2, 20, 2, 2));
                this.lunByComputerCB.setSelected((valueBitmap & GraphGroupingUtilities.GROUPBY_LUNBYDEVICE) != 0);
                mainP.add(this.lunByComputerCB);
            }
        }
        this.check();
        JPanel buttonP = new JPanel();
        buttonP.setBorder(new EmptyBorder(10, 2, 2, 2));
        TopoLayoutUtilities.HorizontalLayout layout2 = new TopoLayoutUtilities.HorizontalLayout();
        layout2.setHorizontalJustify(4);
        buttonP.setLayout(layout2);
        content.add((Component)buttonP, "South");
        JButton okB = new JButton(GuiUtil.getString("TOPO_LABEL_COMMON_OK"));
        okB.addActionListener(new PostAction());
        buttonP.add(okB);
        JButton cancelB = new JButton(GuiUtil.getString("TOPO_LABEL_COMMON_CANCEL"));
        cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTopoDialogGroupBy.this.dispose();
            }
        });
        buttonP.add(cancelB);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private void check() {
        boolean b;
        boolean bl = b = !this.singleGroupCB.isSelected();
        if (this.groupByLabel != null) {
            this.groupByLabel.setEnabled(b);
        }
        if (this.byHealthCB != null) {
            this.byHealthCB.setEnabled(b);
        }
        if (this.byUDP1CB != null) {
            this.byUDP1CB.setEnabled(b);
        }
        if (this.byUDP2CB != null) {
            this.byUDP2CB.setEnabled(b);
        }
        if (this.byUDP3CB != null) {
            this.byUDP3CB.setEnabled(b);
        }
        if (this.computerByOSCB != null) {
            this.computerByOSCB.setEnabled(b);
        }
        if (this.swByFabricCB != null) {
            this.swByFabricCB.setEnabled(b);
        }
        if (this.subsystemByModelCB != null) {
            this.subsystemByModelCB.setEnabled(b);
        }
        if (this.diskByPoolCB != null) {
            this.diskByPoolCB.setEnabled(b);
        }
        if (this.diskBySubsystemCB != null) {
            this.diskBySubsystemCB.setEnabled(b);
        }
        if (this.poolByRAIDCB != null) {
            this.poolByRAIDCB.setEnabled(b);
        }
        if (this.volumeByPoolCB != null) {
            this.volumeByPoolCB.setEnabled(b);
        }
        if (this.volumeBySubsystemCB != null) {
            this.volumeBySubsystemCB.setEnabled(b);
        }
        if (this.lunByComputerCB != null) {
            this.lunByComputerCB.setEnabled(b);
        }
    }

    private class PostAction
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            int bitmap = 0;
            if (!JTopoDialogGroupBy.this.singleGroupCB.isSelected()) {
                if (JTopoDialogGroupBy.this.byHealthCB != null && JTopoDialogGroupBy.this.byHealthCB.isSelected()) {
                    bitmap |= GraphGroupingUtilities.GROUPBY_HEALTH.intValue();
                }
                if (JTopoDialogGroupBy.this.byUDP1CB != null && JTopoDialogGroupBy.this.byUDP1CB.isSelected()) {
                    bitmap |= GraphGroupingUtilities.GROUPBY_UDP1.intValue();
                }
                if (JTopoDialogGroupBy.this.byUDP2CB != null && JTopoDialogGroupBy.this.byUDP2CB.isSelected()) {
                    bitmap |= GraphGroupingUtilities.GROUPBY_UDP2.intValue();
                }
                if (JTopoDialogGroupBy.this.byUDP3CB != null && JTopoDialogGroupBy.this.byUDP3CB.isSelected()) {
                    bitmap |= GraphGroupingUtilities.GROUPBY_UDP3.intValue();
                }
                if (JTopoDialogGroupBy.this.computerByOSCB != null && JTopoDialogGroupBy.this.computerByOSCB.isSelected()) {
                    bitmap |= GraphGroupingUtilities.GROUPBY_COMPUTERBYOS.intValue();
                }
                if (JTopoDialogGroupBy.this.swByFabricCB != null && JTopoDialogGroupBy.this.swByFabricCB.isSelected()) {
                    bitmap |= GraphGroupingUtilities.GROUPBY_SWBYFABRIC.intValue();
                }
                if (JTopoDialogGroupBy.this.subsystemByModelCB != null && JTopoDialogGroupBy.this.subsystemByModelCB.isSelected()) {
                    bitmap |= GraphGroupingUtilities.GROUPBY_SUBSYSTEMBYMODEL.intValue();
                }
                if (JTopoDialogGroupBy.this.diskByPoolCB != null && JTopoDialogGroupBy.this.diskByPoolCB.isSelected()) {
                    bitmap |= GraphGroupingUtilities.GROUPBY_DISKBYPOOL.intValue();
                }
                if (JTopoDialogGroupBy.this.diskBySubsystemCB != null && JTopoDialogGroupBy.this.diskBySubsystemCB.isSelected()) {
                    bitmap |= GraphGroupingUtilities.GROUPBY_DISKBYSUBSYSTEM.intValue();
                }
                if (JTopoDialogGroupBy.this.poolByRAIDCB != null && JTopoDialogGroupBy.this.poolByRAIDCB.isSelected()) {
                    bitmap |= GraphGroupingUtilities.GROUPBY_POOLBYRAID.intValue();
                }
                if (JTopoDialogGroupBy.this.volumeByPoolCB != null && JTopoDialogGroupBy.this.volumeByPoolCB.isSelected()) {
                    bitmap |= GraphGroupingUtilities.GROUPBY_VOLUMEBYPOOL.intValue();
                }
                if (JTopoDialogGroupBy.this.volumeBySubsystemCB != null && JTopoDialogGroupBy.this.volumeBySubsystemCB.isSelected()) {
                    bitmap |= GraphGroupingUtilities.GROUPBY_VOLUMEBYSUBSYSTEM.intValue();
                }
                if (JTopoDialogGroupBy.this.lunByComputerCB != null && JTopoDialogGroupBy.this.lunByComputerCB.isSelected()) {
                    bitmap |= GraphGroupingUtilities.GROUPBY_LUNBYDEVICE.intValue();
                }
            }
            Integer result = new Integer(bitmap);
            for (GraphScopedType scopedType : JTopoDialogGroupBy.this.scopedTypeHS) {
                JTopoDialogGroupBy.this.settingPerViewType.setGroupByBitmap(scopedType, result);
            }
            JTopoDialogGroupBy.this.controllerView.updateView();
            JTopoDialogGroupBy.this.dispose();
        }
    }
}

