/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.util.Enumeration;
import java.util.ResourceBundle;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2SubsystemPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemPerf;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoIcon;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoIconSubsystem
extends AbstractJTopoIcon {
    protected void reattach() {
        Boolean isSVC;
        if (this.focusEntity == null) {
            return;
        }
        GraphSubsystem subsystem = (GraphSubsystem)this.focusEntity;
        ITopoNodeModel nodeModel = (ITopoNodeModel)this.widgetModel;
        Boolean bl = isSVC = subsystem == null ? null : subsystem.getIsSVC();
        if (Boolean.TRUE.equals(isSVC)) {
            nodeModel.setType(GuiUtil.getString("TOPO_LABEL_ENTITY_SVC"));
        } else {
            nodeModel.setType(GuiUtil.getString("TOPO_LABEL_ENTITY_SUBSYSTEM"));
        }
        nodeModel.setLabel(subsystem.getDisplayName());
        nodeModel.setHealth(subsystem.getHealthStatus());
        if (Boolean.TRUE.equals(isSVC)) {
            nodeModel.setIconSelected(TopoResource.ICON_SVC_32_SELECTED);
            nodeModel.setIconUnselected(TopoResource.ICON_SVC_32_UNSELECTED);
            nodeModel.setIconMissing(TopoResource.ICON_SVC_32_MISSING);
        } else {
            nodeModel.setIconSelected(TopoResource.ICON_SUBSYSTEM_32_SELECTED);
            nodeModel.setIconUnselected(TopoResource.ICON_SUBSYSTEM_32_UNSELECTED);
            nodeModel.setIconMissing(TopoResource.ICON_SUBSYSTEM_32_MISSING);
        }
        nodeModel.setPerf(subsystem.getPerfStatus());
        String perfTooltip = null;
        Enumeration enu = this.canvas.getDataModel().associator(GraphSubsystem2SubsystemPerf.TYPE, this.focusEntityID);
        if (enu.hasMoreElements()) {
            GraphSubsystemPerf p = (GraphSubsystemPerf)enu.nextElement();
            String ioRateRx = GraphModelUtilities.formatDouble(p.getIORateRx());
            String ioRateTx = GraphModelUtilities.formatDouble(p.getIORateTx());
            String dataRateRx = GraphModelUtilities.formatDouble(p.getDataRateRx());
            String dataRateTx = GraphModelUtilities.formatDouble(p.getDataRateTx());
            String responseTimeRx = GraphModelUtilities.formatDouble(p.getResponseTimeRx());
            String responseTimeTx = GraphModelUtilities.formatDouble(p.getResponseTimeTx());
            String cacheHitRx = GraphModelUtilities.formatDouble(p.getCacheHitRx());
            String cacheHitTx = GraphModelUtilities.formatDouble(p.getCacheHitTx());
            String nvsFullPercentage = GraphModelUtilities.formatDouble(p.getNVSFullPercentage());
            String cacheHoldingTime = GraphModelUtilities.formatInteger(p.getCacheHoldingTime());
            ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.common.meta.MdRbMetrics");
            StringBuffer sb = new StringBuffer();
            sb.append("<HTML>");
            sb.append(GraphModelUtilities.getTooltipPerf(subsystem.getPerfStatus()));
            sb.append("<HR width=120 align=left>");
            sb.append("<TABLE>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_READ_IO_RATE_NAME") + ":" + "</TD>");
            sb.append("<TD>" + ioRateRx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_WRITE_IO_RATE_NAME") + ":" + "</TD>");
            sb.append("<TD>" + ioRateTx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_READ_KB_RATE_NAME") + ":" + "</TD>");
            sb.append("<TD>" + dataRateRx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_WRITE_KB_RATE_NAME") + ":" + "</TD>");
            sb.append("<TD>" + dataRateTx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_READ_RESP_TIME_NAME") + ":" + "</TD>");
            sb.append("<TD>" + responseTimeRx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_WRITE_RESP_TIME_NAME") + ":" + "</TD>");
            sb.append("<TD>" + responseTimeTx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_READ_HITS_PERC_NAME") + ":" + "</TD>");
            sb.append("<TD>" + cacheHitRx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_WRITE_HITS_PERC_NAME") + ":" + "</TD>");
            sb.append("<TD>" + cacheHitTx + "</TD>");
            sb.append("</TR>");
            if (p.getNVSFullPercentage() != null) {
                sb.append("<TR>");
                sb.append("<TD>" + rb.getString("MET_NVS_FULL_PERC_NAME") + ":" + "</TD>");
                sb.append("<TD>" + nvsFullPercentage + "</TD>");
                sb.append("</TR>");
            }
            if (p.getCacheHoldingTime() != null) {
                sb.append("<TR>");
                sb.append("<TD>" + rb.getString("MET_CACHE_HOLD_TIME_NAME") + ":" + "</TD>");
                sb.append("<TD>" + cacheHoldingTime + "</TD>");
                sb.append("</TR>");
            }
            sb.append("</TABLE>");
            sb.append("</HTML>");
            perfTooltip = sb.toString();
        }
        nodeModel.setPerfTooltip(perfTooltip);
        nodeModel.fireModelChanged();
    }
}

