/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoSubview;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.JTopoLShapedLineGeneric;
import org.eclipse.aperi.gui.topo.widget.JTopoPanel;

public class JTopoSubviewDispatcher
extends JTopoPanel {
    protected JTopoPanel focusPanel;
    protected TopPanel topPanel;
    protected JTopoLShapedLineGeneric topLine;
    protected BottomPanel bottomPanel;
    protected JTopoLShapedLineGeneric bottomLine;

    protected JTopoSubviewDispatcher() {
        this((ITopoUnitModel)null, true);
    }

    protected JTopoSubviewDispatcher(ITopoUnitModel unitModel, boolean isWidgetModelListener) {
        super(unitModel, isWidgetModelListener);
        unitModel = (ITopoUnitModel)this.widgetModel;
        this.focusPanel = new JTopoPanel(unitModel, false);
        this.topPanel = new TopPanel(unitModel);
        this.topLine = new JTopoLShapedLineGeneric();
        this.topLine.setFromWidget(this.focusPanel);
        this.topLine.setToWidget(this.topPanel);
        this.bottomPanel = new BottomPanel(unitModel);
        this.bottomLine = new JTopoLShapedLineGeneric();
        this.bottomLine.setFromWidget(this.focusPanel);
        this.bottomLine.setToWidget(this.bottomPanel);
        this.initState();
    }

    private void initState() {
        this.setFocusWidget(null);
        this.setTopWidget(null);
        this.setBottomWidget(null);
        this.add(this.focusPanel);
        this.add(this.topPanel);
        this.add(this.topLine);
        this.add(this.bottomPanel);
        this.add(this.bottomLine);
    }

    public void resetState() {
        super.resetState();
        this.focusPanel.resetState();
        this.topPanel.resetState();
        this.topLine.resetState();
        this.bottomPanel.resetState();
        this.bottomLine.resetState();
        this.initState();
    }

    public void setSessionModel(AbstractJTopoCanvas canvas, String scope) {
        super.setSessionModel(canvas, scope);
        this.focusPanel.setSessionModel(canvas, scope);
        this.topPanel.setSessionModel(canvas, scope);
        this.topLine.setSessionModel(canvas, scope);
        this.bottomPanel.setSessionModel(canvas, scope);
        this.bottomLine.setSessionModel(canvas, scope);
    }

    public void setDataModel(GraphEntity focusEntity) {
        super.setDataModel(focusEntity);
        this.focusPanel.setDataModel(focusEntity);
        this.topPanel.setDataModel(focusEntity);
        this.topLine.setDataModel(focusEntity);
        this.bottomPanel.setDataModel(focusEntity);
        this.bottomLine.setDataModel(focusEntity);
    }

    public void setFocusWidget(AbstractJTopoEntity focus) {
        this.focusPanel.removeAll();
        boolean b = focus != null;
        this.focusPanel.setVisible(b);
        if (b) {
            this.focusPanel.add(focus);
        }
    }

    public void setTopWidget(AbstractJTopoSubview top) {
        this.topPanel.removeAll();
        boolean b = top != null;
        this.topPanel.setVisible(b);
        this.topLine.setVisible(b);
        if (b) {
            this.topPanel.add(top);
        }
    }

    public void setBottomWidget(AbstractJTopoSubview bottom) {
        this.bottomPanel.removeAll();
        boolean b = bottom != null;
        this.bottomPanel.setVisible(b);
        this.bottomLine.setVisible(b);
        if (b) {
            this.bottomPanel.add(bottom);
        }
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class DefaultLayout
    implements LayoutManager {
        private int spacing = 20;

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension d;
            Dimension dim = new Dimension(0, 0);
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            Dimension d2 = JTopoSubviewDispatcher.this.focusPanel.getPreferredSize();
            dim.width += d2.width;
            dim.height += d2.height;
            dim.width += this.spacing;
            int maxW = 0;
            if (JTopoSubviewDispatcher.this.topPanel.isVisible()) {
                d = JTopoSubviewDispatcher.this.topPanel.getPreferredSize();
                maxW = maxW > d.width ? maxW : d.width;
                dim.height += d.height;
            }
            if (JTopoSubviewDispatcher.this.bottomPanel.isVisible()) {
                d = JTopoSubviewDispatcher.this.bottomPanel.getPreferredSize();
                maxW = maxW > d.width ? maxW : d.width;
                dim.height += d.height;
            }
            dim.width += maxW;
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            int height;
            int width;
            int y;
            int x;
            Insets insets = parent.getInsets();
            Dimension focusPanelD = JTopoSubviewDispatcher.this.focusPanel.getPreferredSize();
            int nextX = insets.left;
            int nextY = insets.top;
            if (JTopoSubviewDispatcher.this.topPanel.isVisible()) {
                Dimension d = JTopoSubviewDispatcher.this.topPanel.getPreferredSize();
                x = nextX + focusPanelD.width + this.spacing;
                y = nextY;
                width = d.width;
                height = d.height;
                JTopoSubviewDispatcher.this.topPanel.setBounds(x, y, width, height);
                nextY += JTopoSubviewDispatcher.this.topPanel.getHeight();
            } else {
                JTopoSubviewDispatcher.this.topPanel.setBounds(0, 0, 0, 0);
            }
            int x2 = nextX;
            int y2 = nextY;
            int width2 = focusPanelD.width;
            int height2 = focusPanelD.height;
            JTopoSubviewDispatcher.this.focusPanel.setBounds(x2, y2, width2, height2);
            nextY += JTopoSubviewDispatcher.this.focusPanel.getHeight();
            if (JTopoSubviewDispatcher.this.bottomPanel.isVisible()) {
                Dimension d = JTopoSubviewDispatcher.this.bottomPanel.getPreferredSize();
                x = nextX + focusPanelD.width + this.spacing;
                y = nextY;
                width = d.width;
                height = d.height;
                JTopoSubviewDispatcher.this.bottomPanel.setBounds(x, y, width, height);
                nextY += JTopoSubviewDispatcher.this.bottomPanel.getHeight();
            } else {
                JTopoSubviewDispatcher.this.bottomPanel.setBounds(0, 0, 0, 0);
            }
            JTopoSubviewDispatcher.this.topLine.setFirstPassOfLayout(true);
            JTopoSubviewDispatcher.this.bottomLine.setFirstPassOfLayout(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JTopoSubviewDispatcher.this.topLine.setFirstPassOfLayout(false);
                    JTopoSubviewDispatcher.this.topLine.revalidate();
                    JTopoSubviewDispatcher.this.bottomLine.setFirstPassOfLayout(false);
                    JTopoSubviewDispatcher.this.bottomLine.revalidate();
                }
            });
        }
    }

    protected class BottomPanel
    extends JTopoPanel {
        public BottomPanel(ITopoUnitModel unitModel) {
            super(unitModel, false);
        }

        protected Point getConnectingPoint() {
            return new Point(this.getX(), this.getY() + this.getHeight() / 2);
        }
    }

    protected class TopPanel
    extends JTopoPanel {
        public TopPanel(ITopoUnitModel unitModel) {
            super(unitModel, false);
        }

        protected Point getConnectingPoint() {
            return new Point(this.getX(), this.getY() + this.getHeight() / 2);
        }
    }
}

