/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewFabricL2Connectivity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBox;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoSubview;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxComputerGroup;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxOtherGroup;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxSubsystemGroup;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxSwitchGroup;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxTapeLibraryGroup;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoSubviewFabricL2Connectivity
extends AbstractJTopoSubview {
    protected void reattach() {
        if (this.focusEntity == null) {
            return;
        }
        GraphSubviewFabricL2Connectivity connectivity = (GraphSubviewFabricL2Connectivity)this.focusEntity;
        ITopoGroupModel groupModel = (ITopoGroupModel)this.widgetModel;
        groupModel.setType(connectivity.getDisplayName());
        groupModel.setLabel(connectivity.getDisplayName());
        groupModel.setHealth(connectivity.getHealthStatus());
        groupModel.setIconSelected(TopoResource.ICON_FABRICGROUP_16_SELECTED);
        groupModel.setIconUnselected(TopoResource.ICON_FABRICGROUP_16_UNSELECTED);
        groupModel.setIconMissing(TopoResource.ICON_FABRICGROUP_16_MISSING);
        groupModel.removeAllSummaries();
        int computerTotal = connectivity.getNumOfComputers();
        int computerUnfiltered = connectivity.getNumOfAbnormalComputers();
        groupModel.addSummary(new ITopoGroupModel.Summary(computerTotal, computerUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_COMPUTER"), GuiUtil.getString("TOPO_LABEL_ENTITY_COMPUTERS")));
        int swTotal = connectivity.getNumOfSwitches();
        int swUnfiltered = connectivity.getNumOfAbnormalSwitches();
        groupModel.addSummary(new ITopoGroupModel.Summary(swTotal, swUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_SWITCH"), GuiUtil.getString("TOPO_LABEL_ENTITY_SWITCHES")));
        int subsystemTotal = connectivity.getNumOfSubsystems();
        int subsystemUnfiltered = connectivity.getNumOfAbnormalSubsystems();
        groupModel.addSummary(new ITopoGroupModel.Summary(subsystemTotal, subsystemUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_SUBSYSTEM"), GuiUtil.getString("TOPO_LABEL_ENTITY_SUBSYSTEMS")));
        int tapeLibraryTotal = connectivity.getNumOfTapeLibraries();
        int tapeLibraryUnfiltered = connectivity.getNumOfAbnormalTapeLibraries();
        groupModel.addSummary(new ITopoGroupModel.Summary(tapeLibraryTotal, tapeLibraryUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_TAPELIBRARY"), GuiUtil.getString("TOPO_LABEL_ENTITY_TAPELIBRARIES")));
        int otherTotal = connectivity.getNumOfOthers();
        int otherUnfiltered = connectivity.getNumOfAbnormalOthers();
        groupModel.addSummary(new ITopoGroupModel.Summary(otherTotal, otherUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_OTHER"), GuiUtil.getString("TOPO_LABEL_ENTITY_OTHER")));
        int total = computerTotal + swTotal + subsystemTotal + tapeLibraryTotal + otherTotal;
        int unfiltered = computerUnfiltered + swUnfiltered + subsystemUnfiltered + tapeLibraryUnfiltered + otherUnfiltered;
        groupModel.setTotalCount(total);
        groupModel.setUnfilteredCount(unfiltered);
        groupModel.setGroupKey(connectivity.getGroupKey());
        groupModel.fireModelChanged();
    }

    protected AbstractJTopoBox.ContainerPanel createContainerPanel(ITopoGroupModel groupModel) {
        return new ContainerPanel((ITopoUnitModel)groupModel);
    }

    protected class ContainerPanel
    extends AbstractJTopoBox.ContainerPanel {
        protected JPanel leftPanel;
        protected JPanel computerGroupPanel;
        protected JPanel otherGroupPanel;
        protected JPanel swGroupPanel;
        protected JPanel rightPanel;
        protected JPanel subsystemGroupPanel;
        protected JPanel tapeLibraryGroupPanel;

        public ContainerPanel(ITopoUnitModel unitModel) {
            super(unitModel);
            this.leftPanel = new JPanel();
            this.leftPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            TopoLayoutUtilities.VerticalLayout layout = new TopoLayoutUtilities.VerticalLayout();
            layout.setSpacing(40);
            layout.setAlignment(4);
            this.leftPanel.setLayout(layout);
            this.computerGroupPanel = new JPanel();
            this.computerGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            layout = new TopoLayoutUtilities.VerticalLayout();
            layout.setAlignment(4);
            this.computerGroupPanel.setLayout(layout);
            this.leftPanel.add(this.computerGroupPanel);
            this.otherGroupPanel = new JPanel();
            this.otherGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            layout = new TopoLayoutUtilities.VerticalLayout();
            layout.setAlignment(4);
            this.otherGroupPanel.setLayout(layout);
            this.leftPanel.add(this.otherGroupPanel);
            this.swGroupPanel = new JPanel();
            this.swGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            layout = new TopoLayoutUtilities.VerticalLayout();
            this.swGroupPanel.setLayout(layout);
            this.rightPanel = new JPanel();
            this.rightPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            layout = new TopoLayoutUtilities.VerticalLayout();
            layout.setSpacing(40);
            layout.setAlignment(2);
            this.rightPanel.setLayout(layout);
            this.subsystemGroupPanel = new JPanel();
            this.subsystemGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            layout = new TopoLayoutUtilities.VerticalLayout();
            this.subsystemGroupPanel.setLayout(layout);
            this.rightPanel.add(this.subsystemGroupPanel);
            this.tapeLibraryGroupPanel = new JPanel();
            this.tapeLibraryGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            layout = new TopoLayoutUtilities.VerticalLayout();
            this.tapeLibraryGroupPanel.setLayout(layout);
            this.rightPanel.add(this.tapeLibraryGroupPanel);
            this.initState();
        }

        private void initState() {
            this.add(this.leftPanel);
            this.add(this.swGroupPanel);
            this.add(this.rightPanel);
            this.removeAllEntities();
        }

        public void resetState() {
            super.resetState();
            this.initState();
        }

        public void addEntity(AbstractJTopoEntity entity) {
            this.entityV.add(entity);
            if (entity instanceof JTopoBoxComputerGroup || entity instanceof JTopoBoxOtherGroup) {
                if (entity instanceof JTopoBoxComputerGroup) {
                    this.computerGroupPanel.setVisible(true);
                    this.computerGroupPanel.add(entity);
                } else if (entity instanceof JTopoBoxOtherGroup) {
                    this.otherGroupPanel.setVisible(true);
                    this.otherGroupPanel.add(entity);
                }
                this.leftPanel.setVisible(true);
            } else if (entity instanceof JTopoBoxSwitchGroup) {
                this.swGroupPanel.setVisible(true);
                this.swGroupPanel.add(entity);
            } else if (entity instanceof JTopoBoxSubsystemGroup || entity instanceof JTopoBoxTapeLibraryGroup) {
                if (entity instanceof JTopoBoxSubsystemGroup) {
                    this.subsystemGroupPanel.setVisible(true);
                    this.subsystemGroupPanel.add(entity);
                } else if (entity instanceof JTopoBoxTapeLibraryGroup) {
                    this.tapeLibraryGroupPanel.setVisible(true);
                    this.tapeLibraryGroupPanel.add(entity);
                }
                this.rightPanel.setVisible(true);
            }
        }

        public void removeEntity(AbstractJTopoEntity entity) {
            this.entityV.remove(entity);
            if (entity instanceof JTopoBoxComputerGroup || entity instanceof JTopoBoxOtherGroup) {
                if (entity instanceof JTopoBoxComputerGroup) {
                    this.computerGroupPanel.remove(entity);
                    this.computerGroupPanel.setVisible(this.computerGroupPanel.getComponentCount() > 0);
                } else if (entity instanceof JTopoBoxOtherGroup) {
                    this.otherGroupPanel.remove(entity);
                    this.otherGroupPanel.setVisible(this.otherGroupPanel.getComponentCount() > 0);
                }
                this.leftPanel.setVisible(this.computerGroupPanel.isVisible() || this.otherGroupPanel.isVisible());
            } else if (entity instanceof JTopoBoxSwitchGroup) {
                this.swGroupPanel.remove(entity);
                this.swGroupPanel.setVisible(this.swGroupPanel.getComponentCount() > 0);
            } else if (entity instanceof JTopoBoxSubsystemGroup || entity instanceof JTopoBoxTapeLibraryGroup) {
                if (entity instanceof JTopoBoxSubsystemGroup) {
                    this.subsystemGroupPanel.remove(entity);
                    this.subsystemGroupPanel.setVisible(this.subsystemGroupPanel.getComponentCount() > 0);
                } else if (entity instanceof JTopoBoxTapeLibraryGroup) {
                    this.tapeLibraryGroupPanel.remove(entity);
                    this.tapeLibraryGroupPanel.setVisible(this.tapeLibraryGroupPanel.getComponentCount() > 0);
                }
                this.rightPanel.setVisible(this.subsystemGroupPanel.isVisible() || this.tapeLibraryGroupPanel.isVisible());
            }
        }

        public void removeAllEntities() {
            this.entityV.clear();
            this.computerGroupPanel.removeAll();
            this.computerGroupPanel.setVisible(false);
            this.otherGroupPanel.removeAll();
            this.otherGroupPanel.setVisible(false);
            this.swGroupPanel.removeAll();
            this.swGroupPanel.setVisible(false);
            this.subsystemGroupPanel.removeAll();
            this.subsystemGroupPanel.setVisible(false);
            this.tapeLibraryGroupPanel.removeAll();
            this.tapeLibraryGroupPanel.setVisible(false);
            this.leftPanel.setVisible(false);
            this.rightPanel.setVisible(false);
        }

        protected LayoutManager createDefaultLayout() {
            return new DefaultLayout();
        }

        protected class DefaultLayout
        extends TopoLayoutUtilities.HorizontalLayout {
            public DefaultLayout() {
                this.setMargin(15);
                this.setSpacing(40);
                this.setAlignment(0);
            }
        }
    }
}

