/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewOtherL2Device;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBox;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoSubview;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxLunGroup;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxVolumeGroup;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoSubviewOtherL2Device
extends AbstractJTopoSubview {
    protected void reattach() {
        if (this.focusEntity == null) {
            return;
        }
        GraphSubviewOtherL2Device device = (GraphSubviewOtherL2Device)this.focusEntity;
        ITopoGroupModel groupModel = (ITopoGroupModel)this.widgetModel;
        groupModel.setType(device.getDisplayName());
        groupModel.setLabel(device.getDisplayName());
        groupModel.setHealth(device.getHealthStatus());
        groupModel.setIconSelected(TopoResource.ICON_VOLUMEGROUP_16_SELECTED);
        groupModel.setIconUnselected(TopoResource.ICON_VOLUMEGROUP_16_UNSELECTED);
        groupModel.setIconMissing(TopoResource.ICON_VOLUMEGROUP_16_MISSING);
        groupModel.removeAllSummaries();
        int lunTotal = device.getNumOfLuns();
        int lunUnfiltered = device.getNumOfAbnormalLuns();
        groupModel.addSummary(new ITopoGroupModel.Summary(lunTotal, lunUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_LUN"), GuiUtil.getString("TOPO_LABEL_ENTITY_LUNS")));
        int volumeTotal = device.getNumOfVolumes();
        int volumeUnfiltered = device.getNumOfAbnormalVolumes();
        groupModel.addSummary(new ITopoGroupModel.Summary(volumeTotal, volumeUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_VOLUME"), GuiUtil.getString("TOPO_LABEL_ENTITY_VOLUMES")));
        int total = lunTotal + volumeTotal;
        int unfiltered = lunUnfiltered + volumeUnfiltered;
        groupModel.setTotalCount(total);
        groupModel.setUnfilteredCount(unfiltered);
        groupModel.setGroupKey(device.getGroupKey());
        groupModel.fireModelChanged();
    }

    protected AbstractJTopoBox.ContainerPanel createContainerPanel(ITopoGroupModel groupModel) {
        return new ContainerPanel((ITopoUnitModel)groupModel);
    }

    protected class ContainerPanel
    extends AbstractJTopoBox.ContainerPanel {
        protected JPanel lunGroupPanel;
        protected JPanel volumeGroupPanel;

        public ContainerPanel(ITopoUnitModel unitModel) {
            super(unitModel);
            this.lunGroupPanel = new JPanel();
            this.lunGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            TopoLayoutUtilities.SquareGridLayout layout = new TopoLayoutUtilities.SquareGridLayout();
            this.lunGroupPanel.setLayout(layout);
            this.volumeGroupPanel = new JPanel();
            this.volumeGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            layout = new TopoLayoutUtilities.SquareGridLayout();
            this.volumeGroupPanel.setLayout(layout);
            this.initState();
        }

        private void initState() {
            this.add(this.lunGroupPanel);
            this.add(this.volumeGroupPanel);
            this.removeAllEntities();
        }

        public void resetState() {
            super.resetState();
            this.initState();
        }

        public void addEntity(AbstractJTopoEntity entity) {
            this.entityV.add(entity);
            if (entity instanceof JTopoBoxLunGroup) {
                this.lunGroupPanel.setVisible(true);
                this.lunGroupPanel.add(entity);
            } else if (entity instanceof JTopoBoxVolumeGroup) {
                this.volumeGroupPanel.setVisible(true);
                this.volumeGroupPanel.add(entity);
            }
        }

        public void removeEntity(AbstractJTopoEntity entity) {
            this.entityV.remove(entity);
            if (entity instanceof JTopoBoxLunGroup) {
                this.lunGroupPanel.remove(entity);
                this.lunGroupPanel.setVisible(this.lunGroupPanel.getComponentCount() > 0);
            } else if (entity instanceof JTopoBoxVolumeGroup) {
                this.volumeGroupPanel.remove(entity);
                this.volumeGroupPanel.setVisible(this.volumeGroupPanel.getComponentCount() > 0);
            }
        }

        public void removeAllEntities() {
            this.entityV.clear();
            this.lunGroupPanel.removeAll();
            this.lunGroupPanel.setVisible(false);
            this.volumeGroupPanel.removeAll();
            this.volumeGroupPanel.setVisible(false);
        }

        protected LayoutManager createDefaultLayout() {
            return new DefaultLayout();
        }

        protected class DefaultLayout
        extends TopoLayoutUtilities.VerticalLayout {
            public DefaultLayout() {
                this.setMargin(15);
                this.setSpacing(10);
                this.setAlignment(0);
            }
        }
    }
}

