/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.util.Enumeration;
import javax.swing.table.TableColumn;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphModelSubsystemL2;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2VolumePerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolumeGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolumeGroup2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolumePerf;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoTable;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoTabular;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnGroup;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnModel;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnRegular;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnStatus;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableModel;
import org.eclipse.aperi.gui.topo.widget.JCustomRendererTable;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularSubsystemL2;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoTableVolume
extends AbstractJTopoTable {
    private TableColumn removedColumnSubsystem;

    public JTopoTableVolume() {
        this.tableColumnModel = new DefaultTopoTableColumnModel();
        int columnCount = 0;
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnStatus(columnCount++, "TOPO_LABEL_ATTR_COMMON_LOCATED", null));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnStatus(columnCount++, "TOPO_LABEL_ATTR_COMMON_HEALTH", null));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnStatus(columnCount++, "TOPO_LABEL_ATTR_COMMON_PERF", null));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnGroup(columnCount++));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_LABEL", 150));
        if (GraphDebug.isInfoVisible()) {
            this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_DEBUG", 150));
        }
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_OPERATIONALSTATUS"));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_VOLUME_FORMAT"));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_VOLUME_CAPACITY"));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_VOLUME_ISASSIGNED"));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ENTITY_SUBSYSTEM"));
        this.table.setColumnModel(this.tableColumnModel);
        this.tableModel = new DefaultTopoTableModel(this.tableColumnModel);
        this.table.setModel(this.tableModel);
        this.arrangeRecordGroup = new AbstractJTopoTable.ArrangeRecord("TOPO_LABEL_ATTR_COMMON_GROUP", true);
        this.arrangeRecord = new AbstractJTopoTable.ArrangeRecord("TOPO_LABEL_ATTR_COMMON_LABEL", true);
    }

    protected void reattach() {
        DefaultTopoTableModel tableModel = (DefaultTopoTableModel)this.table.getModel();
        tableModel.removeAll();
        if (this.dataModel == null) {
            return;
        }
        GraphSubsystem subsystem = null;
        if (this.dataModel.getModelID() instanceof GraphModelSubsystemL2.ID) {
            subsystem = (GraphSubsystem)this.dataModel.get(this.dataModel.getModelID().getFocusEntityID());
        }
        DefaultTopoTableModel.RootNode root = tableModel.getRootNode();
        Enumeration enu2 = this.dataModel.enumerate(GraphVolumeGroup.TYPE);
        while (enu2.hasMoreElements()) {
            GraphVolumeGroup volumeGroup = (GraphVolumeGroup)enu2.nextElement();
            GraphVolumeGroup.ID volumeGroupID = (GraphVolumeGroup.ID)volumeGroup.getEntityID();
            if (Boolean.TRUE.equals(volumeGroup.getIsFilterable())) continue;
            DefaultTopoTableModel.GroupNode group = null;
            if (!Boolean.TRUE.equals(volumeGroup.getIsHelper())) {
                DefaultTopoTableModel defaultTopoTableModel = tableModel;
                defaultTopoTableModel.getClass();
                group = defaultTopoTableModel.new DefaultTopoTableModel.GroupNode(volumeGroupID);
                root.addMember(group);
                group.addData(new JCustomRendererTable.StatusCell(null, null, null));
                group.addData(new JCustomRendererTable.StatusCell(GraphModelUtilities.getStatusAlias(volumeGroup.getHealthStatus()), volumeGroup.getHealthStatus(), TopoResource.getIconHealth(volumeGroup.getHealthStatus())));
                Integer perfStatus = volumeGroup.getPerfStatus();
                if (perfStatus != null) {
                    group.addData(new JCustomRendererTable.StatusCell(GraphModelUtilities.getStatusAlias(perfStatus), perfStatus, TopoResource.getIconPerf(perfStatus)));
                } else {
                    group.addData(new JCustomRendererTable.StatusCell(null, null, null));
                }
                group.addData(new JCustomRendererTable.GroupLabelCell(volumeGroup.getDisplayName(), volumeGroup.getSortingValue(), volumeGroup.getCollationKey(), group));
            }
            Enumeration enu = this.dataModel.associator(GraphVolumeGroup2Volume.TYPE, volumeGroupID);
            while (enu.hasMoreElements()) {
                Enumeration subsystemEnu;
                GraphVolume volume = (GraphVolume)enu.nextElement();
                GraphVolume.ID volumeID = (GraphVolume.ID)volume.getEntityID();
                if (!(this.dataModel.getModelID() instanceof GraphModelSubsystemL2.ID) && (subsystemEnu = this.dataModel.associator(GraphSubsystem2Volume.TYPE, volumeID)).hasMoreElements()) {
                    subsystem = (GraphSubsystem)subsystemEnu.nextElement();
                }
                if (Boolean.TRUE.equals(volume.getIsFilterable())) continue;
                DefaultTopoTableModel defaultTopoTableModel = tableModel;
                defaultTopoTableModel.getClass();
                DefaultTopoTableModel.MemberNode member = defaultTopoTableModel.new DefaultTopoTableModel.MemberNode(volumeID);
                if (group == null) {
                    root.addMember(member);
                } else {
                    group.addMember(member);
                }
                member.addData(new JCustomRendererTable.StatusCell(null, null, null));
                member.addData(new JCustomRendererTable.StatusCell(GraphModelUtilities.getStatusAlias(volume.getHealthStatus()), volume.getHealthStatus(), TopoResource.getIconHealth(volume.getHealthStatus())));
                Enumeration volumePerfEnu = this.dataModel.associator(GraphVolume2VolumePerf.TYPE, volumeID);
                if (volumePerfEnu.hasMoreElements()) {
                    GraphVolumePerf perf = (GraphVolumePerf)volumePerfEnu.nextElement();
                    member.addData(new JCustomRendererTable.StatusCell(GraphModelUtilities.getStatusAlias(perf.getHealthStatus()), perf.getHealthStatus(), TopoResource.getIconPerf(perf.getHealthStatus())));
                } else {
                    member.addData(new JCustomRendererTable.StatusCell(null, null, null));
                }
                if (group == null) {
                    member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)GuiUtil.getString("TOPO_LABEL_COMMON_NA"))));
                } else {
                    member.addData(new JCustomRendererTable.MemberGroupLabelCell(volumeGroup.getDisplayName(), group));
                }
                member.addData(new JCustomRendererTable.CollatorCell(volume.getDisplayName(), volume.getCollationKey()));
                if (GraphDebug.isInfoVisible()) {
                    member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)volume.getEntityID().getID().toString())));
                }
                member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)GraphModelUtilities.getOperationalStatus(volume.getOperationalStatus()))));
                boolean fbVolume = GraphVolume.FORMAT_FB.equals(volume.getFormat());
                if (fbVolume) {
                    member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)GuiUtil.getString("TOPO_LABEL_ATTR_VOLUME_FORMAT_FB"))));
                    String s = GraphModelUtilities.byte2GBString(volume.getCapacity()) + " " + GuiUtil.getString("TOPO_LABEL_ATTR_VOLUME_UNITS_GB");
                    member.addData(new JCustomRendererTable.FormatedStringCell(s, volume.getCapacity()));
                } else {
                    String subsystemType = subsystem == null ? null : subsystem.getType();
                    Integer type = volume.getFormat();
                    int bytesPerCylinder = 798720;
                    if (subsystemType != null) {
                        if (subsystemType.equals(GraphSubsystem.MODEL_2107) || subsystemType.equals(GraphSubsystem.MODEL_1705)) {
                            if (GraphVolume.FORMAT_CKD_3380.equals(type)) {
                                bytesPerCylinder = 712140;
                            } else if (GraphVolume.FORMAT_CKD_3390.equals(type)) {
                                bytesPerCylinder = 849960;
                            }
                        } else if (subsystemType.equals(GraphSubsystem.MODEL_2105)) {
                            if (GraphVolume.FORMAT_CKD_3380.equals(type)) {
                                bytesPerCylinder = 798720;
                            } else if (GraphVolume.FORMAT_CKD_3390.equals(type)) {
                                bytesPerCylinder = 860160;
                            }
                        }
                    }
                    long cylinderValue = volume.getCapacity() / (long)bytesPerCylinder;
                    member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)GuiUtil.getString("TOPO_LABEL_ATTR_VOLUME_FORMAT_CKD"))));
                    String s = GraphModelUtilities.byte2ByteString(new Long(cylinderValue)) + " " + GuiUtil.getString("TOPO_LABEL_ATTR_VOLUME_UNITS_CYL");
                    member.addData(new JCustomRendererTable.FormatedStringCell(s, new Long(cylinderValue)));
                }
                member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)GraphModelUtilities.getBooleanStr(volume.getIsAssigned()))));
                if (subsystem != null) {
                    member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)subsystem.getDisplayName())));
                    continue;
                }
                member.addData(new JCustomRendererTable.ComparableCell(null));
            }
        }
        AbstractJTopoTabular tabular = this.getTabular();
        if (tabular instanceof JTopoTabularSubsystemL2) {
            this.showSubsystemColumn(false);
        } else {
            this.showSubsystemColumn(true);
        }
        this.arrange();
    }

    protected void showSubsystemColumn(boolean b) {
        if (b) {
            if (this.removedColumnSubsystem != null) {
                this.tableColumnModel.addColumn(this.removedColumnSubsystem);
                this.removedColumnSubsystem = null;
            }
        } else if (this.removedColumnSubsystem == null) {
            int columnIndexSubsystem = -1;
            for (int i = 0; i < this.tableColumnModel.getColumnCount(); ++i) {
                TableColumn column = this.tableColumnModel.getColumn(i);
                if (!column.getIdentifier().equals("TOPO_LABEL_ENTITY_SUBSYSTEM")) continue;
                columnIndexSubsystem = i;
                break;
            }
            if (columnIndexSubsystem != -1) {
                this.removedColumnSubsystem = this.tableColumnModel.getColumn(columnIndexSubsystem);
                this.tableColumnModel.removeColumn(this.removedColumnSubsystem);
            }
        }
    }
}

