/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Vector;

public class TopoLayoutUtilities {
    public static int getVisibleComponentCount(Container parent) {
        int count = 0;
        Component[] comps = parent.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            if (!comp.isVisible()) continue;
            ++count;
        }
        return count;
    }

    public static Vector getVisibleComponents(Container parent) {
        Vector<Component> v = new Vector<Component>();
        Component[] comps = parent.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            if (!comp.isVisible()) continue;
            v.add(comp);
        }
        return v;
    }

    public static abstract class GridLayout
    implements LayoutManager {
        protected int horizontalAlignment = 0;
        protected int verticalAlignment = 1;
        protected int horizontalJustify = 0;
        protected int verticalJustify = 0;
        protected int spacing = 0;
        protected int margin = 0;

        public int getHorizontalAlignment() {
            return this.horizontalAlignment;
        }

        public void setHorizontalAlignment(int horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
        }

        public int getVerticalAlignment() {
            return this.verticalAlignment;
        }

        public void setVerticalAlignment(int verticalAlignment) {
            this.verticalAlignment = verticalAlignment;
        }

        public int getHorizontalJustify() {
            return this.horizontalJustify;
        }

        public void setHorizontalJustify(int horizontalJustify) {
            this.horizontalJustify = horizontalJustify;
        }

        public int getVerticalJustify() {
            return this.verticalJustify;
        }

        public void setVerticalJustify(int verticalJustify) {
            this.verticalJustify = verticalJustify;
        }

        public int getSpacing() {
            return this.spacing;
        }

        public void setSpacing(int spacing) {
            this.spacing = spacing;
        }

        public int getMargin() {
            return this.margin;
        }

        public void setMargin(int margin) {
            this.margin = margin;
        }

        protected abstract Dimension getRowColumn(Vector var1);

        protected Component[][] getGrids(Vector compV, Dimension dim) {
            Component[][] comps = new Component[dim.height][dim.width];
            int size = compV.size();
            int count = 0;
            for (int r = 0; r < dim.height; ++r) {
                for (int c = 0; c < dim.width; ++c) {
                    if (count < size) {
                        comps[r][c] = (Component)compV.elementAt(count);
                    }
                    ++count;
                }
            }
            return comps;
        }

        protected Dimension[][] getDimensions(Component[][] comps) {
            int rowCount = comps.length;
            int columnCount = rowCount == 0 ? 0 : comps[0].length;
            Dimension[][] dims = new Dimension[rowCount][columnCount];
            for (int r = 0; r < rowCount; ++r) {
                for (int c = 0; c < columnCount; ++c) {
                    Component comp = comps[r][c];
                    if (comp == null) continue;
                    dims[r][c] = comp.getPreferredSize();
                }
            }
            return dims;
        }

        protected int[] getWidestDimensions(Dimension[][] dims) {
            int rowCount = dims.length;
            int columnCount = rowCount == 0 ? 0 : dims[0].length;
            int[] results = new int[columnCount];
            for (int c = 0; c < columnCount; ++c) {
                int widest = 0;
                for (int r = 0; r < rowCount; ++r) {
                    Dimension dim = dims[r][c];
                    if (dim == null) continue;
                    widest = dim.width > widest ? dim.width : widest;
                }
                results[c] = widest;
            }
            return results;
        }

        protected int[] getTallestDimensions(Dimension[][] dims) {
            int rowCount = dims.length;
            int columnCount = rowCount == 0 ? 0 : dims[0].length;
            int[] results = new int[rowCount];
            for (int r = 0; r < rowCount; ++r) {
                int tallest = 0;
                for (int c = 0; c < columnCount; ++c) {
                    Dimension dim = dims[r][c];
                    if (dim == null) continue;
                    tallest = dim.height > tallest ? dim.height : tallest;
                }
                results[r] = tallest;
            }
            return results;
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            Vector compV = TopoLayoutUtilities.getVisibleComponents(parent);
            Dimension rowColumnDim = this.getRowColumn(compV);
            Component[][] grids = this.getGrids(compV, rowColumnDim);
            Dimension[][] dims = this.getDimensions(grids);
            int[] widestDims = this.getWidestDimensions(dims);
            int[] tallestDims = this.getTallestDimensions(dims);
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            dim.width += this.margin * 2;
            dim.height += this.margin * 2;
            int w = 0;
            for (int i = 0; i < widestDims.length; ++i) {
                w += widestDims[i];
                if (i == 0) continue;
                w += this.spacing;
            }
            int h = 0;
            for (int i = 0; i < tallestDims.length; ++i) {
                h += tallestDims[i];
                if (i == 0) continue;
                h += this.spacing;
            }
            dim.width += w;
            dim.height += h;
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            int nextX = 0;
            int nextY = 0;
            Vector compV = TopoLayoutUtilities.getVisibleComponents(parent);
            Dimension rowColumnDim = this.getRowColumn(compV);
            Component[][] grids = this.getGrids(compV, rowColumnDim);
            Dimension[][] dims = this.getDimensions(grids);
            int[] widestDims = this.getWidestDimensions(dims);
            int[] tallestDims = this.getTallestDimensions(dims);
            Insets insets = parent.getInsets();
            nextX += insets.left;
            nextY += insets.top;
            nextX += this.margin;
            nextY += this.margin;
            int extraWidth = parent.getWidth() - insets.left - insets.right - this.margin * 2;
            for (int i = 0; i < widestDims.length; ++i) {
                if (i != 0) {
                    extraWidth -= this.spacing;
                }
                extraWidth -= widestDims[i];
            }
            int extraHeight = parent.getHeight() - insets.top - insets.bottom - this.margin * 2;
            for (int i = 0; i < tallestDims.length; ++i) {
                if (i != 0) {
                    extraHeight -= this.spacing;
                }
                extraHeight -= tallestDims[i];
            }
            if (this.horizontalJustify == 0) {
                nextX += extraWidth / 2;
            } else if (this.horizontalJustify == 4) {
                nextX += extraWidth;
            }
            if (this.verticalJustify == 0) {
                nextY += extraHeight / 2;
            } else if (this.verticalJustify == 3) {
                nextY += extraHeight;
            }
            int originalNextX = nextX;
            for (int r = 0; r < rowColumnDim.height; ++r) {
                int tallest = tallestDims[r];
                nextX = originalNextX;
                for (int c = 0; c < rowColumnDim.width; ++c) {
                    int widest = widestDims[c];
                    Component comp = grids[r][c];
                    Dimension d = dims[r][c];
                    if (d == null) continue;
                    int x = nextX;
                    int y = nextY;
                    int width = d.width;
                    int height = d.height;
                    if (this.horizontalAlignment == 0) {
                        x += (widest - width) / 2;
                    } else if (this.horizontalAlignment == 4) {
                        x += widest - width;
                    }
                    if (this.verticalAlignment == 0) {
                        y += (tallest - height) / 2;
                    } else if (this.verticalAlignment == 3) {
                        y += tallest - height;
                    }
                    comp.setBounds(x, y, width, height);
                    nextX += widestDims[c] + this.spacing;
                }
                nextY += tallest + this.spacing;
            }
        }
    }

    public static class VerticalGridLayout
    extends GridLayout {
        protected int sizePerRow;

        public VerticalGridLayout(int sizePerRow) {
            this.sizePerRow = sizePerRow;
        }

        protected Dimension getRowColumn(Vector compV) {
            int visibleCount = compV.size();
            int column = this.sizePerRow;
            int row = (int)Math.ceil((double)visibleCount / (double)column);
            return new Dimension(column, row);
        }
    }

    public static class HorizontalGridLayout
    extends GridLayout {
        protected int sizePerColumn;

        public HorizontalGridLayout(int sizePerColumn) {
            this.sizePerColumn = sizePerColumn;
        }

        protected Dimension getRowColumn(Vector compV) {
            int visibleCount = compV.size();
            int row = this.sizePerColumn;
            int column = (int)Math.ceil((double)visibleCount / (double)row);
            return new Dimension(column, row);
        }
    }

    public static class SquareGridLayout
    extends GridLayout {
        protected Dimension getRowColumn(Vector compV) {
            int visibleCount = compV.size();
            int column = (int)Math.ceil(Math.sqrt(visibleCount));
            int row = (int)Math.ceil((double)visibleCount / (double)column);
            return new Dimension(column, row);
        }
    }

    public static class VerticalLayout
    implements LayoutManager {
        protected int alignment = 2;
        protected int horizontalJustify = 0;
        protected int verticalJustify = 0;
        protected int spacing = 0;
        protected int margin = 0;

        public int getAlignment() {
            return this.alignment;
        }

        public void setAlignment(int alignment) {
            this.alignment = alignment;
        }

        public int getHorizontalJustify() {
            return this.horizontalJustify;
        }

        public void setHorizontalJustify(int horizontalJustify) {
            this.horizontalJustify = horizontalJustify;
        }

        public int getVerticalJustify() {
            return this.verticalJustify;
        }

        public void setVerticalJustify(int verticalJustify) {
            this.verticalJustify = verticalJustify;
        }

        public int getSpacing() {
            return this.spacing;
        }

        public void setSpacing(int spacing) {
            this.spacing = spacing;
        }

        public int getMargin() {
            return this.margin;
        }

        public void setMargin(int margin) {
            this.margin = margin;
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            Vector compV = TopoLayoutUtilities.getVisibleComponents(parent);
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            dim.width += this.margin * 2;
            dim.height += this.margin * 2;
            int w = 0;
            int h = 0;
            for (int i = 0; i < compV.size(); ++i) {
                Component comp = (Component)compV.elementAt(i);
                Dimension d = comp.getPreferredSize();
                int n = w = d.width > w ? d.width : w;
                if (i != 0) {
                    h += this.spacing;
                }
                h += d.height;
            }
            dim.width += w;
            dim.height += h;
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            int i;
            int nextX = 0;
            int nextY = 0;
            Vector compV = TopoLayoutUtilities.getVisibleComponents(parent);
            Dimension[] dims = new Dimension[compV.size()];
            for (int i2 = 0; i2 < compV.size(); ++i2) {
                Dimension d;
                Component comp = (Component)compV.elementAt(i2);
                dims[i2] = d = comp.getPreferredSize();
            }
            Insets insets = parent.getInsets();
            nextX += insets.left;
            nextY += insets.top;
            nextX += this.margin;
            nextY += this.margin;
            int widest = 0;
            for (int i3 = 0; i3 < compV.size(); ++i3) {
                Dimension d = dims[i3];
                widest = d.width > widest ? d.width : widest;
            }
            int extraWidth = parent.getWidth() - insets.left - insets.right - this.margin * 2 - widest;
            int extraHeight = parent.getHeight() - insets.top - insets.bottom - this.margin * 2;
            for (i = 0; i < dims.length; ++i) {
                if (i != 0) {
                    extraHeight -= this.spacing;
                }
                extraHeight -= dims[i].height;
            }
            if (this.horizontalJustify == 0) {
                nextX += extraWidth / 2;
            } else if (this.horizontalJustify == 4) {
                nextX += extraWidth;
            }
            if (this.verticalJustify == 0) {
                nextY += extraHeight / 2;
            } else if (this.verticalJustify == 3) {
                nextY += extraHeight;
            }
            for (i = 0; i < compV.size(); ++i) {
                Component comp = (Component)compV.elementAt(i);
                Dimension d = dims[i];
                int x = nextX;
                int y = nextY;
                int width = d.width;
                int height = d.height;
                if (this.alignment == 0) {
                    x += (widest - width) / 2;
                } else if (this.alignment == 4) {
                    x += widest - width;
                }
                comp.setBounds(x, y, width, height);
                nextY += height + this.spacing;
            }
        }
    }

    public static class HorizontalLayout
    implements LayoutManager {
        protected int alignment = 1;
        protected int horizontalJustify = 0;
        protected int verticalJustify = 0;
        protected int spacing = 0;
        protected int margin = 0;

        public int getAlignment() {
            return this.alignment;
        }

        public void setAlignment(int alignment) {
            this.alignment = alignment;
        }

        public int getHorizontalJustify() {
            return this.horizontalJustify;
        }

        public void setHorizontalJustify(int horizontalJustify) {
            this.horizontalJustify = horizontalJustify;
        }

        public int getVerticalJustify() {
            return this.verticalJustify;
        }

        public void setVerticalJustify(int verticalJustify) {
            this.verticalJustify = verticalJustify;
        }

        public int getSpacing() {
            return this.spacing;
        }

        public void setSpacing(int spacing) {
            this.spacing = spacing;
        }

        public int getMargin() {
            return this.margin;
        }

        public void setMargin(int margin) {
            this.margin = margin;
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            Vector compV = TopoLayoutUtilities.getVisibleComponents(parent);
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            dim.width += this.margin * 2;
            dim.height += this.margin * 2;
            int w = 0;
            int h = 0;
            for (int i = 0; i < compV.size(); ++i) {
                Component comp = (Component)compV.elementAt(i);
                Dimension d = comp.getPreferredSize();
                if (i != 0) {
                    w += this.spacing;
                }
                w += d.width;
                h = d.height > h ? d.height : h;
            }
            dim.width += w;
            dim.height += h;
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            int nextX = 0;
            int nextY = 0;
            Vector compV = TopoLayoutUtilities.getVisibleComponents(parent);
            Dimension[] dims = new Dimension[compV.size()];
            for (int i = 0; i < compV.size(); ++i) {
                Dimension d;
                Component comp = (Component)compV.elementAt(i);
                dims[i] = d = comp.getPreferredSize();
            }
            Insets insets = parent.getInsets();
            nextX += insets.left;
            nextY += insets.top;
            nextX += this.margin;
            nextY += this.margin;
            int tallest = 0;
            for (int i = 0; i < compV.size(); ++i) {
                Dimension d = dims[i];
                tallest = d.height > tallest ? d.height : tallest;
            }
            int extraWidth = parent.getWidth() - insets.left - insets.right - this.margin * 2;
            for (int i = 0; i < dims.length; ++i) {
                if (i != 0) {
                    extraWidth -= this.spacing;
                }
                extraWidth -= dims[i].width;
            }
            int extraHeight = parent.getHeight() - insets.top - insets.bottom - this.margin * 2 - tallest;
            if (this.horizontalJustify == 0) {
                nextX += extraWidth / 2;
            } else if (this.horizontalJustify == 4) {
                nextX += extraWidth;
            }
            if (this.verticalJustify == 0) {
                nextY += extraHeight / 2;
            } else if (this.verticalJustify == 3) {
                nextY += extraHeight;
            }
            for (int i = 0; i < compV.size(); ++i) {
                Component comp = (Component)compV.elementAt(i);
                Dimension d = dims[i];
                int x = nextX;
                int y = nextY;
                int width = d.width;
                int height = d.height;
                if (this.alignment == 0) {
                    y += (tallest - height) / 2;
                } else if (this.alignment == 3) {
                    y += tallest - height;
                }
                comp.setBounds(x, y, width, height);
                nextX += width + this.spacing;
            }
        }
    }
}

