/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import org.eclipse.aperi.gui.topo.model.GraphGroupingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL0;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL1;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL2;
import org.eclipse.aperi.gui.topo.model.GraphModelFabricL2;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL0;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL1;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL2;
import org.eclipse.aperi.gui.topo.model.GraphModelOverview;
import org.eclipse.aperi.gui.topo.model.GraphModelStorageL0;
import org.eclipse.aperi.gui.topo.model.GraphModelSubsystemL1;
import org.eclipse.aperi.gui.topo.model.GraphModelSubsystemL2;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL0;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL1;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL2;
import org.eclipse.aperi.gui.topo.model.GraphModelTapeLibraryL1;
import org.eclipse.aperi.gui.topo.model.GraphModelTapeLibraryL2;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;

public class TopoSetting
implements Serializable {
    protected boolean isOverlayHealthEnabled = true;
    protected boolean isOverlayPerfEnabled = false;
    protected int filteringLevel = 0;
    protected boolean isShowConnectionEnabled = true;
    protected boolean isShowZoneEnabled = false;
    protected int refreshRate = 5;
    protected Rectangle minimapBounds = new Rectangle(660, 50, 120, 90);
    protected LinkedHashSet openedViews = new LinkedHashSet();
    protected Hashtable settingPerViewTypeH;

    public TopoSetting() {
        this.openedViews.add(new GraphModelOverview.ID());
        this.settingPerViewTypeH = new Hashtable();
        SettingPerViewType settingPerViewType = new SettingPerViewType();
        this.settingPerViewTypeH.put("Overview", settingPerViewType);
        settingPerViewType = new SettingPerViewType();
        this.settingPerViewTypeH.put("FabricL0", settingPerViewType);
        settingPerViewType = new SettingPerViewType();
        this.settingPerViewTypeH.put("FabricL2", settingPerViewType);
        settingPerViewType.setGroupByBitmap(GraphModelFabricL2.COMPUTERGROUP, GraphGroupingUtilities.GROUPBY_ALL);
        settingPerViewType.setGroupByBitmap(GraphModelFabricL2.SWGROUP, GraphGroupingUtilities.GROUPBY_ALL);
        settingPerViewType.setGroupByBitmap(GraphModelFabricL2.SUBSYSTEMGROUP, GraphGroupingUtilities.GROUPBY_ALL);
        settingPerViewType.setGroupByBitmap(GraphModelFabricL2.TAPELIBRARYGROUP, GraphGroupingUtilities.GROUPBY_ALL);
        settingPerViewType.setGroupByBitmap(GraphModelFabricL2.OTHERGROUP, GraphGroupingUtilities.GROUPBY_ALL);
        settingPerViewType = new SettingPerViewType();
        this.settingPerViewTypeH.put("ComputerL0", settingPerViewType);
        settingPerViewType.setGroupByBitmap(GraphModelComputerL0.COMPUTERGROUP, GraphGroupingUtilities.GROUPBY_HEALTH);
        settingPerViewType = new SettingPerViewType();
        this.settingPerViewTypeH.put("ComputerL1", settingPerViewType);
        settingPerViewType.setGroupByBitmap(GraphModelComputerL1.SWGROUP, GraphGroupingUtilities.GROUPBY_SWBYFABRIC);
        settingPerViewType.setGroupByBitmap(GraphModelComputerL1.VOLUMEGROUP, GraphGroupingUtilities.GROUPBY_VOLUMEBYSUBSYSTEM);
        settingPerViewType = new SettingPerViewType();
        this.settingPerViewTypeH.put("ComputerL2", settingPerViewType);
        settingPerViewType.setGroupByBitmap(GraphModelComputerL2.SWGROUP, GraphGroupingUtilities.GROUPBY_SWBYFABRIC);
        settingPerViewType.setGroupByBitmap(GraphModelComputerL2.VOLUMEGROUP, GraphGroupingUtilities.GROUPBY_VOLUMEBYSUBSYSTEM);
        settingPerViewType = new SettingPerViewType();
        this.settingPerViewTypeH.put("SwitchL0", settingPerViewType);
        settingPerViewType.setGroupByBitmap(GraphModelSwitchL0.SWGROUP, GraphGroupingUtilities.GROUPBY_HEALTH);
        settingPerViewType = new SettingPerViewType();
        this.settingPerViewTypeH.put("SwitchL1", settingPerViewType);
        settingPerViewType.setGroupByBitmap(GraphModelSwitchL1.COMPUTERGROUP, GraphGroupingUtilities.GROUPBY_ALL);
        settingPerViewType.setGroupByBitmap(GraphModelSwitchL1.SWGROUP, GraphGroupingUtilities.GROUPBY_ALL);
        settingPerViewType.setGroupByBitmap(GraphModelSwitchL1.SUBSYSTEMGROUP, GraphGroupingUtilities.GROUPBY_ALL);
        settingPerViewType.setGroupByBitmap(GraphModelSwitchL1.TAPELIBRARYGROUP, GraphGroupingUtilities.GROUPBY_ALL);
        settingPerViewType.setGroupByBitmap(GraphModelSwitchL1.OTHERGROUP, GraphGroupingUtilities.GROUPBY_ALL);
        settingPerViewType = new SettingPerViewType();
        this.settingPerViewTypeH.put("SwitchL2", settingPerViewType);
        settingPerViewType.setGroupByBitmap(GraphModelSwitchL2.COMPUTERGROUP, GraphGroupingUtilities.GROUPBY_ALL);
        settingPerViewType.setGroupByBitmap(GraphModelSwitchL2.SWGROUP, GraphGroupingUtilities.GROUPBY_ALL);
        settingPerViewType.setGroupByBitmap(GraphModelSwitchL2.SUBSYSTEMGROUP, GraphGroupingUtilities.GROUPBY_ALL);
        settingPerViewType.setGroupByBitmap(GraphModelSwitchL2.TAPELIBRARYGROUP, GraphGroupingUtilities.GROUPBY_ALL);
        settingPerViewType.setGroupByBitmap(GraphModelSwitchL2.OTHERGROUP, GraphGroupingUtilities.GROUPBY_ALL);
        settingPerViewType = new SettingPerViewType();
        this.settingPerViewTypeH.put("StorageL0", settingPerViewType);
        settingPerViewType.setGroupByBitmap(GraphModelStorageL0.SUBSYSTEMGROUP, GraphGroupingUtilities.GROUPBY_HEALTH);
        settingPerViewType.setGroupByBitmap(GraphModelStorageL0.TAPELIBRARYGROUP, GraphGroupingUtilities.GROUPBY_HEALTH);
        settingPerViewType = new SettingPerViewType();
        this.settingPerViewTypeH.put("SubsystemL1", settingPerViewType);
        settingPerViewType.setGroupByBitmap(GraphModelSubsystemL1.SWGROUP, GraphGroupingUtilities.GROUPBY_SWBYFABRIC);
        settingPerViewType = new SettingPerViewType();
        this.settingPerViewTypeH.put("SubsystemL2", settingPerViewType);
        settingPerViewType.setGroupByBitmap(GraphModelSubsystemL2.SWGROUP, GraphGroupingUtilities.GROUPBY_SWBYFABRIC);
        settingPerViewType.setGroupByBitmap(GraphModelSubsystemL2.VOLUMEGROUP_EXTERNAL, GraphGroupingUtilities.GROUPBY_VOLUMEBYSUBSYSTEM);
        settingPerViewType.setGroupByBitmap(GraphModelSubsystemL2.DISKGROUP, GraphGroupingUtilities.GROUPBY_DISKBYPOOL);
        settingPerViewType.setGroupByBitmap(GraphModelSubsystemL2.POOLGROUP, GraphGroupingUtilities.GROUPBY_POOLBYRAID);
        settingPerViewType.setGroupByBitmap(GraphModelSubsystemL2.VOLUMEGROUP, GraphGroupingUtilities.GROUPBY_VOLUMEBYPOOL);
        settingPerViewType.setGroupByBitmap(GraphModelSubsystemL2.DISKGROUP_EXTERNAL, GraphGroupingUtilities.GROUPBY_DISKBYSUBSYSTEM);
        settingPerViewType.setGroupByBitmap(GraphModelSubsystemL2.LUNGROUP, GraphGroupingUtilities.GROUPBY_LUNBYDEVICE);
        settingPerViewType = new SettingPerViewType();
        this.settingPerViewTypeH.put("TapeLibraryL1", settingPerViewType);
        settingPerViewType.setGroupByBitmap(GraphModelTapeLibraryL1.SWGROUP, GraphGroupingUtilities.GROUPBY_SWBYFABRIC);
        settingPerViewType = new SettingPerViewType();
        this.settingPerViewTypeH.put("TapeLibraryL2", settingPerViewType);
        settingPerViewType.setGroupByBitmap(GraphModelTapeLibraryL2.SWGROUP, GraphGroupingUtilities.GROUPBY_SWBYFABRIC);
        settingPerViewType.setGroupByBitmap(GraphModelTapeLibraryL2.TAPEDRIVEGROUP, GraphGroupingUtilities.GROUPBY_ALL);
        settingPerViewType = new SettingPerViewType();
        this.settingPerViewTypeH.put("OtherL0", settingPerViewType);
        settingPerViewType.setGroupByBitmap(GraphModelOtherL0.OTHERGROUP, GraphGroupingUtilities.GROUPBY_HEALTH);
        settingPerViewType = new SettingPerViewType();
        this.settingPerViewTypeH.put("OtherL1", settingPerViewType);
        settingPerViewType.setGroupByBitmap(GraphModelOtherL1.SWGROUP, GraphGroupingUtilities.GROUPBY_SWBYFABRIC);
        settingPerViewType.setGroupByBitmap(GraphModelOtherL1.VOLUMEGROUP, GraphGroupingUtilities.GROUPBY_VOLUMEBYSUBSYSTEM);
        settingPerViewType = new SettingPerViewType();
        this.settingPerViewTypeH.put("OtherL2", settingPerViewType);
        settingPerViewType.setGroupByBitmap(GraphModelOtherL2.SWGROUP, GraphGroupingUtilities.GROUPBY_SWBYFABRIC);
        settingPerViewType.setGroupByBitmap(GraphModelOtherL2.VOLUMEGROUP, GraphGroupingUtilities.GROUPBY_VOLUMEBYSUBSYSTEM);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TopoSetting {");
        sb.append("isOverlayHealthEnabled=" + this.isOverlayHealthEnabled);
        sb.append(",isOverlayPerfEnabled=" + this.isOverlayPerfEnabled);
        sb.append(",filteringLevel=" + this.filteringLevel);
        sb.append(",isShowConnectionEnabled=" + this.isShowConnectionEnabled);
        sb.append(",isShowZoneEnabled=" + this.isShowZoneEnabled);
        sb.append(",refreshRate=" + this.refreshRate);
        sb.append(",openedViews=" + this.openedViews);
        sb.append(",minimapBounds=" + this.minimapBounds);
        sb.append(",settingPerViewTypeH=" + this.settingPerViewTypeH);
        sb.append("}");
        return sb.toString();
    }

    public boolean isOverlayHealthEnabled() {
        return this.isOverlayHealthEnabled;
    }

    public void setOverlayHealthEnabled(boolean b) {
        this.isOverlayHealthEnabled = b;
    }

    public boolean isOverlayPerfEnabled() {
        return this.isOverlayPerfEnabled;
    }

    public void setOverlayPerfEnabled(boolean b) {
        this.isOverlayPerfEnabled = b;
    }

    public int getFilteringLevel() {
        return this.filteringLevel;
    }

    public void setFilteringLevel(int filteringLevel) {
        this.filteringLevel = filteringLevel;
    }

    public boolean isShowConnectionEnabled() {
        return this.isShowConnectionEnabled;
    }

    public void setShowConnectionEnabled(boolean b) {
        this.isShowConnectionEnabled = b;
    }

    public boolean isShowZoneEnabled() {
        return this.isShowZoneEnabled;
    }

    public void setShowZoneEnabled(boolean b) {
        this.isShowZoneEnabled = b;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
    }

    public Rectangle getMinimapBounds() {
        return this.minimapBounds;
    }

    public void setMinimapBounds(Rectangle r) {
        this.minimapBounds = r;
    }

    public LinkedHashSet getOpenedViews() {
        return this.openedViews;
    }

    public void setOpenedViews(LinkedHashSet hs) {
        this.openedViews = hs;
    }

    public boolean isViewOpened(GraphModel.ID modelID) {
        return this.openedViews.contains(modelID);
    }

    public void addOpenedView(GraphModel.ID modelID) {
        this.openedViews.add(modelID);
    }

    public void removeOpenedView(GraphModel.ID modelID) {
        this.openedViews.remove(modelID);
    }

    public SettingPerViewType getSettingPerViewType(String viewType) {
        return (SettingPerViewType)this.settingPerViewTypeH.get(viewType);
    }

    public void setSettingPerViewType(String viewType, SettingPerViewType setting) {
        this.settingPerViewTypeH.put(viewType, setting);
    }

    protected class SettingPerViewType
    implements Serializable {
        protected double splitRatio = 0.62;
        protected Hashtable groupByH = new Hashtable();

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("PerViewType{");
            sb.append("splitRatio=" + this.splitRatio);
            sb.append(",groupingH=" + this.groupByH);
            sb.append("}");
            return sb.toString();
        }

        public double getSplitRatio() {
            return this.splitRatio;
        }

        public void setSplitRatio(double ratio) {
            this.splitRatio = ratio;
        }

        public Hashtable getGroupBySet() {
            return this.groupByH;
        }

        public void setGroupBySet(Hashtable groupByH) {
            this.groupByH = groupByH;
        }

        public Integer getGroupByBitmap(GraphScopedType scopedType) {
            return (Integer)this.groupByH.get(scopedType);
        }

        public void setGroupByBitmap(GraphScopedType scopedType, Integer groupByBitmap) {
            this.groupByH.put(scopedType, groupByBitmap);
        }
    }
}

