/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget.plaf.basic;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableColumn;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnModel;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableModel;

public class BasicCustomRendererTableUI
extends BasicTableUI {
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        this.overwriteGrid(g, c);
    }

    protected void overwriteGrid(Graphics g, JComponent c) {
        if (this.table.getShowVerticalLines()) {
            DefaultTopoTableModel tableModel = (DefaultTopoTableModel)this.table.getModel();
            DefaultTopoTableModel.RootNode root = tableModel.getRootNode();
            this.overwriteGrid_helper(g, root);
        }
    }

    protected void overwriteGrid_helper(Graphics g, DefaultTopoTableModel.GroupNode group) {
        int rowIndex = group.getRowIndex();
        if (rowIndex != -1) {
            boolean isRowSelected = this.table.isRowSelected(rowIndex);
            if (isRowSelected) {
                g.setColor(this.table.getSelectionBackground());
            } else {
                g.setColor(this.table.getBackground());
            }
            DefaultTopoTableColumnModel tableColumnModel = (DefaultTopoTableColumnModel)this.table.getColumnModel();
            int columnIndexGroup = tableColumnModel.getColumnIndex("TOPO_LABEL_ATTR_COMMON_GROUP");
            Rectangle r = this.table.getCellRect(rowIndex, columnIndexGroup, true);
            int x = r.x;
            int y = r.y;
            int h = r.height;
            for (int i = columnIndexGroup; i < tableColumnModel.getColumnCount(); ++i) {
                TableColumn column = tableColumnModel.getColumn(i);
                g.drawLine((x += column.getWidth()) - 1, y, x - 1, y + h - 2);
            }
        }
        if (!group.isCollapsed()) {
            Vector memberV = group.getMemberVector();
            for (int i = 0; i < memberV.size(); ++i) {
                DefaultTopoTableModel.MemberNode member = (DefaultTopoTableModel.MemberNode)memberV.elementAt(i);
                if (!(member instanceof DefaultTopoTableModel.GroupNode)) continue;
                this.overwriteGrid_helper(g, (DefaultTopoTableModel.GroupNode)member);
            }
        }
    }
}

