/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

public final class ColumnInfo
implements Comparable {
    private String name;
    private int datatype;
    private int length;
    private String tableName;
    private boolean m_isForeignKey = false;
    private boolean m_isNullable = true;
    private boolean m_isPrimaryKey = false;
    private boolean m_isAutoGenerated = false;
    private String m_operator = null;
    private ColumnInfo m_referencedColumn;

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ColumnInfo) {
            return this.name.equals(((ColumnInfo)o).getName());
        }
        if (o instanceof String) {
            return this.name.equals((String)o);
        }
        return super.equals(o);
    }

    public int compareTo(Object c2) {
        if (c2 instanceof ColumnInfo) {
            return this.name.compareTo(((ColumnInfo)c2).getName());
        }
        throw new ClassCastException("Unable to compare " + c2.getClass().getName());
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDataType(int datatype) {
        this.datatype = datatype;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setForeignKeyConstraint() {
        this.m_isForeignKey = true;
    }

    public void unsetForeignKeyConstraint() {
        this.m_isForeignKey = false;
    }

    public void setAutoGenerated() {
        this.m_isAutoGenerated = true;
    }

    public void unsetAutoGenerated() {
        this.m_isAutoGenerated = false;
    }

    public void setNullable() {
        this.m_isNullable = true;
    }

    public void setIsPrimaryKey() {
        this.m_isPrimaryKey = true;
    }

    public void unsetIsPrimaryKey() {
        this.m_isPrimaryKey = false;
    }

    public void setReferencedColumn(ColumnInfo colInfo) {
        this.m_referencedColumn = colInfo;
    }

    public void unsetReferencedColumn() {
        this.m_referencedColumn = null;
    }

    public String getName() {
        return this.name;
    }

    public int getDataType() {
        return this.datatype;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isNullable() {
        return this.m_isNullable;
    }

    public boolean isAutoGenerated() {
        return this.m_isAutoGenerated;
    }

    public boolean isPrimaryKey() {
        return this.m_isPrimaryKey;
    }

    public boolean getForeignKeyConstraint() {
        return this.m_isForeignKey;
    }

    public ColumnInfo getReferencedColumn() {
        return this.m_referencedColumn;
    }

    public ColumnInfo addOperator(String operator) {
        ColumnInfo ret = new ColumnInfo();
        ret.name = this.name;
        ret.datatype = this.datatype;
        ret.tableName = this.tableName;
        ret.m_operator = operator;
        return ret;
    }

    public String getOperator() {
        return this.m_operator;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Column: ");
        sb.append(this.name);
        sb.append(", Data Type: ");
        sb.append(this.datatype);
        return sb.toString();
    }
}

