/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.sanmgmt.Variables;

public class DBConnection
implements PooledConnection,
Cloneable {
    static final String className = DBConnection.class.getName();
    private boolean supportsGeneratedKeys;
    private Connection connection;
    private String schema;
    private boolean closed = false;
    private boolean transactionActive = false;
    private Vector activeSql = new Vector();
    private Hashtable psCache = new Hashtable();
    private static PrintStream debug = null;
    private static boolean traceStatements;
    private static Object[] patterns;
    private static PrintWriter traceOut;

    public DBConnection(Connection connection) {
        this.connection = connection;
        try {
            this.supportsGeneratedKeys = connection.getMetaData().supportsGetGeneratedKeys();
        }
        catch (Throwable e) {
            this.supportsGeneratedKeys = false;
        }
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public void setSchema(String schema) {
        this.schema = schema;
        try {
            DatabaseMetaData dbmd = this.connection.getMetaData();
            String db_vendor = dbmd.getDatabaseProductName();
            Statement stmt = this.connection.createStatement();
            if (db_vendor.startsWith("DB2")) {
                stmt.executeUpdate("set current schema = " + schema);
                stmt.close();
            } else if (db_vendor.startsWith("Oracle")) {
                stmt.executeUpdate("alter session set current_schema=" + schema);
                stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
    }

    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connection.setReadOnly(readOnly);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    public void commit() throws SQLException {
        String methodName = "commit";
        if (this.connection != null) {
            this.transactionActive = false;
            this.activeSql.clear();
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        String methodName = "rollback";
        if (this.connection != null) {
            this.transactionActive = false;
            this.activeSql.clear();
            this.connection.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        String methodName = "close";
        if (!this.closed) {
            try {
                this.drainPsCache();
                this.connection.commit();
            }
            finally {
                this.closed = true;
                if (this.connection != null) {
                    DBConnPoolDataSource.returnConnection(this);
                }
            }
        } else {
            DBConnection.debugPrintException(new Exception("Multiple invocations of DBConnection.close() detected"));
            throw new SQLException("Closed connection is being closed again");
        }
    }

    public void clear() {
        this.closed = false;
        this.activeSql.clear();
    }

    public synchronized boolean isClosed() throws SQLException {
        if (this.closed) {
            return true;
        }
        if (this.connection != null) {
            if (this.connection.isClosed()) {
                this.closed = true;
                DBConnPoolDataSource.returnConnection(this);
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean isClosedReal() throws SQLException {
        if (this.connection != null) {
            return this.connection.isClosed();
        }
        return true;
    }

    protected void closeReal() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public DBPreparedStatement prepareStatement(String sql) throws SQLException {
        DBPreparedStatement dbps = null;
        if (traceStatements) {
            try {
                for (int i = 0; i < patterns.length; ++i) {
                    if (!((Pattern)patterns[i]).matcher(sql).matches()) continue;
                    Exception e = new Exception("PrepareStatement called for: " + sql);
                    e.printStackTrace(traceOut);
                    traceOut.flush();
                    break;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        PreparedStatement ps = this.connection.prepareStatement(sql, 1004, 1007);
        dbps = new DBPreparedStatement(ps, this);
        dbps.setSql(sql);
        this.addToPsCache(dbps);
        return dbps;
    }

    public DBPreparedStatement prepareStatement(String sql, boolean lob) throws SQLException {
        DBPreparedStatement dbps = null;
        if (traceStatements) {
            try {
                for (int i = 0; i < patterns.length; ++i) {
                    if (!((Pattern)patterns[i]).matcher(sql).matches()) continue;
                    Exception e = new Exception("PrepareStatement called for: " + sql);
                    e.printStackTrace(traceOut);
                    traceOut.flush();
                    break;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        PreparedStatement ps = null;
        ps = lob ? this.connection.prepareStatement(sql) : this.connection.prepareStatement(sql, 1004, 1007);
        if (ps != null) {
            dbps = new DBPreparedStatement(ps, this);
            dbps.setSql(sql);
            this.addToPsCache(dbps);
        }
        return dbps;
    }

    public synchronized void addToPsCache(DBPreparedStatement dbps) {
        if (dbps != null) {
            this.psCache.put(dbps, new Exception("DBPreparedStatement created"));
        }
    }

    public synchronized void removeFromPsCache(DBPreparedStatement dbps) {
        if (dbps != null) {
            this.psCache.remove(dbps);
        }
    }

    public synchronized void drainPsCache() {
        if (this.psCache.size() > 0) {
            Enumeration enu = this.psCache.keys();
            while (enu.hasMoreElements()) {
                DBPreparedStatement dbps = (DBPreparedStatement)enu.nextElement();
                try {
                    dbps.close();
                }
                catch (Exception exception) {}
            }
            this.psCache.clear();
        }
    }

    public synchronized void printOpenStatements(PrintWriter pw) {
        DBConnection.debugPrintExceptions(pw, "Open statements from " + this, this.psCache.elements());
    }

    public synchronized void printActiveTransaction(PrintWriter pw) {
        DBConnection.debugPrintln(pw, "Transaction active = " + this.transactionActive);
        if (this.transactionActive) {
            for (int i = 0; i < this.activeSql.size(); ++i) {
                DBConnection.debugPrintln(pw, (String)this.activeSql.get(i));
            }
        }
    }

    public static synchronized void debugPrintln(String str) {
        if (debug == null) {
            return;
        }
        if (str != null) {
            debug.println(new Date().toString() + " " + str);
        }
    }

    public static synchronized void debugPrintln(PrintWriter pw, String str) {
        if (pw == null) {
            return;
        }
        if (str != null) {
            pw.println(new Date().toString() + " " + str);
        }
    }

    public static synchronized void debugPrintException(Exception e) {
        if (debug == null) {
            return;
        }
        if (e != null) {
            DBConnection.debugPrintln("");
            e.printStackTrace(debug);
        }
    }

    public static synchronized void debugPrintException(PrintWriter pw, Exception e) {
        if (pw == null) {
            return;
        }
        if (e != null) {
            DBConnection.debugPrintln(pw, "");
            e.printStackTrace(pw);
        }
    }

    public static synchronized void debugPrintExceptions(String header, Enumeration enu) {
        if (debug == null) {
            return;
        }
        if (header != null) {
            debug.println(new Date().toString() + " " + header);
        }
        if (enu != null) {
            while (enu.hasMoreElements()) {
                Object obj = enu.nextElement();
                if (!(obj instanceof Exception)) continue;
                DBConnection.debugPrintException((Exception)obj);
            }
        }
    }

    public static synchronized void debugPrintExceptions(PrintWriter pw, String header, Enumeration enu) {
        if (pw == null) {
            return;
        }
        if (header != null) {
            pw.println(new Date().toString() + " " + header);
        }
        if (enu == null || !enu.hasMoreElements()) {
            pw.println("  None");
        }
        if (enu != null) {
            while (enu.hasMoreElements()) {
                Object obj = enu.nextElement();
                if (!(obj instanceof Exception)) continue;
                DBConnection.debugPrintException(pw, (Exception)obj);
            }
        }
    }

    public Object clone() {
        DBConnection dbc = null;
        try {
            dbc = (DBConnection)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return dbc;
    }

    protected synchronized void setTransactionActive(String sql) {
        if (sql != null) {
            this.transactionActive = true;
            this.activeSql.add(sql);
        }
    }

    static {
        String traceFile = "dbtrace.log";
        String logDir = Variables.getBaseDirectory() + File.separator + "log";
        File logDirFile = new File(logDir);
        if (logDirFile.exists() && logDirFile.canWrite()) {
            traceFile = logDir + File.separator + traceFile;
        }
        try {
            debug = new PrintStream(new FileOutputStream(traceFile, true), true);
        }
        catch (Throwable t) {
            // empty catch block
        }
        traceStatements = false;
        patterns = null;
        traceOut = null;
        String stmtFile = System.getProperty("tpc.dbtrace.statement.file");
        if (stmtFile != null) {
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(stmtFile));
                Vector<Pattern> lines = new Vector<Pattern>();
                while ((line = in.readLine()) != null) {
                    lines.add(Pattern.compile(line));
                }
                in.close();
                patterns = lines.toArray();
                traceOut = new PrintWriter(new FileWriter(stmtFile + ".out"));
                System.err.println("DBTRACE: PreparedStatement tracing turned on. Input file = " + stmtFile + ", Output File = " + stmtFile + ".out");
                traceStatements = true;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

