/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

public class Debug {
    public static final boolean debug = true;
    public static final boolean trace = true;
    public static final int debug_level = 3;

    private static void format(String base, Object o, PrintStream out) {
        String toString;
        if (o instanceof Exception) {
            ByteArrayOutputStream bous = new ByteArrayOutputStream();
            PrintStream pstream = new PrintStream(bous);
            ((Exception)o).printStackTrace(pstream);
            toString = bous.toString();
        } else {
            toString = o.toString();
        }
        Exception e = new Exception();
        StackTraceElement[] st = e.getStackTrace();
        StackTraceElement elem = null;
        if (st != null && st.length > 2) {
            elem = st[2];
        }
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        DateFormat dateFormat = DateFormat.getTimeInstance(1);
        String prefix = '[' + dateFormat.format(date) + "] - " + (elem != null ? "at " + elem.toString() : "") + " " + base.toUpperCase();
        String newOutput = toString.replaceAll("\n", "\n" + prefix);
        out.println(prefix + newOutput);
    }

    public static void debug(Object o) {
        Debug.format("debug - ", o, System.out);
    }

    public static void error(Object e) {
        Debug.format("error - ", e, System.err);
    }

    public static void warning(Object e) {
        Debug.format("warning - ", e, System.out);
    }

    public static void info(Object e) {
        Debug.format("info - ", e, System.out);
    }

    public static void trace(Object e) {
        Debug.format("trace -", e, System.out);
    }
}

