/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.eclipse.aperi.infrastructure.database.DBConnection;

public class SQLExceptionHelper {
    public static final String SQLSTATE_ROW_NOT_FOUND = "2000";

    public static boolean isDuplicateKeyViolation(DBConnection con, SQLException e) throws SQLException {
        if (con == null) {
            throw new SQLException("Null connection provided to isDuplicateKeyViolation");
        }
        if (e == null) {
            throw new SQLException("Null exception provided to isDuplicateKeyViolation");
        }
        String sqlState = e.getSQLState();
        return sqlState != null && sqlState.length() == 5 && sqlState.charAt(0) == '2' && sqlState.charAt(1) == '3';
    }

    public static boolean isRowNotFound(DBConnection con, SQLException e) throws SQLException {
        if (con == null) {
            throw new SQLException("Null connection provided to isRowNotFound");
        }
        if (e == null) {
            throw new SQLException("Null exception provided to isRowNotFound");
        }
        String sqlState = e.getSQLState();
        return sqlState != null && sqlState.equals(SQLSTATE_ROW_NOT_FOUND);
    }

    public static boolean isDeadlock(DBConnection con, SQLException e) throws SQLException {
        if (con == null) {
            throw new SQLException("Null connection provided to isDeadlock");
        }
        if (e == null) {
            throw new SQLException("Null exception provided to isDeadlock");
        }
        if (con.getConnection() == null) {
            throw new SQLException("Null SQL connection provided to isDeadlock");
        }
        DatabaseMetaData dbmd = con.getConnection().getMetaData();
        if (dbmd == null) {
            throw new SQLException("Invalid metadata returned for isDeadlock");
        }
        String db_vendor = dbmd.getDatabaseProductName();
        int errorCode = e.getErrorCode();
        String sqlState = e.getSQLState();
        return db_vendor != null && (db_vendor.startsWith("Microsoft SQL Server") && errorCode == 1205 || db_vendor.startsWith("DB2") && errorCode == -911 || db_vendor.startsWith("Apache Derby") && sqlState != null && sqlState.equals("40001") || db_vendor.startsWith("Oracle") && errorCode == 60);
    }

    public static boolean isOutOfSpace(DBConnection con, SQLException e) throws SQLException {
        if (con == null) {
            throw new SQLException("Null connection provided to isOutOfSpace");
        }
        if (e == null) {
            throw new SQLException("Null exception provided to isOutOfSpace");
        }
        if (con.getConnection() == null) {
            throw new SQLException("Null SQL connection provided to isOutOfSpace");
        }
        DatabaseMetaData dbmd = con.getConnection().getMetaData();
        if (dbmd == null) {
            throw new SQLException("Invalid metadata returned for isOutOfSpace");
        }
        String db_vendor = dbmd.getDatabaseProductName();
        String sqlState = e.getSQLState();
        int errorCode = e.getErrorCode();
        return db_vendor != null && (db_vendor.startsWith("DB2") && sqlState != null && (sqlState.equals("57011") || sqlState.equals("58004")) || db_vendor.startsWith("Oracle") && sqlState != null && sqlState.equals("72000") && errorCode == 1653 || db_vendor.startsWith("Apache Derby") && sqlState != null && sqlState.equals("XSDG1") || db_vendor.startsWith("Microsoft SQL Server") && sqlState != null && sqlState.equals("01000") && errorCode == 1105);
    }

    public static boolean isTransactionLogFull(DBConnection con, SQLException e) throws SQLException {
        if (con == null) {
            throw new SQLException("Null connection provided to isTransactionLogFull");
        }
        if (e == null) {
            throw new SQLException("Null exception provided to isTransactionLogFull");
        }
        if (con.getConnection() == null) {
            throw new SQLException("Null SQL connection provided to isTransactionLogFull");
        }
        DatabaseMetaData dbmd = con.getConnection().getMetaData();
        if (dbmd == null) {
            throw new SQLException("Invalid metadata returned for isTransactionLogFull");
        }
        String db_vendor = dbmd.getDatabaseProductName();
        String sqlState = e.getSQLState();
        int errorCode = e.getErrorCode();
        return db_vendor != null && (db_vendor.startsWith("DB2") && sqlState != null && sqlState.equals("57011") || db_vendor.startsWith("Oracle") && sqlState != null && sqlState.equals("99999") && errorCode == 30036 || db_vendor.startsWith("Apache Derby") && sqlState != null && sqlState.equals("XSLA4") || db_vendor.startsWith("Microsoft SQL Server") && sqlState != null && sqlState.equals("01000") && errorCode == 9002);
    }

    public static boolean isDatabaseDown(DBConnection con, SQLException e) throws SQLException {
        if (con == null) {
            throw new SQLException("Null connection provided to isDatabaseDown");
        }
        if (e == null) {
            throw new SQLException("Null exception provided to isDatabaseDown");
        }
        if (con.getConnection() == null) {
            throw new SQLException("Null SQL connection provided to isDatabaseDown");
        }
        DatabaseMetaData dbmd = con.getConnection().getMetaData();
        if (dbmd == null) {
            throw new SQLException("Invalid metadata returned for isDatabaseDown");
        }
        String db_vendor = dbmd.getDatabaseProductName();
        String sqlState = e.getSQLState();
        int errorCode = e.getErrorCode();
        return db_vendor != null && (db_vendor.startsWith("DB2") && sqlState != null && sqlState.equals("55032") || db_vendor.startsWith("Oracle") && sqlState == null && errorCode == 0 || db_vendor.startsWith("Apache Derby") && sqlState != null && sqlState.equals("XJ015") || db_vendor.startsWith("Microsoft SQL Server") && sqlState != null && sqlState.equals("08S01") && errorCode == 0);
    }

    public static boolean isConnectionLost(DBConnection con, SQLException e) throws SQLException {
        if (con == null) {
            throw new SQLException("Null connection provided to isDatabaseDown");
        }
        if (e == null) {
            throw new SQLException("Null exception provided to isDatabaseDown");
        }
        if (con.getConnection() == null) {
            throw new SQLException("Null SQL connection provided to isDatabaseDown");
        }
        DatabaseMetaData dbmd = con.getConnection().getMetaData();
        if (dbmd == null) {
            throw new SQLException("Invalid metadata returned for isDatabaseDown");
        }
        String db_vendor = dbmd.getDatabaseProductName();
        String sqlState = e.getSQLState();
        int errorCode = e.getErrorCode();
        return db_vendor != null && (db_vendor.startsWith("Apache Derby") && sqlState != null && sqlState.startsWith("0800") || db_vendor.startsWith("DB2") && errorCode == -999999);
    }
}

