/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResAgentTable;

public class Agent
extends TResAgentTable {
    public static AgentCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new AgentCursor(con, htWhereClause, columns);
    }

    public Agent() {
        this.clear();
    }

    public Agent(int ComputerId, int PortNumber, int ServerId, String State2, Timestamp TimeStamp, String ProcessorType, short ProcessorNumber, String Modification, byte[] ProductStates, byte[] ProductVersions, byte[] FeatureSet) {
        this.clear();
        this.m_ComputerId = ComputerId;
        this.m_PortNumber = PortNumber;
        this.m_ServerId = ServerId;
        this.m_State = State2;
        this.m_TimeStamp = TimeStamp;
        this.m_ProcessorType = ProcessorType;
        this.m_ProcessorNumber = ProcessorNumber;
        this.m_Modification = Modification;
        this.m_ProductStates = ProductStates;
        this.m_ProductVersions = ProductVersions;
        this.m_FeatureSet = FeatureSet;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_ComputerId != Integer.MIN_VALUE) {
            htColsAndValues.put(Agent.getColumnInfo("COMPUTER_ID"), String.valueOf(this.m_ComputerId));
        }
        if (this.m_PortNumber != Integer.MIN_VALUE) {
            htColsAndValues.put(Agent.getColumnInfo("PORT_NUMBER"), String.valueOf(this.m_PortNumber));
        }
        if (this.m_ServerId != Integer.MIN_VALUE) {
            htColsAndValues.put(Agent.getColumnInfo("SERVER_ID"), String.valueOf(this.m_ServerId));
        }
        if (this.m_State != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Agent.getColumnInfo("STATE"), this.m_State);
        }
        if (this.m_TimeStamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(Agent.getColumnInfo("TIME_STAMP"), this.m_TimeStamp);
        }
        if (this.m_ProcessorType != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Agent.getColumnInfo("PROCESSOR_TYPE"), this.m_ProcessorType);
        }
        if (this.m_ProcessorNumber != Short.MIN_VALUE) {
            htColsAndValues.put(Agent.getColumnInfo("PROCESSOR_NUMBER"), String.valueOf(this.m_ProcessorNumber));
        }
        if (this.m_Modification != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Agent.getColumnInfo("MODIFICATION"), this.m_Modification);
        }
        if (this.m_ProductStates != DBConstants.INVALID_BYTE_ARRAY_VALUE) {
            htColsAndValues.put(Agent.getColumnInfo("PRODUCT_STATES"), new String(this.m_ProductStates));
        }
        if (this.m_ProductVersions != DBConstants.INVALID_BYTE_ARRAY_VALUE) {
            htColsAndValues.put(Agent.getColumnInfo("PRODUCT_VERSIONS"), new String(this.m_ProductVersions));
        }
        if (this.m_FeatureSet != DBConstants.INVALID_BYTE_ARRAY_VALUE) {
            htColsAndValues.put(Agent.getColumnInfo("FEATURE_SET"), new String(this.m_FeatureSet));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_AGENT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_RES_AGENT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_AGENT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_AGENT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_AGENT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_AGENT", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_AGENT", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Agent retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Agent el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_AGENT", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Agent();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_AGENT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_AGENT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setComputerId(DBrs.getInt("COMPUTER_ID"));
        this.setPortNumber(DBrs.getInt("PORT_NUMBER"));
        this.setServerId(DBrs.getInt("SERVER_ID"));
        this.setState(DBrs.getString("STATE"));
        this.setTimeStamp(DBrs.getTimestamp("TIME_STAMP"));
        this.setProcessorType(DBrs.getString("PROCESSOR_TYPE"));
        this.setProcessorNumber(DBrs.getShort("PROCESSOR_NUMBER"));
        this.setModification(DBrs.getString("MODIFICATION"));
        this.setProductStates(DBrs.getBytes("PRODUCT_STATES"));
        this.setProductVersions(DBrs.getBytes("PRODUCT_VERSIONS"));
        this.setFeatureSet(DBrs.getBytes("FEATURE_SET"));
    }

    public static class AgentCursor
    extends DBCursor {
        private Agent element = new Agent();
        private DBConnection con;

        public AgentCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_AGENT", con, htWhereClause, columns);
            this.con = con;
        }

        public Agent getObject() throws SQLException {
            Agent el = null;
            if (this.DBrs != null) {
                el = new Agent();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Agent getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

