/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResAuthRolesTable;

public class AuthRoles
extends TResAuthRolesTable {
    public static AuthRolesCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new AuthRolesCursor(con, htWhereClause, columns);
    }

    public AuthRoles() {
        this.clear();
    }

    public AuthRoles(int RoleId, String RoleName, String GroupName, short GroupType) {
        this.clear();
        this.m_RoleId = RoleId;
        this.m_RoleName = RoleName;
        this.m_GroupName = GroupName;
        this.m_GroupType = GroupType;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_RoleName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(AuthRoles.getColumnInfo("ROLE_NAME"), this.m_RoleName);
        }
        if (this.m_GroupName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(AuthRoles.getColumnInfo("GROUP_NAME"), this.m_GroupName);
        }
        if (this.m_GroupType != Short.MIN_VALUE) {
            htColsAndValues.put(AuthRoles.getColumnInfo("GROUP_TYPE"), String.valueOf(this.m_GroupType));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_RoleId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key ROLE_ID not found");
        }
        this.htColsAndValues.put(AuthRoles.getColumnInfo("ROLE_ID"), String.valueOf(this.m_RoleId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_AUTH_ROLES", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(AuthRoles.getColumnInfo("ROLE_ID")) == null) {
            throw new SQLException(" ERROR: key ROLE_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_AUTH_ROLES", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_RoleId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key ROLE_ID not found");
        }
        this.htWhereClause.put(AuthRoles.getColumnInfo("ROLE_ID"), String.valueOf(this.m_RoleId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_AUTH_ROLES", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(AuthRoles.getColumnInfo("ROLE_ID")) == null) {
            throw new SQLException(" ERROR: key ROLE_ID not found");
        }
        this.htWhereClause.put(AuthRoles.getColumnInfo("ROLE_ID"), htinput.get(AuthRoles.getColumnInfo("ROLE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_AUTH_ROLES", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_RoleId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key ROLE_ID not found");
        }
        this.htWhereClause.put(AuthRoles.getColumnInfo("ROLE_ID"), String.valueOf(this.m_RoleId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_AUTH_ROLES", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(AuthRoles.getColumnInfo("ROLE_ID")) == null) {
            throw new SQLException(" ERROR: key ROLE_ID not found");
        }
        this.htWhereClause.put(AuthRoles.getColumnInfo("ROLE_ID"), htinput.get(AuthRoles.getColumnInfo("ROLE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_AUTH_ROLES", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_RoleId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key ROLE_ID not found");
        }
        this.htWhereClause.put(AuthRoles.getColumnInfo("ROLE_ID"), String.valueOf(this.m_RoleId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_AUTH_ROLES", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthRoles retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        AuthRoles el = null;
        if (htinput.get(AuthRoles.getColumnInfo("ROLE_ID")) == null) {
            throw new SQLException(" ERROR: key ROLE_ID not found");
        }
        htWhereClause.put(AuthRoles.getColumnInfo("ROLE_ID"), htinput.get(AuthRoles.getColumnInfo("ROLE_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_AUTH_ROLES", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new AuthRoles();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_AUTH_ROLES", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_AUTH_ROLES", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setRoleId(DBrs.getInt("ROLE_ID"));
        this.setRoleName(DBrs.getString("ROLE_NAME"));
        this.setGroupName(DBrs.getString("GROUP_NAME"));
        this.setGroupType(DBrs.getShort("GROUP_TYPE"));
    }

    public static class AuthRolesCursor
    extends DBCursor {
        private AuthRoles element = new AuthRoles();
        private DBConnection con;

        public AuthRolesCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_AUTH_ROLES", con, htWhereClause, columns);
            this.con = con;
        }

        public AuthRoles getObject() throws SQLException {
            AuthRoles el = null;
            if (this.DBrs != null) {
                el = new AuthRoles();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public AuthRoles getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

