/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemTable;

public class CimkeySubsystem
extends TResCimkeySubsystemTable {
    private String m_CreationClassNameId_str;

    public void setCreationClassName(String el) {
        this.m_CreationClassNameId_str = el;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public static CimkeySubsystemCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new CimkeySubsystemCursor(con, htWhereClause, columns);
    }

    public CimkeySubsystem() {
        this.clear();
    }

    public CimkeySubsystem(int CimkeySubsystemId, int SubsystemId, int CimNamespaceId, String Name2, short NameFormat, short CreationClassNameId, int CapabilityDataId, short Active) {
        this.clear();
        this.m_CimkeySubsystemId = CimkeySubsystemId;
        this.m_SubsystemId = SubsystemId;
        this.m_CimNamespaceId = CimNamespaceId;
        this.m_Name = Name2;
        this.m_NameFormat = NameFormat;
        this.m_CreationClassNameId = CreationClassNameId;
        this.m_CapabilityDataId = CapabilityDataId;
        this.m_Active = Active;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_CimkeySubsystemId != Integer.MIN_VALUE) {
            htColsAndValues.put(CimkeySubsystem.getColumnInfo("CIMKEY_SUBSYSTEM_ID"), String.valueOf(this.m_CimkeySubsystemId));
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(CimkeySubsystem.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_NameFormat != Short.MIN_VALUE) {
            htColsAndValues.put(CimkeySubsystem.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_CapabilityDataId != Integer.MIN_VALUE) {
            htColsAndValues.put(CimkeySubsystem.getColumnInfo("CAPABILITY_DATA_ID"), String.valueOf(this.m_CapabilityDataId));
        }
        if (this.m_Active != Short.MIN_VALUE) {
            htColsAndValues.put(CimkeySubsystem.getColumnInfo("ACTIVE"), String.valueOf(this.m_Active));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htColsAndValues.put(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htColsAndValues.put(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_CIMKEY_SUBSYSTEM", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        if (htinput.get(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_CIMKEY_SUBSYSTEM", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMKEY_SUBSYSTEM", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID"), htinput.get(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID")));
        if (htinput.get(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID"), htinput.get(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMKEY_SUBSYSTEM", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CIMKEY_SUBSYSTEM", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID"), htinput.get(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID")));
        if (htinput.get(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID"), htinput.get(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CIMKEY_SUBSYSTEM", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_CIMKEY_SUBSYSTEM", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CimkeySubsystem retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        CimkeySubsystem el = null;
        if (htinput.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        htWhereClause.put(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID"), htinput.get(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID")));
        if (htinput.get(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        htWhereClause.put(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID"), htinput.get(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_CIMKEY_SUBSYSTEM", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new CimkeySubsystem();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMKEY_SUBSYSTEM", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_CIMKEY_SUBSYSTEM", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setCimkeySubsystemId(DBrs.getInt("CIMKEY_SUBSYSTEM_ID"));
        this.setSubsystemId(DBrs.getInt("SUBSYSTEM_ID"));
        this.setCimNamespaceId(DBrs.getInt("CIM_NAMESPACE_ID"));
        this.setName(DBrs.getString("NAME"));
        this.setNameFormat(DBrs.getShort("NAME_FORMAT"));
        this.setCreationClassNameId(DBrs.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(con, this.m_CreationClassNameId));
        this.setCapabilityDataId(DBrs.getInt("CAPABILITY_DATA_ID"));
        this.setActive(DBrs.getShort("ACTIVE"));
    }

    public static class CimkeySubsystemCursor
    extends DBCursor {
        private CimkeySubsystem element = new CimkeySubsystem();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResCimkeySubsystemTable.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResCimkeySubsystemTable.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TResCimkeySubsystemTable.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            return htWhereClause;
        }

        public CimkeySubsystemCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_CIMKEY_SUBSYSTEM", con, CimkeySubsystemCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public CimkeySubsystem getObject() throws SQLException {
            CimkeySubsystem el = null;
            if (this.DBrs != null) {
                el = new CimkeySubsystem();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public CimkeySubsystem getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

