/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResClusterTable;

public class Cluster
extends TResClusterTable {
    public static ClusterCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new ClusterCursor(con, htWhereClause, columns);
    }

    public Cluster() {
        this.clear();
    }

    public Cluster(int ClusterId, String ClusterName, String DomainName, String IpAddress, int DomainId, short ClusterType, Timestamp DiscoveredTime) {
        this.clear();
        this.m_ClusterId = ClusterId;
        this.m_ClusterName = ClusterName;
        this.m_DomainName = DomainName;
        this.m_IpAddress = IpAddress;
        this.m_DomainId = DomainId;
        this.m_ClusterType = ClusterType;
        this.m_DiscoveredTime = DiscoveredTime;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_ClusterId != Integer.MIN_VALUE) {
            htColsAndValues.put(Cluster.getColumnInfo("CLUSTER_ID"), String.valueOf(this.m_ClusterId));
        }
        if (this.m_ClusterName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Cluster.getColumnInfo("CLUSTER_NAME"), this.m_ClusterName);
        }
        if (this.m_DomainName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Cluster.getColumnInfo("DOMAIN_NAME"), this.m_DomainName);
        }
        if (this.m_IpAddress != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Cluster.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        }
        if (this.m_DomainId != Integer.MIN_VALUE) {
            htColsAndValues.put(Cluster.getColumnInfo("DOMAIN_ID"), String.valueOf(this.m_DomainId));
        }
        if (this.m_ClusterType != Short.MIN_VALUE) {
            htColsAndValues.put(Cluster.getColumnInfo("CLUSTER_TYPE"), String.valueOf(this.m_ClusterType));
        }
        if (this.m_DiscoveredTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(Cluster.getColumnInfo("DISCOVERED_TIME"), this.m_DiscoveredTime);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_CLUSTER", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_RES_CLUSTER", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CLUSTER", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CLUSTER", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CLUSTER", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CLUSTER", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_CLUSTER", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cluster retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Cluster el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_CLUSTER", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Cluster();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_CLUSTER", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_CLUSTER", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setClusterId(DBrs.getInt("CLUSTER_ID"));
        this.setClusterName(DBrs.getString("CLUSTER_NAME"));
        this.setDomainName(DBrs.getString("DOMAIN_NAME"));
        this.setIpAddress(DBrs.getString("IP_ADDRESS"));
        this.setDomainId(DBrs.getInt("DOMAIN_ID"));
        this.setClusterType(DBrs.getShort("CLUSTER_TYPE"));
        this.setDiscoveredTime(DBrs.getTimestamp("DISCOVERED_TIME"));
    }

    public static class ClusterCursor
    extends DBCursor {
        private Cluster element = new Cluster();
        private DBConnection con;

        public ClusterCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_CLUSTER", con, htWhereClause, columns);
            this.con = con;
        }

        public Cluster getObject() throws SQLException {
            Cluster el = null;
            if (this.DBrs != null) {
                el = new Cluster();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Cluster getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

