/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResDevAccessTable;

public class DevAccess
extends TResDevAccessTable {
    public static DevAccessCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new DevAccessCursor(con, htWhereClause, columns);
    }

    public DevAccess() {
        this.clear();
    }

    public DevAccess(int ControllerId, int DeviceId, short Target, short Lun2, String Path2, String InActive) {
        this.clear();
        this.m_ControllerId = ControllerId;
        this.m_DeviceId = DeviceId;
        this.m_Target = Target;
        this.m_Lun = Lun2;
        this.m_Path = Path2;
        this.m_InActive = InActive;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_ControllerId != Integer.MIN_VALUE) {
            htColsAndValues.put(DevAccess.getColumnInfo("CONTROLLER_ID"), String.valueOf(this.m_ControllerId));
        }
        if (this.m_DeviceId != Integer.MIN_VALUE) {
            htColsAndValues.put(DevAccess.getColumnInfo("DEVICE_ID"), String.valueOf(this.m_DeviceId));
        }
        if (this.m_Target != Short.MIN_VALUE) {
            htColsAndValues.put(DevAccess.getColumnInfo("TARGET"), String.valueOf(this.m_Target));
        }
        if (this.m_Lun != Short.MIN_VALUE) {
            htColsAndValues.put(DevAccess.getColumnInfo("LUN"), String.valueOf(this.m_Lun));
        }
        if (this.m_Path != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(DevAccess.getColumnInfo("PATH"), this.m_Path);
        }
        if (this.m_InActive != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(DevAccess.getColumnInfo("IN_ACTIVE"), this.m_InActive);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_DEV_ACCESS", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_RES_DEV_ACCESS", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_DEV_ACCESS", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_DEV_ACCESS", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_DEV_ACCESS", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_DEV_ACCESS", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_DEV_ACCESS", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DevAccess retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        DevAccess el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_DEV_ACCESS", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new DevAccess();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_DEV_ACCESS", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_DEV_ACCESS", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setControllerId(DBrs.getInt("CONTROLLER_ID"));
        this.setDeviceId(DBrs.getInt("DEVICE_ID"));
        this.setTarget(DBrs.getShort("TARGET"));
        this.setLun(DBrs.getShort("LUN"));
        this.setPath(DBrs.getString("PATH"));
        this.setInActive(DBrs.getString("IN_ACTIVE"));
    }

    public static class DevAccessCursor
    extends DBCursor {
        private DevAccess element = new DevAccess();
        private DBConnection con;

        public DevAccessCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_DEV_ACCESS", con, htWhereClause, columns);
            this.con = con;
        }

        public DevAccess getObject() throws SQLException {
            DevAccess el = null;
            if (this.DBrs != null) {
                el = new DevAccess();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public DevAccess getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

