/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TStatDiskHistTable;

public class DiskHist
extends TStatDiskHistTable {
    public static DiskHistCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new DiskHistCursor(con, htWhereClause, columns);
    }

    public DiskHist() {
        this.clear();
    }

    public DiskHist(int DiskId, Timestamp StatisticTime, String StatisticType, int PrimaryDefects, int GrownDefects, int RecovrdWrtErrs, int UnrecovrdWrtErrs, double BytesWritten, int RecovrdRdErrs, int UnrecovrdRdErrs, double BytesRead, int RecovrdVfyErrs, int UnrecovrdVfyErrs, int NonMediumErrs, double Capacity, double FreeSpace, short Temperature) {
        this.clear();
        this.m_DiskId = DiskId;
        this.m_StatisticTime = StatisticTime;
        this.m_StatisticType = StatisticType;
        this.m_PrimaryDefects = PrimaryDefects;
        this.m_GrownDefects = GrownDefects;
        this.m_RecovrdWrtErrs = RecovrdWrtErrs;
        this.m_UnrecovrdWrtErrs = UnrecovrdWrtErrs;
        this.m_BytesWritten = BytesWritten;
        this.m_RecovrdRdErrs = RecovrdRdErrs;
        this.m_UnrecovrdRdErrs = UnrecovrdRdErrs;
        this.m_BytesRead = BytesRead;
        this.m_RecovrdVfyErrs = RecovrdVfyErrs;
        this.m_UnrecovrdVfyErrs = UnrecovrdVfyErrs;
        this.m_NonMediumErrs = NonMediumErrs;
        this.m_Capacity = Capacity;
        this.m_FreeSpace = FreeSpace;
        this.m_Temperature = Temperature;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_DiskId != Integer.MIN_VALUE) {
            htColsAndValues.put(DiskHist.getColumnInfo("DISK_ID"), String.valueOf(this.m_DiskId));
        }
        if (this.m_StatisticTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(DiskHist.getColumnInfo("STATISTIC_TIME"), this.m_StatisticTime);
        }
        if (this.m_StatisticType != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(DiskHist.getColumnInfo("STATISTIC_TYPE"), this.m_StatisticType);
        }
        if (this.m_PrimaryDefects != Integer.MIN_VALUE) {
            htColsAndValues.put(DiskHist.getColumnInfo("PRIMARY_DEFECTS"), String.valueOf(this.m_PrimaryDefects));
        }
        if (this.m_GrownDefects != Integer.MIN_VALUE) {
            htColsAndValues.put(DiskHist.getColumnInfo("GROWN_DEFECTS"), String.valueOf(this.m_GrownDefects));
        }
        if (this.m_RecovrdWrtErrs != Integer.MIN_VALUE) {
            htColsAndValues.put(DiskHist.getColumnInfo("RECOVRD_WRT_ERRS"), String.valueOf(this.m_RecovrdWrtErrs));
        }
        if (this.m_UnrecovrdWrtErrs != Integer.MIN_VALUE) {
            htColsAndValues.put(DiskHist.getColumnInfo("UNRECOVRD_WRT_ERRS"), String.valueOf(this.m_UnrecovrdWrtErrs));
        }
        if (this.m_BytesWritten != Double.MIN_VALUE) {
            htColsAndValues.put(DiskHist.getColumnInfo("BYTES_WRITTEN"), String.valueOf(this.m_BytesWritten));
        }
        if (this.m_RecovrdRdErrs != Integer.MIN_VALUE) {
            htColsAndValues.put(DiskHist.getColumnInfo("RECOVRD_RD_ERRS"), String.valueOf(this.m_RecovrdRdErrs));
        }
        if (this.m_UnrecovrdRdErrs != Integer.MIN_VALUE) {
            htColsAndValues.put(DiskHist.getColumnInfo("UNRECOVRD_RD_ERRS"), String.valueOf(this.m_UnrecovrdRdErrs));
        }
        if (this.m_BytesRead != Double.MIN_VALUE) {
            htColsAndValues.put(DiskHist.getColumnInfo("BYTES_READ"), String.valueOf(this.m_BytesRead));
        }
        if (this.m_RecovrdVfyErrs != Integer.MIN_VALUE) {
            htColsAndValues.put(DiskHist.getColumnInfo("RECOVRD_VFY_ERRS"), String.valueOf(this.m_RecovrdVfyErrs));
        }
        if (this.m_UnrecovrdVfyErrs != Integer.MIN_VALUE) {
            htColsAndValues.put(DiskHist.getColumnInfo("UNRECOVRD_VFY_ERRS"), String.valueOf(this.m_UnrecovrdVfyErrs));
        }
        if (this.m_NonMediumErrs != Integer.MIN_VALUE) {
            htColsAndValues.put(DiskHist.getColumnInfo("NON_MEDIUM_ERRS"), String.valueOf(this.m_NonMediumErrs));
        }
        if (this.m_Capacity != Double.MIN_VALUE) {
            htColsAndValues.put(DiskHist.getColumnInfo("CAPACITY"), String.valueOf(this.m_Capacity));
        }
        if (this.m_FreeSpace != Double.MIN_VALUE) {
            htColsAndValues.put(DiskHist.getColumnInfo("FREE_SPACE"), String.valueOf(this.m_FreeSpace));
        }
        if (this.m_Temperature != Short.MIN_VALUE) {
            htColsAndValues.put(DiskHist.getColumnInfo("TEMPERATURE"), String.valueOf(this.m_Temperature));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_STAT_DISK_HIST", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_STAT_DISK_HIST", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_DISK_HIST", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_DISK_HIST", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_DISK_HIST", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_DISK_HIST", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_STAT_DISK_HIST", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiskHist retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        DiskHist el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_STAT_DISK_HIST", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new DiskHist();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_STAT_DISK_HIST", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_STAT_DISK_HIST", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setDiskId(DBrs.getInt("DISK_ID"));
        this.setStatisticTime(DBrs.getTimestamp("STATISTIC_TIME"));
        this.setStatisticType(DBrs.getString("STATISTIC_TYPE"));
        this.setPrimaryDefects(DBrs.getInt("PRIMARY_DEFECTS"));
        this.setGrownDefects(DBrs.getInt("GROWN_DEFECTS"));
        this.setRecovrdWrtErrs(DBrs.getInt("RECOVRD_WRT_ERRS"));
        this.setUnrecovrdWrtErrs(DBrs.getInt("UNRECOVRD_WRT_ERRS"));
        this.setBytesWritten(DBrs.getDouble("BYTES_WRITTEN"));
        this.setRecovrdRdErrs(DBrs.getInt("RECOVRD_RD_ERRS"));
        this.setUnrecovrdRdErrs(DBrs.getInt("UNRECOVRD_RD_ERRS"));
        this.setBytesRead(DBrs.getDouble("BYTES_READ"));
        this.setRecovrdVfyErrs(DBrs.getInt("RECOVRD_VFY_ERRS"));
        this.setUnrecovrdVfyErrs(DBrs.getInt("UNRECOVRD_VFY_ERRS"));
        this.setNonMediumErrs(DBrs.getInt("NON_MEDIUM_ERRS"));
        this.setCapacity(DBrs.getDouble("CAPACITY"));
        this.setFreeSpace(DBrs.getDouble("FREE_SPACE"));
        this.setTemperature(DBrs.getShort("TEMPERATURE"));
    }

    public static class DiskHistCursor
    extends DBCursor {
        private DiskHist element = new DiskHist();
        private DBConnection con;

        public DiskHistCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_STAT_DISK_HIST", con, htWhereClause, columns);
            this.con = con;
        }

        public DiskHist getObject() throws SQLException {
            DiskHist el = null;
            if (this.DBrs != null) {
                el = new DiskHist();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public DiskHist getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

