/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResExportTable;

public class Export
extends TResExportTable {
    public static ExportCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new ExportCursor(con, htWhereClause, columns);
    }

    public Export() {
        this.clear();
    }

    public Export(int ExportId, int ComputerId, String Protocol, String Path2, String ExportName, Timestamp DiscoveredTime) {
        this.clear();
        this.m_ExportId = ExportId;
        this.m_ComputerId = ComputerId;
        this.m_Protocol = Protocol;
        this.m_Path = Path2;
        this.m_ExportName = ExportName;
        this.m_DiscoveredTime = DiscoveredTime;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_ExportId != Integer.MIN_VALUE) {
            htColsAndValues.put(Export.getColumnInfo("EXPORT_ID"), String.valueOf(this.m_ExportId));
        }
        if (this.m_ComputerId != Integer.MIN_VALUE) {
            htColsAndValues.put(Export.getColumnInfo("COMPUTER_ID"), String.valueOf(this.m_ComputerId));
        }
        if (this.m_Protocol != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Export.getColumnInfo("PROTOCOL"), this.m_Protocol);
        }
        if (this.m_Path != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Export.getColumnInfo("PATH"), this.m_Path);
        }
        if (this.m_ExportName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Export.getColumnInfo("EXPORT_NAME"), this.m_ExportName);
        }
        if (this.m_DiscoveredTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(Export.getColumnInfo("DISCOVERED_TIME"), this.m_DiscoveredTime);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_EXPORT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_RES_EXPORT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_EXPORT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_EXPORT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_EXPORT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_EXPORT", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_EXPORT", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Export retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Export el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_EXPORT", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Export();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_EXPORT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_EXPORT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setExportId(DBrs.getInt("EXPORT_ID"));
        this.setComputerId(DBrs.getInt("COMPUTER_ID"));
        this.setProtocol(DBrs.getString("PROTOCOL"));
        this.setPath(DBrs.getString("PATH"));
        this.setExportName(DBrs.getString("EXPORT_NAME"));
        this.setDiscoveredTime(DBrs.getTimestamp("DISCOVERED_TIME"));
    }

    public static class ExportCursor
    extends DBCursor {
        private Export element = new Export();
        private DBConnection con;

        public ExportCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_EXPORT", con, htWhereClause, columns);
            this.con = con;
        }

        public Export getObject() throws SQLException {
            Export el = null;
            if (this.DBrs != null) {
                el = new Export();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Export getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

