/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResFabric2switchTable;

public class Fabric2switch
extends TResFabric2switchTable {
    public static Fabric2switchCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new Fabric2switchCursor(con, htWhereClause, columns);
    }

    public Fabric2switch() {
        this.clear();
    }

    public Fabric2switch(int Fabric2switchId, String FabricWwn, String SwitchWwn, Timestamp UpdateTimestamp, short Detectable, int OperationalStatus, short ConsolidatedStatus) {
        this.clear();
        this.m_Fabric2switchId = Fabric2switchId;
        this.m_FabricWwn = FabricWwn;
        this.m_SwitchWwn = SwitchWwn;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_Detectable = Detectable;
        this.m_OperationalStatus = OperationalStatus;
        this.m_ConsolidatedStatus = ConsolidatedStatus;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_Fabric2switchId != Integer.MIN_VALUE) {
            htColsAndValues.put(Fabric2switch.getColumnInfo("FABRIC2SWITCH_ID"), String.valueOf(this.m_Fabric2switchId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(Fabric2switch.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(Fabric2switch.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(Fabric2switch.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(Fabric2switch.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htColsAndValues.put(Fabric2switch.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htColsAndValues.put(Fabric2switch.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_FABRIC2SWITCH", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Fabric2switch.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        if (htinput.get(Fabric2switch.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        return DBQueryAssistant.performInsert("T_RES_FABRIC2SWITCH", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Fabric2switch.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(Fabric2switch.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_FABRIC2SWITCH", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Fabric2switch.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Fabric2switch.getColumnInfo("FABRIC_WWN"), htinput.get(Fabric2switch.getColumnInfo("FABRIC_WWN")));
        if (htinput.get(Fabric2switch.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(Fabric2switch.getColumnInfo("SWITCH_WWN"), htinput.get(Fabric2switch.getColumnInfo("SWITCH_WWN")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_FABRIC2SWITCH", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Fabric2switch.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(Fabric2switch.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_FABRIC2SWITCH", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Fabric2switch.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Fabric2switch.getColumnInfo("FABRIC_WWN"), htinput.get(Fabric2switch.getColumnInfo("FABRIC_WWN")));
        if (htinput.get(Fabric2switch.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(Fabric2switch.getColumnInfo("SWITCH_WWN"), htinput.get(Fabric2switch.getColumnInfo("SWITCH_WWN")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_FABRIC2SWITCH", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Fabric2switch.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(Fabric2switch.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_FABRIC2SWITCH", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Fabric2switch retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Fabric2switch el = null;
        if (htinput.get(Fabric2switch.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        htWhereClause.put(Fabric2switch.getColumnInfo("FABRIC_WWN"), htinput.get(Fabric2switch.getColumnInfo("FABRIC_WWN")));
        if (htinput.get(Fabric2switch.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        htWhereClause.put(Fabric2switch.getColumnInfo("SWITCH_WWN"), htinput.get(Fabric2switch.getColumnInfo("SWITCH_WWN")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_FABRIC2SWITCH", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Fabric2switch();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_FABRIC2SWITCH", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_FABRIC2SWITCH", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setFabric2switchId(DBrs.getInt("FABRIC2SWITCH_ID"));
        this.setFabricWwn(DBrs.getString("FABRIC_WWN"));
        this.setSwitchWwn(DBrs.getString("SWITCH_WWN"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(DBrs.getShort("CONSOLIDATED_STATUS"));
    }

    public static class Fabric2switchCursor
    extends DBCursor {
        private Fabric2switch element = new Fabric2switch();
        private DBConnection con;

        public Fabric2switchCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_FABRIC2SWITCH", con, htWhereClause, columns);
            this.con = con;
        }

        public Fabric2switch getObject() throws SQLException {
            Fabric2switch el = null;
            if (this.DBrs != null) {
                el = new Fabric2switch();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Fabric2switch getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

