/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TFoundFilesystemTable;

public class FoundFilesystem
extends TFoundFilesystemTable {
    public static FoundFilesystemCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new FoundFilesystemCursor(con, htWhereClause, columns);
    }

    public FoundFilesystem() {
        this.clear();
    }

    public FoundFilesystem(int ComputerId, int FilesystemId, int ScanningCompId, String MountPoint, String NonRoot) {
        this.clear();
        this.m_ComputerId = ComputerId;
        this.m_FilesystemId = FilesystemId;
        this.m_ScanningCompId = ScanningCompId;
        this.m_MountPoint = MountPoint;
        this.m_NonRoot = NonRoot;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_ComputerId != Integer.MIN_VALUE) {
            htColsAndValues.put(FoundFilesystem.getColumnInfo("COMPUTER_ID"), String.valueOf(this.m_ComputerId));
        }
        if (this.m_FilesystemId != Integer.MIN_VALUE) {
            htColsAndValues.put(FoundFilesystem.getColumnInfo("FILESYSTEM_ID"), String.valueOf(this.m_FilesystemId));
        }
        if (this.m_ScanningCompId != Integer.MIN_VALUE) {
            htColsAndValues.put(FoundFilesystem.getColumnInfo("SCANNING_COMP_ID"), String.valueOf(this.m_ScanningCompId));
        }
        if (this.m_MountPoint != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(FoundFilesystem.getColumnInfo("MOUNT_POINT"), this.m_MountPoint);
        }
        if (this.m_NonRoot != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(FoundFilesystem.getColumnInfo("NON_ROOT"), this.m_NonRoot);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_FOUND_FILESYSTEM", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_FOUND_FILESYSTEM", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_FOUND_FILESYSTEM", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_FOUND_FILESYSTEM", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_FOUND_FILESYSTEM", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_FOUND_FILESYSTEM", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_FOUND_FILESYSTEM", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FoundFilesystem retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        FoundFilesystem el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_FOUND_FILESYSTEM", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new FoundFilesystem();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_FOUND_FILESYSTEM", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_FOUND_FILESYSTEM", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setComputerId(DBrs.getInt("COMPUTER_ID"));
        this.setFilesystemId(DBrs.getInt("FILESYSTEM_ID"));
        this.setScanningCompId(DBrs.getInt("SCANNING_COMP_ID"));
        this.setMountPoint(DBrs.getString("MOUNT_POINT"));
        this.setNonRoot(DBrs.getString("NON_ROOT"));
    }

    public static class FoundFilesystemCursor
    extends DBCursor {
        private FoundFilesystem element = new FoundFilesystem();
        private DBConnection con;

        public FoundFilesystemCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_FOUND_FILESYSTEM", con, htWhereClause, columns);
            this.con = con;
        }

        public FoundFilesystem getObject() throws SQLException {
            FoundFilesystem el = null;
            if (this.DBrs != null) {
                el = new FoundFilesystem();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public FoundFilesystem getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

