/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResModelTable;

public class Model
extends TResModelTable {
    public static ModelCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new ModelCursor(con, htWhereClause, columns);
    }

    public Model() {
        this.clear();
    }

    public Model(short ModelId, String ModelName, String ModelDescription) {
        this.clear();
        this.m_ModelId = ModelId;
        this.m_ModelName = ModelName;
        this.m_ModelDescription = ModelDescription;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_ModelId != Short.MIN_VALUE) {
            htColsAndValues.put(Model.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_ModelDescription != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Model.getColumnInfo("MODEL_DESCRIPTION"), this.m_ModelDescription);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_ModelName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MODEL_NAME not found");
        }
        this.htColsAndValues.put(Model.getColumnInfo("MODEL_NAME"), this.m_ModelName);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_MODEL", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Model.getColumnInfo("MODEL_NAME")) == null) {
            throw new SQLException(" ERROR: key MODEL_NAME not found");
        }
        return DBQueryAssistant.performInsert("T_RES_MODEL", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_ModelName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(Model.getColumnInfo("MODEL_NAME"), this.m_ModelName);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_MODEL", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Model.getColumnInfo("MODEL_NAME")) == null) {
            throw new SQLException(" ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(Model.getColumnInfo("MODEL_NAME"), htinput.get(Model.getColumnInfo("MODEL_NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_MODEL", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ModelName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(Model.getColumnInfo("MODEL_NAME"), this.m_ModelName);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_MODEL", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Model.getColumnInfo("MODEL_NAME")) == null) {
            throw new SQLException(" ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(Model.getColumnInfo("MODEL_NAME"), htinput.get(Model.getColumnInfo("MODEL_NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_MODEL", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ModelName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(Model.getColumnInfo("MODEL_NAME"), this.m_ModelName);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_MODEL", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Model el = null;
        if (htinput.get(Model.getColumnInfo("MODEL_NAME")) == null) {
            throw new SQLException(" ERROR: key MODEL_NAME not found");
        }
        htWhereClause.put(Model.getColumnInfo("MODEL_NAME"), htinput.get(Model.getColumnInfo("MODEL_NAME")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_MODEL", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Model();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_MODEL", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_MODEL", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setModelId(DBrs.getShort("MODEL_ID"));
        this.setModelName(DBrs.getString("MODEL_NAME"));
        this.setModelDescription(DBrs.getString("MODEL_DESCRIPTION"));
    }

    public static class ModelCursor
    extends DBCursor {
        private Model element = new Model();
        private DBConnection con;

        public ModelCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_MODEL", con, htWhereClause, columns);
            this.con = con;
        }

        public Model getObject() throws SQLException {
            Model el = null;
            if (this.DBrs != null) {
                el = new Model();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Model getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

