/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResOutbandAgentTable;

public class OutbandAgent
extends TResOutbandAgentTable {
    public static OutbandAgentCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new OutbandAgentCursor(con, htWhereClause, columns);
    }

    public OutbandAgent() {
        this.clear();
    }

    public OutbandAgent(int OutbandAgentId, String HostName, String IpAddress, String UserId, String Password) {
        this.clear();
        this.m_OutbandAgentId = OutbandAgentId;
        this.m_HostName = HostName;
        this.m_IpAddress = IpAddress;
        this.m_UserId = UserId;
        this.m_Password = Password;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_OutbandAgentId != Integer.MIN_VALUE) {
            htColsAndValues.put(OutbandAgent.getColumnInfo("OUTBAND_AGENT_ID"), String.valueOf(this.m_OutbandAgentId));
        }
        if (this.m_HostName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(OutbandAgent.getColumnInfo("HOST_NAME"), this.m_HostName);
        }
        if (this.m_UserId != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(OutbandAgent.getColumnInfo("USER_ID"), this.m_UserId);
        }
        if (this.m_Password != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(OutbandAgent.getColumnInfo("PASSWORD"), this.m_Password);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_IpAddress == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key IP_ADDRESS not found");
        }
        this.htColsAndValues.put(OutbandAgent.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_OUTBAND_AGENT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(OutbandAgent.getColumnInfo("IP_ADDRESS")) == null) {
            throw new SQLException(" ERROR: key IP_ADDRESS not found");
        }
        return DBQueryAssistant.performInsert("T_RES_OUTBAND_AGENT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_IpAddress == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key IP_ADDRESS not found");
        }
        this.htWhereClause.put(OutbandAgent.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_OUTBAND_AGENT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(OutbandAgent.getColumnInfo("IP_ADDRESS")) == null) {
            throw new SQLException(" ERROR: key IP_ADDRESS not found");
        }
        this.htWhereClause.put(OutbandAgent.getColumnInfo("IP_ADDRESS"), htinput.get(OutbandAgent.getColumnInfo("IP_ADDRESS")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_OUTBAND_AGENT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_IpAddress == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key IP_ADDRESS not found");
        }
        this.htWhereClause.put(OutbandAgent.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_OUTBAND_AGENT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(OutbandAgent.getColumnInfo("IP_ADDRESS")) == null) {
            throw new SQLException(" ERROR: key IP_ADDRESS not found");
        }
        this.htWhereClause.put(OutbandAgent.getColumnInfo("IP_ADDRESS"), htinput.get(OutbandAgent.getColumnInfo("IP_ADDRESS")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_OUTBAND_AGENT", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_IpAddress == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key IP_ADDRESS not found");
        }
        this.htWhereClause.put(OutbandAgent.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_OUTBAND_AGENT", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutbandAgent retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        OutbandAgent el = null;
        if (htinput.get(OutbandAgent.getColumnInfo("IP_ADDRESS")) == null) {
            throw new SQLException(" ERROR: key IP_ADDRESS not found");
        }
        htWhereClause.put(OutbandAgent.getColumnInfo("IP_ADDRESS"), htinput.get(OutbandAgent.getColumnInfo("IP_ADDRESS")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_OUTBAND_AGENT", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new OutbandAgent();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_OUTBAND_AGENT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_OUTBAND_AGENT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setOutbandAgentId(DBrs.getInt("OUTBAND_AGENT_ID"));
        this.setHostName(DBrs.getString("HOST_NAME"));
        this.setIpAddress(DBrs.getString("IP_ADDRESS"));
        this.setUserId(DBrs.getString("USER_ID"));
        this.setPassword(DBrs.getString("PASSWORD"));
    }

    public static class OutbandAgentCursor
    extends DBCursor {
        private OutbandAgent element = new OutbandAgent();
        private DBConnection con;

        public OutbandAgentCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_OUTBAND_AGENT", con, htWhereClause, columns);
            this.con = con;
        }

        public OutbandAgent getObject() throws SQLException {
            OutbandAgent el = null;
            if (this.DBrs != null) {
                el = new OutbandAgent();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public OutbandAgent getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

