/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalPackageTable;

public class PhysicalPackage
extends TResPhysicalPackageTable {
    private String m_VendorId_str;
    private String m_ModelId_str;

    public void setVendor(String el) {
        this.m_VendorId_str = el;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public void setModel(String el) {
        this.m_ModelId_str = el;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public static PhysicalPackageCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new PhysicalPackageCursor(con, htWhereClause, columns);
    }

    public PhysicalPackage() {
        this.clear();
    }

    public PhysicalPackage(int PackageId, int RemovalConditions, short Removable, short Replaceable, short HotSwappable, float Height, float Depth, float Width, float Weight, String ElementName, short VendorId, short ModelId, String OtherIdentifyingInfo, short PoweredOn, String Location2, Timestamp UpdateTimestamp) {
        this.clear();
        this.m_PackageId = PackageId;
        this.m_RemovalConditions = RemovalConditions;
        this.m_Removable = Removable;
        this.m_Replaceable = Replaceable;
        this.m_HotSwappable = HotSwappable;
        this.m_Height = Height;
        this.m_Depth = Depth;
        this.m_Width = Width;
        this.m_Weight = Weight;
        this.m_ElementName = ElementName;
        this.m_VendorId = VendorId;
        this.m_ModelId = ModelId;
        this.m_OtherIdentifyingInfo = OtherIdentifyingInfo;
        this.m_PoweredOn = PoweredOn;
        this.m_Location = Location2;
        this.m_UpdateTimestamp = UpdateTimestamp;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_RemovalConditions != Integer.MIN_VALUE) {
            htColsAndValues.put(PhysicalPackage.getColumnInfo("REMOVAL_CONDITIONS"), String.valueOf(this.m_RemovalConditions));
        }
        if (this.m_Removable != Short.MIN_VALUE) {
            htColsAndValues.put(PhysicalPackage.getColumnInfo("REMOVABLE"), String.valueOf(this.m_Removable));
        }
        if (this.m_Replaceable != Short.MIN_VALUE) {
            htColsAndValues.put(PhysicalPackage.getColumnInfo("REPLACEABLE"), String.valueOf(this.m_Replaceable));
        }
        if (this.m_HotSwappable != Short.MIN_VALUE) {
            htColsAndValues.put(PhysicalPackage.getColumnInfo("HOT_SWAPPABLE"), String.valueOf(this.m_HotSwappable));
        }
        if (this.m_Height != Float.MIN_VALUE) {
            htColsAndValues.put(PhysicalPackage.getColumnInfo("HEIGHT"), String.valueOf(this.m_Height));
        }
        if (this.m_Depth != Float.MIN_VALUE) {
            htColsAndValues.put(PhysicalPackage.getColumnInfo("DEPTH"), String.valueOf(this.m_Depth));
        }
        if (this.m_Width != Float.MIN_VALUE) {
            htColsAndValues.put(PhysicalPackage.getColumnInfo("WIDTH"), String.valueOf(this.m_Width));
        }
        if (this.m_Weight != Float.MIN_VALUE) {
            htColsAndValues.put(PhysicalPackage.getColumnInfo("WEIGHT"), String.valueOf(this.m_Weight));
        }
        if (this.m_ElementName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PhysicalPackage.getColumnInfo("ELEMENT_NAME"), this.m_ElementName);
        }
        if (this.m_VendorId != Short.MIN_VALUE) {
            htColsAndValues.put(PhysicalPackage.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_ModelId != Short.MIN_VALUE) {
            htColsAndValues.put(PhysicalPackage.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_OtherIdentifyingInfo != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PhysicalPackage.getColumnInfo("OTHER_IDENTIFYING_INFO"), this.m_OtherIdentifyingInfo);
        }
        if (this.m_PoweredOn != Short.MIN_VALUE) {
            htColsAndValues.put(PhysicalPackage.getColumnInfo("POWERED_ON"), String.valueOf(this.m_PoweredOn));
        }
        if (this.m_Location != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PhysicalPackage.getColumnInfo("LOCATION"), this.m_Location);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(PhysicalPackage.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_PackageId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PACKAGE_ID not found");
        }
        this.htColsAndValues.put(PhysicalPackage.getColumnInfo("PACKAGE_ID"), String.valueOf(this.m_PackageId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_PHYSICAL_PACKAGE", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(PhysicalPackage.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(PhysicalPackage.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(PhysicalPackage.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(PhysicalPackage.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(PhysicalPackage.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(PhysicalPackage.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(PhysicalPackage.getColumnInfo("PACKAGE_ID")) == null) {
            throw new SQLException(" ERROR: key PACKAGE_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_PHYSICAL_PACKAGE", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_PackageId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PACKAGE_ID not found");
        }
        this.htWhereClause.put(PhysicalPackage.getColumnInfo("PACKAGE_ID"), String.valueOf(this.m_PackageId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_PHYSICAL_PACKAGE", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(PhysicalPackage.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(PhysicalPackage.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(PhysicalPackage.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(PhysicalPackage.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(PhysicalPackage.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(PhysicalPackage.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(PhysicalPackage.getColumnInfo("PACKAGE_ID")) == null) {
            throw new SQLException(" ERROR: key PACKAGE_ID not found");
        }
        this.htWhereClause.put(PhysicalPackage.getColumnInfo("PACKAGE_ID"), htinput.get(PhysicalPackage.getColumnInfo("PACKAGE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_PHYSICAL_PACKAGE", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_PackageId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PACKAGE_ID not found");
        }
        this.htWhereClause.put(PhysicalPackage.getColumnInfo("PACKAGE_ID"), String.valueOf(this.m_PackageId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_PHYSICAL_PACKAGE", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(PhysicalPackage.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(PhysicalPackage.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(PhysicalPackage.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(PhysicalPackage.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(PhysicalPackage.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(PhysicalPackage.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(PhysicalPackage.getColumnInfo("PACKAGE_ID")) == null) {
            throw new SQLException(" ERROR: key PACKAGE_ID not found");
        }
        this.htWhereClause.put(PhysicalPackage.getColumnInfo("PACKAGE_ID"), htinput.get(PhysicalPackage.getColumnInfo("PACKAGE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_PHYSICAL_PACKAGE", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_PackageId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key PACKAGE_ID not found");
        }
        this.htWhereClause.put(PhysicalPackage.getColumnInfo("PACKAGE_ID"), String.valueOf(this.m_PackageId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_PHYSICAL_PACKAGE", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhysicalPackage retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        PhysicalPackage el = null;
        if (htinput.get(PhysicalPackage.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(PhysicalPackage.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(PhysicalPackage.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(PhysicalPackage.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(PhysicalPackage.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(PhysicalPackage.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(PhysicalPackage.getColumnInfo("PACKAGE_ID")) == null) {
            throw new SQLException(" ERROR: key PACKAGE_ID not found");
        }
        htWhereClause.put(PhysicalPackage.getColumnInfo("PACKAGE_ID"), htinput.get(PhysicalPackage.getColumnInfo("PACKAGE_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_PHYSICAL_PACKAGE", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new PhysicalPackage();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(PhysicalPackage.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(PhysicalPackage.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(PhysicalPackage.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(PhysicalPackage.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(PhysicalPackage.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(PhysicalPackage.getColumnInfo("MODEL_ID")))));
        }
        if (htWhereClause.get(PhysicalPackage.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(PhysicalPackage.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(PhysicalPackage.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(PhysicalPackage.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(PhysicalPackage.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(PhysicalPackage.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_PHYSICAL_PACKAGE", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(PhysicalPackage.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(PhysicalPackage.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(PhysicalPackage.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(PhysicalPackage.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(PhysicalPackage.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(PhysicalPackage.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_PHYSICAL_PACKAGE", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setPackageId(DBrs.getInt("PACKAGE_ID"));
        this.setRemovalConditions(DBrs.getInt("REMOVAL_CONDITIONS"));
        this.setRemovable(DBrs.getShort("REMOVABLE"));
        this.setReplaceable(DBrs.getShort("REPLACEABLE"));
        this.setHotSwappable(DBrs.getShort("HOT_SWAPPABLE"));
        this.setHeight(DBrs.getFloat("HEIGHT"));
        this.setDepth(DBrs.getFloat("DEPTH"));
        this.setWidth(DBrs.getFloat("WIDTH"));
        this.setWeight(DBrs.getFloat("WEIGHT"));
        this.setElementName(DBrs.getString("ELEMENT_NAME"));
        this.setVendorId(DBrs.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(con, this.m_VendorId));
        this.setModelId(DBrs.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(con, this.m_ModelId));
        this.setOtherIdentifyingInfo(DBrs.getString("OTHER_IDENTIFYING_INFO"));
        this.setPoweredOn(DBrs.getShort("POWERED_ON"));
        this.setLocation(DBrs.getString("LOCATION"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
    }

    public static class PhysicalPackageCursor
    extends DBCursor {
        private PhysicalPackage element = new PhysicalPackage();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResPhysicalPackageTable.getColumnInfo("VENDOR_ID")) != null) {
                htWhereClause.put(TResPhysicalPackageTable.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(TResPhysicalPackageTable.getColumnInfo("VENDOR_ID")))));
            }
            if (htWhereClause.get(TResPhysicalPackageTable.getColumnInfo("MODEL_ID")) != null) {
                htWhereClause.put(TResPhysicalPackageTable.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(TResPhysicalPackageTable.getColumnInfo("MODEL_ID")))));
            }
            return htWhereClause;
        }

        public PhysicalPackageCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_PHYSICAL_PACKAGE", con, PhysicalPackageCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public PhysicalPackage getObject() throws SQLException {
            PhysicalPackage el = null;
            if (this.DBrs != null) {
                el = new PhysicalPackage();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public PhysicalPackage getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

